/* valatype.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <rasa@gmx.ch>
 */

#ifndef __VALADATATYPE_H__
#define __VALADATATYPE_H__
typedef struct _ValaDataTypePrivate ValaDataTypePrivate;

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valacodenode.h>
#include <vala/valamemberaccessibility.h>

G_BEGIN_DECLS


#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))


/**
 * Represents a runtime data type. This data type may be defined in Vala source
 * code or imported from an external library with a Vala API file.
 */
struct _ValaDataType {
	ValaCodeNode parent;
	ValaDataTypePrivate * priv;
	ValaMemberAccessibility access;
	ValaNamespace* namespace;
};
struct _ValaDataTypeClass {
	ValaCodeNodeClass parent;
	char* (*get_cname) (ValaDataType* self, gboolean const_type);
	gboolean (*is_reference_type) (ValaDataType* self);
	char* (*get_dup_function) (ValaDataType* self);
	char* (*get_free_function) (ValaDataType* self);
	gboolean (*is_reference_counting) (ValaDataType* self);
	char* (*get_ref_function) (ValaDataType* self);
	char* (*get_unref_function) (ValaDataType* self);
	char* (*get_type_id) (ValaDataType* self);
	char* (*get_marshaller_type_name) (ValaDataType* self);
	char* (*get_get_value_function) (ValaDataType* self);
	char* (*get_set_value_function) (ValaDataType* self);
	char* (*get_upper_case_cname) (ValaDataType* self, const char* infix);
	char* (*get_lower_case_cname) (ValaDataType* self, const char* infix);
	char* (*get_lower_case_cprefix) (ValaDataType* self);
	char* (*get_default_value) (ValaDataType* self);
	GList* (*get_cheader_filenames) (ValaDataType* self);
	gboolean (*is_subtype_of) (ValaDataType* self, ValaDataType* t);
	gint (*get_type_parameter_index) (ValaDataType* self, const char* name);
};

char* vala_data_type_get_cname (ValaDataType* self, gboolean const_type);
gboolean vala_data_type_is_reference_type (ValaDataType* self);
char* vala_data_type_get_dup_function (ValaDataType* self);
char* vala_data_type_get_free_function (ValaDataType* self);
gboolean vala_data_type_is_reference_counting (ValaDataType* self);
char* vala_data_type_get_ref_function (ValaDataType* self);
char* vala_data_type_get_unref_function (ValaDataType* self);
char* vala_data_type_get_type_id (ValaDataType* self);
char* vala_data_type_get_marshaller_type_name (ValaDataType* self);
char* vala_data_type_get_get_value_function (ValaDataType* self);
char* vala_data_type_get_set_value_function (ValaDataType* self);
char* vala_data_type_get_upper_case_cname (ValaDataType* self, const char* infix);
char* vala_data_type_get_lower_case_cname (ValaDataType* self, const char* infix);
char* vala_data_type_get_lower_case_cprefix (ValaDataType* self);
char* vala_data_type_get_default_value (ValaDataType* self);
GList* vala_data_type_get_cheader_filenames (ValaDataType* self);
void vala_data_type_add_cheader_filename (ValaDataType* self, const char* filename);
ValaPointer* vala_data_type_get_pointer (ValaDataType* self);
ValaArray* vala_data_type_get_array (ValaDataType* self, gint rank);
gboolean vala_data_type_is_subtype_of (ValaDataType* self, ValaDataType* t);
gint vala_data_type_get_type_parameter_index (ValaDataType* self, const char* name);
char* vala_data_type_get_name (ValaDataType* self);
void vala_data_type_set_name (ValaDataType* self, const char* value);
GType vala_data_type_get_type ();

G_END_DECLS

#endif
