/* valatyperegisterfunction.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valatyperegisterfunction.h"
#include <ccode/valaccodeblock.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodedeclarator.h>
#include <ccode/valaccodemodifiers.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodefunction.h>
#include <ccode/valaccodeformalparameter.h>
#include <ccode/valaccodereturnstatement.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <ccode/valaccodeassignment.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodeifstatement.h>
#include <ccode/valaccodestatement.h>
#include <gobject/valatyperegisterfunction.h>

struct _ValaTypeRegisterFunctionPrivate {
	ValaCCodeFragment* declaration_fragment;
	ValaCCodeFragment* definition_fragment;
};
#define VALA_TYPE_REGISTER_FUNCTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_TYPE_REGISTER_FUNCTION, ValaTypeRegisterFunctionPrivate))
enum  {
	VALA_TYPE_REGISTER_FUNCTION_DUMMY_PROPERTY
};
static char* vala_type_register_function_real_get_type_flags (ValaTypeRegisterFunction* self);
static ValaCCodeFragment* vala_type_register_function_real_get_type_interface_init_declaration (ValaTypeRegisterFunction* self);
static gpointer vala_type_register_function_parent_class = NULL;
static void vala_type_register_function_dispose (GObject * obj);


/**
 * Constructs the C function from the specified type.
 */
void vala_type_register_function_init_from_type (ValaTypeRegisterFunction* self, gboolean plugin)
{
	char* __temp1;
	ValaDataType* __temp0;
	char* __temp2;
	char* type_id_name;
	ValaCCodeBlock* type_block;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* __temp3;
	ValaCCodeFunction* fun;
	ValaCCodeBlock* type_init;
	ValaCCodeDeclaration* ctypedecl;
	ValaCCodeVariableDeclarator* __temp22;
	char* __temp21;
	char* __temp20;
	char* __temp19;
	char* __temp18;
	char* __temp17;
	ValaCCodeFragment* __temp23;
	ValaCCodeFunctionCall* reg_call;
	ValaCCodeIdentifier* __temp27;
	ValaCCodeConstant* __temp30;
	char* __temp29;
	ValaDataType* __temp28;
	ValaCCodeIdentifier* __temp31;
	ValaCCodeConstant* __temp32;
	ValaCCodeExpressionStatement* __temp33;
	ValaCCodeFragment* __temp34;
	ValaCCodeReturnStatement* __temp38;
	ValaCCodeFunction* __temp39;
	g_return_if_fail (VALA_IS_TYPE_REGISTER_FUNCTION (self));
	__temp1 = NULL;
	__temp0 = NULL;
	__temp2 = NULL;
	type_id_name = (__temp2 = g_strdup_printf ("%s_type_id", (__temp1 = vala_data_type_get_lower_case_cname ((__temp0 = vala_type_register_function_get_type_declaration (self)), NULL))), (__temp1 = (g_free (__temp1), NULL)), (__temp0 = (g_object_unref (__temp0), NULL)), __temp2);
	type_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	cdecl_ = vala_ccode_declaration_new ("GType");
	__temp3 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp3 = vala_ccode_variable_declarator_new_with_initializer (type_id_name, VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("0"))))));
	(__temp3 == NULL ? NULL : (__temp3 = (g_object_unref (__temp3), NULL)));
	(vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_STATIC), vala_ccode_declaration_get_modifiers (cdecl_));
	if (!plugin) {
		vala_ccode_block_add_statement (type_block, VALA_CCODE_NODE (cdecl_));
	} else {
		vala_ccode_fragment_append (self->priv->definition_fragment, VALA_CCODE_NODE (cdecl_));
	}
	fun = NULL;
	if (!plugin) {
		ValaCCodeFunction* __temp6;
		char* __temp5;
		ValaDataType* __temp4;
		__temp6 = NULL;
		__temp5 = NULL;
		__temp4 = NULL;
		fun = (__temp6 = vala_ccode_function_new (g_strdup_printf ("%s_get_type", (__temp5 = vala_data_type_get_lower_case_cname ((__temp4 = vala_type_register_function_get_type_declaration (self)), NULL))), "GType"), (fun == NULL ? NULL : (fun = (g_object_unref (fun), NULL))), __temp6);
		(__temp5 = (g_free (__temp5), NULL));
		(__temp4 = (g_object_unref (__temp4), NULL));
	} else {
		ValaCCodeFunction* __temp9;
		char* __temp8;
		ValaDataType* __temp7;
		ValaCCodeFormalParameter* __temp10;
		char* __temp12;
		ValaDataType* __temp11;
		ValaCCodeFunction* __temp13;
		ValaCCodeFunction* get_fun;
		ValaCCodeFunction* __temp14;
		ValaCCodeBlock* __temp15;
		ValaCCodeReturnStatement* __temp16;
		__temp9 = NULL;
		__temp8 = NULL;
		__temp7 = NULL;
		fun = (__temp9 = vala_ccode_function_new (g_strdup_printf ("%s_register_type", (__temp8 = vala_data_type_get_lower_case_cname ((__temp7 = vala_type_register_function_get_type_declaration (self)), NULL))), "GType"), (fun == NULL ? NULL : (fun = (g_object_unref (fun), NULL))), __temp9);
		(__temp8 = (g_free (__temp8), NULL));
		(__temp7 = (g_object_unref (__temp7), NULL));
		__temp10 = NULL;
		vala_ccode_function_add_parameter (fun, (__temp10 = vala_ccode_formal_parameter_new ("module", "GTypeModule *")));
		(__temp10 == NULL ? NULL : (__temp10 = (g_object_unref (__temp10), NULL)));
		__temp12 = NULL;
		__temp11 = NULL;
		__temp13 = NULL;
		get_fun = (__temp13 = vala_ccode_function_new (g_strdup_printf ("%s_get_type", (__temp12 = vala_data_type_get_lower_case_cname ((__temp11 = vala_type_register_function_get_type_declaration (self)), NULL))), "GType"), (__temp12 = (g_free (__temp12), NULL)), (__temp11 = (g_object_unref (__temp11), NULL)), __temp13);
		__temp14 = NULL;
		vala_ccode_fragment_append (self->priv->declaration_fragment, VALA_CCODE_NODE ((__temp14 = vala_ccode_function_copy (get_fun))));
		(__temp14 = (g_object_unref (__temp14), NULL));
		__temp15 = NULL;
		(vala_ccode_function_set_block (get_fun, (__temp15 = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL))), vala_ccode_function_get_block (get_fun));
		(__temp15 == NULL ? NULL : (__temp15 = (g_object_unref (__temp15), NULL)));
		__temp16 = NULL;
		vala_ccode_block_add_statement (vala_ccode_function_get_block (get_fun), VALA_CCODE_NODE ((__temp16 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (type_id_name))))));
		(__temp16 == NULL ? NULL : (__temp16 = (g_object_unref (__temp16), NULL)));
		vala_ccode_fragment_append (self->priv->definition_fragment, VALA_CCODE_NODE (get_fun));
		(get_fun == NULL ? NULL : (get_fun = (g_object_unref (get_fun), NULL)));
	}
	type_init = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	ctypedecl = vala_ccode_declaration_new ("const GTypeInfo");
	(vala_ccode_declaration_set_modifiers (ctypedecl, VALA_CCODE_MODIFIERS_STATIC), vala_ccode_declaration_get_modifiers (ctypedecl));
	__temp22 = NULL;
	__temp21 = NULL;
	__temp20 = NULL;
	__temp19 = NULL;
	__temp18 = NULL;
	__temp17 = NULL;
	vala_ccode_declaration_add_declarator (ctypedecl, VALA_CCODE_DECLARATOR ((__temp22 = vala_ccode_variable_declarator_new_with_initializer ("g_define_type_info", VALA_CCODE_EXPRESSION (vala_ccode_constant_new (g_strdup_printf ("{ sizeof (%s), (GBaseInitFunc) %s, (GBaseFinalizeFunc) NULL, (GClassInitFunc) %s, (GClassFinalizeFunc) NULL, NULL, %s, 0, (GInstanceInitFunc) %s }", (__temp17 = vala_type_register_function_get_type_struct_name (self)), (__temp18 = vala_type_register_function_get_base_init_func_name (self)), (__temp19 = vala_type_register_function_get_class_init_func_name (self)), (__temp20 = vala_type_register_function_get_instance_struct_size (self)), (__temp21 = vala_type_register_function_get_instance_init_func_name (self)))))))));
	(__temp22 == NULL ? NULL : (__temp22 = (g_object_unref (__temp22), NULL)));
	(__temp21 = (g_free (__temp21), NULL));
	(__temp20 = (g_free (__temp20), NULL));
	(__temp19 = (g_free (__temp19), NULL));
	(__temp18 = (g_free (__temp18), NULL));
	(__temp17 = (g_free (__temp17), NULL));
	vala_ccode_block_add_statement (type_init, VALA_CCODE_NODE (ctypedecl));
	__temp23 = NULL;
	vala_ccode_block_add_statement (type_init, VALA_CCODE_NODE ((__temp23 = vala_type_register_function_get_type_interface_init_declaration (self))));
	(__temp23 = (g_object_unref (__temp23), NULL));
	reg_call = NULL;
	if (!plugin) {
		ValaCCodeFunctionCall* __temp24;
		__temp24 = NULL;
		reg_call = (__temp24 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_type_register_static"))), (reg_call == NULL ? NULL : (reg_call = (g_object_unref (reg_call), NULL))), __temp24);
	} else {
		ValaCCodeFunctionCall* __temp25;
		ValaCCodeIdentifier* __temp26;
		__temp25 = NULL;
		reg_call = (__temp25 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_type_module_register_type"))), (reg_call == NULL ? NULL : (reg_call = (g_object_unref (reg_call), NULL))), __temp25);
		__temp26 = NULL;
		vala_ccode_function_call_add_argument (reg_call, VALA_CCODE_EXPRESSION ((__temp26 = vala_ccode_identifier_new ("module"))));
		(__temp26 == NULL ? NULL : (__temp26 = (g_object_unref (__temp26), NULL)));
	}
	__temp27 = NULL;
	vala_ccode_function_call_add_argument (reg_call, VALA_CCODE_EXPRESSION ((__temp27 = vala_ccode_identifier_new (vala_type_register_function_get_parent_type_name (self)))));
	(__temp27 == NULL ? NULL : (__temp27 = (g_object_unref (__temp27), NULL)));
	__temp30 = NULL;
	__temp29 = NULL;
	__temp28 = NULL;
	vala_ccode_function_call_add_argument (reg_call, VALA_CCODE_EXPRESSION ((__temp30 = vala_ccode_constant_new (g_strdup_printf ("\"%s\"", (__temp29 = vala_data_type_get_cname ((__temp28 = vala_type_register_function_get_type_declaration (self)), FALSE)))))));
	(__temp30 == NULL ? NULL : (__temp30 = (g_object_unref (__temp30), NULL)));
	(__temp29 = (g_free (__temp29), NULL));
	(__temp28 = (g_object_unref (__temp28), NULL));
	__temp31 = NULL;
	vala_ccode_function_call_add_argument (reg_call, VALA_CCODE_EXPRESSION ((__temp31 = vala_ccode_identifier_new ("&g_define_type_info"))));
	(__temp31 == NULL ? NULL : (__temp31 = (g_object_unref (__temp31), NULL)));
	__temp32 = NULL;
	vala_ccode_function_call_add_argument (reg_call, VALA_CCODE_EXPRESSION ((__temp32 = vala_ccode_constant_new (vala_type_register_function_get_type_flags (self)))));
	(__temp32 == NULL ? NULL : (__temp32 = (g_object_unref (__temp32), NULL)));
	__temp33 = NULL;
	vala_ccode_block_add_statement (type_init, VALA_CCODE_NODE ((__temp33 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (type_id_name)), VALA_CCODE_EXPRESSION (reg_call), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
	(__temp33 == NULL ? NULL : (__temp33 = (g_object_unref (__temp33), NULL)));
	__temp34 = NULL;
	vala_ccode_block_add_statement (type_init, VALA_CCODE_NODE ((__temp34 = vala_type_register_function_get_type_interface_init_statements (self))));
	(__temp34 = (g_object_unref (__temp34), NULL));
	if (!plugin) {
		ValaCCodeFunctionCall* cond;
		ValaCCodeBinaryExpression* __temp35;
		ValaCCodeIfStatement* cif;
		cond = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("G_UNLIKELY")));
		__temp35 = NULL;
		vala_ccode_function_call_add_argument (cond, VALA_CCODE_EXPRESSION ((__temp35 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (type_id_name)), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("0"))))));
		(__temp35 == NULL ? NULL : (__temp35 = (g_object_unref (__temp35), NULL)));
		cif = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (cond), VALA_CCODE_STATEMENT (type_init), NULL);
		vala_ccode_block_add_statement (type_block, VALA_CCODE_NODE (cif));
		(cond == NULL ? NULL : (cond = (g_object_unref (cond), NULL)));
		(cif == NULL ? NULL : (cif = (g_object_unref (cif), NULL)));
	} else {
		ValaCCodeBlock* __temp37;
		ValaCCodeBlock* __temp36;
		__temp37 = NULL;
		__temp36 = NULL;
		type_block = (__temp37 = (__temp36 = type_init, (__temp36 == NULL ? NULL : g_object_ref (__temp36))), (type_block == NULL ? NULL : (type_block = (g_object_unref (type_block), NULL))), __temp37);
	}
	__temp38 = NULL;
	vala_ccode_block_add_statement (type_block, VALA_CCODE_NODE ((__temp38 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (type_id_name))))));
	(__temp38 == NULL ? NULL : (__temp38 = (g_object_unref (__temp38), NULL)));
	__temp39 = NULL;
	vala_ccode_fragment_append (self->priv->declaration_fragment, VALA_CCODE_NODE ((__temp39 = vala_ccode_function_copy (fun))));
	(__temp39 = (g_object_unref (__temp39), NULL));
	(vala_ccode_function_set_block (fun, type_block), vala_ccode_function_get_block (fun));
	vala_ccode_fragment_append (self->priv->definition_fragment, VALA_CCODE_NODE (fun));
	(type_id_name = (g_free (type_id_name), NULL));
	(type_block == NULL ? NULL : (type_block = (g_object_unref (type_block), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
	(fun == NULL ? NULL : (fun = (g_object_unref (fun), NULL)));
	(type_init == NULL ? NULL : (type_init = (g_object_unref (type_init), NULL)));
	(ctypedecl == NULL ? NULL : (ctypedecl = (g_object_unref (ctypedecl), NULL)));
	(reg_call == NULL ? NULL : (reg_call = (g_object_unref (reg_call), NULL)));
}


ValaDataType* vala_type_register_function_get_type_declaration (ValaTypeRegisterFunction* self)
{
	return VALA_TYPE_REGISTER_FUNCTION_GET_CLASS (self)->get_type_declaration (self);
}


char* vala_type_register_function_get_type_struct_name (ValaTypeRegisterFunction* self)
{
	return VALA_TYPE_REGISTER_FUNCTION_GET_CLASS (self)->get_type_struct_name (self);
}


char* vala_type_register_function_get_base_init_func_name (ValaTypeRegisterFunction* self)
{
	return VALA_TYPE_REGISTER_FUNCTION_GET_CLASS (self)->get_base_init_func_name (self);
}


char* vala_type_register_function_get_class_init_func_name (ValaTypeRegisterFunction* self)
{
	return VALA_TYPE_REGISTER_FUNCTION_GET_CLASS (self)->get_class_init_func_name (self);
}


char* vala_type_register_function_get_instance_struct_size (ValaTypeRegisterFunction* self)
{
	return VALA_TYPE_REGISTER_FUNCTION_GET_CLASS (self)->get_instance_struct_size (self);
}


char* vala_type_register_function_get_instance_init_func_name (ValaTypeRegisterFunction* self)
{
	return VALA_TYPE_REGISTER_FUNCTION_GET_CLASS (self)->get_instance_init_func_name (self);
}


char* vala_type_register_function_get_parent_type_name (ValaTypeRegisterFunction* self)
{
	return VALA_TYPE_REGISTER_FUNCTION_GET_CLASS (self)->get_parent_type_name (self);
}


/**
 * Returns the set of type flags to be applied when registering.
 *
 * @return type flags
 */
static char* vala_type_register_function_real_get_type_flags (ValaTypeRegisterFunction* self)
{
	g_return_val_if_fail (VALA_IS_TYPE_REGISTER_FUNCTION (self), NULL);
	return g_strdup ("0");
}


char* vala_type_register_function_get_type_flags (ValaTypeRegisterFunction* self)
{
	return VALA_TYPE_REGISTER_FUNCTION_GET_CLASS (self)->get_type_flags (self);
}


/**
 * Returns additional C declarations to setup interfaces.
 *
 * @return C declarations
 */
static ValaCCodeFragment* vala_type_register_function_real_get_type_interface_init_declaration (ValaTypeRegisterFunction* self)
{
	g_return_val_if_fail (VALA_IS_TYPE_REGISTER_FUNCTION (self), NULL);
	return g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
}


ValaCCodeFragment* vala_type_register_function_get_type_interface_init_declaration (ValaTypeRegisterFunction* self)
{
	return VALA_TYPE_REGISTER_FUNCTION_GET_CLASS (self)->get_type_interface_init_declaration (self);
}


ValaCCodeFragment* vala_type_register_function_get_type_interface_init_statements (ValaTypeRegisterFunction* self)
{
	return VALA_TYPE_REGISTER_FUNCTION_GET_CLASS (self)->get_type_interface_init_statements (self);
}


/**
 * Returns the declaration for this type register function in C code.
 *
 * @return C function declaration fragment
 */
ValaCCodeFragment* vala_type_register_function_get_declaration (ValaTypeRegisterFunction* self)
{
	ValaCCodeFragment* __temp42;
	g_return_val_if_fail (VALA_IS_TYPE_REGISTER_FUNCTION (self), NULL);
	__temp42 = NULL;
	return (__temp42 = self->priv->declaration_fragment, (__temp42 == NULL ? NULL : g_object_ref (__temp42)));
}


/**
 * Returns the definition for this type register function in C code.
 *
 * @return C function definition fragment
 */
ValaCCodeFragment* vala_type_register_function_get_definition (ValaTypeRegisterFunction* self)
{
	ValaCCodeFragment* __temp44;
	g_return_val_if_fail (VALA_IS_TYPE_REGISTER_FUNCTION (self), NULL);
	__temp44 = NULL;
	return (__temp44 = self->priv->definition_fragment, (__temp44 == NULL ? NULL : g_object_ref (__temp44)));
}


static void vala_type_register_function_class_init (ValaTypeRegisterFunctionClass * klass)
{
	vala_type_register_function_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaTypeRegisterFunctionPrivate));
	G_OBJECT_CLASS (klass)->dispose = vala_type_register_function_dispose;
	VALA_TYPE_REGISTER_FUNCTION_CLASS (klass)->get_type_flags = vala_type_register_function_real_get_type_flags;
	VALA_TYPE_REGISTER_FUNCTION_CLASS (klass)->get_type_interface_init_declaration = vala_type_register_function_real_get_type_interface_init_declaration;
}


static void vala_type_register_function_init (ValaTypeRegisterFunction * self)
{
	self->priv = VALA_TYPE_REGISTER_FUNCTION_GET_PRIVATE (self);
	self->priv->declaration_fragment = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	self->priv->definition_fragment = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
}


static void vala_type_register_function_dispose (GObject * obj)
{
	ValaTypeRegisterFunction * self;
	ValaTypeRegisterFunctionClass * klass;
	GObjectClass * parent_class;
	self = VALA_TYPE_REGISTER_FUNCTION (obj);
	(self->priv->declaration_fragment == NULL ? NULL : (self->priv->declaration_fragment = (g_object_unref (self->priv->declaration_fragment), NULL)));
	(self->priv->definition_fragment == NULL ? NULL : (self->priv->definition_fragment = (g_object_unref (self->priv->definition_fragment), NULL)));
	klass = VALA_TYPE_REGISTER_FUNCTION_CLASS (g_type_class_peek (VALA_TYPE_TYPE_REGISTER_FUNCTION));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_type_register_function_get_type ()
{
	static GType vala_type_register_function_type_id = 0;
	if (G_UNLIKELY (vala_type_register_function_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaTypeRegisterFunctionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_type_register_function_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaTypeRegisterFunction), 0, (GInstanceInitFunc) vala_type_register_function_init };
		vala_type_register_function_type_id = g_type_register_static (G_TYPE_OBJECT, "ValaTypeRegisterFunction", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return vala_type_register_function_type_id;
}




