/* valaccodetypedefinition.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valaccodetypedefinition.h"
#include <ccode/valaccodetypedefinition.h>

struct _ValaCCodeTypeDefinitionPrivate {
	char* _type_name;
	ValaCCodeDeclarator* _declarator;
};
#define VALA_CCODE_TYPE_DEFINITION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_TYPE_DEFINITION, ValaCCodeTypeDefinitionPrivate))
enum  {
	VALA_CCODE_TYPE_DEFINITION_DUMMY_PROPERTY,
	VALA_CCODE_TYPE_DEFINITION_TYPE_NAME,
	VALA_CCODE_TYPE_DEFINITION_DECLARATOR
};
static void vala_ccode_type_definition_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static void vala_ccode_type_definition_real_write_declaration (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_type_definition_parent_class = NULL;
static void vala_ccode_type_definition_dispose (GObject * obj);


ValaCCodeTypeDefinition* vala_ccode_type_definition_new (const char* type, ValaCCodeDeclarator* decl)
{
	GParameter * __params;
	GParameter * __params_it;
	ValaCCodeTypeDefinition * self;
	g_return_val_if_fail (decl == NULL || VALA_IS_CCODE_DECLARATOR (decl), NULL);
	__params = g_new0 (GParameter, 2);
	__params_it = __params;
	(__params_it->name = "type-name", g_value_init (&__params_it->value, G_TYPE_STRING), g_value_set_string (&__params_it->value, type), __params_it++);
	(__params_it->name = "declarator", g_value_init (&__params_it->value, VALA_TYPE_CCODE_DECLARATOR), g_value_set_object (&__params_it->value, decl), __params_it++);
	self = g_object_newv (VALA_TYPE_CCODE_TYPE_DEFINITION, __params_it - __params, __params);
	return self;
}


static void vala_ccode_type_definition_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer)
{
	ValaCCodeTypeDefinition * self;
	self = VALA_CCODE_TYPE_DEFINITION (base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
}


static void vala_ccode_type_definition_real_write_declaration (ValaCCodeNode* base, ValaCCodeWriter* writer)
{
	ValaCCodeTypeDefinition * self;
	self = VALA_CCODE_TYPE_DEFINITION (base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	vala_ccode_writer_write_indent (writer);
	vala_ccode_writer_write_string (writer, "typedef ");
	vala_ccode_writer_write_string (writer, vala_ccode_type_definition_get_type_name (self));
	vala_ccode_writer_write_string (writer, " ");
	vala_ccode_node_write_declaration (VALA_CCODE_NODE (vala_ccode_type_definition_get_declarator (self)), writer);
	vala_ccode_writer_write_string (writer, ";");
	vala_ccode_writer_write_newline (writer);
}


char* vala_ccode_type_definition_get_type_name (ValaCCodeTypeDefinition* self)
{
	g_return_val_if_fail (VALA_IS_CCODE_TYPE_DEFINITION (self), NULL);
	return self->priv->_type_name;
}


void vala_ccode_type_definition_set_type_name (ValaCCodeTypeDefinition* self, const char* value)
{
	char* __temp2;
	const char* __temp1;
	g_return_if_fail (VALA_IS_CCODE_TYPE_DEFINITION (self));
	__temp2 = NULL;
	__temp1 = NULL;
	self->priv->_type_name = (__temp2 = (__temp1 = value, (__temp1 == NULL ? NULL : g_strdup (__temp1))), (self->priv->_type_name = (g_free (self->priv->_type_name), NULL)), __temp2);
}


ValaCCodeDeclarator* vala_ccode_type_definition_get_declarator (ValaCCodeTypeDefinition* self)
{
	g_return_val_if_fail (VALA_IS_CCODE_TYPE_DEFINITION (self), NULL);
	return self->priv->_declarator;
}


void vala_ccode_type_definition_set_declarator (ValaCCodeTypeDefinition* self, ValaCCodeDeclarator* value)
{
	ValaCCodeDeclarator* __temp5;
	ValaCCodeDeclarator* __temp4;
	g_return_if_fail (VALA_IS_CCODE_TYPE_DEFINITION (self));
	__temp5 = NULL;
	__temp4 = NULL;
	self->priv->_declarator = (__temp5 = (__temp4 = value, (__temp4 == NULL ? NULL : g_object_ref (__temp4))), (self->priv->_declarator == NULL ? NULL : (self->priv->_declarator = (g_object_unref (self->priv->_declarator), NULL))), __temp5);
}


static void vala_ccode_type_definition_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaCCodeTypeDefinition * self;
	self = VALA_CCODE_TYPE_DEFINITION (object);
	switch (property_id) {
		case VALA_CCODE_TYPE_DEFINITION_TYPE_NAME:
		g_value_set_string (value, vala_ccode_type_definition_get_type_name (self));
		break;
		case VALA_CCODE_TYPE_DEFINITION_DECLARATOR:
		g_value_set_object (value, vala_ccode_type_definition_get_declarator (self));
		break;
	}
}


static void vala_ccode_type_definition_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaCCodeTypeDefinition * self;
	self = VALA_CCODE_TYPE_DEFINITION (object);
	switch (property_id) {
		case VALA_CCODE_TYPE_DEFINITION_TYPE_NAME:
		vala_ccode_type_definition_set_type_name (self, g_value_get_string (value));
		break;
		case VALA_CCODE_TYPE_DEFINITION_DECLARATOR:
		vala_ccode_type_definition_set_declarator (self, g_value_get_object (value));
		break;
	}
}


static void vala_ccode_type_definition_class_init (ValaCCodeTypeDefinitionClass * klass)
{
	vala_ccode_type_definition_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeTypeDefinitionPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_type_definition_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_type_definition_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_type_definition_dispose;
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_type_definition_real_write;
	VALA_CCODE_NODE_CLASS (klass)->write_declaration = vala_ccode_type_definition_real_write_declaration;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_TYPE_DEFINITION_TYPE_NAME, g_param_spec_string ("type-name", "foo", "bar", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_TYPE_DEFINITION_DECLARATOR, g_param_spec_object ("declarator", "foo", "bar", VALA_TYPE_CCODE_DECLARATOR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_ccode_type_definition_init (ValaCCodeTypeDefinition * self)
{
	self->priv = VALA_CCODE_TYPE_DEFINITION_GET_PRIVATE (self);
}


static void vala_ccode_type_definition_dispose (GObject * obj)
{
	ValaCCodeTypeDefinition * self;
	ValaCCodeTypeDefinitionClass * klass;
	GObjectClass * parent_class;
	self = VALA_CCODE_TYPE_DEFINITION (obj);
	(self->priv->_type_name = (g_free (self->priv->_type_name), NULL));
	(self->priv->_declarator == NULL ? NULL : (self->priv->_declarator = (g_object_unref (self->priv->_declarator), NULL)));
	klass = VALA_CCODE_TYPE_DEFINITION_CLASS (g_type_class_peek (VALA_TYPE_CCODE_TYPE_DEFINITION));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_ccode_type_definition_get_type ()
{
	static GType vala_ccode_type_definition_type_id = 0;
	if (G_UNLIKELY (vala_ccode_type_definition_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeTypeDefinitionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_type_definition_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeTypeDefinition), 0, (GInstanceInitFunc) vala_ccode_type_definition_init };
		vala_ccode_type_definition_type_id = g_type_register_static (VALA_TYPE_CCODE_NODE, "ValaCCodeTypeDefinition", &g_define_type_info, 0);
	}
	return vala_ccode_type_definition_type_id;
}




