/* valavariabledeclarator.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valavariabledeclarator.h"
#include <vala/valatypereference.h>
#include <vala/valaexpression.h>
#include <vala/valasourcereference.h>
#include <vala/valavariabledeclarator.h>
#include <vala/valacodevisitor.h>
#include <vala/valacallback.h>

struct _ValaVariableDeclaratorPrivate {
	char* _name;
	ValaTypeReference* _type_reference;
	ValaExpression* _initializer;
};
#define VALA_VARIABLE_DECLARATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_VARIABLE_DECLARATOR, ValaVariableDeclaratorPrivate))
enum  {
	VALA_VARIABLE_DECLARATOR_DUMMY_PROPERTY,
	VALA_VARIABLE_DECLARATOR_NAME,
	VALA_VARIABLE_DECLARATOR_INITIALIZER,
	VALA_VARIABLE_DECLARATOR_TYPE_REFERENCE,
};
static void vala_variable_declarator_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static GList* vala_variable_declarator_real_get_parameters (ValaInvokable* base);
static ValaTypeReference* vala_variable_declarator_real_get_return_type (ValaInvokable* base);
static gboolean vala_variable_declarator_real_is_invokable (ValaInvokable* base);
static void vala_variable_declarator_real_replace (ValaCodeNode* base, ValaCodeNode* old_node, ValaCodeNode* new_node);
static gpointer vala_variable_declarator_parent_class = NULL;
static ValaInvokableIface* vala_variable_declarator_vala_invokable_parent_iface = NULL;
static void vala_variable_declarator_dispose (GObject * obj);


/**
 * Creates a new variable declarator.
 *
 * @param name   name of the variable
 * @param init   optional initializer expression
 * @param source reference to source code
 * @return       newly created variable declarator
 */
ValaVariableDeclarator* vala_variable_declarator_new (const char* _name, ValaExpression* init, ValaSourceReference* source)
{
	g_return_val_if_fail (_name != NULL, NULL);
	g_return_val_if_fail (init == NULL || VALA_IS_EXPRESSION (init), NULL);
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	GParameter * __params = g_new0 (GParameter, 3);
	GParameter * __params_it = __params;
	(__params_it->name = "name", g_value_init (&__params_it->value, G_TYPE_STRING), g_value_set_string (&__params_it->value, _name), __params_it++);
	(__params_it->name = "initializer", g_value_init (&__params_it->value, VALA_TYPE_EXPRESSION), g_value_set_object (&__params_it->value, init), __params_it++);
	(__params_it->name = "source-reference", g_value_init (&__params_it->value, VALA_TYPE_SOURCE_REFERENCE), g_value_set_object (&__params_it->value, source), __params_it++);
	ValaVariableDeclarator * self = g_object_newv (VALA_TYPE_VARIABLE_DECLARATOR, __params_it - __params, __params);
	return self;
}


static void vala_variable_declarator_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaVariableDeclarator * self = VALA_VARIABLE_DECLARATOR (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	if (vala_variable_declarator_get_initializer (self) != NULL) {
		vala_code_node_accept (VALA_CODE_NODE (vala_variable_declarator_get_initializer (self)), visitor);
		vala_code_visitor_visit_end_full_expression (visitor, vala_variable_declarator_get_initializer (self));
	}
	if (vala_variable_declarator_get_type_reference (self) != NULL) {
		vala_code_node_accept (VALA_CODE_NODE (vala_variable_declarator_get_type_reference (self)), visitor);
	}
	vala_code_visitor_visit_variable_declarator (visitor, self);
}


static GList* vala_variable_declarator_real_get_parameters (ValaInvokable* base)
{
	ValaVariableDeclarator * self = VALA_VARIABLE_DECLARATOR (base);
	if (!vala_invokable_is_invokable (VALA_INVOKABLE (self))) {
		return NULL;
	}
	ValaCallback* __temp1 = NULL;
	ValaCallback* cb = (__temp1 = VALA_CALLBACK (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (self))), (__temp1 == NULL ? NULL : g_object_ref (__temp1)));
	GList* __temp2 = NULL;
	return (__temp2 = vala_callback_get_parameters (cb), (cb == NULL ? NULL : (cb = (g_object_unref (cb), NULL))), __temp2);
	(cb == NULL ? NULL : (cb = (g_object_unref (cb), NULL)));
}


static ValaTypeReference* vala_variable_declarator_real_get_return_type (ValaInvokable* base)
{
	ValaVariableDeclarator * self = VALA_VARIABLE_DECLARATOR (base);
	if (!vala_invokable_is_invokable (VALA_INVOKABLE (self))) {
		return VALA_TYPE_REFERENCE (NULL);
	}
	ValaCallback* __temp4 = NULL;
	ValaCallback* cb = (__temp4 = VALA_CALLBACK (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (self))), (__temp4 == NULL ? NULL : g_object_ref (__temp4)));
	ValaTypeReference* __temp5 = NULL;
	ValaTypeReference* __temp6 = NULL;
	return (__temp6 = (__temp5 = vala_callback_get_return_type (cb), (__temp5 == NULL ? NULL : g_object_ref (__temp5))), (cb == NULL ? NULL : (cb = (g_object_unref (cb), NULL))), __temp6);
	(cb == NULL ? NULL : (cb = (g_object_unref (cb), NULL)));
}


static gboolean vala_variable_declarator_real_is_invokable (ValaInvokable* base)
{
	ValaVariableDeclarator * self = VALA_VARIABLE_DECLARATOR (base);
	return (VALA_IS_CALLBACK (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (self))));
}


static void vala_variable_declarator_real_replace (ValaCodeNode* base, ValaCodeNode* old_node, ValaCodeNode* new_node)
{
	ValaVariableDeclarator * self = VALA_VARIABLE_DECLARATOR (base);
	g_return_if_fail (VALA_IS_CODE_NODE (old_node));
	g_return_if_fail (VALA_IS_CODE_NODE (new_node));
	if (VALA_CODE_NODE (vala_variable_declarator_get_initializer (self)) == old_node) {
		(vala_variable_declarator_set_initializer (self, VALA_EXPRESSION (new_node)), vala_variable_declarator_get_initializer (self));
	}
}


char* vala_variable_declarator_get_name (ValaVariableDeclarator* self)
{
	g_return_val_if_fail (VALA_IS_VARIABLE_DECLARATOR (self), NULL);
	return self->priv->_name;
}


void vala_variable_declarator_set_name (ValaVariableDeclarator* self, const char* value)
{
	g_return_if_fail (VALA_IS_VARIABLE_DECLARATOR (self));
	char* __temp9 = NULL;
	self->priv->_name = (__temp9 = g_strdup (value), (self->priv->_name = (g_free (self->priv->_name), NULL)), __temp9);
}


ValaExpression* vala_variable_declarator_get_initializer (ValaVariableDeclarator* self)
{
	g_return_val_if_fail (VALA_IS_VARIABLE_DECLARATOR (self), NULL);
	return self->priv->_initializer;
}


void vala_variable_declarator_set_initializer (ValaVariableDeclarator* self, ValaExpression* value)
{
	g_return_if_fail (VALA_IS_VARIABLE_DECLARATOR (self));
	ValaExpression* __temp12 = NULL;
	ValaExpression* __temp11 = NULL;
	self->priv->_initializer = (__temp12 = (__temp11 = value, (__temp11 == NULL ? NULL : g_object_ref (__temp11))), (self->priv->_initializer == NULL ? NULL : (self->priv->_initializer = (g_object_unref (self->priv->_initializer), NULL))), __temp12);
	if (self->priv->_initializer != NULL) {
		(vala_code_node_set_parent_node (VALA_CODE_NODE (self->priv->_initializer), VALA_CODE_NODE (self)), vala_code_node_get_parent_node (VALA_CODE_NODE (self->priv->_initializer)));
	}
}


ValaTypeReference* vala_variable_declarator_get_type_reference (ValaVariableDeclarator* self)
{
	g_return_val_if_fail (VALA_IS_VARIABLE_DECLARATOR (self), NULL);
	return self->priv->_type_reference;
}


void vala_variable_declarator_set_type_reference (ValaVariableDeclarator* self, ValaTypeReference* value)
{
	g_return_if_fail (VALA_IS_VARIABLE_DECLARATOR (self));
	ValaTypeReference* __temp15 = NULL;
	ValaTypeReference* __temp14 = NULL;
	self->priv->_type_reference = (__temp15 = (__temp14 = value, (__temp14 == NULL ? NULL : g_object_ref (__temp14))), (self->priv->_type_reference == NULL ? NULL : (self->priv->_type_reference = (g_object_unref (self->priv->_type_reference), NULL))), __temp15);
}


static void vala_variable_declarator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaVariableDeclarator * self = VALA_VARIABLE_DECLARATOR (object);
	switch (property_id) {
		case VALA_VARIABLE_DECLARATOR_NAME:
		g_value_set_string (value, vala_variable_declarator_get_name (self));
		break;
		case VALA_VARIABLE_DECLARATOR_INITIALIZER:
		g_value_set_object (value, vala_variable_declarator_get_initializer (self));
		break;
		case VALA_VARIABLE_DECLARATOR_TYPE_REFERENCE:
		g_value_set_object (value, vala_variable_declarator_get_type_reference (self));
		break;
	}
}


static void vala_variable_declarator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaVariableDeclarator * self = VALA_VARIABLE_DECLARATOR (object);
	switch (property_id) {
		case VALA_VARIABLE_DECLARATOR_NAME:
		vala_variable_declarator_set_name (self, g_value_get_string (value));
		break;
		case VALA_VARIABLE_DECLARATOR_INITIALIZER:
		vala_variable_declarator_set_initializer (self, g_value_get_object (value));
		break;
		case VALA_VARIABLE_DECLARATOR_TYPE_REFERENCE:
		vala_variable_declarator_set_type_reference (self, g_value_get_object (value));
		break;
	}
}


static void vala_variable_declarator_class_init (ValaVariableDeclaratorClass * klass)
{
	vala_variable_declarator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaVariableDeclaratorPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_variable_declarator_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_variable_declarator_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_variable_declarator_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_variable_declarator_real_accept;
	VALA_CODE_NODE_CLASS (klass)->replace = vala_variable_declarator_real_replace;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_VARIABLE_DECLARATOR_NAME, g_param_spec_string ("name", "foo", "bar", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_VARIABLE_DECLARATOR_INITIALIZER, g_param_spec_object ("initializer", "foo", "bar", VALA_TYPE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_VARIABLE_DECLARATOR_TYPE_REFERENCE, g_param_spec_object ("type-reference", "foo", "bar", VALA_TYPE_TYPE_REFERENCE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_variable_declarator_vala_invokable_interface_init (ValaInvokableIface * iface)
{
	vala_variable_declarator_vala_invokable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_parameters = vala_variable_declarator_real_get_parameters;
	iface->get_return_type = vala_variable_declarator_real_get_return_type;
	iface->is_invokable = vala_variable_declarator_real_is_invokable;
}


static void vala_variable_declarator_init (ValaVariableDeclarator * self)
{
	self->priv = VALA_VARIABLE_DECLARATOR_GET_PRIVATE (self);
}


static void vala_variable_declarator_dispose (GObject * obj)
{
	ValaVariableDeclarator * self = VALA_VARIABLE_DECLARATOR (obj);
	(self->priv->_name = (g_free (self->priv->_name), NULL));
	(self->priv->_type_reference == NULL ? NULL : (self->priv->_type_reference = (g_object_unref (self->priv->_type_reference), NULL)));
	(self->priv->_initializer == NULL ? NULL : (self->priv->_initializer = (g_object_unref (self->priv->_initializer), NULL)));
	ValaVariableDeclaratorClass * klass;
	GObjectClass * parent_class;
	klass = VALA_VARIABLE_DECLARATOR_CLASS (g_type_class_peek (VALA_TYPE_VARIABLE_DECLARATOR));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_variable_declarator_get_type ()
{
	static GType vala_variable_declarator_type_id = 0;
	if (G_UNLIKELY (vala_variable_declarator_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaVariableDeclaratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_variable_declarator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaVariableDeclarator), 0, (GInstanceInitFunc) vala_variable_declarator_init };
		vala_variable_declarator_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaVariableDeclarator", &g_define_type_info, 0);
		static const GInterfaceInfo vala_invokable_info = { (GInterfaceInitFunc) vala_variable_declarator_vala_invokable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		g_type_add_interface_static (vala_variable_declarator_type_id, VALA_TYPE_INVOKABLE, &vala_invokable_info);
	}
	return vala_variable_declarator_type_id;
}




