[CCode (cheader_filename = "ccode/valaccodeassignment.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodeassignment.h")]
	public class CCodeAssignment : Vala.CCodeExpression {
		public CCodeAssignment (Vala.CCodeExpression l, Vala.CCodeExpression r, Vala.CCodeAssignmentOperator op = CCodeAssignmentOperator.SIMPLE);
		public Vala.CCodeExpression left { get; construct; }
		public weak Vala.CCodeAssignmentOperator operator { get; set; }
		public Vala.CCodeExpression right { get; construct; }
	}
}
[CCode (cheader_filename = "ccode/valaccodeassignment.h")]
namespace Vala {
	[CCode (cprefix = "VALA_CCODE_ASSIGNMENT_OPERATOR_")]
	public enum CCodeAssignmentOperator {
		SIMPLE,
		BITWISE_OR,
		BITWISE_AND,
		BITWISE_XOR,
		ADD,
		SUB,
		MUL,
		DIV,
		PERCENT,
		SHIFT_LEFT,
		SHIFT_RIGHT,
	}
}
[CCode (cheader_filename = "ccode/valaccodebinaryexpression.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodebinaryexpression.h")]
	public class CCodeBinaryExpression : Vala.CCodeExpression {
		public CCodeBinaryExpression (Vala.CCodeBinaryOperator op, Vala.CCodeExpression! l, Vala.CCodeExpression! r);
		public weak Vala.CCodeBinaryOperator operator { get; set; }
		public Vala.CCodeExpression left { get; set construct; }
		public Vala.CCodeExpression right { get; set construct; }
	}
}
[CCode (cheader_filename = "ccode/valaccodebinaryexpression.h")]
namespace Vala {
	[CCode (cprefix = "VALA_CCODE_BINARY_OPERATOR_")]
	public enum CCodeBinaryOperator {
		PLUS,
		MINUS,
		MUL,
		DIV,
		MOD,
		SHIFT_LEFT,
		SHIFT_RIGHT,
		LESS_THAN,
		GREATER_THAN,
		LESS_THAN_OR_EQUAL,
		GREATER_THAN_OR_EQUAL,
		EQUALITY,
		INEQUALITY,
		BITWISE_AND,
		BITWISE_OR,
		BITWISE_XOR,
		AND,
		OR,
	}
}
[CCode (cheader_filename = "ccode/valaccodeblock.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodeblock.h")]
	public class CCodeBlock : Vala.CCodeStatement {
		public void prepend_statement (Vala.CCodeNode! statement);
		public void add_statement (Vala.CCodeNode! statement);
		public weak bool suppress_newline { get; set; }
	}
}
[CCode (cheader_filename = "ccode/valaccodebreakstatement.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodebreakstatement.h")]
	public class CCodeBreakStatement : Vala.CCodeStatement {
	}
}
[CCode (cheader_filename = "ccode/valaccodecasestatement.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodecasestatement.h")]
	public class CCodeCaseStatement : Vala.CCodeStatement {
		public CCodeCaseStatement (Vala.CCodeExpression! expr);
		public void add_statement (Vala.CCodeStatement! stmt);
		public Vala.CCodeExpression expression { get; set construct; }
	}
}
[CCode (cheader_filename = "ccode/valaccodecastexpression.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodecastexpression.h")]
	public class CCodeCastExpression : Vala.CCodeExpression {
		public CCodeCastExpression (Vala.CCodeExpression! expr, string! type);
		public Vala.CCodeExpression inner { get; set construct; }
		public string type_name { get; set construct; }
	}
}
[CCode (cheader_filename = "ccode/valaccodecommaexpression.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodecommaexpression.h")]
	public class CCodeCommaExpression : Vala.CCodeExpression {
		public void append_expression (Vala.CCodeExpression! expr);
	}
}
[CCode (cheader_filename = "ccode/valaccodecomment.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodecomment.h")]
	public class CCodeComment : Vala.CCodeNode {
		public CCodeComment (string! _text);
		public string text { get; set construct; }
	}
}
[CCode (cheader_filename = "ccode/valaccodeconditionalexpression.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodeconditionalexpression.h")]
	public class CCodeConditionalExpression : Vala.CCodeExpression {
		public CCodeConditionalExpression (Vala.CCodeExpression! cond, Vala.CCodeExpression! true_expr, Vala.CCodeExpression! false_expr);
		public Vala.CCodeExpression condition { get; set construct; }
		public Vala.CCodeExpression true_expression { get; set construct; }
		public Vala.CCodeExpression false_expression { get; set construct; }
	}
}
[CCode (cheader_filename = "ccode/valaccodeconstant.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodeconstant.h")]
	public class CCodeConstant : Vala.CCodeExpression {
		public CCodeConstant (string! _name);
		public string name { get; set construct; }
	}
}
[CCode (cheader_filename = "ccode/valaccodecontinuestatement.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodecontinuestatement.h")]
	public class CCodeContinueStatement : Vala.CCodeStatement {
	}
}
[CCode (cheader_filename = "ccode/valaccodedeclaration.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodedeclaration.h")]
	public class CCodeDeclaration : Vala.CCodeStatement {
		public CCodeDeclaration (string! _type_name);
		public void add_declarator (Vala.CCodeDeclarator! decl);
		public string type_name { get; set construct; }
		public weak Vala.CCodeModifiers modifiers { get; set; }
	}
}
[CCode (cheader_filename = "ccode/valaccodedeclarator.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodedeclarator.h")]
	public abstract class CCodeDeclarator : Vala.CCodeNode {
	}
}
[CCode (cheader_filename = "ccode/valaccodedostatement.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodedostatement.h")]
	public class CCodeDoStatement : Vala.CCodeStatement {
		public CCodeDoStatement (Vala.CCodeStatement stmt, Vala.CCodeExpression! cond);
		public Vala.CCodeStatement body { get; set; }
		public Vala.CCodeExpression condition { get; set construct; }
	}
}
[CCode (cheader_filename = "ccode/valaccodeemptystatement.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodeemptystatement.h")]
	public class CCodeEmptyStatement : Vala.CCodeStatement {
	}
}
[CCode (cheader_filename = "ccode/valaccodeenum.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodeenum.h")]
	public class CCodeEnum : Vala.CCodeNode {
		public CCodeEnum (string n = null);
		public void add_value (string! name, string value = null);
		public string name { get; set; }
	}
}
[CCode (cheader_filename = "ccode/valaccodeexpression.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodeexpression.h")]
	public abstract class CCodeExpression : Vala.CCodeNode {
	}
}
[CCode (cheader_filename = "ccode/valaccodeexpressionstatement.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodeexpressionstatement.h")]
	public class CCodeExpressionStatement : Vala.CCodeStatement {
		public CCodeExpressionStatement (Vala.CCodeExpression expr);
		public Vala.CCodeExpression expression { get; set construct; }
	}
}
[CCode (cheader_filename = "ccode/valaccodeformalparameter.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodeformalparameter.h")]
	public class CCodeFormalParameter : Vala.CCodeNode {
		public CCodeFormalParameter (string! n, string! type);
		public string name { get; set construct; }
		public string type_name { get; set construct; }
	}
}
[CCode (cheader_filename = "ccode/valaccodeforstatement.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodeforstatement.h")]
	public class CCodeForStatement : Vala.CCodeStatement {
		public CCodeForStatement (Vala.CCodeExpression! cond, Vala.CCodeStatement stmt = null);
		public void add_initializer (Vala.CCodeExpression! expr);
		public void add_iterator (Vala.CCodeExpression! expr);
		public Vala.CCodeExpression condition { get; set construct; }
		public Vala.CCodeStatement body { get; set; }
	}
}
[CCode (cheader_filename = "ccode/valaccodefragment.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodefragment.h")]
	public class CCodeFragment : Vala.CCodeNode {
		public void append (Vala.CCodeNode! node);
		public GLib.List get_children ();
	}
}
[CCode (cheader_filename = "ccode/valaccodefunction.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodefunction.h")]
	public class CCodeFunction : Vala.CCodeNode {
		public CCodeFunction (string! _name, string! _return_type);
		public void add_parameter (Vala.CCodeFormalParameter! param);
		public Vala.CCodeFunction! copy ();
		public string name { get; set construct; }
		public weak Vala.CCodeModifiers modifiers { get; set; }
		public string return_type { get; set construct; }
		public Vala.CCodeBlock block { get; set; }
	}
}
[CCode (cheader_filename = "ccode/valaccodefunctioncall.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodefunctioncall.h")]
	public class CCodeFunctionCall : Vala.CCodeExpression {
		public CCodeFunctionCall (Vala.CCodeExpression _call = null);
		public void add_argument (Vala.CCodeExpression! expr);
		public Vala.CCodeExpression call { get; set; }
	}
}
[CCode (cheader_filename = "ccode/valaccodefunctiondeclarator.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodefunctiondeclarator.h")]
	public class CCodeFunctionDeclarator : Vala.CCodeDeclarator {
		public CCodeFunctionDeclarator (string! n);
		public void add_parameter (Vala.CCodeFormalParameter! param);
		public string name { get; set construct; }
	}
}
[CCode (cheader_filename = "ccode/valaccodeidentifier.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodeidentifier.h")]
	public class CCodeIdentifier : Vala.CCodeExpression {
		public CCodeIdentifier (string! _name);
		public string name { get; set construct; }
	}
}
[CCode (cheader_filename = "ccode/valaccodeifstatement.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodeifstatement.h")]
	public class CCodeIfStatement : Vala.CCodeStatement {
		public CCodeIfStatement (Vala.CCodeExpression! cond, Vala.CCodeStatement! true_stmt, Vala.CCodeStatement false_stmt = null);
		public Vala.CCodeExpression condition { get; set construct; }
		public Vala.CCodeStatement true_statement { get; set construct; }
		public Vala.CCodeStatement false_statement { get; set construct; }
		public weak bool else_if { get; set; }
	}
}
[CCode (cheader_filename = "ccode/valaccodeincludedirective.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodeincludedirective.h")]
	public class CCodeIncludeDirective : Vala.CCodeNode {
		public CCodeIncludeDirective (string! _filename, bool _local = false);
		public string filename { get; set construct; }
		public weak bool local { get; set; }
	}
}
[CCode (cheader_filename = "ccode/valaccodeinitializerlist.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodeinitializerlist.h")]
	public class CCodeInitializerList : Vala.CCodeExpression {
		public void append (Vala.CCodeExpression! expr);
	}
}
[CCode (cheader_filename = "ccode/valaccodelinedirective.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodelinedirective.h")]
	public class CCodeLineDirective : Vala.CCodeNode {
		public CCodeLineDirective (string! _filename, int _line);
		public string filename { get; set construct; }
		public weak int line { get; set; }
	}
}
[CCode (cheader_filename = "ccode/valaccodemacroreplacement.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodemacroreplacement.h")]
	public class CCodeMacroReplacement : Vala.CCodeNode {
		public CCodeMacroReplacement (string! n, string! replace);
		public string name { get; set construct; }
		public string replacement { get; set construct; }
	}
}
[CCode (cheader_filename = "ccode/valaccodememberaccess.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodememberaccess.h")]
	public class CCodeMemberAccess : Vala.CCodeExpression {
		public CCodeMemberAccess (Vala.CCodeExpression! container, string! member, bool pointer = false);
		public CCodeMemberAccess.pointer (Vala.CCodeExpression! container, string! member);
		public Vala.CCodeExpression inner { get; set construct; }
		public string member_name { get; set construct; }
		public weak bool is_pointer { get; set; }
	}
}
[CCode (cheader_filename = "ccode/valaccodemodifiers.h")]
namespace Vala {
	[CCode (cprefix = "VALA_CCODE_MODIFIERS_")]
	public enum CCodeModifiers {
		NONE,
		STATIC,
		REGISTER,
	}
}
[CCode (cheader_filename = "ccode/valaccodenewline.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodenewline.h")]
	public class CCodeNewline : Vala.CCodeNode {
	}
}
[CCode (cheader_filename = "ccode/valaccodenode.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodenode.h")]
	public abstract class CCodeNode : GLib.Object {
		public abstract void write (Vala.CCodeWriter! writer);
		public Vala.CCodeLineDirective line { get; set; }
	}
}
[CCode (cheader_filename = "ccode/valaccodeoncesection.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodeoncesection.h")]
	public class CCodeOnceSection : Vala.CCodeFragment {
		public CCodeOnceSection (string! def);
		public string define { get; set construct; }
	}
}
[CCode (cheader_filename = "ccode/valaccodeparenthesizedexpression.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodeparenthesizedexpression.h")]
	public class CCodeParenthesizedExpression : Vala.CCodeExpression {
		public CCodeParenthesizedExpression (Vala.CCodeExpression! expr);
		public Vala.CCodeExpression inner { get; set construct; }
	}
}
[CCode (cheader_filename = "ccode/valaccodereturnstatement.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodereturnstatement.h")]
	public class CCodeReturnStatement : Vala.CCodeStatement {
		public CCodeReturnStatement (Vala.CCodeExpression expr = null);
		public Vala.CCodeExpression return_expression { get; set; }
	}
}
[CCode (cheader_filename = "ccode/valaccodestatement.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodestatement.h")]
	public abstract class CCodeStatement : Vala.CCodeNode {
	}
}
[CCode (cheader_filename = "ccode/valaccodestruct.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodestruct.h")]
	public class CCodeStruct : Vala.CCodeNode {
		public CCodeStruct (string! n);
		public void add_declaration (Vala.CCodeDeclaration! decl);
		public void add_field (string! type_name, string! name);
		public string name { get; set construct; }
	}
}
[CCode (cheader_filename = "ccode/valaccodeswitchstatement.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodeswitchstatement.h")]
	public class CCodeSwitchStatement : Vala.CCodeStatement {
		public CCodeSwitchStatement (Vala.CCodeExpression! expr);
		public void add_case (Vala.CCodeCaseStatement! case_stmt);
		public Vala.CCodeExpression expression { get; set construct; }
	}
}
[CCode (cheader_filename = "ccode/valaccodetypedefinition.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodetypedefinition.h")]
	public class CCodeTypeDefinition : Vala.CCodeNode {
		public CCodeTypeDefinition (string type, Vala.CCodeDeclarator decl);
		public string type_name { get; set; }
		public Vala.CCodeDeclarator declarator { get; set; }
	}
}
[CCode (cheader_filename = "ccode/valaccodeunaryexpression.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodeunaryexpression.h")]
	public class CCodeUnaryExpression : Vala.CCodeExpression {
		public CCodeUnaryExpression (Vala.CCodeUnaryOperator op, Vala.CCodeExpression! expr);
		public weak Vala.CCodeUnaryOperator operator { get; set; }
		public Vala.CCodeExpression inner { get; set construct; }
	}
}
[CCode (cheader_filename = "ccode/valaccodeunaryexpression.h")]
namespace Vala {
	[CCode (cprefix = "VALA_CCODE_UNARY_OPERATOR_")]
	public enum CCodeUnaryOperator {
		PLUS,
		MINUS,
		LOGICAL_NEGATION,
		BITWISE_COMPLEMENT,
		POINTER_INDIRECTION,
		ADDRESS_OF,
		PREFIX_INCREMENT,
		PREFIX_DECREMENT,
		POSTFIX_INCREMENT,
		POSTFIX_DECREMENT,
	}
}
[CCode (cheader_filename = "ccode/valaccodevariabledeclarator.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodevariabledeclarator.h")]
	public class CCodeVariableDeclarator : Vala.CCodeDeclarator {
		public CCodeVariableDeclarator (string! _name);
		public CCodeVariableDeclarator.with_initializer (string! _name, Vala.CCodeExpression init);
		public string name { get; set construct; }
		public Vala.CCodeExpression initializer { get; set; }
	}
}
[CCode (cheader_filename = "ccode/valaccodewhilestatement.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodewhilestatement.h")]
	public class CCodeWhileStatement : Vala.CCodeStatement {
		public CCodeWhileStatement (Vala.CCodeExpression! cond, Vala.CCodeStatement stmt = null);
		public Vala.CCodeExpression condition { get; set construct; }
		public Vala.CCodeStatement body { get; set; }
	}
}
[CCode (cheader_filename = "ccode/valaccodewriter.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodewriter.h")]
	public class CCodeWriter : GLib.Object {
		public CCodeWriter (string! _filename);
		public void close ();
		public void write_indent ();
		public void write_string (string! s);
		public void write_newline ();
		public void write_begin_block ();
		public void write_end_block ();
		public void write_comment (string! text);
		public string filename { get; construct; }
		public weak bool bol { get; }
	}
}
[CCode (cheader_filename = "ccode/valaccodeelementaccess.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodeelementaccess.h")]
	public class CCodeElementAccess : Vala.CCodeExpression {
		public CCodeElementAccess (Vala.CCodeExpression! cont, Vala.CCodeExpression! i);
		public Vala.CCodeExpression container { get; set construct; }
		public Vala.CCodeExpression index { get; set construct; }
	}
}
