/* game.c generated by valac 0.22.0, the Vala compiler
 * generated from game.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <math.h>
#include <gobject/gvaluecollector.h>


#define TYPE_TILE (tile_get_type ())
#define TILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TILE, Tile))
#define TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TILE, TileClass))
#define IS_TILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TILE))
#define IS_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TILE))
#define TILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TILE, TileClass))

typedef struct _Tile Tile;
typedef struct _TileClass TileClass;
typedef struct _TilePrivate TilePrivate;
typedef struct _ParamSpecTile ParamSpecTile;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
typedef struct _GamePrivate GamePrivate;
#define _tile_unref0(var) ((var == NULL) ? NULL : (var = (tile_unref (var), NULL)))
#define __g_list_free__tile_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__tile_unref0_ (var), NULL)))

struct _Tile {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TilePrivate * priv;
	gint grid_x;
	gint grid_y;
	gint color;
	gboolean visited;
};

struct _TileClass {
	GTypeClass parent_class;
	void (*finalize) (Tile *self);
};

struct _TilePrivate {
	gboolean _closed;
};

struct _ParamSpecTile {
	GParamSpec parent_instance;
};

struct _Game {
	GObject parent_instance;
	GamePrivate * priv;
};

struct _GameClass {
	GObjectClass parent_class;
};

struct _GamePrivate {
	Tile** tiles;
	gint tiles_length1;
	gint tiles_length2;
	gint _score;
	gint _color_num;
	gint _rows;
	gint _columns;
};


static gpointer tile_parent_class = NULL;
static gpointer game_parent_class = NULL;

gpointer tile_ref (gpointer instance);
void tile_unref (gpointer instance);
GParamSpec* param_spec_tile (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_tile (GValue* value, gpointer v_object);
void value_take_tile (GValue* value, gpointer v_object);
gpointer value_get_tile (const GValue* value);
GType tile_get_type (void) G_GNUC_CONST;
#define TILE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TILE, TilePrivate))
enum  {
	TILE_DUMMY_PROPERTY
};
Tile* tile_new (gint x, gint y, gint c);
Tile* tile_construct (GType object_type, gint x, gint y, gint c);
void tile_update_position (Tile* self, gint new_x, gint new_y);
gboolean tile_get_closed (Tile* self);
void tile_set_closed (Tile* self, gboolean value);
static void g_cclosure_user_marshal_VOID__INT_INT_INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void tile_finalize (Tile* obj);
GType game_get_type (void) G_GNUC_CONST;
#define GAME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GAME, GamePrivate))
enum  {
	GAME_DUMMY_PROPERTY,
	GAME_SCORE,
	GAME_COLOR_NUM,
	GAME_ROWS,
	GAME_COLUMNS
};
Game* game_new (gint rows, gint columns, gint color_num);
Game* game_construct (GType object_type, gint rows, gint columns, gint color_num);
static GList* _game_connected_tiles (Game* self, Tile* li);
gint game_get_rows (Game* self);
gint game_get_columns (Game* self);
static void _tile_unref0_ (gpointer var);
static void _g_list_free__tile_unref0_ (GList* self);
GList* game_connected_tiles (Game* self, Tile* li);
Tile* game_get_tile (Game* self, gint x, gint y);
gboolean game_remove_connected_tiles (Game* self, Tile* tile);
void game_increment_score_from_tiles (Game* self, gint n_tiles);
gboolean game_has_completed (Game* self);
gboolean game_has_won (Game* self);
void game_increment_score (Game* self, gint increment);
void game_reset_visit (Game* self);
gint game_get_score (Game* self);
void game_set_score (Game* self, gint value);
gint game_get_color_num (Game* self);
void game_set_color_num (Game* self, gint value);
void game_set_rows (Game* self, gint value);
void game_set_columns (Game* self, gint value);
static void game_finalize (GObject* obj);
static void _vala_game_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_game_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


Tile* tile_construct (GType object_type, gint x, gint y, gint c) {
	Tile* self = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	self = (Tile*) g_type_create_instance (object_type);
	_tmp0_ = x;
	self->grid_x = _tmp0_;
	_tmp1_ = y;
	self->grid_y = _tmp1_;
	_tmp2_ = c;
	self->color = _tmp2_;
	return self;
}


Tile* tile_new (gint x, gint y, gint c) {
	return tile_construct (TYPE_TILE, x, y, c);
}


void tile_update_position (Tile* self, gint new_x, gint new_y) {
	gint old_x = 0;
	gint _tmp0_ = 0;
	gint old_y = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->grid_x;
	old_x = _tmp0_;
	_tmp1_ = self->grid_y;
	old_y = _tmp1_;
	_tmp3_ = new_x;
	_tmp4_ = old_x;
	if (_tmp3_ != _tmp4_) {
		_tmp2_ = TRUE;
	} else {
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		_tmp5_ = new_y;
		_tmp6_ = old_y;
		_tmp2_ = _tmp5_ != _tmp6_;
	}
	_tmp7_ = _tmp2_;
	if (_tmp7_) {
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		_tmp8_ = new_x;
		self->grid_x = _tmp8_;
		_tmp9_ = new_y;
		self->grid_y = _tmp9_;
		_tmp10_ = tile_get_closed (self);
		_tmp11_ = _tmp10_;
		if (!_tmp11_) {
			gint _tmp12_ = 0;
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			_tmp12_ = old_x;
			_tmp13_ = old_y;
			_tmp14_ = new_x;
			_tmp15_ = new_y;
			g_signal_emit_by_name (self, "move", _tmp12_, _tmp13_, _tmp14_, _tmp15_);
		}
	}
}


gboolean tile_get_closed (Tile* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_closed;
	result = _tmp0_;
	return result;
}


void tile_set_closed (Tile* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_closed = _tmp0_;
	_tmp1_ = self->priv->_closed;
	if (_tmp1_) {
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		_tmp2_ = self->grid_x;
		_tmp3_ = self->grid_y;
		g_signal_emit_by_name (self, "close", _tmp2_, _tmp3_);
	}
}


static void g_cclosure_user_marshal_VOID__INT_INT_INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT_INT_INT_INT) (gpointer data1, gint arg_1, gint arg_2, gint arg_3, gint arg_4, gpointer data2);
	register GMarshalFunc_VOID__INT_INT_INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_INT_INT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), g_value_get_int (param_values + 3), g_value_get_int (param_values + 4), data2);
}


static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT_INT) (gpointer data1, gint arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), data2);
}


static void value_tile_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_tile_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		tile_unref (value->data[0].v_pointer);
	}
}


static void value_tile_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = tile_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_tile_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_tile_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Tile* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = tile_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_tile_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Tile** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = tile_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_tile (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecTile* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_TILE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_tile (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TILE), NULL);
	return value->data[0].v_pointer;
}


void value_set_tile (GValue* value, gpointer v_object) {
	Tile* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TILE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TILE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		tile_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tile_unref (old);
	}
}


void value_take_tile (GValue* value, gpointer v_object) {
	Tile* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TILE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TILE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tile_unref (old);
	}
}


static void tile_class_init (TileClass * klass) {
	tile_parent_class = g_type_class_peek_parent (klass);
	TILE_CLASS (klass)->finalize = tile_finalize;
	g_type_class_add_private (klass, sizeof (TilePrivate));
	g_signal_new ("move", TYPE_TILE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT_INT_INT, G_TYPE_NONE, 4, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT);
	g_signal_new ("close", TYPE_TILE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_INT);
}


static void tile_instance_init (Tile * self) {
	self->priv = TILE_GET_PRIVATE (self);
	self->priv->_closed = FALSE;
	self->visited = FALSE;
	self->ref_count = 1;
}


static void tile_finalize (Tile* obj) {
	Tile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TILE, Tile);
}


/**
 *  This is the model layer of a tile.
 */
GType tile_get_type (void) {
	static volatile gsize tile_type_id__volatile = 0;
	if (g_once_init_enter (&tile_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_tile_init, value_tile_free_value, value_tile_copy_value, value_tile_peek_pointer, "p", value_tile_collect_value, "p", value_tile_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tile_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Tile), 0, (GInstanceInitFunc) tile_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tile_type_id;
		tile_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Tile", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&tile_type_id__volatile, tile_type_id);
	}
	return tile_type_id__volatile;
}


gpointer tile_ref (gpointer instance) {
	Tile* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void tile_unref (gpointer instance) {
	Tile* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TILE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


Game* game_construct (GType object_type, gint rows, gint columns, gint color_num) {
	Game * self = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	Tile** _tmp5_ = NULL;
	self = (Game*) g_object_new (object_type, NULL);
	_tmp0_ = rows;
	self->priv->_rows = _tmp0_;
	_tmp1_ = columns;
	self->priv->_columns = _tmp1_;
	_tmp2_ = color_num;
	self->priv->_color_num = _tmp2_;
	_tmp3_ = rows;
	_tmp4_ = columns;
	_tmp5_ = g_new0 (Tile*, (_tmp3_ * _tmp4_) + 1);
	self->priv->tiles = (_vala_array_free (self->priv->tiles, self->priv->tiles_length1 * self->priv->tiles_length2, (GDestroyNotify) tile_unref), NULL);
	self->priv->tiles = _tmp5_;
	self->priv->tiles_length1 = _tmp3_;
	self->priv->tiles_length2 = _tmp4_;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				gboolean _tmp7_ = FALSE;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				_tmp7_ = _tmp6_;
				if (!_tmp7_) {
					gint _tmp8_ = 0;
					_tmp8_ = x;
					x = _tmp8_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp9_ = x;
				_tmp10_ = columns;
				if (!(_tmp9_ < _tmp10_)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp11_ = FALSE;
						_tmp11_ = TRUE;
						while (TRUE) {
							gboolean _tmp12_ = FALSE;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							gint c = 0;
							gdouble _tmp16_ = 0.0;
							gint _tmp17_ = 0;
							gdouble _tmp18_ = 0.0;
							Tile** _tmp19_ = NULL;
							gint _tmp19__length1 = 0;
							gint _tmp19__length2 = 0;
							gint _tmp20_ = 0;
							gint _tmp21_ = 0;
							gint _tmp22_ = 0;
							gint _tmp23_ = 0;
							gint _tmp24_ = 0;
							Tile* _tmp25_ = NULL;
							Tile* _tmp26_ = NULL;
							_tmp12_ = _tmp11_;
							if (!_tmp12_) {
								gint _tmp13_ = 0;
								_tmp13_ = y;
								y = _tmp13_ + 1;
							}
							_tmp11_ = FALSE;
							_tmp14_ = y;
							_tmp15_ = rows;
							if (!(_tmp14_ < _tmp15_)) {
								break;
							}
							_tmp16_ = g_random_double ();
							_tmp17_ = color_num;
							_tmp18_ = floor (_tmp16_ * _tmp17_);
							c = (gint) _tmp18_;
							_tmp19_ = self->priv->tiles;
							_tmp19__length1 = self->priv->tiles_length1;
							_tmp19__length2 = self->priv->tiles_length2;
							_tmp20_ = y;
							_tmp21_ = x;
							_tmp22_ = x;
							_tmp23_ = y;
							_tmp24_ = c;
							_tmp25_ = tile_new (_tmp22_, _tmp23_, _tmp24_);
							_tile_unref0 (_tmp19_[(_tmp20_ * _tmp19__length2) + _tmp21_]);
							_tmp19_[(_tmp20_ * _tmp19__length2) + _tmp21_] = _tmp25_;
							_tmp26_ = _tmp19_[(_tmp20_ * _tmp19__length2) + _tmp21_];
						}
					}
				}
			}
		}
	}
	return self;
}


Game* game_new (gint rows, gint columns, gint color_num) {
	return game_construct (TYPE_GAME, rows, columns, color_num);
}


static gpointer _tile_ref0 (gpointer self) {
	return self ? tile_ref (self) : NULL;
}


static void _tile_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (tile_unref (var), NULL));
}


static void _g_list_free__tile_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _tile_unref0_, NULL);
	g_list_free (self);
}


static GList* _game_connected_tiles (Game* self, Tile* li) {
	GList* result = NULL;
	GList* cl = NULL;
	gboolean _tmp0_ = FALSE;
	Tile* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gint x = 0;
	Tile* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint y = 0;
	Tile* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	Tile* _tmp11_ = NULL;
	Tile* _tmp12_ = NULL;
	Tile* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp30_ = FALSE;
	gboolean _tmp36_ = FALSE;
	gboolean _tmp37_ = FALSE;
	gint _tmp38_ = 0;
	gboolean _tmp43_ = FALSE;
	gboolean _tmp51_ = FALSE;
	gboolean _tmp57_ = FALSE;
	gboolean _tmp58_ = FALSE;
	gint _tmp59_ = 0;
	gint _tmp60_ = 0;
	gboolean _tmp65_ = FALSE;
	gboolean _tmp73_ = FALSE;
	gboolean _tmp79_ = FALSE;
	gboolean _tmp80_ = FALSE;
	gint _tmp81_ = 0;
	gboolean _tmp86_ = FALSE;
	gboolean _tmp94_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	cl = NULL;
	_tmp1_ = li;
	_tmp2_ = _tmp1_->visited;
	if (_tmp2_) {
		_tmp0_ = TRUE;
	} else {
		Tile* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		_tmp3_ = li;
		_tmp4_ = tile_get_closed (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp5_;
	}
	_tmp6_ = _tmp0_;
	if (_tmp6_) {
		result = cl;
		return result;
	}
	_tmp7_ = li;
	_tmp8_ = _tmp7_->grid_x;
	x = _tmp8_;
	_tmp9_ = li;
	_tmp10_ = _tmp9_->grid_y;
	y = _tmp10_;
	_tmp11_ = li;
	_tmp11_->visited = TRUE;
	_tmp12_ = li;
	_tmp13_ = _tile_ref0 (_tmp12_);
	cl = g_list_append (cl, _tmp13_);
	_tmp16_ = y;
	_tmp17_ = self->priv->_rows;
	if ((_tmp16_ + 1) < _tmp17_) {
		Tile** _tmp18_ = NULL;
		gint _tmp18__length1 = 0;
		gint _tmp18__length2 = 0;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		Tile* _tmp21_ = NULL;
		_tmp18_ = self->priv->tiles;
		_tmp18__length1 = self->priv->tiles_length1;
		_tmp18__length2 = self->priv->tiles_length2;
		_tmp19_ = y;
		_tmp20_ = x;
		_tmp21_ = _tmp18_[((_tmp19_ + 1) * _tmp18__length2) + _tmp20_];
		_tmp15_ = _tmp21_ != NULL;
	} else {
		_tmp15_ = FALSE;
	}
	_tmp22_ = _tmp15_;
	if (_tmp22_) {
		Tile* _tmp23_ = NULL;
		gint _tmp24_ = 0;
		Tile** _tmp25_ = NULL;
		gint _tmp25__length1 = 0;
		gint _tmp25__length2 = 0;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
		Tile* _tmp28_ = NULL;
		gint _tmp29_ = 0;
		_tmp23_ = li;
		_tmp24_ = _tmp23_->color;
		_tmp25_ = self->priv->tiles;
		_tmp25__length1 = self->priv->tiles_length1;
		_tmp25__length2 = self->priv->tiles_length2;
		_tmp26_ = y;
		_tmp27_ = x;
		_tmp28_ = _tmp25_[((_tmp26_ + 1) * _tmp25__length2) + _tmp27_];
		_tmp29_ = _tmp28_->color;
		_tmp14_ = _tmp24_ == _tmp29_;
	} else {
		_tmp14_ = FALSE;
	}
	_tmp30_ = _tmp14_;
	if (_tmp30_) {
		Tile** _tmp31_ = NULL;
		gint _tmp31__length1 = 0;
		gint _tmp31__length2 = 0;
		gint _tmp32_ = 0;
		gint _tmp33_ = 0;
		Tile* _tmp34_ = NULL;
		GList* _tmp35_ = NULL;
		_tmp31_ = self->priv->tiles;
		_tmp31__length1 = self->priv->tiles_length1;
		_tmp31__length2 = self->priv->tiles_length2;
		_tmp32_ = y;
		_tmp33_ = x;
		_tmp34_ = _tmp31_[((_tmp32_ + 1) * _tmp31__length2) + _tmp33_];
		_tmp35_ = _game_connected_tiles (self, _tmp34_);
		cl = g_list_concat (cl, _tmp35_);
	}
	_tmp38_ = y;
	if ((_tmp38_ - 1) >= 0) {
		Tile** _tmp39_ = NULL;
		gint _tmp39__length1 = 0;
		gint _tmp39__length2 = 0;
		gint _tmp40_ = 0;
		gint _tmp41_ = 0;
		Tile* _tmp42_ = NULL;
		_tmp39_ = self->priv->tiles;
		_tmp39__length1 = self->priv->tiles_length1;
		_tmp39__length2 = self->priv->tiles_length2;
		_tmp40_ = y;
		_tmp41_ = x;
		_tmp42_ = _tmp39_[((_tmp40_ - 1) * _tmp39__length2) + _tmp41_];
		_tmp37_ = _tmp42_ != NULL;
	} else {
		_tmp37_ = FALSE;
	}
	_tmp43_ = _tmp37_;
	if (_tmp43_) {
		Tile* _tmp44_ = NULL;
		gint _tmp45_ = 0;
		Tile** _tmp46_ = NULL;
		gint _tmp46__length1 = 0;
		gint _tmp46__length2 = 0;
		gint _tmp47_ = 0;
		gint _tmp48_ = 0;
		Tile* _tmp49_ = NULL;
		gint _tmp50_ = 0;
		_tmp44_ = li;
		_tmp45_ = _tmp44_->color;
		_tmp46_ = self->priv->tiles;
		_tmp46__length1 = self->priv->tiles_length1;
		_tmp46__length2 = self->priv->tiles_length2;
		_tmp47_ = y;
		_tmp48_ = x;
		_tmp49_ = _tmp46_[((_tmp47_ - 1) * _tmp46__length2) + _tmp48_];
		_tmp50_ = _tmp49_->color;
		_tmp36_ = _tmp45_ == _tmp50_;
	} else {
		_tmp36_ = FALSE;
	}
	_tmp51_ = _tmp36_;
	if (_tmp51_) {
		Tile** _tmp52_ = NULL;
		gint _tmp52__length1 = 0;
		gint _tmp52__length2 = 0;
		gint _tmp53_ = 0;
		gint _tmp54_ = 0;
		Tile* _tmp55_ = NULL;
		GList* _tmp56_ = NULL;
		_tmp52_ = self->priv->tiles;
		_tmp52__length1 = self->priv->tiles_length1;
		_tmp52__length2 = self->priv->tiles_length2;
		_tmp53_ = y;
		_tmp54_ = x;
		_tmp55_ = _tmp52_[((_tmp53_ - 1) * _tmp52__length2) + _tmp54_];
		_tmp56_ = _game_connected_tiles (self, _tmp55_);
		cl = g_list_concat (cl, _tmp56_);
	}
	_tmp59_ = x;
	_tmp60_ = self->priv->_columns;
	if ((_tmp59_ + 1) < _tmp60_) {
		Tile** _tmp61_ = NULL;
		gint _tmp61__length1 = 0;
		gint _tmp61__length2 = 0;
		gint _tmp62_ = 0;
		gint _tmp63_ = 0;
		Tile* _tmp64_ = NULL;
		_tmp61_ = self->priv->tiles;
		_tmp61__length1 = self->priv->tiles_length1;
		_tmp61__length2 = self->priv->tiles_length2;
		_tmp62_ = y;
		_tmp63_ = x;
		_tmp64_ = _tmp61_[(_tmp62_ * _tmp61__length2) + (_tmp63_ + 1)];
		_tmp58_ = _tmp64_ != NULL;
	} else {
		_tmp58_ = FALSE;
	}
	_tmp65_ = _tmp58_;
	if (_tmp65_) {
		Tile* _tmp66_ = NULL;
		gint _tmp67_ = 0;
		Tile** _tmp68_ = NULL;
		gint _tmp68__length1 = 0;
		gint _tmp68__length2 = 0;
		gint _tmp69_ = 0;
		gint _tmp70_ = 0;
		Tile* _tmp71_ = NULL;
		gint _tmp72_ = 0;
		_tmp66_ = li;
		_tmp67_ = _tmp66_->color;
		_tmp68_ = self->priv->tiles;
		_tmp68__length1 = self->priv->tiles_length1;
		_tmp68__length2 = self->priv->tiles_length2;
		_tmp69_ = y;
		_tmp70_ = x;
		_tmp71_ = _tmp68_[(_tmp69_ * _tmp68__length2) + (_tmp70_ + 1)];
		_tmp72_ = _tmp71_->color;
		_tmp57_ = _tmp67_ == _tmp72_;
	} else {
		_tmp57_ = FALSE;
	}
	_tmp73_ = _tmp57_;
	if (_tmp73_) {
		Tile** _tmp74_ = NULL;
		gint _tmp74__length1 = 0;
		gint _tmp74__length2 = 0;
		gint _tmp75_ = 0;
		gint _tmp76_ = 0;
		Tile* _tmp77_ = NULL;
		GList* _tmp78_ = NULL;
		_tmp74_ = self->priv->tiles;
		_tmp74__length1 = self->priv->tiles_length1;
		_tmp74__length2 = self->priv->tiles_length2;
		_tmp75_ = y;
		_tmp76_ = x;
		_tmp77_ = _tmp74_[(_tmp75_ * _tmp74__length2) + (_tmp76_ + 1)];
		_tmp78_ = _game_connected_tiles (self, _tmp77_);
		cl = g_list_concat (cl, _tmp78_);
	}
	_tmp81_ = x;
	if ((_tmp81_ - 1) >= 0) {
		Tile** _tmp82_ = NULL;
		gint _tmp82__length1 = 0;
		gint _tmp82__length2 = 0;
		gint _tmp83_ = 0;
		gint _tmp84_ = 0;
		Tile* _tmp85_ = NULL;
		_tmp82_ = self->priv->tiles;
		_tmp82__length1 = self->priv->tiles_length1;
		_tmp82__length2 = self->priv->tiles_length2;
		_tmp83_ = y;
		_tmp84_ = x;
		_tmp85_ = _tmp82_[(_tmp83_ * _tmp82__length2) + (_tmp84_ - 1)];
		_tmp80_ = _tmp85_ != NULL;
	} else {
		_tmp80_ = FALSE;
	}
	_tmp86_ = _tmp80_;
	if (_tmp86_) {
		Tile* _tmp87_ = NULL;
		gint _tmp88_ = 0;
		Tile** _tmp89_ = NULL;
		gint _tmp89__length1 = 0;
		gint _tmp89__length2 = 0;
		gint _tmp90_ = 0;
		gint _tmp91_ = 0;
		Tile* _tmp92_ = NULL;
		gint _tmp93_ = 0;
		_tmp87_ = li;
		_tmp88_ = _tmp87_->color;
		_tmp89_ = self->priv->tiles;
		_tmp89__length1 = self->priv->tiles_length1;
		_tmp89__length2 = self->priv->tiles_length2;
		_tmp90_ = y;
		_tmp91_ = x;
		_tmp92_ = _tmp89_[(_tmp90_ * _tmp89__length2) + (_tmp91_ - 1)];
		_tmp93_ = _tmp92_->color;
		_tmp79_ = _tmp88_ == _tmp93_;
	} else {
		_tmp79_ = FALSE;
	}
	_tmp94_ = _tmp79_;
	if (_tmp94_) {
		Tile** _tmp95_ = NULL;
		gint _tmp95__length1 = 0;
		gint _tmp95__length2 = 0;
		gint _tmp96_ = 0;
		gint _tmp97_ = 0;
		Tile* _tmp98_ = NULL;
		GList* _tmp99_ = NULL;
		_tmp95_ = self->priv->tiles;
		_tmp95__length1 = self->priv->tiles_length1;
		_tmp95__length2 = self->priv->tiles_length2;
		_tmp96_ = y;
		_tmp97_ = x;
		_tmp98_ = _tmp95_[(_tmp96_ * _tmp95__length2) + (_tmp97_ - 1)];
		_tmp99_ = _game_connected_tiles (self, _tmp98_);
		cl = g_list_concat (cl, _tmp99_);
	}
	result = cl;
	return result;
}


GList* game_connected_tiles (Game* self, Tile* li) {
	GList* result = NULL;
	Tile** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	GList* cl = NULL;
	Tile* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	GList* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (li != NULL, NULL);
	_tmp0_ = self->priv->tiles;
	_tmp0__length1 = self->priv->tiles_length1;
	_tmp0__length2 = self->priv->tiles_length2;
	{
		Tile** l_collection = NULL;
		gint l_collection_length1 = 0;
		gint l_collection_length2 = 0;
		gint l_it = 0;
		l_collection = _tmp0_;
		l_collection_length1 = _tmp0__length1 * _tmp0__length2;
		for (l_it = 0; l_it < (_tmp0__length1 * _tmp0__length2); l_it = l_it + 1) {
			Tile* _tmp1_ = NULL;
			Tile* l = NULL;
			_tmp1_ = _tile_ref0 (l_collection[l_it]);
			l = _tmp1_;
			{
				Tile* _tmp2_ = NULL;
				_tmp2_ = l;
				if (_tmp2_ != NULL) {
					Tile* _tmp3_ = NULL;
					_tmp3_ = l;
					_tmp3_->visited = FALSE;
				}
				_tile_unref0 (l);
			}
		}
	}
	_tmp4_ = li;
	_tmp5_ = _game_connected_tiles (self, _tmp4_);
	cl = _tmp5_;
	_tmp6_ = cl;
	_tmp7_ = g_list_length (_tmp6_);
	if (_tmp7_ < ((guint) 2)) {
		__g_list_free__tile_unref0_0 (cl);
		cl = NULL;
	}
	result = cl;
	return result;
}


Tile* game_get_tile (Game* self, gint x, gint y) {
	Tile* result = NULL;
	Tile** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	Tile* _tmp3_ = NULL;
	Tile* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->tiles;
	_tmp0__length1 = self->priv->tiles_length1;
	_tmp0__length2 = self->priv->tiles_length2;
	_tmp1_ = y;
	_tmp2_ = x;
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
	_tmp4_ = _tile_ref0 (_tmp3_);
	result = _tmp4_;
	return result;
}


gboolean game_remove_connected_tiles (Game* self, Tile* tile) {
	gboolean result = FALSE;
	GList* cl = NULL;
	Tile* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	gint new_x = 0;
	GList* _tmp76_ = NULL;
	guint _tmp77_ = 0U;
	gboolean _tmp78_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tile != NULL, FALSE);
	_tmp0_ = tile;
	_tmp1_ = game_connected_tiles (self, _tmp0_);
	cl = _tmp1_;
	_tmp2_ = cl;
	if (_tmp2_ == NULL) {
		result = FALSE;
		__g_list_free__tile_unref0_0 (cl);
		return result;
	}
	_tmp3_ = cl;
	{
		GList* l_collection = NULL;
		GList* l_it = NULL;
		l_collection = _tmp3_;
		for (l_it = l_collection; l_it != NULL; l_it = l_it->next) {
			Tile* _tmp4_ = NULL;
			Tile* l = NULL;
			_tmp4_ = _tile_ref0 ((Tile*) l_it->data);
			l = _tmp4_;
			{
				Tile* _tmp5_ = NULL;
				_tmp5_ = l;
				tile_set_closed (_tmp5_, TRUE);
				_tile_unref0 (l);
			}
		}
	}
	new_x = 0;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				gboolean _tmp7_ = FALSE;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				GList* not_closed_tiles = NULL;
				GList* closed_tiles = NULL;
				GList* _tmp29_ = NULL;
				gboolean has_empty_col = FALSE;
				gboolean _tmp60_ = FALSE;
				_tmp7_ = _tmp6_;
				if (!_tmp7_) {
					gint _tmp8_ = 0;
					_tmp8_ = x;
					x = _tmp8_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp9_ = x;
				_tmp10_ = self->priv->_columns;
				if (!(_tmp9_ < _tmp10_)) {
					break;
				}
				not_closed_tiles = NULL;
				closed_tiles = NULL;
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp11_ = FALSE;
						_tmp11_ = TRUE;
						while (TRUE) {
							gboolean _tmp12_ = FALSE;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							Tile* li = NULL;
							Tile** _tmp16_ = NULL;
							gint _tmp16__length1 = 0;
							gint _tmp16__length2 = 0;
							gint _tmp17_ = 0;
							gint _tmp18_ = 0;
							Tile* _tmp19_ = NULL;
							Tile* _tmp20_ = NULL;
							Tile* _tmp21_ = NULL;
							Tile* _tmp22_ = NULL;
							gboolean _tmp23_ = FALSE;
							gboolean _tmp24_ = FALSE;
							_tmp12_ = _tmp11_;
							if (!_tmp12_) {
								gint _tmp13_ = 0;
								_tmp13_ = y;
								y = _tmp13_ + 1;
							}
							_tmp11_ = FALSE;
							_tmp14_ = y;
							_tmp15_ = self->priv->_rows;
							if (!(_tmp14_ < _tmp15_)) {
								break;
							}
							_tmp16_ = self->priv->tiles;
							_tmp16__length1 = self->priv->tiles_length1;
							_tmp16__length2 = self->priv->tiles_length2;
							_tmp17_ = y;
							_tmp18_ = x;
							_tmp19_ = _tmp16_[(_tmp17_ * _tmp16__length2) + _tmp18_];
							_tmp20_ = _tile_ref0 (_tmp19_);
							li = _tmp20_;
							_tmp21_ = li;
							if (_tmp21_ == NULL) {
								_tile_unref0 (li);
								break;
							}
							_tmp22_ = li;
							_tmp23_ = tile_get_closed (_tmp22_);
							_tmp24_ = _tmp23_;
							if (_tmp24_) {
								Tile* _tmp25_ = NULL;
								Tile* _tmp26_ = NULL;
								_tmp25_ = li;
								_tmp26_ = _tile_ref0 (_tmp25_);
								closed_tiles = g_list_append (closed_tiles, _tmp26_);
							} else {
								Tile* _tmp27_ = NULL;
								Tile* _tmp28_ = NULL;
								_tmp27_ = li;
								_tmp28_ = _tile_ref0 (_tmp27_);
								not_closed_tiles = g_list_append (not_closed_tiles, _tmp28_);
							}
							_tile_unref0 (li);
						}
					}
				}
				_tmp29_ = closed_tiles;
				closed_tiles = NULL;
				not_closed_tiles = g_list_concat (not_closed_tiles, _tmp29_);
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp30_ = FALSE;
						_tmp30_ = TRUE;
						while (TRUE) {
							gboolean _tmp31_ = FALSE;
							gint _tmp33_ = 0;
							gint _tmp34_ = 0;
							Tile** _tmp35_ = NULL;
							gint _tmp35__length1 = 0;
							gint _tmp35__length2 = 0;
							gint _tmp36_ = 0;
							gint _tmp37_ = 0;
							GList* _tmp38_ = NULL;
							gint _tmp39_ = 0;
							gconstpointer _tmp40_ = NULL;
							Tile* _tmp41_ = NULL;
							Tile* _tmp42_ = NULL;
							_tmp31_ = _tmp30_;
							if (!_tmp31_) {
								gint _tmp32_ = 0;
								_tmp32_ = y;
								y = _tmp32_ + 1;
							}
							_tmp30_ = FALSE;
							_tmp33_ = y;
							_tmp34_ = self->priv->_rows;
							if (!(_tmp33_ < _tmp34_)) {
								break;
							}
							_tmp35_ = self->priv->tiles;
							_tmp35__length1 = self->priv->tiles_length1;
							_tmp35__length2 = self->priv->tiles_length2;
							_tmp36_ = y;
							_tmp37_ = new_x;
							_tmp38_ = not_closed_tiles;
							_tmp39_ = y;
							_tmp40_ = g_list_nth_data (_tmp38_, (guint) _tmp39_);
							_tmp41_ = _tile_ref0 ((Tile*) _tmp40_);
							_tile_unref0 (_tmp35_[(_tmp36_ * _tmp35__length2) + _tmp37_]);
							_tmp35_[(_tmp36_ * _tmp35__length2) + _tmp37_] = _tmp41_;
							_tmp42_ = _tmp35_[(_tmp36_ * _tmp35__length2) + _tmp37_];
						}
					}
				}
				has_empty_col = TRUE;
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp43_ = FALSE;
						_tmp43_ = TRUE;
						while (TRUE) {
							gboolean _tmp44_ = FALSE;
							gint _tmp46_ = 0;
							gint _tmp47_ = 0;
							Tile* l = NULL;
							Tile** _tmp48_ = NULL;
							gint _tmp48__length1 = 0;
							gint _tmp48__length2 = 0;
							gint _tmp49_ = 0;
							gint _tmp50_ = 0;
							Tile* _tmp51_ = NULL;
							Tile* _tmp52_ = NULL;
							Tile* _tmp53_ = NULL;
							Tile* _tmp54_ = NULL;
							gint _tmp55_ = 0;
							gint _tmp56_ = 0;
							Tile* _tmp57_ = NULL;
							gboolean _tmp58_ = FALSE;
							gboolean _tmp59_ = FALSE;
							_tmp44_ = _tmp43_;
							if (!_tmp44_) {
								gint _tmp45_ = 0;
								_tmp45_ = y;
								y = _tmp45_ + 1;
							}
							_tmp43_ = FALSE;
							_tmp46_ = y;
							_tmp47_ = self->priv->_rows;
							if (!(_tmp46_ < _tmp47_)) {
								break;
							}
							_tmp48_ = self->priv->tiles;
							_tmp48__length1 = self->priv->tiles_length1;
							_tmp48__length2 = self->priv->tiles_length2;
							_tmp49_ = y;
							_tmp50_ = new_x;
							_tmp51_ = _tmp48_[(_tmp49_ * _tmp48__length2) + _tmp50_];
							_tmp52_ = _tile_ref0 (_tmp51_);
							l = _tmp52_;
							_tmp53_ = l;
							if (_tmp53_ == NULL) {
								_tile_unref0 (l);
								break;
							}
							_tmp54_ = l;
							_tmp55_ = new_x;
							_tmp56_ = y;
							tile_update_position (_tmp54_, _tmp55_, _tmp56_);
							_tmp57_ = l;
							_tmp58_ = tile_get_closed (_tmp57_);
							_tmp59_ = _tmp58_;
							if (!_tmp59_) {
								has_empty_col = FALSE;
							}
							_tile_unref0 (l);
						}
					}
				}
				_tmp60_ = has_empty_col;
				if (!_tmp60_) {
					gint _tmp61_ = 0;
					_tmp61_ = new_x;
					new_x = _tmp61_ + 1;
				}
				__g_list_free__tile_unref0_0 (closed_tiles);
				__g_list_free__tile_unref0_0 (not_closed_tiles);
			}
		}
	}
	{
		gboolean _tmp62_ = FALSE;
		_tmp62_ = TRUE;
		while (TRUE) {
			gboolean _tmp63_ = FALSE;
			gint _tmp65_ = 0;
			gint _tmp66_ = 0;
			_tmp63_ = _tmp62_;
			if (!_tmp63_) {
				gint _tmp64_ = 0;
				_tmp64_ = new_x;
				new_x = _tmp64_ + 1;
			}
			_tmp62_ = FALSE;
			_tmp65_ = new_x;
			_tmp66_ = self->priv->_columns;
			if (!(_tmp65_ < _tmp66_)) {
				break;
			}
			{
				gint y = 0;
				y = 0;
				{
					gboolean _tmp67_ = FALSE;
					_tmp67_ = TRUE;
					while (TRUE) {
						gboolean _tmp68_ = FALSE;
						gint _tmp70_ = 0;
						gint _tmp71_ = 0;
						Tile** _tmp72_ = NULL;
						gint _tmp72__length1 = 0;
						gint _tmp72__length2 = 0;
						gint _tmp73_ = 0;
						gint _tmp74_ = 0;
						Tile* _tmp75_ = NULL;
						_tmp68_ = _tmp67_;
						if (!_tmp68_) {
							gint _tmp69_ = 0;
							_tmp69_ = y;
							y = _tmp69_ + 1;
						}
						_tmp67_ = FALSE;
						_tmp70_ = y;
						_tmp71_ = self->priv->_rows;
						if (!(_tmp70_ < _tmp71_)) {
							break;
						}
						_tmp72_ = self->priv->tiles;
						_tmp72__length1 = self->priv->tiles_length1;
						_tmp72__length2 = self->priv->tiles_length2;
						_tmp73_ = y;
						_tmp74_ = new_x;
						_tile_unref0 (_tmp72_[(_tmp73_ * _tmp72__length2) + _tmp74_]);
						_tmp72_[(_tmp73_ * _tmp72__length2) + _tmp74_] = NULL;
						_tmp75_ = _tmp72_[(_tmp73_ * _tmp72__length2) + _tmp74_];
					}
				}
			}
		}
	}
	_tmp76_ = cl;
	_tmp77_ = g_list_length (_tmp76_);
	game_increment_score_from_tiles (self, (gint) _tmp77_);
	_tmp78_ = game_has_completed (self);
	if (_tmp78_) {
		gboolean _tmp79_ = FALSE;
		_tmp79_ = game_has_won (self);
		if (_tmp79_) {
			game_increment_score (self, 1000);
		}
		g_signal_emit_by_name (self, "complete");
	}
	result = FALSE;
	__g_list_free__tile_unref0_0 (cl);
	return result;
}


void game_reset_visit (Game* self) {
	Tile** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->tiles;
	_tmp0__length1 = self->priv->tiles_length1;
	_tmp0__length2 = self->priv->tiles_length2;
	{
		Tile** l_collection = NULL;
		gint l_collection_length1 = 0;
		gint l_collection_length2 = 0;
		gint l_it = 0;
		l_collection = _tmp0_;
		l_collection_length1 = _tmp0__length1 * _tmp0__length2;
		for (l_it = 0; l_it < (_tmp0__length1 * _tmp0__length2); l_it = l_it + 1) {
			Tile* _tmp1_ = NULL;
			Tile* l = NULL;
			_tmp1_ = _tile_ref0 (l_collection[l_it]);
			l = _tmp1_;
			{
				Tile* _tmp2_ = NULL;
				_tmp2_ = l;
				if (_tmp2_ != NULL) {
					Tile* _tmp3_ = NULL;
					_tmp3_ = l;
					_tmp3_->visited = FALSE;
				}
				_tile_unref0 (l);
			}
		}
	}
}


gboolean game_has_completed (Game* self) {
	gboolean result = FALSE;
	Tile** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->tiles;
	_tmp0__length1 = self->priv->tiles_length1;
	_tmp0__length2 = self->priv->tiles_length2;
	{
		Tile** l_collection = NULL;
		gint l_collection_length1 = 0;
		gint l_collection_length2 = 0;
		gint l_it = 0;
		l_collection = _tmp0_;
		l_collection_length1 = _tmp0__length1 * _tmp0__length2;
		for (l_it = 0; l_it < (_tmp0__length1 * _tmp0__length2); l_it = l_it + 1) {
			Tile* _tmp1_ = NULL;
			Tile* l = NULL;
			_tmp1_ = _tile_ref0 (l_collection[l_it]);
			l = _tmp1_;
			{
				gboolean _tmp2_ = FALSE;
				gboolean _tmp3_ = FALSE;
				Tile* _tmp4_ = NULL;
				gboolean _tmp8_ = FALSE;
				gboolean _tmp13_ = FALSE;
				_tmp4_ = l;
				if (_tmp4_ != NULL) {
					Tile* _tmp5_ = NULL;
					gboolean _tmp6_ = FALSE;
					gboolean _tmp7_ = FALSE;
					_tmp5_ = l;
					_tmp6_ = tile_get_closed (_tmp5_);
					_tmp7_ = _tmp6_;
					_tmp3_ = !_tmp7_;
				} else {
					_tmp3_ = FALSE;
				}
				_tmp8_ = _tmp3_;
				if (_tmp8_) {
					Tile* _tmp9_ = NULL;
					GList* _tmp10_ = NULL;
					GList* _tmp11_ = NULL;
					guint _tmp12_ = 0U;
					_tmp9_ = l;
					_tmp10_ = game_connected_tiles (self, _tmp9_);
					_tmp11_ = _tmp10_;
					_tmp12_ = g_list_length (_tmp11_);
					_tmp2_ = _tmp12_ > ((guint) 1);
					__g_list_free__tile_unref0_0 (_tmp11_);
				} else {
					_tmp2_ = FALSE;
				}
				_tmp13_ = _tmp2_;
				if (_tmp13_) {
					result = FALSE;
					_tile_unref0 (l);
					return result;
				}
				_tile_unref0 (l);
			}
		}
	}
	result = TRUE;
	return result;
}


gboolean game_has_won (Game* self) {
	gboolean result = FALSE;
	Tile** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->tiles;
	_tmp0__length1 = self->priv->tiles_length1;
	_tmp0__length2 = self->priv->tiles_length2;
	{
		Tile** l_collection = NULL;
		gint l_collection_length1 = 0;
		gint l_collection_length2 = 0;
		gint l_it = 0;
		l_collection = _tmp0_;
		l_collection_length1 = _tmp0__length1 * _tmp0__length2;
		for (l_it = 0; l_it < (_tmp0__length1 * _tmp0__length2); l_it = l_it + 1) {
			Tile* _tmp1_ = NULL;
			Tile* l = NULL;
			_tmp1_ = _tile_ref0 (l_collection[l_it]);
			l = _tmp1_;
			{
				gboolean _tmp2_ = FALSE;
				Tile* _tmp3_ = NULL;
				gboolean _tmp7_ = FALSE;
				_tmp3_ = l;
				if (_tmp3_ != NULL) {
					Tile* _tmp4_ = NULL;
					gboolean _tmp5_ = FALSE;
					gboolean _tmp6_ = FALSE;
					_tmp4_ = l;
					_tmp5_ = tile_get_closed (_tmp4_);
					_tmp6_ = _tmp5_;
					_tmp2_ = !_tmp6_;
				} else {
					_tmp2_ = FALSE;
				}
				_tmp7_ = _tmp2_;
				if (_tmp7_) {
					result = FALSE;
					_tile_unref0 (l);
					return result;
				}
				_tile_unref0 (l);
			}
		}
	}
	result = TRUE;
	return result;
}


void game_increment_score_from_tiles (Game* self, gint n_tiles) {
	gint points_awarded = 0;
	gint _tmp0_ = 0;
	gint _tmp3_ = 0;
	g_return_if_fail (self != NULL);
	points_awarded = 0;
	_tmp0_ = n_tiles;
	if (_tmp0_ >= 3) {
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
		_tmp1_ = n_tiles;
		_tmp2_ = n_tiles;
		points_awarded = (_tmp1_ - 2) * (_tmp2_ - 2);
	}
	_tmp3_ = points_awarded;
	game_increment_score (self, _tmp3_);
}


void game_increment_score (Game* self, gint increment) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_score;
	_tmp1_ = increment;
	game_set_score (self, _tmp0_ + _tmp1_);
	_tmp2_ = increment;
	g_signal_emit_by_name (self, "update-score", _tmp2_);
}


gint game_get_score (Game* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_score;
	result = _tmp0_;
	return result;
}


void game_set_score (Game* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_score = _tmp0_;
	g_object_notify ((GObject *) self, "score");
}


gint game_get_color_num (Game* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_color_num;
	result = _tmp0_;
	return result;
}


void game_set_color_num (Game* self, gint value) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp1_ = value;
	if (_tmp1_ < 2) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp2_ = 0;
		_tmp2_ = value;
		_tmp0_ = _tmp2_ > 4;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		self->priv->_color_num = 3;
	} else {
		gint _tmp4_ = 0;
		_tmp4_ = value;
		self->priv->_color_num = _tmp4_;
	}
	g_object_notify ((GObject *) self, "color-num");
}


gint game_get_rows (Game* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_rows;
	result = _tmp0_;
	return result;
}


void game_set_rows (Game* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_rows = _tmp0_;
	g_object_notify ((GObject *) self, "rows");
}


gint game_get_columns (Game* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_columns;
	result = _tmp0_;
	return result;
}


void game_set_columns (Game* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_columns = _tmp0_;
	g_object_notify ((GObject *) self, "columns");
}


static void game_class_init (GameClass * klass) {
	game_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GamePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_game_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_game_set_property;
	G_OBJECT_CLASS (klass)->finalize = game_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_SCORE, g_param_spec_int ("score", "score", "score", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_COLOR_NUM, g_param_spec_int ("color-num", "color-num", "color-num", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_ROWS, g_param_spec_int ("rows", "rows", "rows", G_MININT, G_MAXINT, 8, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_COLUMNS, g_param_spec_int ("columns", "columns", "columns", G_MININT, G_MAXINT, 8, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("update_score", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
	g_signal_new ("complete", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void game_instance_init (Game * self) {
	self->priv = GAME_GET_PRIVATE (self);
	self->priv->_score = 0;
	self->priv->_color_num = 3;
	self->priv->_rows = 8;
	self->priv->_columns = 8;
}


static void game_finalize (GObject* obj) {
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME, Game);
	self->priv->tiles = (_vala_array_free (self->priv->tiles, self->priv->tiles_length1 * self->priv->tiles_length2, (GDestroyNotify) tile_unref), NULL);
	G_OBJECT_CLASS (game_parent_class)->finalize (obj);
}


/**
 *  This is the model layer of the whole game. All game logic goes here. This class tries not to
 *  bring in any visual stuff to comply the separation of view-model idea.
 */
GType game_get_type (void) {
	static volatile gsize game_type_id__volatile = 0;
	if (g_once_init_enter (&game_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Game), 0, (GInstanceInitFunc) game_instance_init, NULL };
		GType game_type_id;
		game_type_id = g_type_register_static (G_TYPE_OBJECT, "Game", &g_define_type_info, 0);
		g_once_init_leave (&game_type_id__volatile, game_type_id);
	}
	return game_type_id__volatile;
}


static void _vala_game_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME, Game);
	switch (property_id) {
		case GAME_SCORE:
		g_value_set_int (value, game_get_score (self));
		break;
		case GAME_COLOR_NUM:
		g_value_set_int (value, game_get_color_num (self));
		break;
		case GAME_ROWS:
		g_value_set_int (value, game_get_rows (self));
		break;
		case GAME_COLUMNS:
		g_value_set_int (value, game_get_columns (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_game_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME, Game);
	switch (property_id) {
		case GAME_SCORE:
		game_set_score (self, g_value_get_int (value));
		break;
		case GAME_COLOR_NUM:
		game_set_color_num (self, g_value_get_int (value));
		break;
		case GAME_ROWS:
		game_set_rows (self, g_value_get_int (value));
		break;
		case GAME_COLUMNS:
		game_set_columns (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



