/*
 * soup-env.h: SOAP environment
 *
 * Authors:
 *      Rodrigo Moya (rodrigo@ximian.com)
 *
 * Copyright (C) 2001, Ximian, Inc.
 */

#ifndef SOUP_ENV_H
#define SOUP_ENV_H

#include <libsoup/soup-fault.h>

typedef struct _SoupEnv SoupEnv;

SoupEnv     *soup_env_new (void);
void         soup_env_free                     (SoupEnv     *env);

void         soup_env_set_address              (SoupEnv     *env,
						const gchar *address);
const gchar *soup_env_get_address              (SoupEnv     *env);

void         soup_env_set_request_header       (SoupEnv     *env,
						const gchar *key,
						const gchar *value);
const gchar *soup_env_get_request_header       (SoupEnv     *env,
						const gchar *key);
GList       *soup_env_get_request_header_list  (SoupEnv     *env);

void         soup_env_set_response_header      (SoupEnv     *env,
						const gchar *key,
						const gchar *value);
const gchar *soup_env_get_response_header      (SoupEnv     *env,
						const gchar *key);
GList       *soup_env_get_response_header_list (SoupEnv     *env);

SoupFault*   soup_env_get_fault                (SoupEnv     *env);
void         soup_env_set_fault                (SoupEnv     *env,
						SoupFault   *fault);

void         soup_env_clear_request_headers    (SoupEnv     *env);
void         soup_env_clear_response_headers   (SoupEnv     *env);
void         soup_env_clear_fault              (SoupEnv     *env);
void         soup_env_clear_all                (SoupEnv     *env);

#endif
