/*
 * wsdl-schema.h: Build typecodes from XML describing one of the known
 * type systems.
 *
 * Authors:
 *	Dick Porter (dick@ximian.com)
 *
 * Copyright (C) 2001, Ximian, Inc.
 */

#ifndef _WSDL_SCHEMA_H_
#define _WSDL_SCHEMA_H_

#include <glib.h>

#include <tree.h>

#define WSDLNS "http://schemas.xmlsoap.org/wsdl/"
#define SOAPNS "http://schemas.xmlsoap.org/wsdl/soap/"
#define XSDNS "http://www.w3.org/1999/XMLSchema"
#define GLIBNS "http://ximian.com/soup/glib/1.0/"

extern gboolean wsdl_qnamecmp(const xmlNodePtr, const CHAR *, const CHAR *);
extern gboolean wsdl_attrnscmp(const xmlNodePtr, const guchar *, const guchar *);
extern const guchar *wsdl_prefix_to_namespace(const xmlDocPtr,
					      const xmlNodePtr,
					      const guchar *, gboolean);

extern gboolean wsdl_schema_init(const xmlNodePtr, const CHAR **);
extern void wsdl_schema_start_element(const xmlDocPtr, const xmlNodePtr, const CHAR **, const guchar *, const guchar *);
extern void wsdl_schema_end_element(const xmlNodePtr);

#endif /* _WSDL_SCHEMA_H_ */
