%define pygtk2_version 2.5.3-2
%define gnome_python2_version 2.6.0-5

%define pyver %(python -c 'import sys ; print sys.version[:3]')
%{!?python_sitelib: %define python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_pytho\n_lib()")}

Name:    sabayon
Version: 0.16
Release: 1
Summary: Tool to maintain user profiles in a GNOME desktop.

Group:   Applications/System
License: GPL
URL:     http://www.gnome.org/projects/sabayon
Source:  sabayon-%{version}.tar.gz

BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

Requires: python-abi = %{pyver}
Requires: gamin-python
Requires: pygtk2 >= %{pygtk2_version}
Requires: gnome-python2-gconf >= %{gnome_python2_version}
Requires: xorg-x11-Xnest
Requires: shadow-utils

BuildRequires: desktop-file-utils

Requires(post):  shadow-utils
Requires(preun): shadow-utils

%description
Sabayon is a tool to help sysadmins and user change and maintain the
default behaviour of the GNOME desktop.

%prep
%setup -q

%build
%configure
make %{?_smp_mflags}
gzip -9 ChangeLog

%install
rm -rf $RPM_BUILD_ROOT

%makeinstall PAM_PREFIX=$RPM_BUILD_ROOT%{_sysconfdir}

mkdir -p $RPM_BUILD_ROOT/etc/gconf/2
echo 'include "$(HOME)/.gconf.path.defaults"'  > $RPM_BUILD_ROOT%{_sysconfdir}/gconf/2/local-defaults.path
echo 'include "$(HOME)/.gconf.path.mandatory"' > $RPM_BUILD_ROOT%{_sysconfdir}/gconf/2/local-mandatory.path

desktop-file-install --vendor gnome --delete-original		\
  --dir $RPM_BUILD_ROOT%{_datadir}/applications			\
  $RPM_BUILD_ROOT%{_datadir}/applications/%{name}.desktop

%find_lang sabayon

%clean
rm -rf $RPM_BUILD_ROOT

%pre
/usr/sbin/groupadd -r %{name} &>/dev/null || :
/usr/sbin/useradd  -r -s /sbin/nologin -c "Sabayon user" -g %{name} %{name} &>/dev/null || :
/usr/sbin/usermod -d "" %{name} &>/dev/null || :

%postun
if [ $1 -eq 0 ]; then
  /usr/sbin/userdel  %{name} &>/dev/null || :
  /usr/sbin/groupdel %{name} &>/dev/null || :
fi

%files -f sabayon.lang
%defattr(-, root, root)

%doc AUTHORS ChangeLog.gz NEWS README TODO ISSUES
%doc doc/index.html doc/testing.html doc/helping.html doc/developing.html
%doc doc/sabayon.css doc/*.jpg doc/*.gif

%config(noreplace) /etc/gconf/2/local-defaults.path
%config(noreplace) /etc/gconf/2/local-mandatory.path
%config(noreplace) /etc/pam.d/%{name}
%config(noreplace) /etc/security/console.apps/%{name}
%config(noreplace) /etc/X11/xinit/xinitrc.d/%{name}*

%{_sysconfdir}/desktop-profiles

%{_bindir}/%{name}*
%{_sbindir}/%{name}*
%{_libexecdir}/%{name}*

%{_datadir}/%{name}/glade/%{name}.glade
%{_datadir}/applications/gnome-%{name}.desktop
%{_datadir}/pixmaps/%{name}.png

%{python_sitelib}/%{name}/*.py
%{python_sitelib}/%{name}/*.pyc
%ghost %{python_sitelib}/%{name}/*.pyo
%{python_sitelib}/%{name}/sources/*.py
%{python_sitelib}/%{name}/sources/*.pyc
%ghost %{python_sitelib}/%{name}/sources/*.pyo

%changelog
* Wed Mar 16 2005 Mark McLoughlin <markmc@redhat.com>
- Various changes to bring in line with Fedora package guidelines

* Wed Feb  9 2005 Daniel Veillard <veillard@redhat.com>
- initial version
