Summary: Tool to maintain user profiles in a GNOME desktop.
Name: sabayon
Version: 0.15
Release: 1
License: GPL
Group: System/Configuration/Other
Source: sabayon-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-root
Requires: python 
Requires: gamin-python
Requires: pygtk2 >= 2.5.3-2
Requires: gnome-python2-gconf >= 2.6.0-5
Requires: xorg-x11-Xnest
BuildRequires: python 
URL: http://www.gnome.org/projects/sabayon
Prefix: %{_prefix}
Docdir: %{_docdir}

%description
Sabayon is a tool to help sysadmins and user change and maintain the
default behaviour of the GNOME desktop.

%prep
%setup -q

%build
%configure
make
gzip -9 ChangeLog

%install
rm -fr %{buildroot}

%makeinstall PAM_PREFIX=$RPM_BUILD_ROOT/etc

# FIXME: long term we can't rely on owning these files
mkdir -p $RPM_BUILD_ROOT/etc/gconf/2
echo 'include "$(HOME)/.gconf.path.defaults"'  > $RPM_BUILD_ROOT/etc/gconf/2/local-defaults.path
echo 'include "$(HOME)/.gconf.path.mandatory"' > $RPM_BUILD_ROOT/etc/gconf/2/local-mandatory.path

desktop-file-install --vendor gnome --delete-original		\
  --dir $RPM_BUILD_ROOT%{_datadir}/applications			\
  $RPM_BUILD_ROOT%{_datadir}/applications/*.desktop

%find_lang sabayon

%clean
rm -fr %{buildroot}

%pre
# Create a new user for sabayon, see the ISSUES file
/usr/sbin/useradd -c "Sabayon user" -g nobody -s /sbin/nologin -r sabayon >/dev/null 2>&1 || /bin/true
/usr/sbin/usermod -d "" -s /sbin/nologin sabayon >/dev/null 2>&1
# ignore errors, as we can't disambiguate between sabayon already existed
# and couldn't create account with the current adduser.
exit 0

%files -f sabayon.lang
%defattr(-, root, root)

%doc AUTHORS ChangeLog.gz NEWS README TODO ISSUES
%doc doc/index.html doc/testing.html doc/helping.html doc/developing.html
%doc doc/sabayon.css doc/*.jpg doc/*.gif
%config /etc/gconf/2/local-defaults.path
%config /etc/gconf/2/local-mandatory.path
%config /etc/pam.d/sabayon
%config /etc/security/console.apps/sabayon
%{_bindir}/%{name}*
%{_sbindir}/%{name}*
%{_libexecdir}/%{name}*
%{_datadir}/%{name}/*.py*
%{_datadir}/%{name}/sources/*.py*
%{_datadir}/%{name}/glade/sabayon.glade
%{_datadir}/applications/*.desktop
%{_datadir}/pixmaps/*.png
%{_sysconfdir}/desktop-profiles

%changelog
* Wed Feb  9 2005 Daniel Veillard <veillard@redhat.com>
- initial version
