# PiTiVi , Non-linear video editor
#
#       ui/configure.py
#
# Copyright (c) 2005, Edward Hervey <bilboed@bilboed.com>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this program; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.
"""
Utilities for getting the location of various directories.
Enables identical use for installed and uninstalled versions.
"""

import os.path
import string

LIBDIR = '/usr/lib'
PKGDATADIR = '/usr/share/pitivi'
PIXMAPDIR = '/usr/share/pixmaps'
pitivi_version = '0.11.1.4'
APPNAME = 'PiTiVi'
PYGTK_REQ = '2.8.0'
PYGST_REQ = '0.10.6'
GST_REQ = '0.10.13.1'
GNONLIN_REQ = '0.10.8.1'
PYCAIRO_REQ = '1.0.0'

def _get_root_dir():
    return '/'.join(os.path.dirname(os.path.abspath(__file__)).split('/')[:-1])

def _in_devel():
    rd = _get_root_dir()
    return (os.path.exists(os.path.join(rd, '.svn')) or
            os.path.exists(os.path.join(rd, 'CVS')) or
            os.path.exists(os.path.join(rd, '.git')))

def get_pixmap_dir():
    """ Returns the directory for program-only pixmaps """
    dir = os.path.dirname(os.path.abspath(__file__))
    if _in_devel():
        root = dir
    else:
        root = PKGDATADIR
    return os.path.join(root, 'pixmaps')

def get_global_pixmap_dir():
    """ Returns the directory for global pixmaps (ex : application icon) """
    if _in_devel():
        root = _get_root_dir()
    else:
        root = PIXMAPDIR
    return root
