///
// Copyright (C) 2002 - 2004, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "pdfcanvas.hh"
#include <stdexcept>

xml2ps::PDFCanvas::PDFCanvas(std::streambuf *buf, 
			     const xml2ps::Canvas::PageVec& pages,
			     bool allow_extra_pages)
  : Canvas(pages, allow_extra_pages), out(buf), content(0), cur_rise(0)
{
  newPage();
}

xml2ps::PDFCanvas::~PDFCanvas() {
  document.write(out);
}

void xml2ps::PDFCanvas::newPage() {
  Canvas::newPage();
  content = document.add_page(int(cur_page_->width() + 0.5), 
			      int(cur_page_->height() + 0.5));
}

namespace {
  PDF::Content& nonull(PDF::Content* c) {
    if(!c) throw std::logic_error("Tried to paint on no page");
    return *c;
  }
}

void xml2ps::PDFCanvas::setgray(float gray) {
  nonull(content).setgray(gray);
}

void xml2ps::PDFCanvas::setfont(const font::FontInfo& font) {
  currentfont = &font;
  Canvas::setfont(font);
  nonull(content).selectfont(font);
  nonull(content).setCharSpace(font.getLetterSpacing());
}

void xml2ps::PDFCanvas::moveto(float hpos, float vpos) {
  nonull(content).moveto(hpos, vpos);
}

float xml2ps::PDFCanvas::textRise(float rise) {
  float oldrise = cur_rise;
  nonull(content).textRise(cur_rise = rise);
  return oldrise;
}

float xml2ps::PDFCanvas::getRise() const {
  return cur_rise;
}

void xml2ps::PDFCanvas::setWordSpace(const float& space) {
  // the space parameter is in "times normal width of whitespace"
  // the content parameter is in "text units extra".
  if(!currentfont)
    throw std::runtime_error("Tried to set wordspace w/o current font");
  nonull(content).setWordSpace(currentfont->getWidth(" ") * (space-1));
}

void xml2ps::PDFCanvas::show(const Glib::ustring& text) {
  //  const float ls = font_->getLetterSpacing();
  nonull(content).show(text);
}

void xml2ps::PDFCanvas::whitespace() {
  nonull(content).whitespace();
}

void xml2ps::PDFCanvas::whitespace(const float& space) {
  nonull(content).whitespace(space);
}

void xml2ps::PDFCanvas::underlineFrom(const float& below) {
  // who needs it anyway?
}

void
xml2ps::PDFCanvas::underlineTo(const float& below, const float& thickness) {
  // who needs it anyway?
}

void
xml2ps::PDFCanvas::line(float x1, float y1, float x2, float y2) {
  /// \todo implement drawing a simple line.
}
