///
// Copyright (C) 2002 - 2004, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "errordialog.h"
#include "usererror.h"
#include "util/warning.h"
#include "util/stringutil.h"
#include "wmisc.h"
#include <gtkmm/stock.h>
#include <gtkmm/image.h>
#include <sstream>
#include <string>

ErrorDialog* ErrorDialog::dialog = 0;

void ErrorDialog::init(Gtk::Window& parent) {
  if(!dialog)
    dialog = new ErrorDialog(parent);
}

namespace {
  void exception_handler() {
    try {
      throw;			// rethrow the causing exception
      
    } catch(const UserError& err) {
      // A UserError is any error the user should be able to handle.
      ErrorDialog::view("<b>" + err.get_message() + "</b>\n\n"
			 + err.get_cause());
      
    } catch(const std::exception& err) {
      // All other exceptions that reaches this handler are internal errors.
      ErrorDialog::view("<b>Internal error:</b> " + to_xml(err.what()));
      
    } catch(const Glib::Exception& err) {
      // Glib:.Exception is not a std::exception (why?)
      ErrorDialog::view("<b>Internal error (glib):</b> " 
			+ to_xml(err.what()));
      
    } catch(...) {
      ErrorDialog::view("Unknown internal error\n\n<i>Sorry</i>");
    }
  }
  
}

void ErrorDialog::init_handler() {
  Glib::add_exception_handler(&exception_handler);
}

void ErrorDialog::view(const std::string& message) {
  if(dialog)
    dialog->show_message(message);
  else {
    const std::string line(" - - - - - - - - - - - - - - - - - - - - - - - ");
    warning << "\n" << line
	    << "\n\t" << "Error:" << "\n\t" << message
	    << "\n" << line << "\n";
  }
}

ErrorDialog::ErrorDialog(Gtk::Window &parent)
  : DialogWrap("Error", parent)
{
  set_resizable(false);
  Gtk::Box *box = manage(new Gtk::HBox(false, double_space));
  box->set_border_width(border_width);
  get_vbox()->pack_start(*box);
  
  box->pack_start(*manage(new Gtk::Image(Gtk::Stock::DIALOG_ERROR,
					 Gtk::ICON_SIZE_DIALOG)),
		  Gtk::PACK_SHRINK);
  box->pack_start(label, Gtk::PACK_SHRINK);
  add_button(Gtk::Stock::OK, 0);
}

void ErrorDialog::show_message(const std::string& message) {
  label.set_markup(message);
  show_all();
}

void ErrorDialog::on_response(int /* response_id */) {
  hide();
}
