#ifndef PPT_POSTSCRIPTVIEWENT_H	// -*- C++ -*-
#define PPT_POSTSCRIPTVIEWENT_H
///
// Copyright (C) 2003, 2004, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "viewent.h"
#include "document/cachedframe.h"

class PostscriptViewent : public Viewent {
protected:
  typedef CachedFrame* FrameRef;
  typedef Glib::RefPtr<Gdk::Pixbuf> PixbufRef;
public:
  /**
   * Create a new TextViewent.
   * \param cachedframe
   * \param view
   * \param _scale_factor Create bitmaps this many times bigger than
   *  necessary and scale them down, kind of a poor mans
   *  antialiasing. */
  PostscriptViewent(View& view, const FrameRef cachedframe,
		    int _scale_factor = 1);
  ~PostscriptViewent();
  
  void set_image(const std::string& psfile);
  bool draw_content();
  void clear();
  
protected:
  const Pagent* get_frame() const { return frame; }
  
private:
  void process_stopped(pid_t _pid, bool exited_normally, int exit_code);
  
  FrameRef frame;
  pid_t pid;
  std::string tmp_file;
  int scale_factor;
  PixbufRef pixbuf;
  /** There was a problem with the content */
  bool content_is_broken;
  SigC::Connection procstopcon, propscon, objectcon, zoomcon;
};

#endif
