#ifndef PPT_PAGEVIEWENT_H	// -*- C++ -*-
#define PPT_PAGEVIEWENT_H
///
// Copyright (C) 2003, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "groupviewent.h"
#include "document/page.h"

/**
 * {Viewent} for a {Page}.  Responsible for drawing guides etc, {GroupViewent}
 * draws the actual content.
 */
class PageViewent : public GroupViewent {
  typedef Page* FrameRef;
public:
  PageViewent(View& view, const FrameRef page);
  ~PageViewent();
  
  bool draw_content();
  void clear();
  
protected:
  const Pagent* get_frame() const { return page; }
  
private:
  FrameRef page;
};

#endif
