///
// Copyright (C) 2003, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "rasterviewent.h"

RasterViewent::RasterViewent(View& view, const FrameRef rasterframe)
  : Viewent(view), frame(rasterframe), worker(0),
    propscon(frame->props_changed_signal.connect
	     (SigC::hide<Pagent*>(slot(*this, &RasterViewent::clear)))),
    objectcon(frame->object_changed_signal.connect
	      (SigC::hide<Pagent*>(slot(*this, &RasterViewent::clear)))),
    zoomcon(view.connect_zoom_change
	    (SigC::hide<float>(slot(*this, &RasterViewent::clear))))
{}

bool RasterViewent::draw_content() {
  if(frame->get_association().empty()) {	/// \todo or no such file
    draw_content_missing();
    return true;
  }
  sourcepixbuf = frame->get_filepixbuf();
  
  const Gdk::Point sz(int(view.pt2scr(frame->get_width())),
		      int(view.pt2scr(frame->get_height())));

  if(!screenpixbuf) {
    if(!sourcepixbuf) {
      draw_content_broken();
      return true;
    }
    if(worker) {
      screenpixbuf = worker->getPixbuf();
    } else if(frame->get_matrix().is_plain()) {
      screenpixbuf = sourcepixbuf->scale_simple(sz.get_x(), sz.get_y(),
						Gdk::INTERP_BILINEAR);
    } else {
      worker = new PixbufTransformator
	(sourcepixbuf, view, 
	 Matrix::scaling(double(frame->get_width())/sourcepixbuf->get_width(),
			 double(frame->get_height())/sourcepixbuf->get_height())	 * frame->get_matrix());
      screenpixbuf = worker->getPixbuf();
    }
  }
  
  bool done = true;
  if(worker) {
    if(worker->isDone()) {
      delete worker;  worker = 0;
    } else
      done = false;
  }
  const Matrix m = Matrix::scaling(double(frame->get_width()) / sz.get_x(),
				   double(frame->get_height()) / sz.get_y())
    * frame->get_matrix();
  const Gdk::Point corner[] = {
    view.pt2scr(m.transform(Vector(0, 0))),
    view.pt2scr(m.transform(Vector(0, sz.get_y()))),
    view.pt2scr(m.transform(Vector(sz.get_x(), 0))),
    view.pt2scr(m.transform(Vector(sz.get_x(), sz.get_y())))
  };
  using std::min;
  const int min_x = min(min(corner[0].get_x(), corner[1].get_x()), 
			min(corner[2].get_x(), corner[3].get_x()));
  const int min_y = min(min(corner[0].get_y(), corner[1].get_y()), 
			min(corner[2].get_y(), corner[3].get_y()));
  view.get_win()->draw_pixbuf(view.get_gc(), screenpixbuf,
			      0, 0, min_x, min_y, -1, -1,
			      Gdk::RGB_DITHER_NORMAL, 0, 0);
  return done;
}

void RasterViewent::clear() {
  screenpixbuf.clear();
  /// \todo delete worker!
}
