/*
 *  ORBit-C++: C++ bindings for ORBit.
 *
 *  Copyright (C) 2000 Andreas Kloeckner
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Author:	Andreas Kloeckner <ak@ixion.net>
 *
 *  Purpose:	IDL compiler type representation
 *
 *
 */


#ifndef ORBITCPP_TYPES_IDLBOOLEAN
#define ORBITCPP_TYPES_IDLBOOLEAN

#include "IDLSimpleType.h"


class IDLBoolean
: public IDLSimpleType,
  public IDLUnionDiscriminator
{
protected:
	string get_fixed_cpp_typename () const;
	string get_fixed_c_typename () const;

public:
	string getDefaultValue(set<string> const &labels) const;

	string discr_get_c_typename () const {
		return get_fixed_c_typename ();
	}									
	
	string discr_get_cpp_typename () const {
		return get_fixed_cpp_typename ();
	}									
};

#endif //ORBITCPP_TYPES_IDLBOOLEAN

