
/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */

/*
 *  Medusa
 *
 *  Copyright (C) 2000 Eazel, Inc.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Author: Rebecca Schulman <rebecka@eazel.com>
 */

#include <config.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <glib.h>

#include <libgnomevfs/gnome-vfs-init.h>

#include <medusa-lock-file.h>
#include <medusa-lock-file-paths.h>
#include <medusa-conf.h>
#include <medusa-search-service-private.h>
#include <medusa-master-db.h>


#include "medusa-authenticate.h"
#include "medusa-file-search-parse-transmission.h"


static MedusaMasterDB *master_db; 


/* Setup functions */
/*static void             ensure_index_validity                     (MedusaMasterDB *master_db); */
static int              initialize_socket                         (struct sockaddr_un *daemon_address);

/* Get the transmission, and send the data to get made into a query  */


int main (int argc, char *argv[])
{

  int search_listening_fd;
  struct sockaddr_un *daemon_address;
  int client_fd;
  int address_length;
  char transmission[MAX_LINE];
  int transmission_length;


  gnome_vfs_init ();

  daemon_address = g_new0 (struct sockaddr_un, 1);
  search_listening_fd = initialize_socket  (daemon_address);
  chmod (SEARCH_SOCKET_PATH, S_IRWXU | S_IRWXG | S_IRWXO);

  /* Initialize file system db access */
  master_db = NULL;
#ifdef SEARCH_DAEMON_DEBUG
  printf ("Done initializing database\n");
#endif
  address_length = SUN_LEN (daemon_address);
  for (; ;) {
    /* Receive request */
    client_fd = accept (search_listening_fd, (struct sockaddr *) daemon_address, 
			  &address_length);
    g_return_val_if_fail (client_fd != -1, 0);

    /* acquire lock */
    if (! medusa_lock_file_acquire (MEDUSA_FILE_INDEX_LOCK_FILE)) {
      puts ("ERROR: can't acquire database lock");
      exit (-1);
    }
    if (master_db == NULL) {
            master_db = medusa_master_db_new (ROOT_DIRECTORY,
#ifdef SEARCH_DEBUG
					 MEDUSA_DB_LOG_EVERYTHING
#elif defined(SEARCH_LOG_SMALL)
					 MEDUSA_DB_LOG_ABBREVIATED,
#elif defined(SEARCH_LOG_ERRORS)
					 MEDUSA_DB_LOG_ERRORS,
#else
					 MEDUSA_DB_LOG_NOTHING,
#endif

                                              URI_LIST_NAME,
                                              FILE_SYSTEM_DB_FILE_NAME,
                                              FILE_NAME_HASH_NAME,
                                              DIRECTORY_NAME_HASH_NAME,
                                              MIME_TYPE_HASH_NAME,
                                              TEXT_INDEX_START_FILE_NAME,
                                              TEXT_INDEX_LOCATION_FILE_NAME,
                                              TEXT_INDEX_WORD_FILE_NAME,
                                              TEXT_INDEX_TEMP_FILE_NAME);
    }
    /* check if we need to reinitialize */
    /*    ensure_index_validity (master_db); */

    /* Read all of the data and act on it */
    memset (transmission, 0, MAX_LINE - 1);
    transmission_length = read (client_fd, transmission, MAX_LINE - 1);
    while (transmission_length > 0) {
      medusa_file_search_parse_transmission (transmission, client_fd, master_db);
      memset (transmission, 0, MAX_LINE);
      transmission_length = read (client_fd, transmission, MAX_LINE - 1);
    }      

    /* release lock */
    medusa_lock_file_release (MEDUSA_FILE_INDEX_LOCK_FILE);

  }
  /* Just here for completeness */
  medusa_master_db_unref (master_db); 
  return 0;
}



 

/* What is the hell is this doing??  (--Rebecca)
static void
ensure_index_validity (MedusaMasterDB *master_db) 
{
  struct stat statbuf;
  MedusaFileSystemDB *file_system_db;


  file_system_db = master_db->file_system_db;

  fstat (file_system_db->file_database->file->io_handler->file_descriptor, 
	 &statbuf) ;
  
  if (statbuf.st_nlink == 0) {
    medusa_file_system_db_free (file_system_db); 
    file_system_db = medusa_file_system_db_new (ROOT_DIRECTORY);

#ifdef SEARCH_DAEMON_DEBUG
    printf ("Done reinitializing database\n");
#endif

  }
}
    */


static int
initialize_socket (struct sockaddr_un *daemon_address)
{
  int search_listening_fd; 

  search_listening_fd = socket (AF_LOCAL, SOCK_STREAM, 0);
  g_return_val_if_fail (search_listening_fd != -1, -1);

  daemon_address->sun_family = AF_LOCAL;
  /* FIXME:  This number (108) sucks, but it has no #define in the header.
     What to do? (POSIX requires 100 bytes at least, here)  */
  strncpy (daemon_address->sun_path, SEARCH_SOCKET_PATH, 100);

  /* If socket currently exists, delete it */
  unlink (daemon_address->sun_path);

  g_message  ("Creating socket at %s\n", daemon_address->sun_path);
  g_return_val_if_fail (bind (search_listening_fd, (struct sockaddr *) daemon_address, 
			      SUN_LEN (daemon_address)) != -1, -1);
  
  g_return_val_if_fail (listen (search_listening_fd, 5) != -1, -1);

  return search_listening_fd;
} 



