#
# Note that this is NOT a relocatable package
# $Id: medusa.spec.in,v 1.6 2000/08/10 06:41:39 rslomkow Exp $
#
%define name	 medusa
%define ver      0.2
%define RELEASE  1	 
%define rel      %{?CUSTOM_RELEASE} %{!?CUSTOM_RELEASE:%RELEASE}
%define prefix   /gnome
%define sysconfdir /etc

Summary: Medusa, the gnome search/indexing package
Name: %name
Version: %ver
Release: %rel
Copyright: LGPL
Group: System Environment/Base
Source: ftp://ftp.gnome.org/pub/GNOME/unstable/sources/medusa/medusa-%{ver}.tar.gz
BuildRoot: /var/tmp/medusa
Packager: Eskil Heyn Olsen <deity@eazel.com>
URL: http://www.gnome.org
Prereq: /sbin/install-info
Prefix: %{prefix}
Docdir: %{prefix}/doc
Requires: glib >= 1.2.0
Requires: gnome-vfs >= 0.1

%description
Medusa, the gnome search/indexing package.

GNOME is the GNU Network Object Model Environment.  That's a fancy
name but really GNOME is a nice GUI desktop environment.  It makes
using your computer easy, powerful, and easy to configure.

%package devel
Summary:        Libraries and include files for developing nautilus components
Group:          Development/Libraries
Requires:       %name = %{PACKAGE_VERSION}
Obsoletes:      %{name}-devel

%description devel
This package provides the necessary development libraries and include 
files to allow you to develop medusa components.

%changelog

* Sun Jun 11 2000  Eskil Heyn Olsen <deity@eazel.com>

- Created the .spec file

%prep
%setup

%build
# Needed for snapshot releases.
if [ ! -f configure ]; then
  CFLAGS="$RPM_OPT_FLAGS" ./autogen.sh --prefix=%prefix --sysconfdir=$RPM_BUILD_ROOT/etc
else
  CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%prefix --sysconfdir=$RPM_BUILD_ROOT/etc
fi

if [ "$SMP" != "" ]; then
  (make "MAKE=make -k -j $SMP"; exit 0)
  make
else
  make
fi

%install
rm -rf $RPM_BUILD_ROOT
make prefix=$RPM_BUILD_ROOT%{prefix} install

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-, bin, bin)
%config %{sysconfdir}/vfs/modules/*.conf
%{prefix}/bin/medusa-config
%{prefix}/bin/medusa-indexd
%{prefix}/bin/medusa-searchd
%{prefix}/bin/msearch
%{prefix}/lib/*.0
%{prefix}/lib/*.so
%{prefix}/lib/vfs/modules/*.so
%{prefix}/share/medusa/file-index-stoplist

%doc AUTHORS COPYING ChangeLog NEWS README

%files devel
%defattr(-, bin, bin)
%{prefix}/include/libmedusa/*.h
%{prefix}/lib/*.la
%{prefix}/lib/vfs/modules/*.la
