/* lib.c */
/* This is a generated file.  Please modify `lib.pl' */

#include <glibtop.h>
#include <glibtop/open.h>
#include <glibtop/xmalloc.h>

#include <glibtop/sysdeps.h>
#include <glibtop/union.h>

#include <glibtop/backend.h>

/* Some required fields are missing. */

static void
_glibtop_missing_feature (glibtop *server, const char *feature,
			  const u_int64_t present, u_int64_t *required)
{
	u_int64_t old_required = *required;

	/* Return if we have all required fields. */
	if ((~present & old_required) == 0)
		return;

	switch (server->_param.error_method) {
	case GLIBTOP_ERROR_METHOD_WARN_ONCE:
		*required &= present;
	case GLIBTOP_ERROR_METHOD_WARN:
		glibtop_warn_r (server,
				"glibtop_get_%s (): Client requested "
				"field mask %05lx, but only have %05lx.",
				 feature, (unsigned long) old_required,
				 (unsigned long) present);
		break;
	case GLIBTOP_ERROR_METHOD_ABORT:
		glibtop_error_r (server,
				"glibtop_get_%s (): Client requested "
				"field mask %05lx, but only have %05lx.",
				 feature, (unsigned long) old_required,
				 (unsigned long) present);
		break;
	}
}

/* Library functions. */

int
glibtop_get_cpu_l (glibtop *server, glibtop_cpu *buf)
{
	GSList *list;
	int done = 0;
	int retval = (int) 0;

	glibtop_init_r (&server, (1 << GLIBTOP_SYSDEPS_CPU), 0);

	if (!server->_priv) {
		server->glibtop_errno = GLIBTOP_ERROR_NO_BACKEND_OPENED;
		return -GLIBTOP_ERROR_NO_BACKEND_OPENED;
	}

	for (list = server->_priv->backend_list;
	     list; list = list->next) {
		glibtop_backend *backend = list->data;

		if (!backend->info || !backend->info->call_vector)
			continue;

		if (backend->info->call_vector->cpu) {
			retval = backend->info->call_vector->cpu (server, backend, buf);
			done = 1;
			break;
		}
	}

	if (!done) {
		server->glibtop_errno = GLIBTOP_ERROR_NOT_IMPLEMENTED;
		return -GLIBTOP_ERROR_NOT_IMPLEMENTED;
	}

	if (retval < 0) {
		server->glibtop_errno = -retval;
		goto do_return;
	} else {
		server->glibtop_errno = 0;
	}

	goto check_missing;

check_missing:
	/* Make sure that all required fields are present. */
	if (buf->flags & server->required.cpu)
		_glibtop_missing_feature (server, "cpu", buf->flags,
					  &server->required.cpu);
	goto do_return;

do_return:
	return retval;

}

int
glibtop_get_mem_l (glibtop *server, glibtop_mem *buf)
{
	GSList *list;
	int done = 0;
	int retval = (int) 0;

	glibtop_init_r (&server, (1 << GLIBTOP_SYSDEPS_MEM), 0);

	if (!server->_priv) {
		server->glibtop_errno = GLIBTOP_ERROR_NO_BACKEND_OPENED;
		return -GLIBTOP_ERROR_NO_BACKEND_OPENED;
	}

	for (list = server->_priv->backend_list;
	     list; list = list->next) {
		glibtop_backend *backend = list->data;

		if (!backend->info || !backend->info->call_vector)
			continue;

		if (backend->info->call_vector->mem) {
			retval = backend->info->call_vector->mem (server, backend, buf);
			done = 1;
			break;
		}
	}

	if (!done) {
		server->glibtop_errno = GLIBTOP_ERROR_NOT_IMPLEMENTED;
		return -GLIBTOP_ERROR_NOT_IMPLEMENTED;
	}

	if (retval < 0) {
		server->glibtop_errno = -retval;
		goto do_return;
	} else {
		server->glibtop_errno = 0;
	}

	goto check_missing;

check_missing:
	/* Make sure that all required fields are present. */
	if (buf->flags & server->required.mem)
		_glibtop_missing_feature (server, "mem", buf->flags,
					  &server->required.mem);
	goto do_return;

do_return:
	return retval;

}

int
glibtop_get_swap_l (glibtop *server, glibtop_swap *buf)
{
	GSList *list;
	int done = 0;
	int retval = (int) 0;

	glibtop_init_r (&server, (1 << GLIBTOP_SYSDEPS_SWAP), 0);

	if (!server->_priv) {
		server->glibtop_errno = GLIBTOP_ERROR_NO_BACKEND_OPENED;
		return -GLIBTOP_ERROR_NO_BACKEND_OPENED;
	}

	for (list = server->_priv->backend_list;
	     list; list = list->next) {
		glibtop_backend *backend = list->data;

		if (!backend->info || !backend->info->call_vector)
			continue;

		if (backend->info->call_vector->swap) {
			retval = backend->info->call_vector->swap (server, backend, buf);
			done = 1;
			break;
		}
	}

	if (!done) {
		server->glibtop_errno = GLIBTOP_ERROR_NOT_IMPLEMENTED;
		return -GLIBTOP_ERROR_NOT_IMPLEMENTED;
	}

	if (retval < 0) {
		server->glibtop_errno = -retval;
		goto do_return;
	} else {
		server->glibtop_errno = 0;
	}

	goto check_missing;

check_missing:
	/* Make sure that all required fields are present. */
	if (buf->flags & server->required.swap)
		_glibtop_missing_feature (server, "swap", buf->flags,
					  &server->required.swap);
	goto do_return;

do_return:
	return retval;

}

int
glibtop_get_uptime_l (glibtop *server, glibtop_uptime *buf)
{
	GSList *list;
	int done = 0;
	int retval = (int) 0;

	glibtop_init_r (&server, (1 << GLIBTOP_SYSDEPS_UPTIME), 0);

	if (!server->_priv) {
		server->glibtop_errno = GLIBTOP_ERROR_NO_BACKEND_OPENED;
		return -GLIBTOP_ERROR_NO_BACKEND_OPENED;
	}

	for (list = server->_priv->backend_list;
	     list; list = list->next) {
		glibtop_backend *backend = list->data;

		if (!backend->info || !backend->info->call_vector)
			continue;

		if (backend->info->call_vector->uptime) {
			retval = backend->info->call_vector->uptime (server, backend, buf);
			done = 1;
			break;
		}
	}

	if (!done) {
		server->glibtop_errno = GLIBTOP_ERROR_NOT_IMPLEMENTED;
		return -GLIBTOP_ERROR_NOT_IMPLEMENTED;
	}

	if (retval < 0) {
		server->glibtop_errno = -retval;
		goto do_return;
	} else {
		server->glibtop_errno = 0;
	}

	goto check_missing;

check_missing:
	/* Make sure that all required fields are present. */
	if (buf->flags & server->required.uptime)
		_glibtop_missing_feature (server, "uptime", buf->flags,
					  &server->required.uptime);
	goto do_return;

do_return:
	return retval;

}

int
glibtop_get_loadavg_l (glibtop *server, glibtop_loadavg *buf)
{
	GSList *list;
	int done = 0;
	int retval = (int) 0;

	glibtop_init_r (&server, (1 << GLIBTOP_SYSDEPS_LOADAVG), 0);

	if (!server->_priv) {
		server->glibtop_errno = GLIBTOP_ERROR_NO_BACKEND_OPENED;
		return -GLIBTOP_ERROR_NO_BACKEND_OPENED;
	}

	for (list = server->_priv->backend_list;
	     list; list = list->next) {
		glibtop_backend *backend = list->data;

		if (!backend->info || !backend->info->call_vector)
			continue;

		if (backend->info->call_vector->loadavg) {
			retval = backend->info->call_vector->loadavg (server, backend, buf);
			done = 1;
			break;
		}
	}

	if (!done) {
		server->glibtop_errno = GLIBTOP_ERROR_NOT_IMPLEMENTED;
		return -GLIBTOP_ERROR_NOT_IMPLEMENTED;
	}

	if (retval < 0) {
		server->glibtop_errno = -retval;
		goto do_return;
	} else {
		server->glibtop_errno = 0;
	}

	goto check_missing;

check_missing:
	/* Make sure that all required fields are present. */
	if (buf->flags & server->required.loadavg)
		_glibtop_missing_feature (server, "loadavg", buf->flags,
					  &server->required.loadavg);
	goto do_return;

do_return:
	return retval;

}

int
glibtop_get_shm_limits_l (glibtop *server, glibtop_shm_limits *buf)
{
	GSList *list;
	int done = 0;
	int retval = (int) 0;

	glibtop_init_r (&server, (1 << GLIBTOP_SYSDEPS_SHM_LIMITS), 0);

	if (!server->_priv) {
		server->glibtop_errno = GLIBTOP_ERROR_NO_BACKEND_OPENED;
		return -GLIBTOP_ERROR_NO_BACKEND_OPENED;
	}

	for (list = server->_priv->backend_list;
	     list; list = list->next) {
		glibtop_backend *backend = list->data;

		if (!backend->info || !backend->info->call_vector)
			continue;

		if (backend->info->call_vector->shm_limits) {
			retval = backend->info->call_vector->shm_limits (server, backend, buf);
			done = 1;
			break;
		}
	}

	if (!done) {
		server->glibtop_errno = GLIBTOP_ERROR_NOT_IMPLEMENTED;
		return -GLIBTOP_ERROR_NOT_IMPLEMENTED;
	}

	if (retval < 0) {
		server->glibtop_errno = -retval;
		goto do_return;
	} else {
		server->glibtop_errno = 0;
	}

	goto check_missing;

check_missing:
	/* Make sure that all required fields are present. */
	if (buf->flags & server->required.shm_limits)
		_glibtop_missing_feature (server, "shm_limits", buf->flags,
					  &server->required.shm_limits);
	goto do_return;

do_return:
	return retval;

}

int
glibtop_get_msg_limits_l (glibtop *server, glibtop_msg_limits *buf)
{
	GSList *list;
	int done = 0;
	int retval = (int) 0;

	glibtop_init_r (&server, (1 << GLIBTOP_SYSDEPS_MSG_LIMITS), 0);

	if (!server->_priv) {
		server->glibtop_errno = GLIBTOP_ERROR_NO_BACKEND_OPENED;
		return -GLIBTOP_ERROR_NO_BACKEND_OPENED;
	}

	for (list = server->_priv->backend_list;
	     list; list = list->next) {
		glibtop_backend *backend = list->data;

		if (!backend->info || !backend->info->call_vector)
			continue;

		if (backend->info->call_vector->msg_limits) {
			retval = backend->info->call_vector->msg_limits (server, backend, buf);
			done = 1;
			break;
		}
	}

	if (!done) {
		server->glibtop_errno = GLIBTOP_ERROR_NOT_IMPLEMENTED;
		return -GLIBTOP_ERROR_NOT_IMPLEMENTED;
	}

	if (retval < 0) {
		server->glibtop_errno = -retval;
		goto do_return;
	} else {
		server->glibtop_errno = 0;
	}

	goto check_missing;

check_missing:
	/* Make sure that all required fields are present. */
	if (buf->flags & server->required.msg_limits)
		_glibtop_missing_feature (server, "msg_limits", buf->flags,
					  &server->required.msg_limits);
	goto do_return;

do_return:
	return retval;

}

int
glibtop_get_sem_limits_l (glibtop *server, glibtop_sem_limits *buf)
{
	GSList *list;
	int done = 0;
	int retval = (int) 0;

	glibtop_init_r (&server, (1 << GLIBTOP_SYSDEPS_SEM_LIMITS), 0);

	if (!server->_priv) {
		server->glibtop_errno = GLIBTOP_ERROR_NO_BACKEND_OPENED;
		return -GLIBTOP_ERROR_NO_BACKEND_OPENED;
	}

	for (list = server->_priv->backend_list;
	     list; list = list->next) {
		glibtop_backend *backend = list->data;

		if (!backend->info || !backend->info->call_vector)
			continue;

		if (backend->info->call_vector->sem_limits) {
			retval = backend->info->call_vector->sem_limits (server, backend, buf);
			done = 1;
			break;
		}
	}

	if (!done) {
		server->glibtop_errno = GLIBTOP_ERROR_NOT_IMPLEMENTED;
		return -GLIBTOP_ERROR_NOT_IMPLEMENTED;
	}

	if (retval < 0) {
		server->glibtop_errno = -retval;
		goto do_return;
	} else {
		server->glibtop_errno = 0;
	}

	goto check_missing;

check_missing:
	/* Make sure that all required fields are present. */
	if (buf->flags & server->required.sem_limits)
		_glibtop_missing_feature (server, "sem_limits", buf->flags,
					  &server->required.sem_limits);
	goto do_return;

do_return:
	return retval;

}

unsigned *
glibtop_get_proclist_l (glibtop *server, glibtop_array *array,
                        int64_t which, int64_t arg)
{
	GSList *list;
	int done = 0;
	unsigned * retval = (unsigned *) 0;

	glibtop_init_r (&server, (1 << GLIBTOP_SYSDEPS_PROCLIST), 0);

	if (!server->_priv) {
		server->glibtop_errno = GLIBTOP_ERROR_NO_BACKEND_OPENED;
		goto do_return;
	}

	for (list = server->_priv->backend_list;
	     list; list = list->next) {
		glibtop_backend *backend = list->data;

		if (!backend->info || !backend->info->call_vector)
			continue;

		if (backend->info->call_vector->proclist) {
			retval = backend->info->call_vector->proclist (server, backend, array, which, arg);
			done = 1;
			break;
		}
	}

	if (!done) {
		server->glibtop_errno = GLIBTOP_ERROR_NOT_IMPLEMENTED;
		goto do_return;
	}

	goto check_missing;

check_missing:
	/* Make sure that all required fields are present. */
	goto do_return;

do_return:
	return retval;

}

int
glibtop_get_proc_state_l (glibtop *server, glibtop_proc_state *buf,
                          pid_t pid)
{
	GSList *list;
	int done = 0;
	int retval = (int) 0;

	glibtop_init_r (&server, (1 << GLIBTOP_SYSDEPS_PROC_STATE), 0);

	if (!server->_priv) {
		server->glibtop_errno = GLIBTOP_ERROR_NO_BACKEND_OPENED;
		return -GLIBTOP_ERROR_NO_BACKEND_OPENED;
	}

	for (list = server->_priv->backend_list;
	     list; list = list->next) {
		glibtop_backend *backend = list->data;

		if (!backend->info || !backend->info->call_vector)
			continue;

		if (backend->info->call_vector->proc_state) {
			retval = backend->info->call_vector->proc_state (server, backend, buf, pid);
			done = 1;
			break;
		}
	}

	if (!done) {
		server->glibtop_errno = GLIBTOP_ERROR_NOT_IMPLEMENTED;
		return -GLIBTOP_ERROR_NOT_IMPLEMENTED;
	}

	if (retval < 0) {
		server->glibtop_errno = -retval;
		goto do_return;
	} else {
		server->glibtop_errno = 0;
	}

	goto check_missing;

check_missing:
	/* Make sure that all required fields are present. */
	if (buf->flags & server->required.proc_state)
		_glibtop_missing_feature (server, "proc_state", buf->flags,
					  &server->required.proc_state);
	goto do_return;

do_return:
	return retval;

}

int
glibtop_get_proc_uid_l (glibtop *server, glibtop_proc_uid *buf,
                        pid_t pid)
{
	GSList *list;
	int done = 0;
	int retval = (int) 0;

	glibtop_init_r (&server, (1 << GLIBTOP_SYSDEPS_PROC_UID), 0);

	if (!server->_priv) {
		server->glibtop_errno = GLIBTOP_ERROR_NO_BACKEND_OPENED;
		return -GLIBTOP_ERROR_NO_BACKEND_OPENED;
	}

	for (list = server->_priv->backend_list;
	     list; list = list->next) {
		glibtop_backend *backend = list->data;

		if (!backend->info || !backend->info->call_vector)
			continue;

		if (backend->info->call_vector->proc_uid) {
			retval = backend->info->call_vector->proc_uid (server, backend, buf, pid);
			done = 1;
			break;
		}
	}

	if (!done) {
		server->glibtop_errno = GLIBTOP_ERROR_NOT_IMPLEMENTED;
		return -GLIBTOP_ERROR_NOT_IMPLEMENTED;
	}

	if (retval < 0) {
		server->glibtop_errno = -retval;
		goto do_return;
	} else {
		server->glibtop_errno = 0;
	}

	goto check_missing;

check_missing:
	/* Make sure that all required fields are present. */
	if (buf->flags & server->required.proc_uid)
		_glibtop_missing_feature (server, "proc_uid", buf->flags,
					  &server->required.proc_uid);
	goto do_return;

do_return:
	return retval;

}

int
glibtop_get_proc_mem_l (glibtop *server, glibtop_proc_mem *buf,
                        pid_t pid)
{
	GSList *list;
	int done = 0;
	int retval = (int) 0;

	glibtop_init_r (&server, (1 << GLIBTOP_SYSDEPS_PROC_MEM), 0);

	if (!server->_priv) {
		server->glibtop_errno = GLIBTOP_ERROR_NO_BACKEND_OPENED;
		return -GLIBTOP_ERROR_NO_BACKEND_OPENED;
	}

	for (list = server->_priv->backend_list;
	     list; list = list->next) {
		glibtop_backend *backend = list->data;

		if (!backend->info || !backend->info->call_vector)
			continue;

		if (backend->info->call_vector->proc_mem) {
			retval = backend->info->call_vector->proc_mem (server, backend, buf, pid);
			done = 1;
			break;
		}
	}

	if (!done) {
		server->glibtop_errno = GLIBTOP_ERROR_NOT_IMPLEMENTED;
		return -GLIBTOP_ERROR_NOT_IMPLEMENTED;
	}

	if (retval < 0) {
		server->glibtop_errno = -retval;
		goto do_return;
	} else {
		server->glibtop_errno = 0;
	}

	goto check_missing;

check_missing:
	/* Make sure that all required fields are present. */
	if (buf->flags & server->required.proc_mem)
		_glibtop_missing_feature (server, "proc_mem", buf->flags,
					  &server->required.proc_mem);
	goto do_return;

do_return:
	return retval;

}

int
glibtop_get_proc_time_l (glibtop *server, glibtop_proc_time *buf,
                         pid_t pid)
{
	GSList *list;
	int done = 0;
	int retval = (int) 0;

	glibtop_init_r (&server, (1 << GLIBTOP_SYSDEPS_PROC_TIME), 0);

	if (!server->_priv) {
		server->glibtop_errno = GLIBTOP_ERROR_NO_BACKEND_OPENED;
		return -GLIBTOP_ERROR_NO_BACKEND_OPENED;
	}

	for (list = server->_priv->backend_list;
	     list; list = list->next) {
		glibtop_backend *backend = list->data;

		if (!backend->info || !backend->info->call_vector)
			continue;

		if (backend->info->call_vector->proc_time) {
			retval = backend->info->call_vector->proc_time (server, backend, buf, pid);
			done = 1;
			break;
		}
	}

	if (!done) {
		server->glibtop_errno = GLIBTOP_ERROR_NOT_IMPLEMENTED;
		return -GLIBTOP_ERROR_NOT_IMPLEMENTED;
	}

	if (retval < 0) {
		server->glibtop_errno = -retval;
		goto do_return;
	} else {
		server->glibtop_errno = 0;
	}

	goto check_missing;

check_missing:
	/* Make sure that all required fields are present. */
	if (buf->flags & server->required.proc_time)
		_glibtop_missing_feature (server, "proc_time", buf->flags,
					  &server->required.proc_time);
	goto do_return;

do_return:
	return retval;

}

int
glibtop_get_proc_signal_l (glibtop *server, glibtop_proc_signal *buf,
                           pid_t pid)
{
	GSList *list;
	int done = 0;
	int retval = (int) 0;

	glibtop_init_r (&server, (1 << GLIBTOP_SYSDEPS_PROC_SIGNAL), 0);

	if (!server->_priv) {
		server->glibtop_errno = GLIBTOP_ERROR_NO_BACKEND_OPENED;
		return -GLIBTOP_ERROR_NO_BACKEND_OPENED;
	}

	for (list = server->_priv->backend_list;
	     list; list = list->next) {
		glibtop_backend *backend = list->data;

		if (!backend->info || !backend->info->call_vector)
			continue;

		if (backend->info->call_vector->proc_signal) {
			retval = backend->info->call_vector->proc_signal (server, backend, buf, pid);
			done = 1;
			break;
		}
	}

	if (!done) {
		server->glibtop_errno = GLIBTOP_ERROR_NOT_IMPLEMENTED;
		return -GLIBTOP_ERROR_NOT_IMPLEMENTED;
	}

	if (retval < 0) {
		server->glibtop_errno = -retval;
		goto do_return;
	} else {
		server->glibtop_errno = 0;
	}

	goto check_missing;

check_missing:
	/* Make sure that all required fields are present. */
	if (buf->flags & server->required.proc_signal)
		_glibtop_missing_feature (server, "proc_signal", buf->flags,
					  &server->required.proc_signal);
	goto do_return;

do_return:
	return retval;

}

int
glibtop_get_proc_kernel_l (glibtop *server, glibtop_proc_kernel *buf,
                           pid_t pid)
{
	GSList *list;
	int done = 0;
	int retval = (int) 0;

	glibtop_init_r (&server, (1 << GLIBTOP_SYSDEPS_PROC_KERNEL), 0);

	if (!server->_priv) {
		server->glibtop_errno = GLIBTOP_ERROR_NO_BACKEND_OPENED;
		return -GLIBTOP_ERROR_NO_BACKEND_OPENED;
	}

	for (list = server->_priv->backend_list;
	     list; list = list->next) {
		glibtop_backend *backend = list->data;

		if (!backend->info || !backend->info->call_vector)
			continue;

		if (backend->info->call_vector->proc_kernel) {
			retval = backend->info->call_vector->proc_kernel (server, backend, buf, pid);
			done = 1;
			break;
		}
	}

	if (!done) {
		server->glibtop_errno = GLIBTOP_ERROR_NOT_IMPLEMENTED;
		return -GLIBTOP_ERROR_NOT_IMPLEMENTED;
	}

	if (retval < 0) {
		server->glibtop_errno = -retval;
		goto do_return;
	} else {
		server->glibtop_errno = 0;
	}

	goto check_missing;

check_missing:
	/* Make sure that all required fields are present. */
	if (buf->flags & server->required.proc_kernel)
		_glibtop_missing_feature (server, "proc_kernel", buf->flags,
					  &server->required.proc_kernel);
	goto do_return;

do_return:
	return retval;

}

int
glibtop_get_proc_segment_l (glibtop *server, glibtop_proc_segment *buf,
                            pid_t pid)
{
	GSList *list;
	int done = 0;
	int retval = (int) 0;

	glibtop_init_r (&server, (1 << GLIBTOP_SYSDEPS_PROC_SEGMENT), 0);

	if (!server->_priv) {
		server->glibtop_errno = GLIBTOP_ERROR_NO_BACKEND_OPENED;
		return -GLIBTOP_ERROR_NO_BACKEND_OPENED;
	}

	for (list = server->_priv->backend_list;
	     list; list = list->next) {
		glibtop_backend *backend = list->data;

		if (!backend->info || !backend->info->call_vector)
			continue;

		if (backend->info->call_vector->proc_segment) {
			retval = backend->info->call_vector->proc_segment (server, backend, buf, pid);
			done = 1;
			break;
		}
	}

	if (!done) {
		server->glibtop_errno = GLIBTOP_ERROR_NOT_IMPLEMENTED;
		return -GLIBTOP_ERROR_NOT_IMPLEMENTED;
	}

	if (retval < 0) {
		server->glibtop_errno = -retval;
		goto do_return;
	} else {
		server->glibtop_errno = 0;
	}

	goto check_missing;

check_missing:
	/* Make sure that all required fields are present. */
	if (buf->flags & server->required.proc_segment)
		_glibtop_missing_feature (server, "proc_segment", buf->flags,
					  &server->required.proc_segment);
	goto do_return;

do_return:
	return retval;

}

char **
glibtop_get_proc_args_l (glibtop *server, glibtop_array *array,
                         pid_t pid)
{
	GSList *list;
	int done = 0;
	char ** retval = (char **) 0;

	glibtop_init_r (&server, (1 << GLIBTOP_SYSDEPS_PROC_ARGS), 0);

	if (!server->_priv) {
		server->glibtop_errno = GLIBTOP_ERROR_NO_BACKEND_OPENED;
		goto do_return;
	}

	for (list = server->_priv->backend_list;
	     list; list = list->next) {
		glibtop_backend *backend = list->data;

		if (!backend->info || !backend->info->call_vector)
			continue;

		if (backend->info->call_vector->proc_args) {
			retval = backend->info->call_vector->proc_args (server, backend, array, pid);
			done = 1;
			break;
		}
	}

	if (!done) {
		server->glibtop_errno = GLIBTOP_ERROR_NOT_IMPLEMENTED;
		goto do_return;
	}

	goto check_missing;

check_missing:
	/* Make sure that all required fields are present. */
	goto do_return;

do_return:
	return retval;

}

glibtop_map_entry *
glibtop_get_proc_map_l (glibtop *server, glibtop_array *array,
                        pid_t pid)
{
	GSList *list;
	int done = 0;
	glibtop_map_entry * retval = (glibtop_map_entry *) 0;

	glibtop_init_r (&server, (1 << GLIBTOP_SYSDEPS_PROC_MAP), 0);

	if (!server->_priv) {
		server->glibtop_errno = GLIBTOP_ERROR_NO_BACKEND_OPENED;
		goto do_return;
	}

	for (list = server->_priv->backend_list;
	     list; list = list->next) {
		glibtop_backend *backend = list->data;

		if (!backend->info || !backend->info->call_vector)
			continue;

		if (backend->info->call_vector->proc_map) {
			retval = backend->info->call_vector->proc_map (server, backend, array, pid);
			done = 1;
			break;
		}
	}

	if (!done) {
		server->glibtop_errno = GLIBTOP_ERROR_NOT_IMPLEMENTED;
		goto do_return;
	}

	goto check_missing;

check_missing:
	/* Make sure that all required fields are present. */
	goto do_return;

do_return:
	return retval;

}

glibtop_mountentry *
glibtop_get_mountlist_l (glibtop *server, glibtop_array *array,
                         int all_fs)
{
	GSList *list;
	int done = 0;
	glibtop_mountentry * retval = (glibtop_mountentry *) 0;

	glibtop_init_r (&server, (1 << GLIBTOP_SYSDEPS_MOUNTLIST), 0);

	if (!server->_priv) {
		server->glibtop_errno = GLIBTOP_ERROR_NO_BACKEND_OPENED;
		goto do_return;
	}

	for (list = server->_priv->backend_list;
	     list; list = list->next) {
		glibtop_backend *backend = list->data;

		if (!backend->info || !backend->info->call_vector)
			continue;

		if (backend->info->call_vector->mountlist) {
			retval = backend->info->call_vector->mountlist (server, backend, array, all_fs);
			done = 1;
			break;
		}
	}

	if (!done) {
		server->glibtop_errno = GLIBTOP_ERROR_NOT_IMPLEMENTED;
		goto do_return;
	}

	goto check_missing;

check_missing:
	/* Make sure that all required fields are present. */
	goto do_return;

do_return:
	return retval;

}

int
glibtop_get_fsusage_l (glibtop *server, glibtop_fsusage *buf,
                       const char * mount_dir)
{
	GSList *list;
	int done = 0;
	int retval = (int) 0;

	glibtop_init_r (&server, (1 << GLIBTOP_SYSDEPS_FSUSAGE), 0);

	if (!server->_priv) {
		server->glibtop_errno = GLIBTOP_ERROR_NO_BACKEND_OPENED;
		return -GLIBTOP_ERROR_NO_BACKEND_OPENED;
	}

	for (list = server->_priv->backend_list;
	     list; list = list->next) {
		glibtop_backend *backend = list->data;

		if (!backend->info || !backend->info->call_vector)
			continue;

		if (backend->info->call_vector->fsusage) {
			retval = backend->info->call_vector->fsusage (server, backend, buf, mount_dir);
			done = 1;
			break;
		}
	}

	if (!done) {
		server->glibtop_errno = GLIBTOP_ERROR_NOT_IMPLEMENTED;
		return -GLIBTOP_ERROR_NOT_IMPLEMENTED;
	}

	if (retval < 0) {
		server->glibtop_errno = -retval;
		goto do_return;
	} else {
		server->glibtop_errno = 0;
	}

	goto check_missing;

check_missing:
	/* Make sure that all required fields are present. */
	if (buf->flags & server->required.fsusage)
		_glibtop_missing_feature (server, "fsusage", buf->flags,
					  &server->required.fsusage);
	goto do_return;

do_return:
	return retval;

}

glibtop_interface *
glibtop_get_interface_names_l (glibtop *server, glibtop_array *array,
                               u_int64_t interface, u_int64_t number, u_int64_t instance, u_int64_t strategy)
{
	GSList *list;
	int done = 0;
	glibtop_interface * retval = (glibtop_interface *) 0;

	glibtop_init_r (&server, (1 << GLIBTOP_SYSDEPS_INTERFACE_NAMES), 0);

	if (!server->_priv) {
		server->glibtop_errno = GLIBTOP_ERROR_NO_BACKEND_OPENED;
		goto do_return;
	}

	for (list = server->_priv->backend_list;
	     list; list = list->next) {
		glibtop_backend *backend = list->data;

		if (!backend->info || !backend->info->call_vector)
			continue;

		if (backend->info->call_vector->interface_names) {
			retval = backend->info->call_vector->interface_names (server, backend, array, interface, number, instance, strategy);
			done = 1;
			break;
		}
	}

	if (!done) {
		server->glibtop_errno = GLIBTOP_ERROR_NOT_IMPLEMENTED;
		goto do_return;
	}

	goto check_missing;

check_missing:
	/* Make sure that all required fields are present. */
	goto do_return;

do_return:
	return retval;

}

glibtop_ifaddr *
glibtop_get_netinfo_l (glibtop *server, glibtop_array *array, glibtop_netinfo *buf,
                       const char * interface, u_int64_t transport)
{
	GSList *list;
	int done = 0;
	glibtop_ifaddr * retval = (glibtop_ifaddr *) 0;

	glibtop_init_r (&server, (1 << GLIBTOP_SYSDEPS_NETINFO), 0);

	if (!server->_priv) {
		server->glibtop_errno = GLIBTOP_ERROR_NO_BACKEND_OPENED;
		goto do_return;
	}

	for (list = server->_priv->backend_list;
	     list; list = list->next) {
		glibtop_backend *backend = list->data;

		if (!backend->info || !backend->info->call_vector)
			continue;

		if (backend->info->call_vector->netinfo) {
			retval = backend->info->call_vector->netinfo (server, backend, array, buf, interface, transport);
			done = 1;
			break;
		}
	}

	if (!done) {
		server->glibtop_errno = GLIBTOP_ERROR_NOT_IMPLEMENTED;
		goto do_return;
	}

	goto check_missing;

check_missing:
	/* Make sure that all required fields are present. */
	if (buf->flags & server->required.netinfo)
		_glibtop_missing_feature (server, "netinfo", buf->flags,
					  &server->required.netinfo);
	goto do_return;

do_return:
	return retval;

}

int
glibtop_get_netload_l (glibtop *server, glibtop_netload *buf,
                       const char * interface, unsigned transport, unsigned protocol)
{
	GSList *list;
	int done = 0;
	int retval = (int) 0;

	glibtop_init_r (&server, (1 << GLIBTOP_SYSDEPS_NETLOAD), 0);

	if (!server->_priv) {
		server->glibtop_errno = GLIBTOP_ERROR_NO_BACKEND_OPENED;
		return -GLIBTOP_ERROR_NO_BACKEND_OPENED;
	}

	for (list = server->_priv->backend_list;
	     list; list = list->next) {
		glibtop_backend *backend = list->data;

		if (!backend->info || !backend->info->call_vector)
			continue;

		if (backend->info->call_vector->netload) {
			retval = backend->info->call_vector->netload (server, backend, buf, interface, transport, protocol);
			done = 1;
			break;
		}
	}

	if (!done) {
		server->glibtop_errno = GLIBTOP_ERROR_NOT_IMPLEMENTED;
		return -GLIBTOP_ERROR_NOT_IMPLEMENTED;
	}

	if (retval < 0) {
		server->glibtop_errno = -retval;
		goto do_return;
	} else {
		server->glibtop_errno = 0;
	}

	goto check_missing;

check_missing:
	/* Make sure that all required fields are present. */
	if (buf->flags & server->required.netload)
		_glibtop_missing_feature (server, "netload", buf->flags,
					  &server->required.netload);
	goto do_return;

do_return:
	return retval;

}

int
glibtop_get_ppp_l (glibtop *server, glibtop_ppp *buf,
                   unsigned short device, unsigned short use_isdn)
{
	GSList *list;
	int done = 0;
	int retval = (int) 0;

	glibtop_init_r (&server, (1 << GLIBTOP_SYSDEPS_PPP), 0);

	if (!server->_priv) {
		server->glibtop_errno = GLIBTOP_ERROR_NO_BACKEND_OPENED;
		return -GLIBTOP_ERROR_NO_BACKEND_OPENED;
	}

	for (list = server->_priv->backend_list;
	     list; list = list->next) {
		glibtop_backend *backend = list->data;

		if (!backend->info || !backend->info->call_vector)
			continue;

		if (backend->info->call_vector->ppp) {
			retval = backend->info->call_vector->ppp (server, backend, buf, device, use_isdn);
			done = 1;
			break;
		}
	}

	if (!done) {
		server->glibtop_errno = GLIBTOP_ERROR_NOT_IMPLEMENTED;
		return -GLIBTOP_ERROR_NOT_IMPLEMENTED;
	}

	if (retval < 0) {
		server->glibtop_errno = -retval;
		goto do_return;
	} else {
		server->glibtop_errno = 0;
	}

	goto check_missing;

check_missing:
	/* Make sure that all required fields are present. */
	if (buf->flags & server->required.ppp)
		_glibtop_missing_feature (server, "ppp", buf->flags,
					  &server->required.ppp);
	goto do_return;

do_return:
	return retval;

}

