/* marshal.c */
/* This is a generated file.  Please modify `marshal.pl' */

#include <glibtop.h>
#include <glibtop/open.h>
#include <glibtop/xmalloc.h>

#include <glibtop/sysdeps.h>
#include <glibtop/union.h>

#include "command.h"
#include <glibtop/backend.h>

#include <glibtop-backend-private.h>

#if GLIBTOP_SUID_CPU

static int
_glibtop_get_cpu_c (glibtop *server, glibtop_backend *backend, glibtop_cpu *buf)
{
	unsigned _LIBGTOP_SEND_offset, _LIBGTOP_SEND_len;
	unsigned _LIBGTOP_DATA_len;
	void *_LIBGTOP_SEND_buf, *_LIBGTOP_DATA_buf;
	char *_LIBGTOP_SEND_ptr, *_LIBGTOP_DATA_ptr;
	int retval = (int) 0;

	/* variable initialization */
	_LIBGTOP_SEND_len = 0;
	_LIBGTOP_DATA_len = 0;
	_LIBGTOP_SEND_offset = 0;
	_LIBGTOP_SEND_ptr = (char *) _LIBGTOP_SEND_buf;

	/* send buffer */
	_LIBGTOP_SEND_buf = glibtop_malloc_r (server, _LIBGTOP_SEND_len+1);

	/* data buffer */
	_LIBGTOP_DATA_buf = glibtop_malloc_r (server, _LIBGTOP_DATA_len+1);
	_LIBGTOP_DATA_ptr = _LIBGTOP_DATA_buf;

	/* marshal start */
	memset (_LIBGTOP_SEND_buf, 0, _LIBGTOP_SEND_len);

	glibtop_call_i (server, backend, GLIBTOP_CMND_CPU,
			_LIBGTOP_SEND_len, _LIBGTOP_SEND_buf,
			_LIBGTOP_DATA_len, _LIBGTOP_DATA_buf,
			sizeof (glibtop_cpu), buf,
			&retval);

	glibtop_free_r (server, _LIBGTOP_SEND_buf);
	glibtop_free_r (server, _LIBGTOP_DATA_buf);

	return retval;

}

#endif /* GLIBTOP_SUID_CPU */


#if GLIBTOP_SUID_MEM

static int
_glibtop_get_mem_c (glibtop *server, glibtop_backend *backend, glibtop_mem *buf)
{
	unsigned _LIBGTOP_SEND_offset, _LIBGTOP_SEND_len;
	unsigned _LIBGTOP_DATA_len;
	void *_LIBGTOP_SEND_buf, *_LIBGTOP_DATA_buf;
	char *_LIBGTOP_SEND_ptr, *_LIBGTOP_DATA_ptr;
	int retval = (int) 0;

	/* variable initialization */
	_LIBGTOP_SEND_len = 0;
	_LIBGTOP_DATA_len = 0;
	_LIBGTOP_SEND_offset = 0;
	_LIBGTOP_SEND_ptr = (char *) _LIBGTOP_SEND_buf;

	/* send buffer */
	_LIBGTOP_SEND_buf = glibtop_malloc_r (server, _LIBGTOP_SEND_len+1);

	/* data buffer */
	_LIBGTOP_DATA_buf = glibtop_malloc_r (server, _LIBGTOP_DATA_len+1);
	_LIBGTOP_DATA_ptr = _LIBGTOP_DATA_buf;

	/* marshal start */
	memset (_LIBGTOP_SEND_buf, 0, _LIBGTOP_SEND_len);

	glibtop_call_i (server, backend, GLIBTOP_CMND_MEM,
			_LIBGTOP_SEND_len, _LIBGTOP_SEND_buf,
			_LIBGTOP_DATA_len, _LIBGTOP_DATA_buf,
			sizeof (glibtop_mem), buf,
			&retval);

	glibtop_free_r (server, _LIBGTOP_SEND_buf);
	glibtop_free_r (server, _LIBGTOP_DATA_buf);

	return retval;

}

#endif /* GLIBTOP_SUID_MEM */


#if GLIBTOP_SUID_SWAP

static int
_glibtop_get_swap_c (glibtop *server, glibtop_backend *backend, glibtop_swap *buf)
{
	unsigned _LIBGTOP_SEND_offset, _LIBGTOP_SEND_len;
	unsigned _LIBGTOP_DATA_len;
	void *_LIBGTOP_SEND_buf, *_LIBGTOP_DATA_buf;
	char *_LIBGTOP_SEND_ptr, *_LIBGTOP_DATA_ptr;
	int retval = (int) 0;

	/* variable initialization */
	_LIBGTOP_SEND_len = 0;
	_LIBGTOP_DATA_len = 0;
	_LIBGTOP_SEND_offset = 0;
	_LIBGTOP_SEND_ptr = (char *) _LIBGTOP_SEND_buf;

	/* send buffer */
	_LIBGTOP_SEND_buf = glibtop_malloc_r (server, _LIBGTOP_SEND_len+1);

	/* data buffer */
	_LIBGTOP_DATA_buf = glibtop_malloc_r (server, _LIBGTOP_DATA_len+1);
	_LIBGTOP_DATA_ptr = _LIBGTOP_DATA_buf;

	/* marshal start */
	memset (_LIBGTOP_SEND_buf, 0, _LIBGTOP_SEND_len);

	glibtop_call_i (server, backend, GLIBTOP_CMND_SWAP,
			_LIBGTOP_SEND_len, _LIBGTOP_SEND_buf,
			_LIBGTOP_DATA_len, _LIBGTOP_DATA_buf,
			sizeof (glibtop_swap), buf,
			&retval);

	glibtop_free_r (server, _LIBGTOP_SEND_buf);
	glibtop_free_r (server, _LIBGTOP_DATA_buf);

	return retval;

}

#endif /* GLIBTOP_SUID_SWAP */


#if GLIBTOP_SUID_UPTIME

static int
_glibtop_get_uptime_c (glibtop *server, glibtop_backend *backend, glibtop_uptime *buf)
{
	unsigned _LIBGTOP_SEND_offset, _LIBGTOP_SEND_len;
	unsigned _LIBGTOP_DATA_len;
	void *_LIBGTOP_SEND_buf, *_LIBGTOP_DATA_buf;
	char *_LIBGTOP_SEND_ptr, *_LIBGTOP_DATA_ptr;
	int retval = (int) 0;

	/* variable initialization */
	_LIBGTOP_SEND_len = 0;
	_LIBGTOP_DATA_len = 0;
	_LIBGTOP_SEND_offset = 0;
	_LIBGTOP_SEND_ptr = (char *) _LIBGTOP_SEND_buf;

	/* send buffer */
	_LIBGTOP_SEND_buf = glibtop_malloc_r (server, _LIBGTOP_SEND_len+1);

	/* data buffer */
	_LIBGTOP_DATA_buf = glibtop_malloc_r (server, _LIBGTOP_DATA_len+1);
	_LIBGTOP_DATA_ptr = _LIBGTOP_DATA_buf;

	/* marshal start */
	memset (_LIBGTOP_SEND_buf, 0, _LIBGTOP_SEND_len);

	glibtop_call_i (server, backend, GLIBTOP_CMND_UPTIME,
			_LIBGTOP_SEND_len, _LIBGTOP_SEND_buf,
			_LIBGTOP_DATA_len, _LIBGTOP_DATA_buf,
			sizeof (glibtop_uptime), buf,
			&retval);

	glibtop_free_r (server, _LIBGTOP_SEND_buf);
	glibtop_free_r (server, _LIBGTOP_DATA_buf);

	return retval;

}

#endif /* GLIBTOP_SUID_UPTIME */


#if GLIBTOP_SUID_LOADAVG

static int
_glibtop_get_loadavg_c (glibtop *server, glibtop_backend *backend, glibtop_loadavg *buf)
{
	unsigned _LIBGTOP_SEND_offset, _LIBGTOP_SEND_len;
	unsigned _LIBGTOP_DATA_len;
	void *_LIBGTOP_SEND_buf, *_LIBGTOP_DATA_buf;
	char *_LIBGTOP_SEND_ptr, *_LIBGTOP_DATA_ptr;
	int retval = (int) 0;

	/* variable initialization */
	_LIBGTOP_SEND_len = 0;
	_LIBGTOP_DATA_len = 0;
	_LIBGTOP_SEND_offset = 0;
	_LIBGTOP_SEND_ptr = (char *) _LIBGTOP_SEND_buf;

	/* send buffer */
	_LIBGTOP_SEND_buf = glibtop_malloc_r (server, _LIBGTOP_SEND_len+1);

	/* data buffer */
	_LIBGTOP_DATA_buf = glibtop_malloc_r (server, _LIBGTOP_DATA_len+1);
	_LIBGTOP_DATA_ptr = _LIBGTOP_DATA_buf;

	/* marshal start */
	memset (_LIBGTOP_SEND_buf, 0, _LIBGTOP_SEND_len);

	glibtop_call_i (server, backend, GLIBTOP_CMND_LOADAVG,
			_LIBGTOP_SEND_len, _LIBGTOP_SEND_buf,
			_LIBGTOP_DATA_len, _LIBGTOP_DATA_buf,
			sizeof (glibtop_loadavg), buf,
			&retval);

	glibtop_free_r (server, _LIBGTOP_SEND_buf);
	glibtop_free_r (server, _LIBGTOP_DATA_buf);

	return retval;

}

#endif /* GLIBTOP_SUID_LOADAVG */


#if GLIBTOP_SUID_SHM_LIMITS

static int
_glibtop_get_shm_limits_c (glibtop *server, glibtop_backend *backend, glibtop_shm_limits *buf)
{
	unsigned _LIBGTOP_SEND_offset, _LIBGTOP_SEND_len;
	unsigned _LIBGTOP_DATA_len;
	void *_LIBGTOP_SEND_buf, *_LIBGTOP_DATA_buf;
	char *_LIBGTOP_SEND_ptr, *_LIBGTOP_DATA_ptr;
	int retval = (int) 0;

	/* variable initialization */
	_LIBGTOP_SEND_len = 0;
	_LIBGTOP_DATA_len = 0;
	_LIBGTOP_SEND_offset = 0;
	_LIBGTOP_SEND_ptr = (char *) _LIBGTOP_SEND_buf;

	/* send buffer */
	_LIBGTOP_SEND_buf = glibtop_malloc_r (server, _LIBGTOP_SEND_len+1);

	/* data buffer */
	_LIBGTOP_DATA_buf = glibtop_malloc_r (server, _LIBGTOP_DATA_len+1);
	_LIBGTOP_DATA_ptr = _LIBGTOP_DATA_buf;

	/* marshal start */
	memset (_LIBGTOP_SEND_buf, 0, _LIBGTOP_SEND_len);

	glibtop_call_i (server, backend, GLIBTOP_CMND_SHM_LIMITS,
			_LIBGTOP_SEND_len, _LIBGTOP_SEND_buf,
			_LIBGTOP_DATA_len, _LIBGTOP_DATA_buf,
			sizeof (glibtop_shm_limits), buf,
			&retval);

	glibtop_free_r (server, _LIBGTOP_SEND_buf);
	glibtop_free_r (server, _LIBGTOP_DATA_buf);

	return retval;

}

#endif /* GLIBTOP_SUID_SHM_LIMITS */


#if GLIBTOP_SUID_MSG_LIMITS

static int
_glibtop_get_msg_limits_c (glibtop *server, glibtop_backend *backend, glibtop_msg_limits *buf)
{
	unsigned _LIBGTOP_SEND_offset, _LIBGTOP_SEND_len;
	unsigned _LIBGTOP_DATA_len;
	void *_LIBGTOP_SEND_buf, *_LIBGTOP_DATA_buf;
	char *_LIBGTOP_SEND_ptr, *_LIBGTOP_DATA_ptr;
	int retval = (int) 0;

	/* variable initialization */
	_LIBGTOP_SEND_len = 0;
	_LIBGTOP_DATA_len = 0;
	_LIBGTOP_SEND_offset = 0;
	_LIBGTOP_SEND_ptr = (char *) _LIBGTOP_SEND_buf;

	/* send buffer */
	_LIBGTOP_SEND_buf = glibtop_malloc_r (server, _LIBGTOP_SEND_len+1);

	/* data buffer */
	_LIBGTOP_DATA_buf = glibtop_malloc_r (server, _LIBGTOP_DATA_len+1);
	_LIBGTOP_DATA_ptr = _LIBGTOP_DATA_buf;

	/* marshal start */
	memset (_LIBGTOP_SEND_buf, 0, _LIBGTOP_SEND_len);

	glibtop_call_i (server, backend, GLIBTOP_CMND_MSG_LIMITS,
			_LIBGTOP_SEND_len, _LIBGTOP_SEND_buf,
			_LIBGTOP_DATA_len, _LIBGTOP_DATA_buf,
			sizeof (glibtop_msg_limits), buf,
			&retval);

	glibtop_free_r (server, _LIBGTOP_SEND_buf);
	glibtop_free_r (server, _LIBGTOP_DATA_buf);

	return retval;

}

#endif /* GLIBTOP_SUID_MSG_LIMITS */


#if GLIBTOP_SUID_SEM_LIMITS

static int
_glibtop_get_sem_limits_c (glibtop *server, glibtop_backend *backend, glibtop_sem_limits *buf)
{
	unsigned _LIBGTOP_SEND_offset, _LIBGTOP_SEND_len;
	unsigned _LIBGTOP_DATA_len;
	void *_LIBGTOP_SEND_buf, *_LIBGTOP_DATA_buf;
	char *_LIBGTOP_SEND_ptr, *_LIBGTOP_DATA_ptr;
	int retval = (int) 0;

	/* variable initialization */
	_LIBGTOP_SEND_len = 0;
	_LIBGTOP_DATA_len = 0;
	_LIBGTOP_SEND_offset = 0;
	_LIBGTOP_SEND_ptr = (char *) _LIBGTOP_SEND_buf;

	/* send buffer */
	_LIBGTOP_SEND_buf = glibtop_malloc_r (server, _LIBGTOP_SEND_len+1);

	/* data buffer */
	_LIBGTOP_DATA_buf = glibtop_malloc_r (server, _LIBGTOP_DATA_len+1);
	_LIBGTOP_DATA_ptr = _LIBGTOP_DATA_buf;

	/* marshal start */
	memset (_LIBGTOP_SEND_buf, 0, _LIBGTOP_SEND_len);

	glibtop_call_i (server, backend, GLIBTOP_CMND_SEM_LIMITS,
			_LIBGTOP_SEND_len, _LIBGTOP_SEND_buf,
			_LIBGTOP_DATA_len, _LIBGTOP_DATA_buf,
			sizeof (glibtop_sem_limits), buf,
			&retval);

	glibtop_free_r (server, _LIBGTOP_SEND_buf);
	glibtop_free_r (server, _LIBGTOP_DATA_buf);

	return retval;

}

#endif /* GLIBTOP_SUID_SEM_LIMITS */


#if GLIBTOP_SUID_PROCLIST

static unsigned *
_glibtop_get_proclist_c (glibtop *server, glibtop_backend *backend, glibtop_array *array,
                        int64_t which, int64_t arg)
{
	unsigned _LIBGTOP_SEND_offset, _LIBGTOP_SEND_len;
	unsigned _LIBGTOP_DATA_len;
	void *_LIBGTOP_SEND_buf, *_LIBGTOP_DATA_buf;
	char *_LIBGTOP_SEND_ptr, *_LIBGTOP_DATA_ptr;
	unsigned * retval = (unsigned *) 0;

	/* variable initialization */
	_LIBGTOP_SEND_len = 0;
	_LIBGTOP_DATA_len = 0;
	_LIBGTOP_SEND_offset = 0;
	_LIBGTOP_SEND_ptr = (char *) _LIBGTOP_SEND_buf;

	/* send size */
	_LIBGTOP_SEND_len += sizeof (int64_t);
	_LIBGTOP_SEND_len += sizeof (int64_t);

	/* send buffer */
	_LIBGTOP_SEND_buf = glibtop_malloc_r (server, _LIBGTOP_SEND_len+1);

	/* data buffer */
	_LIBGTOP_DATA_buf = glibtop_malloc_r (server, _LIBGTOP_DATA_len+1);
	_LIBGTOP_DATA_ptr = _LIBGTOP_DATA_buf;

	/* marshal start */
	memset (_LIBGTOP_SEND_buf, 0, _LIBGTOP_SEND_len);
	_LIBGTOP_SEND_ptr = (char *) _LIBGTOP_SEND_buf + _LIBGTOP_SEND_offset;
	memcpy (_LIBGTOP_SEND_ptr, &which, sizeof (int64_t));
	_LIBGTOP_SEND_offset += sizeof (int64_t);
	_LIBGTOP_SEND_ptr = (char *) _LIBGTOP_SEND_buf + _LIBGTOP_SEND_offset;
	memcpy (_LIBGTOP_SEND_ptr, &arg, sizeof (int64_t));
	_LIBGTOP_SEND_offset += sizeof (int64_t);

	retval = glibtop_call_i (server, backend, GLIBTOP_CMND_PROCLIST,
			         _LIBGTOP_SEND_len, _LIBGTOP_SEND_buf,
			         _LIBGTOP_DATA_len, _LIBGTOP_DATA_buf,
			         sizeof (glibtop_array), array,
			         NULL);

	glibtop_free_r (server, _LIBGTOP_SEND_buf);
	glibtop_free_r (server, _LIBGTOP_DATA_buf);

	return retval;

}

#endif /* GLIBTOP_SUID_PROCLIST */


#if GLIBTOP_SUID_PROC_STATE

static int
_glibtop_get_proc_state_c (glibtop *server, glibtop_backend *backend, glibtop_proc_state *buf,
                          pid_t pid)
{
	unsigned _LIBGTOP_SEND_offset, _LIBGTOP_SEND_len;
	unsigned _LIBGTOP_DATA_len;
	void *_LIBGTOP_SEND_buf, *_LIBGTOP_DATA_buf;
	char *_LIBGTOP_SEND_ptr, *_LIBGTOP_DATA_ptr;
	int retval = (int) 0;

	/* variable initialization */
	_LIBGTOP_SEND_len = 0;
	_LIBGTOP_DATA_len = 0;
	_LIBGTOP_SEND_offset = 0;
	_LIBGTOP_SEND_ptr = (char *) _LIBGTOP_SEND_buf;

	/* send size */
	_LIBGTOP_SEND_len += sizeof (pid_t);

	/* send buffer */
	_LIBGTOP_SEND_buf = glibtop_malloc_r (server, _LIBGTOP_SEND_len+1);

	/* data buffer */
	_LIBGTOP_DATA_buf = glibtop_malloc_r (server, _LIBGTOP_DATA_len+1);
	_LIBGTOP_DATA_ptr = _LIBGTOP_DATA_buf;

	/* marshal start */
	memset (_LIBGTOP_SEND_buf, 0, _LIBGTOP_SEND_len);
	_LIBGTOP_SEND_ptr = (char *) _LIBGTOP_SEND_buf + _LIBGTOP_SEND_offset;
	memcpy (_LIBGTOP_SEND_ptr, &pid, sizeof (pid_t));
	_LIBGTOP_SEND_offset += sizeof (pid_t);

	glibtop_call_i (server, backend, GLIBTOP_CMND_PROC_STATE,
			_LIBGTOP_SEND_len, _LIBGTOP_SEND_buf,
			_LIBGTOP_DATA_len, _LIBGTOP_DATA_buf,
			sizeof (glibtop_proc_state), buf,
			&retval);

	glibtop_free_r (server, _LIBGTOP_SEND_buf);
	glibtop_free_r (server, _LIBGTOP_DATA_buf);

	return retval;

}

#endif /* GLIBTOP_SUID_PROC_STATE */


#if GLIBTOP_SUID_PROC_UID

static int
_glibtop_get_proc_uid_c (glibtop *server, glibtop_backend *backend, glibtop_proc_uid *buf,
                        pid_t pid)
{
	unsigned _LIBGTOP_SEND_offset, _LIBGTOP_SEND_len;
	unsigned _LIBGTOP_DATA_len;
	void *_LIBGTOP_SEND_buf, *_LIBGTOP_DATA_buf;
	char *_LIBGTOP_SEND_ptr, *_LIBGTOP_DATA_ptr;
	int retval = (int) 0;

	/* variable initialization */
	_LIBGTOP_SEND_len = 0;
	_LIBGTOP_DATA_len = 0;
	_LIBGTOP_SEND_offset = 0;
	_LIBGTOP_SEND_ptr = (char *) _LIBGTOP_SEND_buf;

	/* send size */
	_LIBGTOP_SEND_len += sizeof (pid_t);

	/* send buffer */
	_LIBGTOP_SEND_buf = glibtop_malloc_r (server, _LIBGTOP_SEND_len+1);

	/* data buffer */
	_LIBGTOP_DATA_buf = glibtop_malloc_r (server, _LIBGTOP_DATA_len+1);
	_LIBGTOP_DATA_ptr = _LIBGTOP_DATA_buf;

	/* marshal start */
	memset (_LIBGTOP_SEND_buf, 0, _LIBGTOP_SEND_len);
	_LIBGTOP_SEND_ptr = (char *) _LIBGTOP_SEND_buf + _LIBGTOP_SEND_offset;
	memcpy (_LIBGTOP_SEND_ptr, &pid, sizeof (pid_t));
	_LIBGTOP_SEND_offset += sizeof (pid_t);

	glibtop_call_i (server, backend, GLIBTOP_CMND_PROC_UID,
			_LIBGTOP_SEND_len, _LIBGTOP_SEND_buf,
			_LIBGTOP_DATA_len, _LIBGTOP_DATA_buf,
			sizeof (glibtop_proc_uid), buf,
			&retval);

	glibtop_free_r (server, _LIBGTOP_SEND_buf);
	glibtop_free_r (server, _LIBGTOP_DATA_buf);

	return retval;

}

#endif /* GLIBTOP_SUID_PROC_UID */


#if GLIBTOP_SUID_PROC_MEM

static int
_glibtop_get_proc_mem_c (glibtop *server, glibtop_backend *backend, glibtop_proc_mem *buf,
                        pid_t pid)
{
	unsigned _LIBGTOP_SEND_offset, _LIBGTOP_SEND_len;
	unsigned _LIBGTOP_DATA_len;
	void *_LIBGTOP_SEND_buf, *_LIBGTOP_DATA_buf;
	char *_LIBGTOP_SEND_ptr, *_LIBGTOP_DATA_ptr;
	int retval = (int) 0;

	/* variable initialization */
	_LIBGTOP_SEND_len = 0;
	_LIBGTOP_DATA_len = 0;
	_LIBGTOP_SEND_offset = 0;
	_LIBGTOP_SEND_ptr = (char *) _LIBGTOP_SEND_buf;

	/* send size */
	_LIBGTOP_SEND_len += sizeof (pid_t);

	/* send buffer */
	_LIBGTOP_SEND_buf = glibtop_malloc_r (server, _LIBGTOP_SEND_len+1);

	/* data buffer */
	_LIBGTOP_DATA_buf = glibtop_malloc_r (server, _LIBGTOP_DATA_len+1);
	_LIBGTOP_DATA_ptr = _LIBGTOP_DATA_buf;

	/* marshal start */
	memset (_LIBGTOP_SEND_buf, 0, _LIBGTOP_SEND_len);
	_LIBGTOP_SEND_ptr = (char *) _LIBGTOP_SEND_buf + _LIBGTOP_SEND_offset;
	memcpy (_LIBGTOP_SEND_ptr, &pid, sizeof (pid_t));
	_LIBGTOP_SEND_offset += sizeof (pid_t);

	glibtop_call_i (server, backend, GLIBTOP_CMND_PROC_MEM,
			_LIBGTOP_SEND_len, _LIBGTOP_SEND_buf,
			_LIBGTOP_DATA_len, _LIBGTOP_DATA_buf,
			sizeof (glibtop_proc_mem), buf,
			&retval);

	glibtop_free_r (server, _LIBGTOP_SEND_buf);
	glibtop_free_r (server, _LIBGTOP_DATA_buf);

	return retval;

}

#endif /* GLIBTOP_SUID_PROC_MEM */


#if GLIBTOP_SUID_PROC_TIME

static int
_glibtop_get_proc_time_c (glibtop *server, glibtop_backend *backend, glibtop_proc_time *buf,
                         pid_t pid)
{
	unsigned _LIBGTOP_SEND_offset, _LIBGTOP_SEND_len;
	unsigned _LIBGTOP_DATA_len;
	void *_LIBGTOP_SEND_buf, *_LIBGTOP_DATA_buf;
	char *_LIBGTOP_SEND_ptr, *_LIBGTOP_DATA_ptr;
	int retval = (int) 0;

	/* variable initialization */
	_LIBGTOP_SEND_len = 0;
	_LIBGTOP_DATA_len = 0;
	_LIBGTOP_SEND_offset = 0;
	_LIBGTOP_SEND_ptr = (char *) _LIBGTOP_SEND_buf;

	/* send size */
	_LIBGTOP_SEND_len += sizeof (pid_t);

	/* send buffer */
	_LIBGTOP_SEND_buf = glibtop_malloc_r (server, _LIBGTOP_SEND_len+1);

	/* data buffer */
	_LIBGTOP_DATA_buf = glibtop_malloc_r (server, _LIBGTOP_DATA_len+1);
	_LIBGTOP_DATA_ptr = _LIBGTOP_DATA_buf;

	/* marshal start */
	memset (_LIBGTOP_SEND_buf, 0, _LIBGTOP_SEND_len);
	_LIBGTOP_SEND_ptr = (char *) _LIBGTOP_SEND_buf + _LIBGTOP_SEND_offset;
	memcpy (_LIBGTOP_SEND_ptr, &pid, sizeof (pid_t));
	_LIBGTOP_SEND_offset += sizeof (pid_t);

	glibtop_call_i (server, backend, GLIBTOP_CMND_PROC_TIME,
			_LIBGTOP_SEND_len, _LIBGTOP_SEND_buf,
			_LIBGTOP_DATA_len, _LIBGTOP_DATA_buf,
			sizeof (glibtop_proc_time), buf,
			&retval);

	glibtop_free_r (server, _LIBGTOP_SEND_buf);
	glibtop_free_r (server, _LIBGTOP_DATA_buf);

	return retval;

}

#endif /* GLIBTOP_SUID_PROC_TIME */


#if GLIBTOP_SUID_PROC_SIGNAL

static int
_glibtop_get_proc_signal_c (glibtop *server, glibtop_backend *backend, glibtop_proc_signal *buf,
                           pid_t pid)
{
	unsigned _LIBGTOP_SEND_offset, _LIBGTOP_SEND_len;
	unsigned _LIBGTOP_DATA_len;
	void *_LIBGTOP_SEND_buf, *_LIBGTOP_DATA_buf;
	char *_LIBGTOP_SEND_ptr, *_LIBGTOP_DATA_ptr;
	int retval = (int) 0;

	/* variable initialization */
	_LIBGTOP_SEND_len = 0;
	_LIBGTOP_DATA_len = 0;
	_LIBGTOP_SEND_offset = 0;
	_LIBGTOP_SEND_ptr = (char *) _LIBGTOP_SEND_buf;

	/* send size */
	_LIBGTOP_SEND_len += sizeof (pid_t);

	/* send buffer */
	_LIBGTOP_SEND_buf = glibtop_malloc_r (server, _LIBGTOP_SEND_len+1);

	/* data buffer */
	_LIBGTOP_DATA_buf = glibtop_malloc_r (server, _LIBGTOP_DATA_len+1);
	_LIBGTOP_DATA_ptr = _LIBGTOP_DATA_buf;

	/* marshal start */
	memset (_LIBGTOP_SEND_buf, 0, _LIBGTOP_SEND_len);
	_LIBGTOP_SEND_ptr = (char *) _LIBGTOP_SEND_buf + _LIBGTOP_SEND_offset;
	memcpy (_LIBGTOP_SEND_ptr, &pid, sizeof (pid_t));
	_LIBGTOP_SEND_offset += sizeof (pid_t);

	glibtop_call_i (server, backend, GLIBTOP_CMND_PROC_SIGNAL,
			_LIBGTOP_SEND_len, _LIBGTOP_SEND_buf,
			_LIBGTOP_DATA_len, _LIBGTOP_DATA_buf,
			sizeof (glibtop_proc_signal), buf,
			&retval);

	glibtop_free_r (server, _LIBGTOP_SEND_buf);
	glibtop_free_r (server, _LIBGTOP_DATA_buf);

	return retval;

}

#endif /* GLIBTOP_SUID_PROC_SIGNAL */


#if GLIBTOP_SUID_PROC_KERNEL

static int
_glibtop_get_proc_kernel_c (glibtop *server, glibtop_backend *backend, glibtop_proc_kernel *buf,
                           pid_t pid)
{
	unsigned _LIBGTOP_SEND_offset, _LIBGTOP_SEND_len;
	unsigned _LIBGTOP_DATA_len;
	void *_LIBGTOP_SEND_buf, *_LIBGTOP_DATA_buf;
	char *_LIBGTOP_SEND_ptr, *_LIBGTOP_DATA_ptr;
	int retval = (int) 0;

	/* variable initialization */
	_LIBGTOP_SEND_len = 0;
	_LIBGTOP_DATA_len = 0;
	_LIBGTOP_SEND_offset = 0;
	_LIBGTOP_SEND_ptr = (char *) _LIBGTOP_SEND_buf;

	/* send size */
	_LIBGTOP_SEND_len += sizeof (pid_t);

	/* send buffer */
	_LIBGTOP_SEND_buf = glibtop_malloc_r (server, _LIBGTOP_SEND_len+1);

	/* data buffer */
	_LIBGTOP_DATA_buf = glibtop_malloc_r (server, _LIBGTOP_DATA_len+1);
	_LIBGTOP_DATA_ptr = _LIBGTOP_DATA_buf;

	/* marshal start */
	memset (_LIBGTOP_SEND_buf, 0, _LIBGTOP_SEND_len);
	_LIBGTOP_SEND_ptr = (char *) _LIBGTOP_SEND_buf + _LIBGTOP_SEND_offset;
	memcpy (_LIBGTOP_SEND_ptr, &pid, sizeof (pid_t));
	_LIBGTOP_SEND_offset += sizeof (pid_t);

	glibtop_call_i (server, backend, GLIBTOP_CMND_PROC_KERNEL,
			_LIBGTOP_SEND_len, _LIBGTOP_SEND_buf,
			_LIBGTOP_DATA_len, _LIBGTOP_DATA_buf,
			sizeof (glibtop_proc_kernel), buf,
			&retval);

	glibtop_free_r (server, _LIBGTOP_SEND_buf);
	glibtop_free_r (server, _LIBGTOP_DATA_buf);

	return retval;

}

#endif /* GLIBTOP_SUID_PROC_KERNEL */


#if GLIBTOP_SUID_PROC_SEGMENT

static int
_glibtop_get_proc_segment_c (glibtop *server, glibtop_backend *backend, glibtop_proc_segment *buf,
                            pid_t pid)
{
	unsigned _LIBGTOP_SEND_offset, _LIBGTOP_SEND_len;
	unsigned _LIBGTOP_DATA_len;
	void *_LIBGTOP_SEND_buf, *_LIBGTOP_DATA_buf;
	char *_LIBGTOP_SEND_ptr, *_LIBGTOP_DATA_ptr;
	int retval = (int) 0;

	/* variable initialization */
	_LIBGTOP_SEND_len = 0;
	_LIBGTOP_DATA_len = 0;
	_LIBGTOP_SEND_offset = 0;
	_LIBGTOP_SEND_ptr = (char *) _LIBGTOP_SEND_buf;

	/* send size */
	_LIBGTOP_SEND_len += sizeof (pid_t);

	/* send buffer */
	_LIBGTOP_SEND_buf = glibtop_malloc_r (server, _LIBGTOP_SEND_len+1);

	/* data buffer */
	_LIBGTOP_DATA_buf = glibtop_malloc_r (server, _LIBGTOP_DATA_len+1);
	_LIBGTOP_DATA_ptr = _LIBGTOP_DATA_buf;

	/* marshal start */
	memset (_LIBGTOP_SEND_buf, 0, _LIBGTOP_SEND_len);
	_LIBGTOP_SEND_ptr = (char *) _LIBGTOP_SEND_buf + _LIBGTOP_SEND_offset;
	memcpy (_LIBGTOP_SEND_ptr, &pid, sizeof (pid_t));
	_LIBGTOP_SEND_offset += sizeof (pid_t);

	glibtop_call_i (server, backend, GLIBTOP_CMND_PROC_SEGMENT,
			_LIBGTOP_SEND_len, _LIBGTOP_SEND_buf,
			_LIBGTOP_DATA_len, _LIBGTOP_DATA_buf,
			sizeof (glibtop_proc_segment), buf,
			&retval);

	glibtop_free_r (server, _LIBGTOP_SEND_buf);
	glibtop_free_r (server, _LIBGTOP_DATA_buf);

	return retval;

}

#endif /* GLIBTOP_SUID_PROC_SEGMENT */


#if GLIBTOP_SUID_PROC_ARGS

static char **
_glibtop_get_proc_args_c (glibtop *server, glibtop_backend *backend, glibtop_array *array,
                         pid_t pid)
{
	unsigned _LIBGTOP_SEND_offset, _LIBGTOP_SEND_len;
	unsigned _LIBGTOP_DATA_len;
	void *_LIBGTOP_SEND_buf, *_LIBGTOP_DATA_buf;
	char *_LIBGTOP_SEND_ptr, *_LIBGTOP_DATA_ptr;
	char ** retval = (char **) 0;
	char *_LIBGTOP_ARRAY_ptr, **ptrlist;
	off_t *_LIBGTOP_ARRAY_off_ptr;
	int i;

	/* variable initialization */
	_LIBGTOP_SEND_len = 0;
	_LIBGTOP_DATA_len = 0;
	_LIBGTOP_SEND_offset = 0;
	_LIBGTOP_SEND_ptr = (char *) _LIBGTOP_SEND_buf;

	/* send size */
	_LIBGTOP_SEND_len += sizeof (pid_t);

	/* send buffer */
	_LIBGTOP_SEND_buf = glibtop_malloc_r (server, _LIBGTOP_SEND_len+1);

	/* data buffer */
	_LIBGTOP_DATA_buf = glibtop_malloc_r (server, _LIBGTOP_DATA_len+1);
	_LIBGTOP_DATA_ptr = _LIBGTOP_DATA_buf;

	/* marshal start */
	memset (_LIBGTOP_SEND_buf, 0, _LIBGTOP_SEND_len);
	_LIBGTOP_SEND_ptr = (char *) _LIBGTOP_SEND_buf + _LIBGTOP_SEND_offset;
	memcpy (_LIBGTOP_SEND_ptr, &pid, sizeof (pid_t));
	_LIBGTOP_SEND_offset += sizeof (pid_t);

	retval = glibtop_call_i (server, backend, GLIBTOP_CMND_PROC_ARGS,
			         _LIBGTOP_SEND_len, _LIBGTOP_SEND_buf,
			         _LIBGTOP_DATA_len, _LIBGTOP_DATA_buf,
			         sizeof (glibtop_array), array,
			         NULL);

	ptrlist = glibtop_calloc_r (server, array->number+1, sizeof (char *));
	_LIBGTOP_ARRAY_off_ptr = (off_t *) retval;
	_LIBGTOP_ARRAY_ptr = (char *) retval;
	_LIBGTOP_ARRAY_off_ptr++;

	for (i = 0; i < array->number; i++)
		ptrlist [i] = glibtop_strdup_r (server, _LIBGTOP_ARRAY_ptr + *_LIBGTOP_ARRAY_off_ptr++);
	ptrlist [array->number] = NULL;

	glibtop_free_r (server, retval);
	retval = ptrlist;

	glibtop_free_r (server, _LIBGTOP_SEND_buf);
	glibtop_free_r (server, _LIBGTOP_DATA_buf);

	return retval;

}

#endif /* GLIBTOP_SUID_PROC_ARGS */


#if GLIBTOP_SUID_PROC_MAP

static glibtop_map_entry *
_glibtop_get_proc_map_c (glibtop *server, glibtop_backend *backend, glibtop_array *array,
                        pid_t pid)
{
	unsigned _LIBGTOP_SEND_offset, _LIBGTOP_SEND_len;
	unsigned _LIBGTOP_DATA_len;
	void *_LIBGTOP_SEND_buf, *_LIBGTOP_DATA_buf;
	char *_LIBGTOP_SEND_ptr, *_LIBGTOP_DATA_ptr;
	glibtop_map_entry * retval = (glibtop_map_entry *) 0;

	/* variable initialization */
	_LIBGTOP_SEND_len = 0;
	_LIBGTOP_DATA_len = 0;
	_LIBGTOP_SEND_offset = 0;
	_LIBGTOP_SEND_ptr = (char *) _LIBGTOP_SEND_buf;

	/* send size */
	_LIBGTOP_SEND_len += sizeof (pid_t);

	/* send buffer */
	_LIBGTOP_SEND_buf = glibtop_malloc_r (server, _LIBGTOP_SEND_len+1);

	/* data buffer */
	_LIBGTOP_DATA_buf = glibtop_malloc_r (server, _LIBGTOP_DATA_len+1);
	_LIBGTOP_DATA_ptr = _LIBGTOP_DATA_buf;

	/* marshal start */
	memset (_LIBGTOP_SEND_buf, 0, _LIBGTOP_SEND_len);
	_LIBGTOP_SEND_ptr = (char *) _LIBGTOP_SEND_buf + _LIBGTOP_SEND_offset;
	memcpy (_LIBGTOP_SEND_ptr, &pid, sizeof (pid_t));
	_LIBGTOP_SEND_offset += sizeof (pid_t);

	retval = glibtop_call_i (server, backend, GLIBTOP_CMND_PROC_MAP,
			         _LIBGTOP_SEND_len, _LIBGTOP_SEND_buf,
			         _LIBGTOP_DATA_len, _LIBGTOP_DATA_buf,
			         sizeof (glibtop_array), array,
			         NULL);

	glibtop_free_r (server, _LIBGTOP_SEND_buf);
	glibtop_free_r (server, _LIBGTOP_DATA_buf);

	return retval;

}

#endif /* GLIBTOP_SUID_PROC_MAP */


#if GLIBTOP_SUID_INTERFACE_NAMES

static glibtop_interface *
_glibtop_get_interface_names_c (glibtop *server, glibtop_backend *backend, glibtop_array *array,
                               u_int64_t interface, u_int64_t number, u_int64_t instance, u_int64_t strategy)
{
	unsigned _LIBGTOP_SEND_offset, _LIBGTOP_SEND_len;
	unsigned _LIBGTOP_DATA_len;
	void *_LIBGTOP_SEND_buf, *_LIBGTOP_DATA_buf;
	char *_LIBGTOP_SEND_ptr, *_LIBGTOP_DATA_ptr;
	glibtop_interface * retval = (glibtop_interface *) 0;

	/* variable initialization */
	_LIBGTOP_SEND_len = 0;
	_LIBGTOP_DATA_len = 0;
	_LIBGTOP_SEND_offset = 0;
	_LIBGTOP_SEND_ptr = (char *) _LIBGTOP_SEND_buf;

	/* send size */
	_LIBGTOP_SEND_len += sizeof (u_int64_t);
	_LIBGTOP_SEND_len += sizeof (u_int64_t);
	_LIBGTOP_SEND_len += sizeof (u_int64_t);
	_LIBGTOP_SEND_len += sizeof (u_int64_t);

	/* send buffer */
	_LIBGTOP_SEND_buf = glibtop_malloc_r (server, _LIBGTOP_SEND_len+1);

	/* data buffer */
	_LIBGTOP_DATA_buf = glibtop_malloc_r (server, _LIBGTOP_DATA_len+1);
	_LIBGTOP_DATA_ptr = _LIBGTOP_DATA_buf;

	/* marshal start */
	memset (_LIBGTOP_SEND_buf, 0, _LIBGTOP_SEND_len);
	_LIBGTOP_SEND_ptr = (char *) _LIBGTOP_SEND_buf + _LIBGTOP_SEND_offset;
	memcpy (_LIBGTOP_SEND_ptr, &interface, sizeof (u_int64_t));
	_LIBGTOP_SEND_offset += sizeof (u_int64_t);
	_LIBGTOP_SEND_ptr = (char *) _LIBGTOP_SEND_buf + _LIBGTOP_SEND_offset;
	memcpy (_LIBGTOP_SEND_ptr, &number, sizeof (u_int64_t));
	_LIBGTOP_SEND_offset += sizeof (u_int64_t);
	_LIBGTOP_SEND_ptr = (char *) _LIBGTOP_SEND_buf + _LIBGTOP_SEND_offset;
	memcpy (_LIBGTOP_SEND_ptr, &instance, sizeof (u_int64_t));
	_LIBGTOP_SEND_offset += sizeof (u_int64_t);
	_LIBGTOP_SEND_ptr = (char *) _LIBGTOP_SEND_buf + _LIBGTOP_SEND_offset;
	memcpy (_LIBGTOP_SEND_ptr, &strategy, sizeof (u_int64_t));
	_LIBGTOP_SEND_offset += sizeof (u_int64_t);

	retval = glibtop_call_i (server, backend, GLIBTOP_CMND_INTERFACE_NAMES,
			         _LIBGTOP_SEND_len, _LIBGTOP_SEND_buf,
			         _LIBGTOP_DATA_len, _LIBGTOP_DATA_buf,
			         sizeof (glibtop_array), array,
			         NULL);

	glibtop_free_r (server, _LIBGTOP_SEND_buf);
	glibtop_free_r (server, _LIBGTOP_DATA_buf);

	return retval;

}

#endif /* GLIBTOP_SUID_INTERFACE_NAMES */


#if GLIBTOP_SUID_NETINFO

static int
_glibtop_get_netinfo_c (glibtop *server, glibtop_backend *backend, glibtop_netinfo *buf,
                       const char * interface, unsigned transport)
{
	unsigned _LIBGTOP_SEND_offset, _LIBGTOP_SEND_len;
	unsigned _LIBGTOP_DATA_len;
	unsigned _LIBGTOP_SEND_temp_len;
	void *_LIBGTOP_SEND_buf, *_LIBGTOP_DATA_buf;
	char *_LIBGTOP_SEND_ptr, *_LIBGTOP_DATA_ptr;
	int retval = (int) 0;

	/* variable initialization */
	_LIBGTOP_SEND_len = 0;
	_LIBGTOP_DATA_len = 0;
	_LIBGTOP_SEND_offset = 0;
	_LIBGTOP_SEND_ptr = (char *) _LIBGTOP_SEND_buf;

	/* send size */
	_LIBGTOP_SEND_len += sizeof (size_t);
	_LIBGTOP_DATA_len += strlen (interface) + 1;
	_LIBGTOP_SEND_len += sizeof (unsigned);

	/* send buffer */
	_LIBGTOP_SEND_buf = glibtop_malloc_r (server, _LIBGTOP_SEND_len+1);

	/* data buffer */
	_LIBGTOP_DATA_buf = glibtop_malloc_r (server, _LIBGTOP_DATA_len+1);
	_LIBGTOP_DATA_ptr = _LIBGTOP_DATA_buf;

	/* marshal start */
	memset (_LIBGTOP_SEND_buf, 0, _LIBGTOP_SEND_len);
	_LIBGTOP_SEND_ptr = (char *) _LIBGTOP_SEND_buf + _LIBGTOP_SEND_offset;
	_LIBGTOP_SEND_temp_len = strlen (interface)+1;
	memcpy (_LIBGTOP_SEND_ptr, &_LIBGTOP_SEND_temp_len, sizeof (size_t));
	_LIBGTOP_SEND_ptr += sizeof (size_t);
	memcpy (_LIBGTOP_DATA_ptr, interface, strlen (interface)+1);
	_LIBGTOP_DATA_ptr += strlen (interface)+1;
	_LIBGTOP_SEND_offset += sizeof (size_t);
	_LIBGTOP_SEND_ptr = (char *) _LIBGTOP_SEND_buf + _LIBGTOP_SEND_offset;
	memcpy (_LIBGTOP_SEND_ptr, &transport, sizeof (unsigned));
	_LIBGTOP_SEND_offset += sizeof (unsigned);

	glibtop_call_i (server, backend, GLIBTOP_CMND_NETINFO,
			_LIBGTOP_SEND_len, _LIBGTOP_SEND_buf,
			_LIBGTOP_DATA_len, _LIBGTOP_DATA_buf,
			sizeof (glibtop_netinfo), buf,
			&retval);

	glibtop_free_r (server, _LIBGTOP_SEND_buf);
	glibtop_free_r (server, _LIBGTOP_DATA_buf);

	return retval;

}

#endif /* GLIBTOP_SUID_NETINFO */


#if GLIBTOP_SUID_NETLOAD

static int
_glibtop_get_netload_c (glibtop *server, glibtop_backend *backend, glibtop_netload *buf,
                       const char * interface, unsigned transport, unsigned protocol)
{
	unsigned _LIBGTOP_SEND_offset, _LIBGTOP_SEND_len;
	unsigned _LIBGTOP_DATA_len;
	unsigned _LIBGTOP_SEND_temp_len;
	void *_LIBGTOP_SEND_buf, *_LIBGTOP_DATA_buf;
	char *_LIBGTOP_SEND_ptr, *_LIBGTOP_DATA_ptr;
	int retval = (int) 0;

	/* variable initialization */
	_LIBGTOP_SEND_len = 0;
	_LIBGTOP_DATA_len = 0;
	_LIBGTOP_SEND_offset = 0;
	_LIBGTOP_SEND_ptr = (char *) _LIBGTOP_SEND_buf;

	/* send size */
	_LIBGTOP_SEND_len += sizeof (size_t);
	_LIBGTOP_DATA_len += strlen (interface) + 1;
	_LIBGTOP_SEND_len += sizeof (unsigned);
	_LIBGTOP_SEND_len += sizeof (unsigned);

	/* send buffer */
	_LIBGTOP_SEND_buf = glibtop_malloc_r (server, _LIBGTOP_SEND_len+1);

	/* data buffer */
	_LIBGTOP_DATA_buf = glibtop_malloc_r (server, _LIBGTOP_DATA_len+1);
	_LIBGTOP_DATA_ptr = _LIBGTOP_DATA_buf;

	/* marshal start */
	memset (_LIBGTOP_SEND_buf, 0, _LIBGTOP_SEND_len);
	_LIBGTOP_SEND_ptr = (char *) _LIBGTOP_SEND_buf + _LIBGTOP_SEND_offset;
	_LIBGTOP_SEND_temp_len = strlen (interface)+1;
	memcpy (_LIBGTOP_SEND_ptr, &_LIBGTOP_SEND_temp_len, sizeof (size_t));
	_LIBGTOP_SEND_ptr += sizeof (size_t);
	memcpy (_LIBGTOP_DATA_ptr, interface, strlen (interface)+1);
	_LIBGTOP_DATA_ptr += strlen (interface)+1;
	_LIBGTOP_SEND_offset += sizeof (size_t);
	_LIBGTOP_SEND_ptr = (char *) _LIBGTOP_SEND_buf + _LIBGTOP_SEND_offset;
	memcpy (_LIBGTOP_SEND_ptr, &transport, sizeof (unsigned));
	_LIBGTOP_SEND_offset += sizeof (unsigned);
	_LIBGTOP_SEND_ptr = (char *) _LIBGTOP_SEND_buf + _LIBGTOP_SEND_offset;
	memcpy (_LIBGTOP_SEND_ptr, &protocol, sizeof (unsigned));
	_LIBGTOP_SEND_offset += sizeof (unsigned);

	glibtop_call_i (server, backend, GLIBTOP_CMND_NETLOAD,
			_LIBGTOP_SEND_len, _LIBGTOP_SEND_buf,
			_LIBGTOP_DATA_len, _LIBGTOP_DATA_buf,
			sizeof (glibtop_netload), buf,
			&retval);

	glibtop_free_r (server, _LIBGTOP_SEND_buf);
	glibtop_free_r (server, _LIBGTOP_DATA_buf);

	return retval;

}

#endif /* GLIBTOP_SUID_NETLOAD */


#if GLIBTOP_SUID_PPP

static int
_glibtop_get_ppp_c (glibtop *server, glibtop_backend *backend, glibtop_ppp *buf,
                   unsigned short device)
{
	unsigned _LIBGTOP_SEND_offset, _LIBGTOP_SEND_len;
	unsigned _LIBGTOP_DATA_len;
	void *_LIBGTOP_SEND_buf, *_LIBGTOP_DATA_buf;
	char *_LIBGTOP_SEND_ptr, *_LIBGTOP_DATA_ptr;
	int retval = (int) 0;

	/* variable initialization */
	_LIBGTOP_SEND_len = 0;
	_LIBGTOP_DATA_len = 0;
	_LIBGTOP_SEND_offset = 0;
	_LIBGTOP_SEND_ptr = (char *) _LIBGTOP_SEND_buf;

	/* send size */
	_LIBGTOP_SEND_len += sizeof (unsigned short);

	/* send buffer */
	_LIBGTOP_SEND_buf = glibtop_malloc_r (server, _LIBGTOP_SEND_len+1);

	/* data buffer */
	_LIBGTOP_DATA_buf = glibtop_malloc_r (server, _LIBGTOP_DATA_len+1);
	_LIBGTOP_DATA_ptr = _LIBGTOP_DATA_buf;

	/* marshal start */
	memset (_LIBGTOP_SEND_buf, 0, _LIBGTOP_SEND_len);
	_LIBGTOP_SEND_ptr = (char *) _LIBGTOP_SEND_buf + _LIBGTOP_SEND_offset;
	memcpy (_LIBGTOP_SEND_ptr, &device, sizeof (unsigned short));
	_LIBGTOP_SEND_offset += sizeof (unsigned short);

	glibtop_call_i (server, backend, GLIBTOP_CMND_PPP,
			_LIBGTOP_SEND_len, _LIBGTOP_SEND_buf,
			_LIBGTOP_DATA_len, _LIBGTOP_DATA_buf,
			sizeof (glibtop_ppp), buf,
			&retval);

	glibtop_free_r (server, _LIBGTOP_SEND_buf);
	glibtop_free_r (server, _LIBGTOP_DATA_buf);

	return retval;

}

#endif /* GLIBTOP_SUID_PPP */


glibtop_call_vector glibtop_backend_server_call_vector = {
#if GLIBTOP_SUID_CPU
	_glibtop_get_cpu_c,
#else
	NULL,
#endif
#if GLIBTOP_SUID_MEM
	_glibtop_get_mem_c,
#else
	NULL,
#endif
#if GLIBTOP_SUID_SWAP
	_glibtop_get_swap_c,
#else
	NULL,
#endif
#if GLIBTOP_SUID_UPTIME
	_glibtop_get_uptime_c,
#else
	NULL,
#endif
#if GLIBTOP_SUID_LOADAVG
	_glibtop_get_loadavg_c,
#else
	NULL,
#endif
#if GLIBTOP_SUID_SHM_LIMITS
	_glibtop_get_shm_limits_c,
#else
	NULL,
#endif
#if GLIBTOP_SUID_MSG_LIMITS
	_glibtop_get_msg_limits_c,
#else
	NULL,
#endif
#if GLIBTOP_SUID_SEM_LIMITS
	_glibtop_get_sem_limits_c,
#else
	NULL,
#endif
#if GLIBTOP_SUID_PROCLIST
	_glibtop_get_proclist_c,
#else
	NULL,
#endif
#if GLIBTOP_SUID_PROC_STATE
	_glibtop_get_proc_state_c,
#else
	NULL,
#endif
#if GLIBTOP_SUID_PROC_UID
	_glibtop_get_proc_uid_c,
#else
	NULL,
#endif
#if GLIBTOP_SUID_PROC_MEM
	_glibtop_get_proc_mem_c,
#else
	NULL,
#endif
#if GLIBTOP_SUID_PROC_TIME
	_glibtop_get_proc_time_c,
#else
	NULL,
#endif
#if GLIBTOP_SUID_PROC_SIGNAL
	_glibtop_get_proc_signal_c,
#else
	NULL,
#endif
#if GLIBTOP_SUID_PROC_KERNEL
	_glibtop_get_proc_kernel_c,
#else
	NULL,
#endif
#if GLIBTOP_SUID_PROC_SEGMENT
	_glibtop_get_proc_segment_c,
#else
	NULL,
#endif
#if GLIBTOP_SUID_PROC_ARGS
	_glibtop_get_proc_args_c,
#else
	NULL,
#endif
#if GLIBTOP_SUID_PROC_MAP
	_glibtop_get_proc_map_c,
#else
	NULL,
#endif
	NULL,
	NULL,
#if GLIBTOP_SUID_INTERFACE_NAMES
	_glibtop_get_interface_names_c,
#else
	NULL,
#endif
#if GLIBTOP_SUID_NETINFO
	_glibtop_get_netinfo_c,
#else
	NULL,
#endif
#if GLIBTOP_SUID_NETLOAD
	_glibtop_get_netload_c,
#else
	NULL,
#endif
#if GLIBTOP_SUID_PPP
	_glibtop_get_ppp_c,
#else
	NULL,
#endif

};

