/* PianoWidget.c generated by valac 0.15.1.5-a0bfe, the Vala compiler
 * generated from PianoWidget.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <gee.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <cairo.h>
#include <gobject/gvaluecollector.h>


#define GTK_MUSIC_TYPE_PIANO (gtk_music_piano_get_type ())
#define GTK_MUSIC_PIANO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_MUSIC_TYPE_PIANO, GtkMusicPiano))
#define GTK_MUSIC_PIANO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_MUSIC_TYPE_PIANO, GtkMusicPianoClass))
#define GTK_MUSIC_IS_PIANO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_MUSIC_TYPE_PIANO))
#define GTK_MUSIC_IS_PIANO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_MUSIC_TYPE_PIANO))
#define GTK_MUSIC_PIANO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_MUSIC_TYPE_PIANO, GtkMusicPianoClass))

typedef struct _GtkMusicPiano GtkMusicPiano;
typedef struct _GtkMusicPianoClass GtkMusicPianoClass;
typedef struct _GtkMusicPianoPrivate GtkMusicPianoPrivate;

#define GTK_MUSIC_PIANO_TYPE_LABEL_POSITION (gtk_music_piano_label_position_get_type ())

#define GTK_MUSIC_PIANO_TYPE_MARKED_NOTE_STYLE (gtk_music_piano_marked_note_style_get_type ())
#define GTK_MUSIC_PIANO_MARKED_NOTE_STYLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_MUSIC_PIANO_TYPE_MARKED_NOTE_STYLE, GtkMusicPianoMarkedNoteStyle))
#define GTK_MUSIC_PIANO_MARKED_NOTE_STYLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_MUSIC_PIANO_TYPE_MARKED_NOTE_STYLE, GtkMusicPianoMarkedNoteStyleClass))
#define GTK_MUSIC_PIANO_IS_MARKED_NOTE_STYLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_MUSIC_PIANO_TYPE_MARKED_NOTE_STYLE))
#define GTK_MUSIC_PIANO_IS_MARKED_NOTE_STYLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_MUSIC_PIANO_TYPE_MARKED_NOTE_STYLE))
#define GTK_MUSIC_PIANO_MARKED_NOTE_STYLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_MUSIC_PIANO_TYPE_MARKED_NOTE_STYLE, GtkMusicPianoMarkedNoteStyleClass))

typedef struct _GtkMusicPianoMarkedNoteStyle GtkMusicPianoMarkedNoteStyle;
typedef struct _GtkMusicPianoMarkedNoteStyleClass GtkMusicPianoMarkedNoteStyleClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gtk_music_piano_marked_note_style_unref0(var) ((var == NULL) ? NULL : (var = (gtk_music_piano_marked_note_style_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_region_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_region_destroy (var), NULL)))
typedef struct _GtkMusicPianoMarkedNoteStylePrivate GtkMusicPianoMarkedNoteStylePrivate;
typedef struct _GtkMusicPianoParamSpecMarkedNoteStyle GtkMusicPianoParamSpecMarkedNoteStyle;

typedef enum  {
	GTK_MUSIC_PIANO_ERROR_INVALID_COORDINATES
} GtkMusicPianoError;
#define GTK_MUSIC_PIANO_ERROR gtk_music_piano_error_quark ()
typedef enum  {
	GTK_MUSIC_PIANO_LABEL_POSITION_UP,
	GTK_MUSIC_PIANO_LABEL_POSITION_DOWN
} GtkMusicPianoLabelPosition;

struct _GtkMusicPiano {
	GtkDrawingArea parent_instance;
	GtkMusicPianoPrivate * priv;
	gboolean autoUpdate;
	gushort key_count;
	gushort firstNote;
	gfloat* nat_key_color;
	gint nat_key_color_length1;
	gfloat* accident_key_color;
	gint accident_key_color_length1;
	gboolean showLabels;
	gboolean detailedLabels;
	GtkMusicPianoLabelPosition labelsPosition;
	GeeHashMap* markedNotes;
};

struct _GtkMusicPianoClass {
	GtkDrawingAreaClass parent_class;
};

struct _GtkMusicPianoPrivate {
	gushort h_padding;
	gushort v_padding;
	gfloat accident_key_height;
	gfloat accident_key_width;
	gfloat x_min_natk_dist;
	gushort nat_keys;
	gdouble piano_width;
	gdouble piano_height;
	gdouble piano_x;
	gdouble piano_y;
	gdouble width;
	gdouble height;
	gdouble key_width;
};

typedef enum  {
	GTK_MUSIC_MUSICAL_NOTE_ERROR_INVALID_NOTE,
	GTK_MUSIC_MUSICAL_NOTE_ERROR_INVALID_MIDI,
	GTK_MUSIC_MUSICAL_NOTE_ERROR_ALREADY_COMPLETE
} GtkMusicMusicalNoteError;
#define GTK_MUSIC_MUSICAL_NOTE_ERROR gtk_music_musical_note_error_quark ()
struct _GtkMusicPianoMarkedNoteStyle {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GtkMusicPianoMarkedNoteStylePrivate * priv;
	gfloat* color;
	gint color_length1;
};

struct _GtkMusicPianoMarkedNoteStyleClass {
	GTypeClass parent_class;
	void (*finalize) (GtkMusicPianoMarkedNoteStyle *self);
};

struct _GtkMusicPianoParamSpecMarkedNoteStyle {
	GParamSpec parent_instance;
};


static gpointer gtk_music_piano_parent_class = NULL;
static gpointer gtk_music_piano_marked_note_style_parent_class = NULL;

GQuark gtk_music_piano_error_quark (void);
GType gtk_music_piano_get_type (void) G_GNUC_CONST;
GType gtk_music_piano_label_position_get_type (void) G_GNUC_CONST;
gpointer gtk_music_piano_marked_note_style_ref (gpointer instance);
void gtk_music_piano_marked_note_style_unref (gpointer instance);
GParamSpec* gtk_music_piano_param_spec_marked_note_style (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gtk_music_piano_value_set_marked_note_style (GValue* value, gpointer v_object);
void gtk_music_piano_value_take_marked_note_style (GValue* value, gpointer v_object);
gpointer gtk_music_piano_value_get_marked_note_style (const GValue* value);
GType gtk_music_piano_marked_note_style_get_type (void) G_GNUC_CONST;
#define GTK_MUSIC_PIANO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GTK_MUSIC_TYPE_PIANO, GtkMusicPianoPrivate))
enum  {
	GTK_MUSIC_PIANO_DUMMY_PROPERTY
};
GtkMusicPiano* gtk_music_piano_new (void);
GtkMusicPiano* gtk_music_piano_construct (GType object_type);
void gtk_music_piano_mark_midi (GtkMusicPiano* self, gushort midi_note, gfloat* color, int color_length1);
GtkMusicPianoMarkedNoteStyle* gtk_music_piano_marked_note_style_new (gfloat* color, int color_length1);
GtkMusicPianoMarkedNoteStyle* gtk_music_piano_marked_note_style_construct (GType object_type, gfloat* color, int color_length1);
void gtk_music_piano_redraw (GtkMusicPiano* self);
void gtk_music_piano_unmark_midi (GtkMusicPiano* self, gushort midi_note);
void gtk_music_piano_mark_note (GtkMusicPiano* self, const gchar* note, gfloat* color, int color_length1);
GeeHashSet* gtk_music_piano_find_positions (GtkMusicPiano* self, const gchar* note);
void gtk_music_piano_unmark_note (GtkMusicPiano* self, const gchar* note);
void gtk_music_piano_unmark_all (GtkMusicPiano* self);
gushort gtk_music_piano_point_to_midi (GtkMusicPiano* self, gdouble x, gdouble y, GError** error);
gdouble gtk_music_piano_midi_to_x (GtkMusicPiano* self, gushort midi_code);
gboolean gtk_music_musical_notes_midi_is_accident (gushort midi);
gboolean gtk_music_musical_notes_validate (const gchar* note);
gboolean gtk_music_musical_notes_is_incomplete (const gchar* needle);
GQuark gtk_music_musical_note_error_quark (void);
GeeHashSet* gtk_music_musical_notes_make (const gchar* incompleteNote, GError** error);
gushort gtk_music_musical_notes_get_note_as_midi_code (const gchar* note, GError** error);
static gushort gtk_music_piano_get_natural_keys_count (GtkMusicPiano* self);
static gboolean gtk_music_piano_real_button_press_event (GtkWidget* base, GdkEventButton* event);
static gboolean gtk_music_piano_real_button_release_event (GtkWidget* base, GdkEventButton* event);
static gboolean gtk_music_piano_real_draw (GtkWidget* base, cairo_t* cr);
static void gtk_music_piano_calculate_dimensions (GtkMusicPiano* self, cairo_t* cr);
static void gtk_music_piano_draw_natural_keys (GtkMusicPiano* self, cairo_t* cr);
static void gtk_music_piano_draw_accident_keys (GtkMusicPiano* self, cairo_t* cr);
static void g_cclosure_user_marshal_VOID__OBJECT_POINTER_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
enum  {
	GTK_MUSIC_PIANO_MARKED_NOTE_STYLE_DUMMY_PROPERTY
};
static gfloat* _vala_array_dup2 (gfloat* self, int length);
static void gtk_music_piano_marked_note_style_finalize (GtkMusicPianoMarkedNoteStyle* obj);
static void gtk_music_piano_finalize (GObject* obj);


GQuark gtk_music_piano_error_quark (void) {
	return g_quark_from_static_string ("gtk_music_piano_error-quark");
}


GType gtk_music_piano_label_position_get_type (void) {
	static volatile gsize gtk_music_piano_label_position_type_id__volatile = 0;
	if (g_once_init_enter (&gtk_music_piano_label_position_type_id__volatile)) {
		static const GEnumValue values[] = {{GTK_MUSIC_PIANO_LABEL_POSITION_UP, "GTK_MUSIC_PIANO_LABEL_POSITION_UP", "up"}, {GTK_MUSIC_PIANO_LABEL_POSITION_DOWN, "GTK_MUSIC_PIANO_LABEL_POSITION_DOWN", "down"}, {0, NULL, NULL}};
		GType gtk_music_piano_label_position_type_id;
		gtk_music_piano_label_position_type_id = g_enum_register_static ("GtkMusicPianoLabelPosition", values);
		g_once_init_leave (&gtk_music_piano_label_position_type_id__volatile, gtk_music_piano_label_position_type_id);
	}
	return gtk_music_piano_label_position_type_id__volatile;
}


/**
    * Creates a new Piano widget, which minimum size is defined to 120x40
    **/
GtkMusicPiano* gtk_music_piano_construct (GType object_type) {
	GtkMusicPiano * self = NULL;
	GeeHashMap* _tmp0_;
	self = (GtkMusicPiano*) g_object_new (object_type, NULL);
	gtk_widget_add_events ((GtkWidget*) self, (gint) (GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK));
	gtk_widget_set_size_request ((GtkWidget*) self, 120, 40);
	_tmp0_ = gee_hash_map_new (G_TYPE_INVALID, NULL, NULL, GTK_MUSIC_PIANO_TYPE_MARKED_NOTE_STYLE, (GBoxedCopyFunc) gtk_music_piano_marked_note_style_ref, gtk_music_piano_marked_note_style_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->markedNotes);
	self->markedNotes = _tmp0_;
	return self;
}


GtkMusicPiano* gtk_music_piano_new (void) {
	return gtk_music_piano_construct (GTK_MUSIC_TYPE_PIANO);
}


/**
    * Highlights a key corresponding to a MIDI code
    * @param midi_note A valid MIDI code (in range: 21 .. 108)
    * @param color The color (in RGBA []) to fill the marked key (default: blue)
    **/
void gtk_music_piano_mark_midi (GtkMusicPiano* self, gushort midi_note, gfloat* color, int color_length1) {
	GeeHashMap* _tmp0_;
	gushort _tmp1_;
	gfloat* _tmp2_;
	gint _tmp2__length1;
	GtkMusicPianoMarkedNoteStyle* _tmp3_;
	GtkMusicPianoMarkedNoteStyle* _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->markedNotes;
	_tmp1_ = midi_note;
	_tmp2_ = color;
	_tmp2__length1 = color_length1;
	_tmp3_ = gtk_music_piano_marked_note_style_new (_tmp2_, _tmp2__length1);
	_tmp4_ = _tmp3_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp0_, GUINT_TO_POINTER (_tmp1_), _tmp4_);
	_gtk_music_piano_marked_note_style_unref0 (_tmp4_);
	_tmp5_ = self->autoUpdate;
	if (_tmp5_) {
		gtk_music_piano_redraw (self);
	}
}


/**
    * Removes the mark of a position (string and fret) in the instrument
    * @param midi_note A valid MIDI code (in range: 21 .. 108)
    **/
void gtk_music_piano_unmark_midi (GtkMusicPiano* self, gushort midi_note) {
	GeeHashMap* _tmp0_;
	gushort _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->markedNotes;
	_tmp1_ = midi_note;
	_tmp2_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, GUINT_TO_POINTER (_tmp1_));
	if (_tmp2_) {
		GeeHashMap* _tmp3_;
		gushort _tmp4_;
		_tmp3_ = self->markedNotes;
		_tmp4_ = midi_note;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp3_, GUINT_TO_POINTER (_tmp4_), NULL);
	}
	_tmp5_ = self->autoUpdate;
	if (_tmp5_) {
		gtk_music_piano_redraw (self);
	}
}


/**
    * Highlights all positions corresponding to a note
    * @param note A musical note in scientific notation (examples: F#4 , C)
    **/
void gtk_music_piano_mark_note (GtkMusicPiano* self, const gchar* note, gfloat* color, int color_length1) {
	gboolean _tmp0_;
	gboolean oldAutoUpdate;
	const gchar* _tmp1_;
	GeeHashSet* _tmp2_ = NULL;
	GeeHashSet* positions;
	GeeHashSet* _tmp3_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (note != NULL);
	_tmp0_ = self->autoUpdate;
	oldAutoUpdate = _tmp0_;
	_tmp1_ = note;
	_tmp2_ = gtk_music_piano_find_positions (self, _tmp1_);
	positions = _tmp2_;
	_tmp3_ = positions;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (positions);
		return;
	}
	{
		GeeHashSet* _tmp4_;
		GeeIterator* _tmp5_ = NULL;
		GeeIterator* _u_it;
		_tmp4_ = positions;
		_tmp5_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp4_);
		_u_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			gboolean _tmp7_ = FALSE;
			GeeIterator* _tmp8_;
			gpointer _tmp9_ = NULL;
			gushort u;
			GeeHashMap* _tmp10_;
			gushort _tmp11_;
			gfloat* _tmp12_;
			gint _tmp12__length1;
			GtkMusicPianoMarkedNoteStyle* _tmp13_;
			GtkMusicPianoMarkedNoteStyle* _tmp14_;
			_tmp6_ = _u_it;
			_tmp7_ = gee_iterator_next (_tmp6_);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = _u_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			u = GPOINTER_TO_UINT (_tmp9_);
			_tmp10_ = self->markedNotes;
			_tmp11_ = u;
			_tmp12_ = color;
			_tmp12__length1 = color_length1;
			_tmp13_ = gtk_music_piano_marked_note_style_new (_tmp12_, _tmp12__length1);
			_tmp14_ = _tmp13_;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp10_, GUINT_TO_POINTER (_tmp11_), _tmp14_);
			_gtk_music_piano_marked_note_style_unref0 (_tmp14_);
		}
		_g_object_unref0 (_u_it);
	}
	_tmp15_ = oldAutoUpdate;
	self->autoUpdate = _tmp15_;
	_tmp16_ = self->autoUpdate;
	if (_tmp16_) {
		gtk_music_piano_redraw (self);
	}
	_g_object_unref0 (positions);
}


/**
    * Removes the marks in all positions corresponding to a note
    * @param note A musical note in scientific notation (examples: F#4 , C)
    **/
void gtk_music_piano_unmark_note (GtkMusicPiano* self, const gchar* note) {
	gboolean _tmp0_;
	gboolean oldAutoUpdate;
	const gchar* _tmp1_;
	GeeHashSet* _tmp2_ = NULL;
	GeeHashSet* positions;
	GeeHashSet* _tmp3_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (note != NULL);
	_tmp0_ = self->autoUpdate;
	oldAutoUpdate = _tmp0_;
	_tmp1_ = note;
	_tmp2_ = gtk_music_piano_find_positions (self, _tmp1_);
	positions = _tmp2_;
	_tmp3_ = positions;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (positions);
		return;
	}
	{
		GeeHashSet* _tmp4_;
		GeeIterator* _tmp5_ = NULL;
		GeeIterator* _u_it;
		_tmp4_ = positions;
		_tmp5_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp4_);
		_u_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			gboolean _tmp7_ = FALSE;
			GeeIterator* _tmp8_;
			gpointer _tmp9_ = NULL;
			gushort u;
			GeeHashMap* _tmp10_;
			gushort _tmp11_;
			_tmp6_ = _u_it;
			_tmp7_ = gee_iterator_next (_tmp6_);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = _u_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			u = GPOINTER_TO_UINT (_tmp9_);
			_tmp10_ = self->markedNotes;
			_tmp11_ = u;
			gee_abstract_map_unset ((GeeAbstractMap*) _tmp10_, GUINT_TO_POINTER (_tmp11_), NULL);
		}
		_g_object_unref0 (_u_it);
	}
	_tmp12_ = oldAutoUpdate;
	self->autoUpdate = _tmp12_;
	_tmp13_ = self->autoUpdate;
	if (_tmp13_) {
		gtk_music_piano_redraw (self);
	}
	_g_object_unref0 (positions);
}


/**
    * Removes all marked notes in the Piano view
    **/
void gtk_music_piano_unmark_all (GtkMusicPiano* self) {
	GeeHashMap* _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->markedNotes;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp0_);
	_tmp1_ = self->autoUpdate;
	if (_tmp1_) {
		gtk_music_piano_redraw (self);
	}
}


/**
     * Gets the MIDI code corresponding to a point (x,y) in the widget
     * @param x Valid x coordinate
     * @param y Valid y coordinate
     **/
gushort gtk_music_piano_point_to_midi (GtkMusicPiano* self, gdouble x, gdouble y, GError** error) {
	gushort result = 0U;
	gdouble delta_x = 0.0;
	gfloat _tmp0_;
	gdouble _tmp1_;
	gdouble ak_sep;
	gfloat _tmp2_;
	gdouble _tmp3_;
	gdouble ak_height;
	gushort r1_key = 0U;
	gushort r2_key = 0U;
	gushort r3_key = 0U;
	gboolean curr_accident = FALSE;
	gboolean next_accident = FALSE;
	GError* _tmp56_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->accident_key_width;
	_tmp1_ = self->priv->key_width;
	ak_sep = (_tmp0_ * _tmp1_) / 2;
	_tmp2_ = self->priv->accident_key_height;
	_tmp3_ = self->priv->piano_height;
	ak_height = _tmp2_ * _tmp3_;
	{
		gushort _tmp4_;
		gushort i;
		_tmp4_ = self->firstNote;
		i = _tmp4_;
		{
			gboolean _tmp5_;
			_tmp5_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_;
				gushort _tmp8_;
				gushort _tmp9_;
				gushort _tmp10_;
				gdouble _tmp11_;
				gushort _tmp12_;
				gdouble _tmp13_ = 0.0;
				gdouble _tmp14_;
				gdouble _tmp15_;
				_tmp6_ = _tmp5_;
				if (!_tmp6_) {
					gushort _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp8_ = i;
				_tmp9_ = self->firstNote;
				_tmp10_ = self->key_count;
				if (!(_tmp8_ < (_tmp9_ + _tmp10_))) {
					break;
				}
				_tmp11_ = x;
				_tmp12_ = i;
				_tmp13_ = gtk_music_piano_midi_to_x (self, _tmp12_);
				delta_x = _tmp11_ - _tmp13_;
				_tmp14_ = delta_x;
				_tmp15_ = self->priv->key_width;
				if (_tmp14_ < _tmp15_) {
					gushort _tmp16_;
					gboolean _tmp17_ = FALSE;
					gboolean _tmp18_;
					gushort _tmp23_;
					gboolean _tmp24_;
					gboolean _tmp27_ = FALSE;
					gboolean _tmp28_;
					gboolean _tmp30_;
					gboolean _tmp43_ = FALSE;
					gdouble _tmp44_;
					gdouble _tmp45_;
					gboolean _tmp48_;
					_tmp16_ = i;
					_tmp17_ = gtk_music_musical_notes_midi_is_accident (_tmp16_);
					curr_accident = _tmp17_;
					_tmp18_ = curr_accident;
					if (_tmp18_) {
						gushort _tmp19_;
						gboolean _tmp20_ = FALSE;
						_tmp19_ = i;
						_tmp20_ = gtk_music_musical_notes_midi_is_accident ((gushort) (_tmp19_ + 2));
						next_accident = _tmp20_;
					} else {
						gushort _tmp21_;
						gboolean _tmp22_ = FALSE;
						_tmp21_ = i;
						_tmp22_ = gtk_music_musical_notes_midi_is_accident ((gushort) (_tmp21_ + 1));
						next_accident = _tmp22_;
					}
					_tmp23_ = i;
					r1_key = _tmp23_;
					_tmp24_ = curr_accident;
					if (_tmp24_) {
						gushort _tmp25_;
						_tmp25_ = i;
						r2_key = (gushort) (_tmp25_ + 1);
					} else {
						gushort _tmp26_;
						_tmp26_ = i;
						r2_key = _tmp26_;
					}
					_tmp28_ = curr_accident;
					if (_tmp28_) {
						gboolean _tmp29_;
						_tmp29_ = next_accident;
						_tmp27_ = _tmp29_;
					} else {
						_tmp27_ = FALSE;
					}
					_tmp30_ = _tmp27_;
					if (_tmp30_) {
						gushort _tmp31_;
						_tmp31_ = i;
						r3_key = (gushort) (_tmp31_ + 2);
					} else {
						gboolean _tmp32_ = FALSE;
						gboolean _tmp33_;
						gboolean _tmp35_;
						_tmp33_ = curr_accident;
						if (_tmp33_) {
							gboolean _tmp34_;
							_tmp34_ = next_accident;
							_tmp32_ = !_tmp34_;
						} else {
							_tmp32_ = FALSE;
						}
						_tmp35_ = _tmp32_;
						if (_tmp35_) {
							gushort _tmp36_;
							_tmp36_ = i;
							r3_key = (gushort) (_tmp36_ + 1);
						} else {
							gboolean _tmp37_ = FALSE;
							gboolean _tmp38_;
							gboolean _tmp40_;
							_tmp38_ = curr_accident;
							if (!_tmp38_) {
								gboolean _tmp39_;
								_tmp39_ = next_accident;
								_tmp37_ = _tmp39_;
							} else {
								_tmp37_ = FALSE;
							}
							_tmp40_ = _tmp37_;
							if (_tmp40_) {
								gushort _tmp41_;
								_tmp41_ = i;
								r3_key = (gushort) (_tmp41_ + 1);
							} else {
								gushort _tmp42_;
								_tmp42_ = i;
								r3_key = _tmp42_;
							}
						}
					}
					_tmp44_ = delta_x;
					_tmp45_ = ak_sep;
					if (_tmp44_ < _tmp45_) {
						gdouble _tmp46_;
						gdouble _tmp47_;
						_tmp46_ = y;
						_tmp47_ = ak_height;
						_tmp43_ = _tmp46_ < _tmp47_;
					} else {
						_tmp43_ = FALSE;
					}
					_tmp48_ = _tmp43_;
					if (_tmp48_) {
						result = r1_key;
						return result;
					} else {
						gboolean _tmp49_ = FALSE;
						gdouble _tmp50_;
						gdouble _tmp51_;
						gdouble _tmp52_;
						gboolean _tmp55_;
						_tmp50_ = delta_x;
						_tmp51_ = self->priv->key_width;
						_tmp52_ = ak_sep;
						if (_tmp50_ > (_tmp51_ - _tmp52_)) {
							gdouble _tmp53_;
							gdouble _tmp54_;
							_tmp53_ = y;
							_tmp54_ = ak_height;
							_tmp49_ = _tmp53_ < _tmp54_;
						} else {
							_tmp49_ = FALSE;
						}
						_tmp55_ = _tmp49_;
						if (_tmp55_) {
							result = r3_key;
							return result;
						} else {
							result = r2_key;
							return result;
						}
					}
				}
			}
		}
	}
	_tmp56_ = g_error_new_literal (GTK_MUSIC_PIANO_ERROR, GTK_MUSIC_PIANO_ERROR_INVALID_COORDINATES, "Invalid coordinates!");
	_inner_error_ = _tmp56_;
	if (_inner_error_->domain == GTK_MUSIC_PIANO_ERROR) {
		g_propagate_error (error, _inner_error_);
		return 0U;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0U;
	}
}


/**
     * Gets the x coordinate of the key associated to a given MIDI code
     * @param midi_code A valid MIDI code, present in the piano range
     **/
gdouble gtk_music_piano_midi_to_x (GtkMusicPiano* self, gushort midi_code) {
	gdouble result = 0.0;
	gushort _tmp0_;
	gushort _tmp1_;
	gushort norm_key;
	gboolean _tmp2_ = FALSE;
	gushort _tmp3_;
	gboolean _tmp7_;
	gdouble _tmp8_;
	gdouble x;
	gdouble _tmp9_;
	gushort _tmp10_;
	gdouble _tmp11_;
	gboolean last_was_nkey;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = midi_code;
	_tmp1_ = self->firstNote;
	norm_key = _tmp0_ - _tmp1_;
	_tmp3_ = norm_key;
	if (((gint) _tmp3_) < 0) {
		_tmp2_ = TRUE;
	} else {
		gushort _tmp4_;
		gushort _tmp5_;
		gushort _tmp6_;
		_tmp4_ = norm_key;
		_tmp5_ = self->firstNote;
		_tmp6_ = self->key_count;
		_tmp2_ = _tmp4_ > (_tmp5_ + _tmp6_);
	}
	_tmp7_ = _tmp2_;
	if (_tmp7_) {
		result = (gdouble) (-1);
		return result;
	}
	_tmp8_ = self->priv->piano_x;
	x = _tmp8_;
	_tmp9_ = x;
	_tmp10_ = norm_key;
	_tmp11_ = self->priv->key_width;
	x = _tmp9_ + ((((gint) (_tmp10_ / 12)) * 7) * _tmp11_);
	last_was_nkey = FALSE;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp12_;
			_tmp12_ = TRUE;
			while (TRUE) {
				gboolean _tmp13_;
				gint _tmp15_;
				gushort _tmp16_;
				gboolean _tmp17_;
				gint _tmp20_;
				gboolean _tmp21_ = FALSE;
				_tmp13_ = _tmp12_;
				if (!_tmp13_) {
					gint _tmp14_;
					_tmp14_ = i;
					i = _tmp14_ + 1;
				}
				_tmp12_ = FALSE;
				_tmp15_ = i;
				_tmp16_ = norm_key;
				if (!(_tmp15_ < ((_tmp16_ % 12) + 1))) {
					break;
				}
				_tmp17_ = last_was_nkey;
				if (_tmp17_) {
					gdouble _tmp18_;
					gdouble _tmp19_;
					_tmp18_ = x;
					_tmp19_ = self->priv->key_width;
					x = _tmp18_ + _tmp19_;
				}
				_tmp20_ = i;
				_tmp21_ = gtk_music_musical_notes_midi_is_accident ((gushort) _tmp20_);
				last_was_nkey = !_tmp21_;
			}
		}
	}
	result = x;
	return result;
}


/**
    * Finds all MIDI codes for a given note
    * @param note The note with or without the octave component (e.g: A#, D4)
    **/
GeeHashSet* gtk_music_piano_find_positions (GtkMusicPiano* self, const gchar* note) {
	GeeHashSet* result = NULL;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp5_;
	GeeHashSet* _tmp6_;
	GeeHashSet* midi_codes;
	const gchar* _tmp7_;
	gboolean _tmp8_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (note != NULL, NULL);
	_tmp1_ = note;
	_tmp2_ = gtk_music_musical_notes_validate (_tmp1_);
	if (!_tmp2_) {
		const gchar* _tmp3_;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = note;
		_tmp4_ = gtk_music_musical_notes_is_incomplete (_tmp3_);
		_tmp0_ = !_tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		result = NULL;
		return result;
	}
	_tmp6_ = gee_hash_set_new (G_TYPE_INVALID, NULL, NULL, NULL, NULL);
	midi_codes = _tmp6_;
	_tmp7_ = note;
	_tmp8_ = gtk_music_musical_notes_is_incomplete (_tmp7_);
	if (_tmp8_) {
		const gchar* _tmp9_;
		GeeHashSet* _tmp10_ = NULL;
		GeeHashSet* _tmp11_;
		_tmp9_ = note;
		_tmp10_ = gtk_music_musical_notes_make (_tmp9_, &_inner_error_);
		_tmp11_ = _tmp10_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (midi_codes);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		{
			GeeHashSet* _tmp12_;
			GeeIterator* _tmp13_ = NULL;
			GeeIterator* _tmp14_;
			GeeIterator* _s_it;
			_tmp12_ = _tmp11_;
			_tmp13_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp12_);
			_tmp14_ = _tmp13_;
			_g_object_unref0 (_tmp12_);
			_s_it = _tmp14_;
			while (TRUE) {
				GeeIterator* _tmp15_;
				gboolean _tmp16_ = FALSE;
				GeeIterator* _tmp17_;
				gpointer _tmp18_ = NULL;
				gchar* s;
				const gchar* _tmp19_;
				gushort _tmp20_ = 0U;
				gushort _tmp21_;
				GeeHashSet* _tmp22_;
				_tmp15_ = _s_it;
				_tmp16_ = gee_iterator_next (_tmp15_);
				if (!_tmp16_) {
					break;
				}
				_tmp17_ = _s_it;
				_tmp18_ = gee_iterator_get (_tmp17_);
				s = (gchar*) _tmp18_;
				_tmp19_ = s;
				_tmp20_ = gtk_music_musical_notes_get_note_as_midi_code (_tmp19_, &_inner_error_);
				_tmp21_ = _tmp20_;
				if (_inner_error_ != NULL) {
					_g_free0 (s);
					_g_object_unref0 (_s_it);
					_g_object_unref0 (midi_codes);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_tmp22_ = midi_codes;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, GUINT_TO_POINTER ((gushort) _tmp21_));
				_g_free0 (s);
			}
			_g_object_unref0 (_s_it);
		}
	} else {
		const gchar* _tmp23_;
		gushort _tmp24_ = 0U;
		gushort _tmp25_;
		GeeHashSet* _tmp26_;
		_tmp23_ = note;
		_tmp24_ = gtk_music_musical_notes_get_note_as_midi_code (_tmp23_, &_inner_error_);
		_tmp25_ = _tmp24_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (midi_codes);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp26_ = midi_codes;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp26_, GUINT_TO_POINTER ((gushort) _tmp25_));
	}
	result = midi_codes;
	return result;
}


/**
     * Returns the number of natural keys for the current instance parameters
     * @return The number of natural keys
     **/
static gushort gtk_music_piano_get_natural_keys_count (GtkMusicPiano* self) {
	gushort result = 0U;
	gushort _tmp0_;
	gushort complete_octaves;
	gushort _tmp1_;
	gushort incomplete_octave;
	gushort _tmp2_;
	gushort nat_keys;
	gushort tmp_note = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->key_count;
	complete_octaves = (gushort) (_tmp0_ / 12);
	_tmp1_ = self->key_count;
	incomplete_octave = (gushort) (_tmp1_ % 12);
	_tmp2_ = complete_octaves;
	nat_keys = (gushort) (_tmp2_ * 7);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_;
				gint _tmp6_;
				gushort _tmp7_;
				gushort _tmp8_;
				gint _tmp9_;
				gushort _tmp10_;
				gboolean _tmp11_ = FALSE;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp6_ = i;
				_tmp7_ = incomplete_octave;
				if (!(_tmp6_ < ((gint) _tmp7_))) {
					break;
				}
				_tmp8_ = self->firstNote;
				_tmp9_ = i;
				tmp_note = (gushort) ((_tmp8_ + _tmp9_) % 12);
				_tmp10_ = tmp_note;
				_tmp11_ = gtk_music_musical_notes_midi_is_accident (_tmp10_);
				if (!_tmp11_) {
					gushort _tmp12_;
					_tmp12_ = nat_keys;
					nat_keys = (gushort) (_tmp12_ + 1);
				}
			}
		}
	}
	result = nat_keys;
	return result;
}


static gboolean gtk_music_piano_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	GtkMusicPiano * self;
	gboolean result = FALSE;
	GdkEventButton _tmp0_;
	gdouble _tmp1_;
	GdkEventButton _tmp2_;
	gdouble _tmp3_;
	gushort _tmp4_ = 0U;
	gushort _tmp5_;
	GdkEventButton _tmp6_;
	GError * _inner_error_ = NULL;
	self = (GtkMusicPiano*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.x;
	_tmp2_ = *event;
	_tmp3_ = _tmp2_.y;
	_tmp4_ = gtk_music_piano_point_to_midi (self, _tmp1_, _tmp3_, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp6_ = *event;
	g_signal_emit_by_name (self, "note-pressed", (GtkWidget*) self, &_tmp6_, (gint) _tmp5_);
	result = TRUE;
	return result;
}


static gboolean gtk_music_piano_real_button_release_event (GtkWidget* base, GdkEventButton* event) {
	GtkMusicPiano * self;
	gboolean result = FALSE;
	GdkEventButton _tmp0_;
	gdouble _tmp1_;
	GdkEventButton _tmp2_;
	gdouble _tmp3_;
	gushort _tmp4_ = 0U;
	gushort _tmp5_;
	GdkEventButton _tmp6_;
	GError * _inner_error_ = NULL;
	self = (GtkMusicPiano*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.x;
	_tmp2_ = *event;
	_tmp3_ = _tmp2_.y;
	_tmp4_ = gtk_music_piano_point_to_midi (self, _tmp1_, _tmp3_, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp6_ = *event;
	g_signal_emit_by_name (self, "note-released", (GtkWidget*) self, &_tmp6_, (gint) _tmp5_);
	result = TRUE;
	return result;
}


/**
    * Draws a guitar widget
    *
    * @param cr The drawing context for the widget
    * @return Whether the event should be propagated (TODO Confirm this theory)
    **/
static gboolean gtk_music_piano_real_draw (GtkWidget* base, cairo_t* cr) {
	GtkMusicPiano * self;
	gboolean result = FALSE;
	cairo_t* _tmp0_;
	cairo_t* _tmp1_;
	cairo_t* _tmp2_;
	self = (GtkMusicPiano*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = cr;
	gtk_music_piano_calculate_dimensions (self, _tmp0_);
	_tmp1_ = cr;
	gtk_music_piano_draw_natural_keys (self, _tmp1_);
	_tmp2_ = cr;
	gtk_music_piano_draw_accident_keys (self, _tmp2_);
	result = FALSE;
	return result;
}


/**
    * Forces a complete redraw of the widget
    *
    * This function will invalidate all the region corresponding to the
    * widget's GDK window and ask for updates, forcing a complete redraw.
    *
    **/
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void gtk_music_piano_redraw (GtkMusicPiano* self) {
	GdkWindow* _tmp0_ = NULL;
	GdkWindow* _tmp1_;
	GdkWindow* window;
	GdkWindow* _tmp2_;
	GdkWindow* _tmp3_;
	cairo_region_t* _tmp4_ = NULL;
	cairo_region_t* region;
	GdkWindow* _tmp5_;
	cairo_region_t* _tmp6_;
	GdkWindow* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	window = _tmp1_;
	_tmp2_ = window;
	if (NULL == _tmp2_) {
		_g_object_unref0 (window);
		return;
	}
	_tmp3_ = window;
	_tmp4_ = gdk_window_get_clip_region (_tmp3_);
	region = _tmp4_;
	_tmp5_ = window;
	_tmp6_ = region;
	gdk_window_invalidate_region (_tmp5_, _tmp6_, TRUE);
	_tmp7_ = window;
	gdk_window_process_updates (_tmp7_, TRUE);
	_cairo_region_destroy0 (region);
	_g_object_unref0 (window);
}


/**
    * Calculate some drawing dimensions
    * @param cr The drawing context for the widget
    **/
static void gtk_music_piano_calculate_dimensions (GtkMusicPiano* self, cairo_t* cr) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_;
	gdouble _tmp10_;
	gushort _tmp11_;
	gushort _tmp12_;
	gdouble _tmp13_;
	gdouble _tmp14_;
	gushort _tmp15_;
	gushort _tmp16_ = 0U;
	gdouble _tmp17_;
	gushort _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	self->priv->width = (gdouble) _tmp0_;
	_tmp1_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	self->priv->height = (gdouble) _tmp1_;
	_tmp2_ = self->showLabels;
	if (_tmp2_) {
		gdouble _tmp3_;
		gushort _tmp4_;
		cairo_t* _tmp5_;
		cairo_t* _tmp6_;
		gdouble _tmp7_;
		_tmp3_ = self->priv->height;
		_tmp4_ = self->priv->v_padding;
		self->priv->piano_height = (0.8 * _tmp3_) - (2 * _tmp4_);
		_tmp5_ = cr;
		cairo_select_font_face (_tmp5_, "monospace", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_NORMAL);
		_tmp6_ = cr;
		_tmp7_ = self->priv->width;
		cairo_set_font_size (_tmp6_, 0.05 * _tmp7_);
	} else {
		gdouble _tmp8_;
		gushort _tmp9_;
		_tmp8_ = self->priv->height;
		_tmp9_ = self->priv->v_padding;
		self->priv->piano_height = _tmp8_ - (2 * _tmp9_);
	}
	_tmp10_ = self->priv->width;
	_tmp11_ = self->priv->h_padding;
	self->priv->piano_width = _tmp10_ - (2 * _tmp11_);
	_tmp12_ = self->priv->h_padding;
	self->priv->piano_x = (gdouble) _tmp12_;
	_tmp13_ = self->priv->height;
	_tmp14_ = self->priv->piano_height;
	_tmp15_ = self->priv->v_padding;
	self->priv->piano_y = (_tmp13_ - _tmp14_) - _tmp15_;
	_tmp16_ = gtk_music_piano_get_natural_keys_count (self);
	self->priv->nat_keys = _tmp16_;
	_tmp17_ = self->priv->piano_width;
	_tmp18_ = self->priv->nat_keys;
	self->priv->key_width = _tmp17_ / _tmp18_;
}


/**
    * Draw natural notes (C, D, E, F, G, A, B)
    * @param cr The drawing context for the widget
    **/
static void gtk_music_piano_draw_natural_keys (GtkMusicPiano* self, cairo_t* cr) {
	gdouble _tmp0_;
	gdouble x;
	gdouble _tmp1_;
	gdouble y;
	cairo_t* _tmp2_;
	cairo_t* _tmp15_;
	cairo_t* _tmp16_;
	gfloat* _tmp17_;
	gint _tmp17__length1;
	gfloat _tmp18_;
	gfloat* _tmp19_;
	gint _tmp19__length1;
	gfloat _tmp20_;
	gfloat* _tmp21_;
	gint _tmp21__length1;
	gfloat _tmp22_;
	gfloat* _tmp23_;
	gint _tmp23__length1;
	gfloat _tmp24_;
	cairo_t* _tmp25_;
	cairo_t* _tmp26_;
	cairo_t* _tmp27_;
	cairo_t* _tmp75_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = self->priv->piano_x;
	x = _tmp0_;
	_tmp1_ = self->priv->piano_y;
	y = _tmp1_;
	_tmp2_ = cr;
	cairo_save (_tmp2_);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_;
				gint _tmp6_;
				gushort _tmp7_;
				cairo_t* _tmp8_;
				gdouble _tmp9_;
				gint _tmp10_;
				gdouble _tmp11_;
				gdouble _tmp12_;
				gdouble _tmp13_;
				gdouble _tmp14_;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp6_ = i;
				_tmp7_ = self->priv->nat_keys;
				if (!(_tmp6_ < ((gint) _tmp7_))) {
					break;
				}
				_tmp8_ = cr;
				_tmp9_ = x;
				_tmp10_ = i;
				_tmp11_ = self->priv->key_width;
				_tmp12_ = self->priv->piano_y;
				_tmp13_ = self->priv->key_width;
				_tmp14_ = self->priv->piano_height;
				cairo_rectangle (_tmp8_, _tmp9_ + (_tmp10_ * _tmp11_), _tmp12_, _tmp13_, _tmp14_);
			}
		}
	}
	_tmp15_ = cr;
	cairo_stroke_preserve (_tmp15_);
	_tmp16_ = cr;
	_tmp17_ = self->nat_key_color;
	_tmp17__length1 = self->nat_key_color_length1;
	_tmp18_ = _tmp17_[0];
	_tmp19_ = self->nat_key_color;
	_tmp19__length1 = self->nat_key_color_length1;
	_tmp20_ = _tmp19_[1];
	_tmp21_ = self->nat_key_color;
	_tmp21__length1 = self->nat_key_color_length1;
	_tmp22_ = _tmp21_[2];
	_tmp23_ = self->nat_key_color;
	_tmp23__length1 = self->nat_key_color_length1;
	_tmp24_ = _tmp23_[3];
	cairo_set_source_rgba (_tmp16_, (gdouble) _tmp18_, (gdouble) _tmp20_, (gdouble) _tmp22_, (gdouble) _tmp24_);
	_tmp25_ = cr;
	cairo_fill_preserve (_tmp25_);
	_tmp26_ = cr;
	cairo_set_source_rgba (_tmp26_, (gdouble) 0.0f, (gdouble) 0.0f, (gdouble) 0.0f, (gdouble) 1.0f);
	_tmp27_ = cr;
	cairo_stroke (_tmp27_);
	{
		GeeHashMap* _tmp28_;
		GeeSet* _tmp29_;
		GeeSet* _tmp30_;
		GeeSet* _tmp31_;
		GeeIterator* _tmp32_ = NULL;
		GeeIterator* _tmp33_;
		GeeIterator* _entry_it;
		_tmp28_ = self->markedNotes;
		_tmp29_ = gee_abstract_map_get_entries ((GeeMap*) _tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = _tmp30_;
		_tmp32_ = gee_iterable_iterator ((GeeIterable*) _tmp31_);
		_tmp33_ = _tmp32_;
		_g_object_unref0 (_tmp31_);
		_entry_it = _tmp33_;
		while (TRUE) {
			GeeIterator* _tmp34_;
			gboolean _tmp35_ = FALSE;
			GeeIterator* _tmp36_;
			gpointer _tmp37_ = NULL;
			GeeMapEntry* entry;
			GeeMapEntry* _tmp38_;
			gconstpointer _tmp39_;
			gushort _tmp40_;
			gboolean _tmp41_ = FALSE;
			_tmp34_ = _entry_it;
			_tmp35_ = gee_iterator_next (_tmp34_);
			if (!_tmp35_) {
				break;
			}
			_tmp36_ = _entry_it;
			_tmp37_ = gee_iterator_get (_tmp36_);
			entry = (GeeMapEntry*) _tmp37_;
			_tmp38_ = entry;
			_tmp39_ = gee_map_entry_get_key (_tmp38_);
			_tmp40_ = _tmp39_;
			_tmp41_ = gtk_music_musical_notes_midi_is_accident (GPOINTER_TO_UINT (_tmp40_));
			if (!_tmp41_) {
				GeeMapEntry* _tmp42_;
				gconstpointer _tmp43_;
				gushort _tmp44_;
				gdouble _tmp45_ = 0.0;
				cairo_t* _tmp46_;
				gdouble _tmp47_;
				gdouble _tmp48_;
				gdouble _tmp49_;
				gdouble _tmp50_;
				cairo_t* _tmp51_;
				GeeMapEntry* _tmp52_;
				gconstpointer _tmp53_;
				GtkMusicPianoMarkedNoteStyle* _tmp54_;
				gfloat* _tmp55_;
				gint _tmp55__length1;
				gfloat _tmp56_;
				GeeMapEntry* _tmp57_;
				gconstpointer _tmp58_;
				GtkMusicPianoMarkedNoteStyle* _tmp59_;
				gfloat* _tmp60_;
				gint _tmp60__length1;
				gfloat _tmp61_;
				GeeMapEntry* _tmp62_;
				gconstpointer _tmp63_;
				GtkMusicPianoMarkedNoteStyle* _tmp64_;
				gfloat* _tmp65_;
				gint _tmp65__length1;
				gfloat _tmp66_;
				GeeMapEntry* _tmp67_;
				gconstpointer _tmp68_;
				GtkMusicPianoMarkedNoteStyle* _tmp69_;
				gfloat* _tmp70_;
				gint _tmp70__length1;
				gfloat _tmp71_;
				cairo_t* _tmp72_;
				cairo_t* _tmp73_;
				cairo_t* _tmp74_;
				_tmp42_ = entry;
				_tmp43_ = gee_map_entry_get_key (_tmp42_);
				_tmp44_ = _tmp43_;
				_tmp45_ = gtk_music_piano_midi_to_x (self, GPOINTER_TO_UINT (_tmp44_));
				x = _tmp45_;
				_tmp46_ = cr;
				_tmp47_ = x;
				_tmp48_ = y;
				_tmp49_ = self->priv->key_width;
				_tmp50_ = self->priv->piano_height;
				cairo_rectangle (_tmp46_, _tmp47_, _tmp48_, _tmp49_, _tmp50_);
				_tmp51_ = cr;
				_tmp52_ = entry;
				_tmp53_ = gee_map_entry_get_value (_tmp52_);
				_tmp54_ = _tmp53_;
				_tmp55_ = ((GtkMusicPianoMarkedNoteStyle*) _tmp54_)->color;
				_tmp55__length1 = ((GtkMusicPianoMarkedNoteStyle*) _tmp54_)->color_length1;
				_tmp56_ = _tmp55_[0];
				_tmp57_ = entry;
				_tmp58_ = gee_map_entry_get_value (_tmp57_);
				_tmp59_ = _tmp58_;
				_tmp60_ = ((GtkMusicPianoMarkedNoteStyle*) _tmp59_)->color;
				_tmp60__length1 = ((GtkMusicPianoMarkedNoteStyle*) _tmp59_)->color_length1;
				_tmp61_ = _tmp60_[1];
				_tmp62_ = entry;
				_tmp63_ = gee_map_entry_get_value (_tmp62_);
				_tmp64_ = _tmp63_;
				_tmp65_ = ((GtkMusicPianoMarkedNoteStyle*) _tmp64_)->color;
				_tmp65__length1 = ((GtkMusicPianoMarkedNoteStyle*) _tmp64_)->color_length1;
				_tmp66_ = _tmp65_[2];
				_tmp67_ = entry;
				_tmp68_ = gee_map_entry_get_value (_tmp67_);
				_tmp69_ = _tmp68_;
				_tmp70_ = ((GtkMusicPianoMarkedNoteStyle*) _tmp69_)->color;
				_tmp70__length1 = ((GtkMusicPianoMarkedNoteStyle*) _tmp69_)->color_length1;
				_tmp71_ = _tmp70_[3];
				cairo_set_source_rgba (_tmp51_, (gdouble) _tmp56_, (gdouble) _tmp61_, (gdouble) _tmp66_, (gdouble) _tmp71_);
				_tmp72_ = cr;
				cairo_fill_preserve (_tmp72_);
				_tmp73_ = cr;
				cairo_set_source_rgba (_tmp73_, (gdouble) 0.0f, (gdouble) 0.0f, (gdouble) 0.0f, (gdouble) 1.0f);
				_tmp74_ = cr;
				cairo_stroke (_tmp74_);
			}
			_g_object_unref0 (entry);
		}
		_g_object_unref0 (_entry_it);
	}
	_tmp75_ = cr;
	cairo_restore (_tmp75_);
}


/**
    * Draw natural notes (C#, D#, F#, G#, A#)
    * @param cr The drawing context for the widget
    **/
static void gtk_music_piano_draw_accident_keys (GtkMusicPiano* self, cairo_t* cr) {
	gdouble _tmp0_;
	gdouble x;
	gdouble _tmp1_;
	gdouble y;
	gfloat _tmp2_;
	gdouble _tmp3_;
	gdouble w;
	gfloat _tmp4_;
	gdouble _tmp5_;
	gdouble h;
	cairo_t* _tmp6_;
	cairo_t* _tmp7_;
	gfloat* _tmp8_;
	gint _tmp8__length1;
	gfloat _tmp9_;
	gfloat* _tmp10_;
	gint _tmp10__length1;
	gfloat _tmp11_;
	gfloat* _tmp12_;
	gint _tmp12__length1;
	gfloat _tmp13_;
	gfloat* _tmp14_;
	gint _tmp14__length1;
	gfloat _tmp15_;
	cairo_t* _tmp33_;
	cairo_t* _tmp34_;
	cairo_t* _tmp35_;
	cairo_t* _tmp84_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = self->priv->piano_x;
	x = _tmp0_;
	_tmp1_ = self->priv->piano_y;
	y = _tmp1_;
	_tmp2_ = self->priv->accident_key_width;
	_tmp3_ = self->priv->key_width;
	w = _tmp2_ * _tmp3_;
	_tmp4_ = self->priv->accident_key_height;
	_tmp5_ = self->priv->piano_height;
	h = _tmp4_ * _tmp5_;
	_tmp6_ = cr;
	cairo_save (_tmp6_);
	_tmp7_ = cr;
	_tmp8_ = self->accident_key_color;
	_tmp8__length1 = self->accident_key_color_length1;
	_tmp9_ = _tmp8_[0];
	_tmp10_ = self->accident_key_color;
	_tmp10__length1 = self->accident_key_color_length1;
	_tmp11_ = _tmp10_[1];
	_tmp12_ = self->accident_key_color;
	_tmp12__length1 = self->accident_key_color_length1;
	_tmp13_ = _tmp12_[2];
	_tmp14_ = self->accident_key_color;
	_tmp14__length1 = self->accident_key_color_length1;
	_tmp15_ = _tmp14_[3];
	cairo_set_source_rgba (_tmp7_, (gdouble) _tmp9_, (gdouble) _tmp11_, (gdouble) _tmp13_, (gdouble) _tmp15_);
	{
		gushort _tmp16_;
		gushort i;
		_tmp16_ = self->firstNote;
		i = _tmp16_;
		{
			gboolean _tmp17_;
			_tmp17_ = TRUE;
			while (TRUE) {
				gboolean _tmp18_;
				gushort _tmp20_;
				gushort _tmp21_;
				gushort _tmp22_;
				gushort _tmp23_;
				gboolean _tmp24_ = FALSE;
				_tmp18_ = _tmp17_;
				if (!_tmp18_) {
					gushort _tmp19_;
					_tmp19_ = i;
					i = _tmp19_ + 1;
				}
				_tmp17_ = FALSE;
				_tmp20_ = i;
				_tmp21_ = self->firstNote;
				_tmp22_ = self->key_count;
				if (!(_tmp20_ < (_tmp21_ + _tmp22_))) {
					break;
				}
				_tmp23_ = i;
				_tmp24_ = gtk_music_musical_notes_midi_is_accident (_tmp23_);
				if (_tmp24_) {
					cairo_t* _tmp25_;
					gdouble _tmp26_;
					gdouble _tmp27_;
					gdouble _tmp28_;
					gdouble _tmp29_;
					gdouble _tmp30_;
					_tmp25_ = cr;
					_tmp26_ = x;
					_tmp27_ = w;
					_tmp28_ = y;
					_tmp29_ = w;
					_tmp30_ = h;
					cairo_rectangle (_tmp25_, _tmp26_ - (_tmp27_ / 2), _tmp28_, _tmp29_, _tmp30_);
				} else {
					gdouble _tmp31_;
					gdouble _tmp32_;
					_tmp31_ = x;
					_tmp32_ = self->priv->key_width;
					x = _tmp31_ + _tmp32_;
				}
			}
		}
	}
	_tmp33_ = cr;
	cairo_fill_preserve (_tmp33_);
	_tmp34_ = cr;
	cairo_set_source_rgba (_tmp34_, (gdouble) 0.0f, (gdouble) 0.0f, (gdouble) 0.0f, (gdouble) 1.0f);
	_tmp35_ = cr;
	cairo_stroke (_tmp35_);
	{
		GeeHashMap* _tmp36_;
		GeeSet* _tmp37_;
		GeeSet* _tmp38_;
		GeeSet* _tmp39_;
		GeeIterator* _tmp40_ = NULL;
		GeeIterator* _tmp41_;
		GeeIterator* _entry_it;
		_tmp36_ = self->markedNotes;
		_tmp37_ = gee_abstract_map_get_entries ((GeeMap*) _tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = _tmp38_;
		_tmp40_ = gee_iterable_iterator ((GeeIterable*) _tmp39_);
		_tmp41_ = _tmp40_;
		_g_object_unref0 (_tmp39_);
		_entry_it = _tmp41_;
		while (TRUE) {
			GeeIterator* _tmp42_;
			gboolean _tmp43_ = FALSE;
			GeeIterator* _tmp44_;
			gpointer _tmp45_ = NULL;
			GeeMapEntry* entry;
			GeeMapEntry* _tmp46_;
			gconstpointer _tmp47_;
			gushort _tmp48_;
			gboolean _tmp49_ = FALSE;
			_tmp42_ = _entry_it;
			_tmp43_ = gee_iterator_next (_tmp42_);
			if (!_tmp43_) {
				break;
			}
			_tmp44_ = _entry_it;
			_tmp45_ = gee_iterator_get (_tmp44_);
			entry = (GeeMapEntry*) _tmp45_;
			_tmp46_ = entry;
			_tmp47_ = gee_map_entry_get_key (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = gtk_music_musical_notes_midi_is_accident (GPOINTER_TO_UINT (_tmp48_));
			if (_tmp49_) {
				GeeMapEntry* _tmp50_;
				gconstpointer _tmp51_;
				gushort _tmp52_;
				gdouble _tmp53_ = 0.0;
				cairo_t* _tmp54_;
				gdouble _tmp55_;
				gdouble _tmp56_;
				gdouble _tmp57_;
				gdouble _tmp58_;
				gdouble _tmp59_;
				cairo_t* _tmp60_;
				GeeMapEntry* _tmp61_;
				gconstpointer _tmp62_;
				GtkMusicPianoMarkedNoteStyle* _tmp63_;
				gfloat* _tmp64_;
				gint _tmp64__length1;
				gfloat _tmp65_;
				GeeMapEntry* _tmp66_;
				gconstpointer _tmp67_;
				GtkMusicPianoMarkedNoteStyle* _tmp68_;
				gfloat* _tmp69_;
				gint _tmp69__length1;
				gfloat _tmp70_;
				GeeMapEntry* _tmp71_;
				gconstpointer _tmp72_;
				GtkMusicPianoMarkedNoteStyle* _tmp73_;
				gfloat* _tmp74_;
				gint _tmp74__length1;
				gfloat _tmp75_;
				GeeMapEntry* _tmp76_;
				gconstpointer _tmp77_;
				GtkMusicPianoMarkedNoteStyle* _tmp78_;
				gfloat* _tmp79_;
				gint _tmp79__length1;
				gfloat _tmp80_;
				cairo_t* _tmp81_;
				cairo_t* _tmp82_;
				cairo_t* _tmp83_;
				_tmp50_ = entry;
				_tmp51_ = gee_map_entry_get_key (_tmp50_);
				_tmp52_ = _tmp51_;
				_tmp53_ = gtk_music_piano_midi_to_x (self, GPOINTER_TO_UINT (_tmp52_));
				x = _tmp53_;
				_tmp54_ = cr;
				_tmp55_ = x;
				_tmp56_ = w;
				_tmp57_ = y;
				_tmp58_ = w;
				_tmp59_ = h;
				cairo_rectangle (_tmp54_, _tmp55_ - (_tmp56_ / 2), _tmp57_, _tmp58_, _tmp59_);
				_tmp60_ = cr;
				_tmp61_ = entry;
				_tmp62_ = gee_map_entry_get_value (_tmp61_);
				_tmp63_ = _tmp62_;
				_tmp64_ = ((GtkMusicPianoMarkedNoteStyle*) _tmp63_)->color;
				_tmp64__length1 = ((GtkMusicPianoMarkedNoteStyle*) _tmp63_)->color_length1;
				_tmp65_ = _tmp64_[0];
				_tmp66_ = entry;
				_tmp67_ = gee_map_entry_get_value (_tmp66_);
				_tmp68_ = _tmp67_;
				_tmp69_ = ((GtkMusicPianoMarkedNoteStyle*) _tmp68_)->color;
				_tmp69__length1 = ((GtkMusicPianoMarkedNoteStyle*) _tmp68_)->color_length1;
				_tmp70_ = _tmp69_[1];
				_tmp71_ = entry;
				_tmp72_ = gee_map_entry_get_value (_tmp71_);
				_tmp73_ = _tmp72_;
				_tmp74_ = ((GtkMusicPianoMarkedNoteStyle*) _tmp73_)->color;
				_tmp74__length1 = ((GtkMusicPianoMarkedNoteStyle*) _tmp73_)->color_length1;
				_tmp75_ = _tmp74_[2];
				_tmp76_ = entry;
				_tmp77_ = gee_map_entry_get_value (_tmp76_);
				_tmp78_ = _tmp77_;
				_tmp79_ = ((GtkMusicPianoMarkedNoteStyle*) _tmp78_)->color;
				_tmp79__length1 = ((GtkMusicPianoMarkedNoteStyle*) _tmp78_)->color_length1;
				_tmp80_ = _tmp79_[3];
				cairo_set_source_rgba (_tmp60_, (gdouble) _tmp65_, (gdouble) _tmp70_, (gdouble) _tmp75_, (gdouble) _tmp80_);
				_tmp81_ = cr;
				cairo_fill_preserve (_tmp81_);
				_tmp82_ = cr;
				cairo_set_source_rgba (_tmp82_, (gdouble) 0.0f, (gdouble) 0.0f, (gdouble) 0.0f, (gdouble) 1.0f);
				_tmp83_ = cr;
				cairo_stroke (_tmp83_);
			}
			_g_object_unref0 (entry);
		}
		_g_object_unref0 (_entry_it);
	}
	_tmp84_ = cr;
	cairo_restore (_tmp84_);
}


static void g_cclosure_user_marshal_VOID__OBJECT_POINTER_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_POINTER_INT) (gpointer data1, gpointer arg_1, gpointer arg_2, gint arg_3, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_POINTER_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_POINTER_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_pointer (param_values + 2), g_value_get_int (param_values + 3), data2);
}


static gfloat* _vala_array_dup2 (gfloat* self, int length) {
	return g_memdup (self, length * sizeof (gfloat));
}


GtkMusicPianoMarkedNoteStyle* gtk_music_piano_marked_note_style_construct (GType object_type, gfloat* color, int color_length1) {
	GtkMusicPianoMarkedNoteStyle* self = NULL;
	gfloat* _tmp0_;
	gint _tmp0__length1;
	gfloat* _tmp1_;
	gint _tmp1__length1;
	self = (GtkMusicPianoMarkedNoteStyle*) g_type_create_instance (object_type);
	_tmp0_ = color;
	_tmp0__length1 = color_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup2 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	self->color = (g_free (self->color), NULL);
	self->color = _tmp1_;
	self->color_length1 = _tmp1__length1;
	return self;
}


GtkMusicPianoMarkedNoteStyle* gtk_music_piano_marked_note_style_new (gfloat* color, int color_length1) {
	return gtk_music_piano_marked_note_style_construct (GTK_MUSIC_PIANO_TYPE_MARKED_NOTE_STYLE, color, color_length1);
}


static void gtk_music_piano_value_marked_note_style_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void gtk_music_piano_value_marked_note_style_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		gtk_music_piano_marked_note_style_unref (value->data[0].v_pointer);
	}
}


static void gtk_music_piano_value_marked_note_style_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gtk_music_piano_marked_note_style_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer gtk_music_piano_value_marked_note_style_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* gtk_music_piano_value_marked_note_style_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		GtkMusicPianoMarkedNoteStyle* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gtk_music_piano_marked_note_style_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* gtk_music_piano_value_marked_note_style_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GtkMusicPianoMarkedNoteStyle** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gtk_music_piano_marked_note_style_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* gtk_music_piano_param_spec_marked_note_style (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	GtkMusicPianoParamSpecMarkedNoteStyle* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GTK_MUSIC_PIANO_TYPE_MARKED_NOTE_STYLE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer gtk_music_piano_value_get_marked_note_style (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTK_MUSIC_PIANO_TYPE_MARKED_NOTE_STYLE), NULL);
	return value->data[0].v_pointer;
}


void gtk_music_piano_value_set_marked_note_style (GValue* value, gpointer v_object) {
	GtkMusicPianoMarkedNoteStyle* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTK_MUSIC_PIANO_TYPE_MARKED_NOTE_STYLE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GTK_MUSIC_PIANO_TYPE_MARKED_NOTE_STYLE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gtk_music_piano_marked_note_style_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gtk_music_piano_marked_note_style_unref (old);
	}
}


void gtk_music_piano_value_take_marked_note_style (GValue* value, gpointer v_object) {
	GtkMusicPianoMarkedNoteStyle* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTK_MUSIC_PIANO_TYPE_MARKED_NOTE_STYLE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GTK_MUSIC_PIANO_TYPE_MARKED_NOTE_STYLE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gtk_music_piano_marked_note_style_unref (old);
	}
}


static void gtk_music_piano_marked_note_style_class_init (GtkMusicPianoMarkedNoteStyleClass * klass) {
	gtk_music_piano_marked_note_style_parent_class = g_type_class_peek_parent (klass);
	GTK_MUSIC_PIANO_MARKED_NOTE_STYLE_CLASS (klass)->finalize = gtk_music_piano_marked_note_style_finalize;
}


static void gtk_music_piano_marked_note_style_instance_init (GtkMusicPianoMarkedNoteStyle * self) {
	gfloat* _tmp0_ = NULL;
	_tmp0_ = g_new0 (gfloat, 4);
	_tmp0_[0] = 0.0f;
	_tmp0_[1] = 0.0f;
	_tmp0_[2] = 0.0f;
	_tmp0_[3] = 1.0f;
	self->color = _tmp0_;
	self->color_length1 = 4;
	self->ref_count = 1;
}


static void gtk_music_piano_marked_note_style_finalize (GtkMusicPianoMarkedNoteStyle* obj) {
	GtkMusicPianoMarkedNoteStyle * self;
	self = GTK_MUSIC_PIANO_MARKED_NOTE_STYLE (obj);
	self->color = (g_free (self->color), NULL);
}


GType gtk_music_piano_marked_note_style_get_type (void) {
	static volatile gsize gtk_music_piano_marked_note_style_type_id__volatile = 0;
	if (g_once_init_enter (&gtk_music_piano_marked_note_style_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gtk_music_piano_value_marked_note_style_init, gtk_music_piano_value_marked_note_style_free_value, gtk_music_piano_value_marked_note_style_copy_value, gtk_music_piano_value_marked_note_style_peek_pointer, "p", gtk_music_piano_value_marked_note_style_collect_value, "p", gtk_music_piano_value_marked_note_style_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GtkMusicPianoMarkedNoteStyleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtk_music_piano_marked_note_style_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkMusicPianoMarkedNoteStyle), 0, (GInstanceInitFunc) gtk_music_piano_marked_note_style_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gtk_music_piano_marked_note_style_type_id;
		gtk_music_piano_marked_note_style_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GtkMusicPianoMarkedNoteStyle", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gtk_music_piano_marked_note_style_type_id__volatile, gtk_music_piano_marked_note_style_type_id);
	}
	return gtk_music_piano_marked_note_style_type_id__volatile;
}


gpointer gtk_music_piano_marked_note_style_ref (gpointer instance) {
	GtkMusicPianoMarkedNoteStyle* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void gtk_music_piano_marked_note_style_unref (gpointer instance) {
	GtkMusicPianoMarkedNoteStyle* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GTK_MUSIC_PIANO_MARKED_NOTE_STYLE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void gtk_music_piano_class_init (GtkMusicPianoClass * klass) {
	gtk_music_piano_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GtkMusicPianoPrivate));
	GTK_WIDGET_CLASS (klass)->button_press_event = gtk_music_piano_real_button_press_event;
	GTK_WIDGET_CLASS (klass)->button_release_event = gtk_music_piano_real_button_release_event;
	GTK_WIDGET_CLASS (klass)->draw = gtk_music_piano_real_draw;
	G_OBJECT_CLASS (klass)->finalize = gtk_music_piano_finalize;
	g_signal_new ("note_pressed", GTK_MUSIC_TYPE_PIANO, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_POINTER_INT, G_TYPE_NONE, 3, GTK_TYPE_WIDGET, G_TYPE_POINTER, G_TYPE_INT);
	g_signal_new ("note_released", GTK_MUSIC_TYPE_PIANO, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_POINTER_INT, G_TYPE_NONE, 3, GTK_TYPE_WIDGET, G_TYPE_POINTER, G_TYPE_INT);
}


static void gtk_music_piano_instance_init (GtkMusicPiano * self) {
	gfloat* _tmp0_ = NULL;
	gfloat* _tmp1_ = NULL;
	self->priv = GTK_MUSIC_PIANO_GET_PRIVATE (self);
	self->autoUpdate = TRUE;
	self->key_count = (gushort) 24;
	self->firstNote = (gushort) 36;
	_tmp0_ = g_new0 (gfloat, 4);
	_tmp0_[0] = 1.0f;
	_tmp0_[1] = 1.0f;
	_tmp0_[2] = 1.0f;
	_tmp0_[3] = 1.0f;
	self->nat_key_color = _tmp0_;
	self->nat_key_color_length1 = 4;
	_tmp1_ = g_new0 (gfloat, 4);
	_tmp1_[0] = 0.0f;
	_tmp1_[1] = 0.0f;
	_tmp1_[2] = 0.0f;
	_tmp1_[3] = 1.0f;
	self->accident_key_color = _tmp1_;
	self->accident_key_color_length1 = 4;
	self->showLabels = FALSE;
	self->detailedLabels = FALSE;
	self->labelsPosition = GTK_MUSIC_PIANO_LABEL_POSITION_UP;
	self->priv->h_padding = (gushort) 2;
	self->priv->v_padding = (gushort) 2;
	self->priv->accident_key_height = 0.7f;
	self->priv->accident_key_width = 0.4f;
	self->priv->x_min_natk_dist = 0.1f;
}


static void gtk_music_piano_finalize (GObject* obj) {
	GtkMusicPiano * self;
	self = GTK_MUSIC_PIANO (obj);
	self->nat_key_color = (g_free (self->nat_key_color), NULL);
	self->accident_key_color = (g_free (self->accident_key_color), NULL);
	_g_object_unref0 (self->markedNotes);
	G_OBJECT_CLASS (gtk_music_piano_parent_class)->finalize (obj);
}


/**
 * Piano widget
 **/
GType gtk_music_piano_get_type (void) {
	static volatile gsize gtk_music_piano_type_id__volatile = 0;
	if (g_once_init_enter (&gtk_music_piano_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GtkMusicPianoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtk_music_piano_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkMusicPiano), 0, (GInstanceInitFunc) gtk_music_piano_instance_init, NULL };
		GType gtk_music_piano_type_id;
		gtk_music_piano_type_id = g_type_register_static (GTK_TYPE_DRAWING_AREA, "GtkMusicPiano", &g_define_type_info, 0);
		g_once_init_leave (&gtk_music_piano_type_id__volatile, gtk_music_piano_type_id);
	}
	return gtk_music_piano_type_id__volatile;
}



