/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

 /*
  * TODO:
  * Document everything.
  * What is the gdk_drawable_get_type(), what should i do with it?
  */
  
package org.gnu.gdk;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.pango.Font;
import org.gnu.pango.GlyphString;
import org.gnu.pango.Layout;
import org.gnu.pango.LayoutLine;

/**
 *
 */
 
public class Drawable extends GObject 
{
	
	public Drawable(Handle handle){
		super(handle);
	}
	
	public Dimension getSize(){
		int width[]=new int[1];
		int height[]=new int[1];
		Drawable.gdk_drawable_get_size(getHandle(),width,height);
		return new Dimension(width[0],height[0]);
	}
	
	public void setColormap(Colormap cmap){
		Drawable.gdk_drawable_set_colormap(getHandle(),cmap.getHandle());
	}
	
	public Colormap getColormap(){
	    Handle hndl = gdk_drawable_get_colormap(getHandle());
		GObject obj = retrieveGObject(hndl);
		if (null != obj)
			return (Colormap)obj;
		return new Colormap(hndl);
	}
	
	public Visual getVisual(){
	    Handle hndl = gdk_drawable_get_visual(getHandle());
		GObject obj = retrieveGObject(hndl);
		if (null != obj)
			return (Visual)obj;
		return new Visual(hndl);
	}
	
	
	public int getDepth(){
		return Drawable.gdk_drawable_get_depth(getHandle());
	}
	
	public Image getImage(int x, int y, int width, int height){
	    Handle hndl = gdk_drawable_get_image(getHandle(),x,y,width,height);
		GObject obj = retrieveGObject(hndl);
		if (null != obj)
			return (Image)obj;
		return new Image(hndl);
	}
	
	public Region getClipRegion(){
		return new Region(Drawable.gdk_drawable_get_clip_region(getHandle()));
	}
	
	public Region getVisibleRegion(){
		return new Region(Drawable.gdk_drawable_get_visible_region(getHandle()));
	}
	
	public void drawRGBImage(GC gc, int x, int y, int width, int height, RgbDither dither, byte[] buffer, int rowStride) {
		gdk_draw_rgb_image(getHandle(), gc.getHandle(), x, y, width, height, dither.getValue(), buffer, rowStride);
	}

	public void drawRGBImageDitherAlign(GC gc, int x, int y, int width, int height, RgbDither dither, byte[] buffer, int rowStride, int xdith, int ydith) {
		gdk_draw_rgb_image_dithalign(getHandle(), gc.getHandle(), x, y, width, height, dither.getValue(), buffer, rowStride, xdith, ydith);
	}

	public void drawRGB32Image(GC gc, int x, int y, int width, int height, RgbDither dither, byte[] buffer, int rowStride) {
		gdk_draw_rgb_32_image(getHandle(), gc.getHandle(), x, y, width, height, dither.getValue(), buffer, rowStride);
	}

	public void drawRGB32ImageDitherAlign(GC gc, int x, int y, int width, int height, RgbDither dither, byte[] buffer, int rowStride, int xdith, int ydith) {
		gdk_draw_rgb_32_image_dithalign(getHandle(), gc.getHandle(), x, y, width, height, dither.getValue(), buffer, rowStride, xdith, ydith);
	}

	
	public void drawGrayImage(GC gc, int x, int y, int width, int height, RgbDither dither, byte[] buffer, int rowStride) {
		gdk_draw_gray_image(getHandle(), gc.getHandle(), x, y, width, height, dither.getValue(), buffer, rowStride);
	}

	public void drawIndexedImage(GC gc, int x, int y, int width, int height, RgbDither dither, byte[] buffer, int rowStride, RgbCmap cmap) {
		gdk_draw_indexed_image(getHandle(), gc.getHandle(), x, y, width, height, dither.getValue(), buffer, rowStride, cmap.getHandle());
	}

	public void drawPolygon(GC gc, boolean filled, Point[] points) {
	    Handle[] hndls = new Handle[points.length];
		for (int i = 0; i < points.length; i++) {
			hndls[i] = points[i].getHandle();
		}
		gdk_draw_polygon(getHandle(), gc.getHandle(), filled, hndls);
	}
	
	public void drawDrawable(GC gc, Drawable src, int xsrc, int ysrc, int xdest, int ydest, int width, int height) {
		gdk_draw_drawable(getHandle(), gc.getHandle(), src.getHandle(), xsrc, ysrc, xdest, ydest, width, height);
	}
	
	public void drawImage(GC gc, Image image, int xsrc, int ysrc, int xdest, int ydest, int width, int height) {
		gdk_draw_image(getHandle(), gc.getHandle(), image.getHandle(), xsrc, ysrc, xdest, ydest, width, height);
	}
	
	public void drawPoints(GC gc, Point[] points) {
	    Handle[] hndls = new Handle[points.length];
		for (int i = 0; i < points.length; i++) {
			hndls[i] = points[i].getHandle();
		}
		gdk_draw_points(getHandle(), gc.getHandle(), hndls);
	}

	public void drawSegments(GC gc, Segment[] segments) {
	    Handle[] hndls = new Handle[segments.length];
		for (int i = 0; i < segments.length; i++) {
			hndls[i] = segments[i].getHandle();
		}
		gdk_draw_segments(getHandle(), gc.getHandle(), hndls);
	}
	
	public void drawLines(GC gc, Point[] points) {
	    Handle[] hndls = new Handle[points.length];
		for (int i = 0; i < points.length; i++) {
			hndls[i] = points[i].getHandle();
		}
		gdk_draw_lines(getHandle(), gc.getHandle(), hndls);
	}

	public void drawGlyphs(GC gc, Font font, int x, int y, GlyphString glyphs) {
		gdk_draw_glyphs(getHandle(), gc.getHandle(), font.getHandle(), x, y, glyphs.getHandle());
	}

	public void drawLayoutLine(GC gc, int x, int y, LayoutLine line) {
		gdk_draw_layout_line(getHandle(), gc.getHandle(), x, y, line.getHandle());
	}

	public void drawLayout(GC gc, int x, int y, Layout layout) {
		gdk_draw_layout(getHandle(), gc.getHandle(), x, y, layout.getHandle());
	}
	
	public void drawLayoutLineWithColors(GC gc, int x, int y, LayoutLine line, Color foreground, Color background) {
		gdk_draw_layout_line_with_colors(getHandle(), gc.getHandle(), x, y, line.getHandle(), foreground.getHandle(), background.getHandle());
	}
	
	public void drawLayoutWithColors(GC gc, int x, int y, Layout layout, Color foreground, Color background) {
		gdk_draw_layout_with_colors(getHandle(), gc.getHandle(), x, y, layout.getHandle(), foreground.getHandle(), background.getHandle());
	}
	
    /*
     * BEGINNING OF JNI CODE
     */
    native static final protected int gdk_drawable_get_type (); // ??? not in the api
    native static final protected void gdk_drawable_get_size (Handle drawable, int [] width, int[] height);
    native static final protected void gdk_drawable_set_colormap (Handle drawable, Handle colormap);
    native static final protected Handle gdk_drawable_get_colormap (Handle drawable);
    native static final protected Handle gdk_drawable_get_visual (Handle drawable);
    native static final protected int gdk_drawable_get_depth (Handle drawable);
    native static final protected Handle gdk_drawable_get_image (Handle drawable, int x, int y, int width, int height);
    native static final protected Handle gdk_drawable_get_clip_region (Handle drawable);
    native static final protected Handle gdk_drawable_get_visible_region (Handle drawable);

    // moved from Gdk
    native static final protected void gdk_draw_rgb_image (Handle drawable, Handle gc, int x, int y, int width, int height, int dith, byte[] rgbBuf, int rowstride);
    native static final protected void gdk_draw_rgb_image_dithalign (Handle drawable, Handle gc, int x, int y, int width, int height, int dith, byte[] rgbBuf, int rowstride, int xDith, int yDith);
    native static final protected void gdk_draw_rgb_32_image (Handle drawable, Handle gc, int x, int y, int width, int height, int dith, byte[] rgbBuf, int rowstride);
    native static final protected void gdk_draw_rgb_32_image_dithalign (Handle drawable, Handle gc, int x, int y, int width, int height, int dith, byte[] rgbBuf, int rowstride, int xDith, int yDith);
    native static final protected void gdk_draw_gray_image (Handle drawable, Handle gc, int x, int y, int width, int height, int dith, byte[] rgbBuf, int rowstride);
    native static final protected void gdk_draw_indexed_image (Handle drawable, Handle gc, int x, int y, int width, int height, int dith, byte[] buf, int rowstride, Handle cmap);
    native static final protected void gdk_draw_polygon (Handle window, Handle gc, boolean filled, Handle[] points);
    native static final protected void gdk_draw_drawable (Handle drawable, Handle gc, Handle src, int xsrc, int ysrc, int xdest, int ydest, int width, int height);
    native static final protected void gdk_draw_image (Handle drawable, Handle gc, Handle image, int xsrc, int ysrc, int xdest, int ydest, int width, int height);
    native static final protected void gdk_draw_points (Handle drawable, Handle gc, Handle [] points);
    native static final protected void gdk_draw_segments (Handle drawable, Handle gc, Handle [] segments);
    native static final protected void gdk_draw_lines (Handle window, Handle gc, Handle[] points);
    native static final protected void gdk_draw_glyphs (Handle drawable, Handle gc, Handle font, int x, int y, Handle glyphs);
    native static final protected void gdk_draw_layout_line (Handle drawable, Handle gc, int x, int y, Handle line);
    native static final protected void gdk_draw_layout (Handle drawable, Handle gc, int x, int y, Handle layout);
    native static final protected void gdk_draw_layout_line_with_colors (Handle drawable, Handle gc, int x, int y, Handle line, Handle foreground, Handle background);
    native static final protected void gdk_draw_layout_with_colors (Handle drawable, Handle gc, int x, int y, Handle layout, Handle foreground, Handle background);
    
    /*
     * END OF JNI CODE
     */
}