/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-07-31 13:44:39 EDT
 */

#include <jni.h>
#include <sys/types.h>
#include <pango/pango.h>
#include <gtk/gtk.h>
#ifdef __cplusplus
extern "C" 
{
#endif
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    /*
     * Class:     org.gnu.pango.GlyphString
     * Method:    pango_glyph_string_new
     * Signature: ()I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_pango_GlyphString_pango_1glyph_1string_1new (JNIEnv *env, 
        jclass cls) 
    {
        {
            return (jint)pango_glyph_string_new ();
        }
    }

    /*
     * Class:     org.gnu.pango.GlyphString
     * Method:    pango_glyph_string_set_size
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_pango_GlyphString_pango_1glyph_1string_1set_1size (JNIEnv 
        *env, jclass cls, jint string, jint newLen) 
    {
        PangoGlyphString *string_g = (PangoGlyphString *)string;
        gint32 newLen_g = (gint32) newLen;
        {
            pango_glyph_string_set_size (string_g, newLen_g);
        }
    }

    /*
     * Class:     org.gnu.pango.GlyphString
     * Method:    pango_glyph_string_get_type
     * Signature: ()I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_pango_GlyphString_pango_1glyph_1string_1get_1type (JNIEnv 
        *env, jclass cls) 
    {
        {
            return (jint)pango_glyph_string_get_type ();
        }
    }

    /*
     * Class:     org.gnu.pango.GlyphString
     * Method:    pango_glyph_string_copy
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_pango_GlyphString_pango_1glyph_1string_1copy (JNIEnv *env, 
        jclass cls, jint string) 
    {
        PangoGlyphString *string_g = (PangoGlyphString *)string;
        {
            return (jint)pango_glyph_string_copy (string_g);
        }
    }

    /*
     * Class:     org.gnu.pango.GlyphString
     * Method:    pango_glyph_string_free
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_pango_GlyphString_pango_1glyph_1string_1free (JNIEnv *env, 
        jclass cls, jint string) 
    {
        PangoGlyphString *string_g = (PangoGlyphString *)string;
        {
            pango_glyph_string_free (string_g);
        }
    }

    /*
     * Class:     org.gnu.pango.GlyphString
     * Method:    pango_glyph_string_extents
     * Signature: (IIII)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_pango_GlyphString_pango_1glyph_1string_1extents (JNIEnv 
        *env, jclass cls, jint glyphs, jint font, jint inkRect, jint logicalRect) 
    {
        PangoGlyphString *glyphs_g = (PangoGlyphString *)glyphs;
        PangoFont *font_g = (PangoFont *)font;
        PangoRectangle *inkRect_g = (PangoRectangle *)inkRect;
        PangoRectangle *logicalRect_g = (PangoRectangle *)logicalRect;
        {
            pango_glyph_string_extents (glyphs_g, font_g, inkRect_g, logicalRect_g);
        }
    }

    /*
     * Class:     org.gnu.pango.GlyphString
     * Method:    pango_glyph_string_extents_range
     * Signature: (IIIIII)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_pango_GlyphString_pango_1glyph_1string_1extents_1range (
        JNIEnv *env, jclass cls, jint glyphs, jint start, jint end, jint font, jint inkRect, jint 
        logicalRect) 
    {
        PangoGlyphString *glyphs_g = (PangoGlyphString *)glyphs;
        gint32 start_g = (gint32) start;
        gint32 end_g = (gint32) end;
        PangoFont *font_g = (PangoFont *)font;
        PangoRectangle *inkRect_g = (PangoRectangle *)inkRect;
        PangoRectangle *logicalRect_g = (PangoRectangle *)logicalRect;
        {
            pango_glyph_string_extents_range (glyphs_g, start_g, end_g, font_g, inkRect_g, 
                logicalRect_g);
        }
    }

    /*
     * Class:     org.gnu.pango.GlyphString
     * Method:    pango_glyph_string_get_logical_widths
     * Signature: (Ijava.lang.String;II[Lint ;)V
     */
    JNIEXPORT void JNICALL 
    Java_org_gnu_pango_GlyphString_pango_1glyph_1string_1get_1logical_1widths (JNIEnv *env, jclass 
        cls, jint glyphs, jstring text, jint length, jint embeddingLevel, jintArray 
        logicalWidths) 
    {
        const gchar* text_g = (*env)->GetStringUTFChars(env, text, 0);
        gint *logicalWidths_g = (gint *) (*env)->GetIntArrayElements (env, logicalWidths, NULL);
        pango_glyph_string_get_logical_widths ((PangoGlyphString *)glyphs, text_g, (gint32)length, (gint32)embeddingLevel, 
                logicalWidths_g);
        (*env)->ReleaseIntArrayElements (env, logicalWidths, (jint *) logicalWidths_g, 0);
        (*env)->ReleaseStringUTFChars(env, text, text_g);
    }

    /****************************************
     * END OF GENERATED CODE
     ****************************************/
#ifdef __cplusplus
}

#endif
