/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gdk;
import org.gnu.glib.Boxed;
/**
 *
 */
public class EventButton extends Boxed 
{
	
	public EventButton(int handle) {
		this.handle = handle;
	}
	
	public int getButton() {
		return EventButton.getButton(handle);
	}
	
	public double getX() {
		return EventButton.getX(handle);
	}
	
	public double getY() {
		return EventButton.getY(handle);
	}
	
	public int getType() {
		return EventButton.getType(handle);
	}
	
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int getType (int obj);
    native static final protected int getWindow (int obj);
    native static final protected boolean getSendEvent (int obj);
    native static final protected int getTime (int obj);
    native static final protected double getX (int obj);
    native static final protected double getY (int obj);
    native static final protected int getState (int obj);
    native static final protected int getButton (int obj);
    native static final protected int getDevice (int obj);
    native static final protected double getXRoot (int obj);
    native static final protected double getYRoot (int obj);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

