/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-02 09:30:35 EDT
 */

package org.gnu.gtk;

import org.gnu.glib.Type;

/**
 * The TreeView object is a widget for displaying trees and lists. The sole
 * purpose of this widget is for displaying the data on the screen and setting
 * other parts of the view using the associated objects. 
 *
 * <h1>Gtk Tree and List Widgets Overview</h1>
 * <p>The standard tree and list widgets in Gtk are very powerful, but somewhat
 * complex. For your conveniance, the Java-Gnome project has derived a number of
 * simpler classes for common uses of these widgets. 
 * <dl>
 * <dt>{@link SimpleList}
 * <dd>A single column list of string values.
 * <dt>todo...
 * <dd>todo...
 * </dl>
 * <p>If you choose not to use those, or your requirements are such that you
 * cannot use them, you will have to learn how to use the full objects. 
 * 
 * <h2>{@link TreeView}</h2>
 * <p>There is only one widget which is placed in any applications to create
 * trees, lists and tables. This is the {@link TreeView}. An application can
 * have any number of treeviews and they can be placed as can normal widgets.
 * The data for the widget, and the method in which it is displayed is
 * controlled by other classes. Gtk has been designed so that any number of
 * treeview widgets can be linked to the same data store. {@link
 * TreeViewColumn}s, {@link CellRenderer}s and {@link TreeSelection}s are
 * created for each view, so Views can use the same data store but have their
 * own column layout, data display within those columns (linked to any of the
 * dataBlocks in the store); and their own selections.
 *
 * <h2>{@link TreeModel}</h2>
 * <p>Models are used to store data. Data is stored in what could be considered
 * a table. There are a number of {@link DataBlock}s, which could be considered as
 * data columns (in fact, in the C version of gtk, they are always refered to as
 * columns; but this can get confused with TreeViewColumns which are quite a
 * different matter). These dataBlocks each store one type of data
 * (String, boolean, int, etc.). The 'rows' of the data table, or the individual
 * records in the data store are accessible using iterators called {@link
 * TreeIter}s. These are used extensively in many methods. Setting data involves
 * getting an iterator (usually be creating a new row) and then setting the
 * value for each of the dataBlocks. The ordering of these dataBlocks has
 * absolutely no meaning - you can decide exactly which blocks are used on
 * screen by setting Attribute mappings to the CellRenderers which render data
 * on the screen (see below).
 * <p>Currently, there are two implementations of {@link TreeModel}
 * <p>{@link ListStore} - This is used for tables and lists. Data is organised
 * in rows and columns.
 * <p>{@link TreeStore} - This is for the hierarchical trees. Data is organised
 * using {@link TreePath}'s.
 *
 * <h2>{@link TreeViewColumn}</h2>
 * <p>Both trees and lists can have multiple columns of data. Columns are added
 * and removed using the {@link TreeView} class. Columns are objects which
 * determine how the data is displayed. They have settings such as the column
 * title, whether the column can be resized, and even whether the columns can be
 * reorganized (by dragging the columns). Each {@link TreeView} widget has it's
 * own set of columns. Determining how the data is displayed in the columns is
 * done by CellRenderers (see below). Any number of renderers can be added to
 * the same column
 * 
 * <h2>{@link CellRenderer}</h2>
 * <p>Tree and list `cells' may contain a large variety of data types.
 * Determining how they are displayed is done by the CellRenderer family of
 * classes. If the data is unusual, or you want to combine a number of data
 * types in a single column, you may construct your own renderer. However, you
 * are recommended to stick with the regular choices:
 * <dl>
 * <dt>{@link CellRendererPixbuf}
 * <dd>
 * <dt>{@link CellRendererText}
 * <dd>For displaying Strings
 * <dt>{@link CellRendererToggle}
 * <dd>For displaying boolean data, either as individual checkboxes or as radio
 * buttons.
 * </dl>
 * <p>The CellRenderer's need data to be able to display. This is set using the
 * {@link TreeViewColumn#addAttributeMapping(CellRenderer,
 * CellRendererAttribute, int)}. The renderer attributes vary with each
 * renderer, for example CellRendererText has a TEXT attribute for the text the
 * be displayed. The final parameter is for the dataBlock in the store in which
 * the data is contained.
 * 
 *
 * <p>Java-Gnome comes with a number of simple example applications involving trees.
 * They may be useful for learning the functionality of these classes.
 *
 * @author Mark Howard &lt;mh@debian.org&gt;
 */
public class TreeView extends Container {
	/**
	 * Creates a new tree view from a native handle
	 */
	public TreeView(int handle) {
	    super(handle);
	}

	/**
	 * Creates a new TreeView Widget with the initial model set
	 */
	public TreeView(TreeModel model) {
		handle = gtk_tree_view_new_with_model(model.getHandle());
		initializeEventHandlers();
	}

	protected void noopInit() {
	}

	/**
	 * Returns the model associated with this tree.
	 */
	public TreeModel getModel() {
		return new TreeModel(gtk_tree_view_get_model(handle));
	}

	/**
	 * Appends column to the list of columns.
	 *
	 * @param column The GtkTreeViewColumn to add.
	 * @return The number of columns in tree_view after appending.
	 */
	public int appendColumn(TreeViewColumn column) {
		return gtk_tree_view_append_column(handle, column.getHandle());
	}

	/**
	 * This inserts the column into the tree_view at position. If position is -1, then the column is inserted at the end.
	 *
	 * @param column The GtkTreeViewColumn to be inserted.
	 * @param position The position to insert column in.
	 * @return The number of columns in tree_view after insertion.
	 */
	public int insertColumn(TreeViewColumn column, int position) {
		return gtk_tree_view_insert_column(handle, column.getHandle(), position);
	}

	/**
	 * Removes column from tree_view.
	 * @param column The GtkTreeViewColumn to remove.
	 * @return The number of columns in tree_view after removing.
	 */
	public int removeColumn(TreeViewColumn column) {
		return gtk_tree_view_remove_column(handle, column.getHandle());
	}

	/**
	 * Gets the TreeSelection associated with this widget
	 */
	public TreeSelection getSelection() {
		return new TreeSelection(gtk_tree_view_get_selection(handle));
	}

	/**
	 * Gets the GtkAdjustment currently being used for the horizontal aspect.
	 * @return A GtkAdjustment object, or NULL if none is currently being used.
	 */
	public Adjustment getHAdjustment() {
		return new Adjustment(gtk_tree_view_get_hadjustment(handle));
	}

	/**
	 * Sets the Adjustment for the current horizontal aspect.
	 */
	public void setHAdjustment(Adjustment hadj) {
		gtk_tree_view_set_hadjustment(handle, hadj.getHandle());
	}

	/**
	 * Gets the Adjustment currently being used for the vertical aspect.
	 */
	public Adjustment getVAdjustment() {
		return new Adjustment(gtk_tree_view_get_vadjustment(handle));
	}

	/**
	 * Sets the Adjustment for the current vertical aspect.
	 */
	public void setVAdjustment(Adjustment vadj) {
		gtk_tree_view_set_vadjustment(handle, vadj.getHandle());
	}

	/**
	 * Sets the the visibility state of the headers.
	 * @param headersVisible TRUE if the headers are visibl
	 */
	public void setHeadersVisible(boolean headersVisible) {
		gtk_tree_view_set_headers_visible(handle, headersVisible);
	}

	/**
	 * Allow the column title buttons to be clicked.
	 * @param setting TRUE if the columns are clickable.
	 */
	public void setHeadersClickable(boolean setting) {
		gtk_tree_view_set_headers_clickable(handle, setting);
	}

	/**
	 * This function tells GTK+ that the user interface for your application 
	 * requires users to read across tree rows and associate cells with one 
	 * another. By default, GTK+ will then render the tree with alternating 
	 * row colors. Do not use it just because you prefer the appearance of
	 * the ruled tree; that's a question for the theme. Some themes will 
	 * draw tree rows in alternating colors even when rules are turned off, 
	 * and users who prefer that appearance all the time can choose those
	 * themes. You should call this function only as a semantic hint to 
	 * the theme engine that your tree makes alternating colors useful 
	 * from a functional standpoint (since it has lots of columns, 
	 * generally).
	 * @param setting TRUE if the tree requires reading across rows
	 */
	public void setAlternateRowColor(boolean setting) {
		gtk_tree_view_set_rules_hint(handle, setting);
	}

	/**
	 * Gets the column at the given position in the tree view.
	 * @param n  The position of the column, counting from 0.
	 * @return The TreeViewColumn, or <code>null</code> if the position is outside the range 
	 * of columns.
	 */
	public TreeViewColumn getColumn(int position) {
		int h = gtk_tree_view_get_column(handle, position);
		if (h < 0){
			return null;
		}else{
			return new TreeViewColumn(gtk_tree_view_get_column(handle, position));
		}
	}

	/**
	 * Moves column to be after to baseColumn. If baseColumn is NULL, then 
	 * column is placed in the first position.
	 * @param column The GtkTreeViewColumn to be moved.
	 * @param baseColumn The GtkTreeViewColumn to be moved relative to, or 
	 * NULL.
	 */
	public void moveColumn(TreeViewColumn column, TreeViewColumn baseColumn) {
		gtk_tree_view_move_column_after(handle, column.getHandle(), baseColumn.getHandle());
	}

	/**
	 * Sets the column to draw the expander arrow at. 
	 * If column is NULL, then the expander arrow is always at the first visible 
	 * column.
	 * @param column NULL, or the column to draw the expander arrow at.
	 */
	public void setExpanderColumn(TreeViewColumn column) {
		gtk_tree_view_set_expander_column(handle, column.getHandle());
	}

	/**
	 * todo: set column drag function
	 * Interface.
	 */

	/**
	 * Moves the alignments of the view to the position specified by column and 
	 * path. . rowAlign determines where the row is placed, 
	 * and colAlign determines where column is placed. Both are expected to be 
	 * between 0.0 and 1.0. 0.0 means left/top alignment, 1.0 means 
	 * right/bottom alignment, 0.5 means center.
	 *
	 * @param path The path of the row to move to
	 * @param column The TreeViewColumn to move horizontally to
	 * @param rowAlign The vertical alignment of the row specified by path.
	 * @param colAlign : The horizontal alignment of the column specified by 
	 * column.
	 */
	public void scrollToCell(TreePath path, TreeViewColumn column, double rowAlign, double colAlign) {
		gtk_tree_view_scroll_to_cell(handle, path.getHandle(), column.getHandle(), true, rowAlign, colAlign);
	}
	/**
	 * Moves the alignments of the view to the position specified by column and 
	 * path. 
	 * @param path The path of the row to move to
	 * @param column The TreeViewColumn to move horizontally to
	 */
	public void scrollToCell(TreePath path, TreeViewColumn column) {
		gtk_tree_view_scroll_to_cell_noAlign(handle, path.getHandle(), column.getHandle());
	}
	/*
	 * Moves the alignments of the view to the position specified by column 
	 *
	 * @param column The TreeViewColumn to move horizontally to
	 */
	public void scrollToCell(TreeViewColumn column) {
		gtk_tree_view_scroll_to_cell_col(handle, column.getHandle());
	}
	/**
	 * Moves the alignments of the view to the position specified by 
	 * path.
	 * @param path The path of the row to move to, or NULL.
	 */
	public void scrollToCell(TreePath path) {
		gtk_tree_view_scroll_to_cell_path(handle, path.getHandle());
	}

	native static protected void gtk_tree_view_scroll_to_cell_noAlign(int view, int path, int column);
	native static protected void gtk_tree_view_scroll_to_cell_path(int view, int path);
	native static protected void gtk_tree_view_scroll_to_cell_col(int view, int column);

	/**
	 * Sets the current keyboard focus to be at path, and selects it. This is 
	 * useful when you want to focus the user's attention on a particular 
	 * row. If column is specified, and 
	 * startEditing is TRUE, then editing should be started in the specified 
	 * cell. This function is often followed by {@link Widget#grabFocus()}
	 * in order to give keyboard focus to the widget. Please note that editing
	 * can only happen when the widget is realized.
	 * @param path A TreePath
	 * @param focusColumn A TreeViewColumn, or NULL
	 * @param startEditing TRUE if the specified cell should start being edited.
	 */
	public void setCursor(TreePath path, TreeViewColumn focusColumn, boolean startEditing) {
		gtk_tree_view_set_cursor(handle, path.getHandle(), focusColumn.getHandle(), startEditing);
	}

	/**
	 * Returns the current path
	 */
	public TreePath getCursorPath() {
		return new TreePath(gtk_tree_view_get_cursor_path(handle));
	}

	/** 
	 * Returns the current column 
	 */
	public TreeViewColumn getCursorColumn() {
		return new TreeViewColumn(gtk_tree_view_get_cursor_column(handle));
	}
	native static final protected int gtk_tree_view_get_cursor_path(int treeView);
	native static final protected int gtk_tree_view_get_cursor_column(int treeView);

	/**
	 * TODO: gtk_tree_view_get_cursor ()
	 */

	/**
	 * Activates the cell determined by path and column.
	 * @param path The TreePath to be activated.
	 * @param column The TreeViewColumn to be activated.
	 */
	public void activateCell(TreePath path, TreeViewColumn column) {
		gtk_tree_view_row_activated(handle, path.getHandle(), column.getHandle());
	}

	/**
	 * Recursively expands all nodes
	 */
	public void expandAll() {
		gtk_tree_view_expand_all(handle);
	}

	/**
	 * Recursively collapses all visible, expanded nodes.
	 */
	public void collapseAll() {
		gtk_tree_view_collapse_all(handle);
	}

	/**
	 * Opens the row so its children are visible.
	 * @param path Path to a row
	 * @param openAll Whether to recursively expand, or just expand immediate 
	 * children
	 * @return TRUE if the row existed and had children
	 */
	public boolean expandRow(TreePath path, boolean openAll) {
		return gtk_tree_view_expand_row(handle, path.getHandle(), openAll);
	}

	/**
	 * Collapses a row (hides its child rows, if they exist).
	 * @param path Path to a row in the view
	 * @return TRUE if the row was collapsed.
	 */
	public boolean collapseRow(TreePath path) {
		return gtk_tree_view_collapse_row(handle, path.getHandle());
	}

	/**
	 * TODO: map_expanded_rows
	 */

	/**
	 * Returns TRUE if the node pointed to by path is expanded.
	 * @param path A TreePath to test expansion state.
	 * @return TRUE if path is expanded.
	 */
	public boolean getRowExpanded(TreePath path) {
		return gtk_tree_view_row_expanded(handle, path.getHandle());
	}

	/**
	 * This function is a convenience function to allow you to reorder models 
	 * that support the DragSourceIface and the DragDestIface. Both 
	 * {@link TreeStore} and {@link ListStore} support these. If reorderable 
	 * is TRUE, then the user can reorder the model by dragging and dropping 
	 * rows. The developer can listen to these changes by adding listeners.
	 *
	 * <p>This function does not give you any degree of control over the order 
	 * -- any reorderering is allowed. If more control is needed, you should 
	 *  probably handle drag and drop manually.
	 *
	 * @param reorderable TRUE, if the tree can be reordered.
	 */
	public void setReorderable(boolean reorderable) {
		gtk_tree_view_set_reorderable(handle, reorderable);
	}
	
	/**
	 * Sets the model for a GtkTreeView. 
	 * If the {@link TreeView} already has a model set, 
	 * it will remove it before setting the new model. 
	 * If model is NULL, then it will unset the old model.
	 *
	 * @param model the new model for the {@link TreeView}
	 */
	public void setModel(TreeModel model) {
			gtk_tree_view_set_model(handle, model.getHandle());
	}


	/**
	 * Resizes all columns to their optimal width. Only works after the treeview has been realized.
	 */
	public void autoSizeColumns(){
		// todo gtk_tree_view_columns_autosize( handle );
		throw new RuntimeException( "Not yet implemented" );
	}
	  
	 
	/**
	 * Returns an array of all the columns currently in the view
	 */
	public TreeViewColumn[] getColumns(){
		// todo
		// GList*      gtk_tree_view_get_columns       (GtkTreeView *tree_view);
//
//Returns a GList of all the GtkTreeViewColumn s currently in tree_view. The returned list must be freed with g_list_free().
//
//tree_view :	A GtkTreeView
//Returns :	A list of GtkTreeViewColumn s
		throw new RuntimeException( "Not yet implemented" );
	}

	/**
	 * Sets the current keyboard focus to be at path, and selects it. This is 
	 * useful when you want to focus the user's attention on a particular 
	 * row. If column is specified, and 
	 * startEditing is TRUE, then editing should be started in the specified 
	 * cell. If focusCell is also specified, the particular cellRenderer in that
	 * column will get focusThis function is often followed by {@link
	 * Widget#grabFocus()} in order to give keyboard focus to the widget. Please
	 * note that editing can only happen when the widget is realized.
	 *
	 * @since 2.2
	 * 
	 * @param path A TreePath
	 * @param focusColumn A TreeViewColumn, or NULL
	 * @param focusCell A cellrenderer, or null
	 * @param startEditing TRUE if the specified cell should start being edited.
	 */
	public void setCursor(TreePath path, TreeViewColumn focusColumn, CellRenderer focusCell, boolean startEditing) {
		//gtk_tree_view_set_cursor_on_cell(handle, path.getHandle(), focusColumn.getHandle(), focusCell.getHandle(), startEditing);
		throw new RuntimeException( "Not yet implemented" );
	}

	/**
	 * Expands the row at path. This will also expand all parent rows of path as necessary.
	 *
	 * @since 2.2
	 *
	 * @param path path to a row
	 */
	public void expandToPath( TreePath path ){
		// todo void        gtk_tree_view_expand_to_path    (GtkTreeView *tree_view,
       //                                      GtkTreePath *path);
	   throw new RuntimeException( "Not yet implemented" );
	}

	
	
	/**
	 * Sets ab object implementing {@link TreeViewColumnDrop} which will check
	 * if columns may be dropped in each position.
	 */
	public void setColumnDragChecker( TreeViewColumnDrop checker ){
		// todo. based on gtk_tree_view_set_column_drag_function
		 throw new RuntimeException( "Not yet implemented" );
	}


		
	/**
	 * Does anyone want this type of functionality?
	 * todo: gtk_tree_view_enable_model_drag_dest ()
	 * todo: gtk_tree_view_enable_model_drag_source ()
	 * gtk_tree_view_unset_rows_drag_source ()
	 * gtk_tree_view_unset_rows_drag_dest ()
	 * gtk_tree_view_set_drag_dest_row ()
	 * gtk_tree_view_get_drag_dest_row ()
	 * gtk_tree_view_get_dest_row_at_pos ()
	 * 
	 */

	/**
	 * If enable search is set, then the user can type in text to search through
	 * the tree interactively.
	 * @param enableSearch TRUE, if the user can search interactively
	 */
	public void setEnableSearch(boolean enableSearch) {
		gtk_tree_view_set_enable_search(handle, enableSearch);
	}

	/**
	 * Sets column as the column where the interactive search code should 
	 * search in. Additionally, turns on interactive searching.
	 * @param column The column to search in
	 */
	public void setSearchColumn(TreeViewColumn column) {
		gtk_tree_view_set_search_column(handle, column.getHandle());
	}

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_tree_view_get_type());
	}

	/****************************************
	 * BEGINNING OF GENERATED CODE
	 ****************************************/
	native static final protected int gtk_tree_view_get_type();
	native static final protected int gtk_tree_view_new();
	native static final protected int gtk_tree_view_new_with_model(int model);
	native static final protected int gtk_tree_view_get_model(int treeView);
	native static final protected void gtk_tree_view_set_model(int treeView, int model);
	native static final protected int gtk_tree_view_get_selection(int treeView);
	native static final protected int gtk_tree_view_get_hadjustment(int treeView);
	native static final protected void gtk_tree_view_set_hadjustment(int treeView, int adjustment);
	native static final protected int gtk_tree_view_get_vadjustment(int treeView);
	native static final protected void gtk_tree_view_set_vadjustment(int treeView, int adjustment);
	native static final protected boolean gtk_tree_view_get_headers_visible(int treeView);
	native static final protected void gtk_tree_view_set_headers_visible(int treeView, boolean headersVisible);
	native static final protected void gtk_tree_view_set_headers_clickable(int treeView, boolean setting);
	native static final protected void gtk_tree_view_set_rules_hint(int treeView, boolean setting);
	native static final protected boolean gtk_tree_view_get_rules_hint(int treeView);
	native static final protected int gtk_tree_view_append_column(int treeView, int column);
	native static final protected int gtk_tree_view_remove_column(int treeView, int column);
	native static final protected int gtk_tree_view_insert_column(int treeView, int column, int position);
	native static final protected int gtk_tree_view_get_column(int treeView, int n);
	native static final protected int gtk_tree_view_get_columns(int treeView);
	native static final protected void gtk_tree_view_move_column_after(int treeView, int column, int baseColumn);
	native static final protected void gtk_tree_view_set_expander_column(int treeView, int column);
	native static final protected int gtk_tree_view_get_expander_column(int treeView);
	native static final protected void gtk_tree_view_scroll_to_point(int treeView, int treeX, int treeY);
	native static final protected void gtk_tree_view_scroll_to_cell(
		int treeView,
		int path,
		int column,
		boolean useAlign,
		double rowAlign,
		double colAlign);
	native static final protected void gtk_tree_view_row_activated(int treeView, int path, int column);
	native static final protected void gtk_tree_view_expand_all(int treeView);
	native static final protected void gtk_tree_view_collapse_all(int treeView);
	native static final protected boolean gtk_tree_view_expand_row(int treeView, int path, boolean openAll);
	native static final protected boolean gtk_tree_view_collapse_row(int treeView, int path);
	native static final protected boolean gtk_tree_view_row_expanded(int treeView, int path);
	native static final protected void gtk_tree_view_set_reorderable(int treeView, boolean reorderable);
	native static final protected boolean gtk_tree_view_get_reorderable(int treeView);
	native static final protected void gtk_tree_view_set_cursor(int treeView, int path, int focusColumn, boolean startEditing);
	native static final protected void gtk_tree_view_get_cursor(int treeView, int path, int focusColumn);
	native static final protected int gtk_tree_view_get_bin_window(int treeView);
	native static final protected boolean gtk_tree_view_get_path_at_pos(
		int treeView,
		int x,
		int y,
		int[] path,
		int[] column,
		int[] cellX,
		int[] cellY);
	native static final protected void gtk_tree_view_get_cell_area(int treeView, int path, int column, int rect);
	native static final protected void gtk_tree_view_get_background_area(int treeView, int path, int column, int rect);
	native static final protected void gtk_tree_view_get_visible_rect(int treeView, int visibleRect);
	native static final protected void gtk_tree_view_widget_to_tree_coords(int treeView, int wx, int wy, int[] tx, int[] ty);
	native static final protected void gtk_tree_view_tree_to_widget_coords(int treeView, int tx, int ty, int[] wx, int[] wy);
	native static final protected void gtk_tree_view_unset_rows_drag_source(int treeView);
	native static final protected void gtk_tree_view_unset_rows_drag_dest(int treeView);
	native static final protected int gtk_tree_view_create_row_drag_icon(int treeView, int path);
	native static final protected void gtk_tree_view_set_enable_search(int treeView, boolean enableSearch);
	native static final protected boolean gtk_tree_view_get_enable_search(int treeView);
	native static final protected int gtk_tree_view_get_search_column(int treeView);
	native static final protected void gtk_tree_view_set_search_column(int treeView, int column);
	/****************************************
	 * END OF GENERATED CODE
	 ****************************************/
}
