/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-02 09:30:38 EDT
 */

package org.gnu.gtk;
import org.gnu.glib.GObject;
import org.gnu.glib.Type;
/**
 * See {@link TextView} description for an overview of the related objects. 
 */
public class TextTagTable extends GObject 
{
	 protected TextTagTable(int handle){
		 this.handle = handle;
	 }

	 /**
	  * Constructs a new table, containing no tags
	  */
	 public TextTagTable(){
		 handle = gtk_text_tag_table_new ();
	}

	/**
	 * Add a tag to the table. The tag is assigned the highest priority in the
	 * table.
	 *
	 * <p>tag must not be in a tag table already, and may not have the same name
	 * as an already-added tag.
	 */
	 public void add(TextTag tag){
		 gtk_text_tag_table_add(handle, tag.getHandle());
	 }

	 /**
	  * Remove a tag from the table. 
	  */
	 public void remove(TextTag tag){
		 gtk_text_tag_table_remove(handle, tag.getHandle());
	 }

	 /**
	  * Look up a named tag.
	  * @param name name of a tag
	  * @return The tag, or <code>null</code> if no tag exists by that name.
	  */
	 public TextTag lookup(String name){
	     int tagHandle = gtk_text_tag_table_lookup(handle, name);
	     return (tagHandle != 0) ? new TextTag(tagHandle) : null;
	 }
	
	 /**
	  * Returns the size of the table (number of tags)
	  */
	 public int getSize(){
		 return gtk_text_tag_table_get_size(handle);
	 }

	 /* 
	  * TODO:
	  * - foreach function
	  * - signals: tag-added   tag-changed   tag-removed
	  */
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_text_tag_table_get_type());
	}

    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int gtk_text_tag_table_get_type ();
    native static final protected int gtk_text_tag_table_new ();
    native static final protected void gtk_text_tag_table_add (int table, int tag);
    native static final protected void gtk_text_tag_table_remove (int table, int tag);
    native static final protected int gtk_text_tag_table_lookup (int table, String name);
    native static final protected int gtk_text_tag_table_get_size (int table);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

