/* 
 * LibGTcpSocket: libgtcpsocket/gtcp-socket-types.h
 *
 * Copyright (C) 2002 James M. Cape
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

/*

GLib 2.0 DNS lookup backend.

Notes on editing:
	Tab size: 4
*/

#ifndef __GTCP_SOCKET_TYPES_H__
#define __GTCP_SOCKET_TYPES_H__

#include <glib.h>

G_BEGIN_DECLS


typedef enum					/*< prefix=GTCP_LOOKUP > */
{
	GTCP_LOOKUP_IN_PROGRESS = -1,

	GTCP_LOOKUP_OK = 0,

	GTCP_LOOKUP_ERROR_NOT_FOUND,
	GTCP_LOOKUP_ERROR_NO_RECOVERY,
	GTCP_LOOKUP_ERROR_TRY_AGAIN,
	GTCP_LOOKUP_ERROR_IPV4_IPV6_MISMATCH,
	GTCP_LOOKUP_ERROR_THREAD_ERROR
}
GTcpLookupStatus;


typedef enum					/*< prefix=GTCP_CONNECTION > */
{
	GTCP_CONNECTION_ERROR_CONNECTION_REFUSED,
	GTCP_CONNECTION_ERROR_TIMEOUT,
	GTCP_CONNECTION_ERROR_NETWORK_UNREACHABLE,
	GTCP_CONNECTION_ERROR_BAD_BROADCAST_OR_FIREWALL,
	GTCP_CONNECTION_ERROR_INTERNAL,
	GTCP_CONNECTION_ERROR_THREAD_ERROR,
	GTCP_CONNECTION_ERROR_PROXY_ERROR,
	GTCP_CONNECTION_CLOSING,
	GTCP_CONNECTION_CLOSED,

	GTCP_CONNECTION_CONNECTED,
	GTCP_CONNECTION_CONNECTING
}
GTcpConnectionStatus;


typedef enum					/*< prefix=GTCP_CONNECTION > */
{
	GTCP_CONNECTION_HTTP,
	GTCP_CONNECTION_FTP,
	GTCP_CONNECTION_OTHER
}
GTcpConnectionStyle;


typedef enum					/* < prefix=GTCP_PROXY > */
{
	GTCP_PROXY_HTTP = GTCP_CONNECTION_HTTP,
	GTCP_PROXY_FTP = GTCP_CONNECTION_FTP,
	GTCP_PROXY_OTHER = GTCP_CONNECTION_OTHER,

	GTCP_PROXY_SSL,
	GTCP_PROXY_SOCKS4,
	GTCP_PROXY_SOCKS5
}
GTcpProxyType;


typedef enum					/*< prefix=GTCP_SEND > */
{
	GTCP_SEND_DATA_QUEUED,
	GTCP_SEND_ERROR,
	GTCP_SEND_ERROR_NOT_OPEN,
	GTCP_SEND_ERROR_NULL_DATA
}
GTcpSendStatus;


typedef enum					/*< prefix=GTCP_SERVER > */
{
	GTCP_SERVER_LEAVE_OPEN,
	GTCP_SERVER_KILL_ON_CLOSE,
	GTCP_SERVER_KILL_ON_FINALIZE,
	GTCP_SERVER_FINALIZE_ON_CLOSE,
	GTCP_SERVER_FINALIZE_ON_FINALIZE
}
GTcpServerKillStyle;


typedef enum					/* < prefix=GTCP_SERVER_OPEN > */
{
	GTCP_SERVER_OPEN_OK,
	GTCP_SERVER_OPEN_OPENING,

	GTCP_SERVER_OPEN_ERROR_NO_LOCAL_HOSTNAME,

	GTCP_SERVER_OPEN_ERROR_SOCKET_TYPE_PERMS,
	GTCP_SERVER_OPEN_ERROR_NO_MEM,
	GTCP_SERVER_OPEN_ERROR_TABLE_OVERFLOW,

	GTCP_SERVER_OPEN_ERROR_LOW_PORT_PERMS,
	GTCP_SERVER_OPEN_ERROR_ALREADY_BOUND,

	GTCP_SERVER_OPEN_ERROR_INTERNAL_ERROR
}
GTcpServerOpenStatus;


G_END_DECLS

#endif /* __GTCP_SOCKET_TYPES__ */
