#include "config.h"
#include <cups/cups.h>
#include "gnome-cups-init.h"
#include "gnome-cups-printer.h"

/* Should be per thread with push/pop/user_data etc. (clearly) */
static GnomeCupsAuthFunction global_auth = NULL;

static const char *
cups_password_cb (const char *prompt)
{
	static char *hazard = NULL;

	g_free (hazard);
	hazard = NULL;

	if (global_auth) {
		char *password = NULL;
		char *username = g_strdup (g_get_user_name ());

		if (global_auth (prompt, &username, &password, NULL)) {

			if (username) {
				cupsSetUser (username);
			} else {
				cupsSetUser (g_get_user_name ());
			}
			hazard = password;
		}
		g_free (username);

	} else {
		g_warning ("Cannot prompt for password: '%s'", prompt);
	}

	return hazard;
}

void
gnome_cups_init (GnomeCupsAuthFunction opt_auth_fn)
{
	g_type_init ();

	global_auth = opt_auth_fn;
	cupsSetPasswordCB (cups_password_cb);

	_gnome_cups_printer_init ();
}

