/* $Id: unicode_info.h,v 1.11 2003/03/29 21:24:51 nlevitt Exp $ */
/*
 * Copyright (c) 2002  Noah Levitt <nlevitt@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */


#ifndef UNICODE_INFO_H
#define UNICODE_INFO_H

#include <gtk/gtk.h>


G_BEGIN_DECLS


#ifndef UNICHAR_MAX
# define UNICHAR_MAX 0x0000ffff
#endif


typedef struct
{
  gunichar start;
  gunichar end;
  const gchar *name;
}
UnicodeBlock;

extern const UnicodeBlock unicode_blocks[];

gint count_blocks (gunichar max);


/* return values are read-only */
G_CONST_RETURN gchar * get_unicode_name (gunichar uc);
G_CONST_RETURN gchar * get_unicode_data_name (gunichar uc);
G_CONST_RETURN gchar * get_unicode_category_name (gunichar uc);
G_CONST_RETURN gchar * get_unicode_kDefinition (gunichar uc);
G_CONST_RETURN gchar * get_unicode_kCantonese (gunichar uc);
G_CONST_RETURN gchar * get_unicode_kMandarin (gunichar uc);
G_CONST_RETURN gchar * get_unicode_kTang (gunichar uc);
G_CONST_RETURN gchar * get_unicode_kKorean (gunichar uc);
G_CONST_RETURN gchar * get_unicode_kJapaneseKun (gunichar uc);
G_CONST_RETURN gchar * get_unicode_kJapaneseOn (gunichar uc);
G_CONST_RETURN gchar * get_hangul_syllable_name (gunichar s);

/* A wrapper for g_unicode_canonical_decomposition that also does hangul
 * decomposition. 
 * See http://bugzilla.gnome.org/show_bug.cgi?id=100456
 * Will no longer be necessary once my patch is accepted.
 */
gunichar * unicode_canonical_decomposition (gunichar ch, gsize *result_len);

/* starts search at start */
gunichar find_substring_match (gunichar start, 
                               const gchar *search_text, 
                               gint direction);

/* nameslist stuff */
G_CONST_RETURN gchar ** get_nameslist_stars (gunichar uc);
G_CONST_RETURN gchar ** get_nameslist_equals (gunichar uc);
gunichar * get_nameslist_exes (gunichar uc);
G_CONST_RETURN gchar ** get_nameslist_pounds (gunichar uc);
G_CONST_RETURN gchar ** get_nameslist_colons (gunichar uc);
gboolean unichar_validate (gunichar ch);
gint unichar_to_printable_utf8 (gunichar uc, gchar *outbuf);
GUnicodeType unichar_type (gunichar uc);
gboolean unichar_isdefined (gunichar uc);
gboolean unichar_isgraph (gunichar c);

G_END_DECLS

#endif  /* #ifndef UNICODE_INFO_H */

