#include <stdio.h>
#include <sys/time.h>

#include "fromtop.h"

void
sprint_time (char *s, time_t ti, unsigned long hz)
{
	time_t t = ti / hz;
	time_t centi_sec = (ti % 100) * 100 / 100;

	if (t < 0)                            /* time overflow */
		sprintf(s, ">>d");
	else if (t >= 48*60*60)               /* > 2 days */
		sprintf(s, "%5lud", t/(24*60*60));
	else if (t >= 60*60)                  /* > 1 hour */
		sprintf(s, "%2lu:%02uh", t/(60*60), (unsigned) ((t/60)%60));
	else if (t > 60)                      /* > 1 minute */
		sprintf(s, "%2lu:%02um", t/60, (unsigned) t%60);
	else
		sprintf(s, "%2lu.%02lus", t, centi_sec);
}

/*
 * Finds the current time (in microseconds) and calculates the time
 * elapsed since the last update. This is essential for computing
 * percent CPU usage.
 */
float get_elapsed_time(void)
{
    struct timeval time;
    struct timezone timez;
    static double oldtime = 0.0;
    float elapsed_time;
    double newtime;

    gettimeofday (&time, &timez);

    newtime = ((double) time.tv_sec) + ((double) time.tv_usec / 1000000.0);

    elapsed_time = (float) (newtime - oldtime);
    oldtime = newtime;

    return elapsed_time;
}

char * status(proc_t* task) {
    static char buf[4] = "   ";

    buf[0] = task->state;
    if (task->rss == 0 && task->state != 'Z')
        buf[1] = 'W';
    else
        buf[1] = ' ';
    if (task->nice < 0)
	buf[2] = '<';
    else if (task->nice > 0)
	buf[2] = 'N';
    else
	buf[2] = ' ';

    return(buf);
}
