/*
 *  Copyright (C) 1999, 2000 Bruno Pires Marinho
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <gnome.h>
#include <glib.h>
#include "gtm.h"
#include "file-data.h"
#include "dialogs.h"
#include "finish.xpm"
#include "run.xpm"
#include "stop.xpm"

#define NUM_COLS 5
#define NUM_ROWS 6


typedef struct
{
    GtkWidget *dlg;
    /* data labels */
    GtkWidget *num_stopped;
    GtkWidget *num_running;
    GtkWidget *num_completed;
    GtkWidget *num_total;

    GtkWidget *size_stopped;
    GtkWidget *size_running;
    GtkWidget *size_completed;
    GtkWidget *size_total;
    
    GtkWidget *retrieved_stopped;
    GtkWidget *retrieved_running;
    GtkWidget *retrieved_completed;
    GtkWidget *retrieved_total;

    GtkWidget *remain_stopped;
    GtkWidget *remain_running;
    GtkWidget *remain_total;

    GtkWidget *percent_stopped;
    GtkWidget *percent_running;
    GtkWidget *percent_total;
} SummaryData;

static SummaryData *stats_data = NULL;

static void 
ok_cb (GnomeDialog *dialog, gint arg1, gpointer ignored)
{
    gtk_widget_hide_all (stats_data->dlg);
}

static void 
close_cb (GnomeDialog *dialog, gpointer ignored)
{
    gtk_widget_hide_all (stats_data->dlg);
}

/* create an aligned label */
static GtkWidget*
dialog_stats_create_label ()
{
    GtkWidget *label;
    label = gtk_label_new("");
    gtk_misc_set_alignment (GTK_MISC (label), 1, 0.5);
    return label;
}

static void
dialog_stats_create_data ()
{
    GtkWidget *table, *label;
    GtkTable *t;
    static GdkPixmap *pm_stop = NULL, *pm_run = NULL, *pm_finish = NULL;
    static GdkBitmap *pm_stop_mask = NULL, *pm_run_mask = NULL,
        *pm_finish_mask = NULL;

    stats_data = g_new (SummaryData, 1);
    stats_data->dlg = 
        gnome_dialog_new (_ ("List summary"), GNOME_STOCK_BUTTON_CLOSE, NULL);
    
    stats_data->num_stopped = dialog_stats_create_label();
    stats_data->num_running = dialog_stats_create_label();
    stats_data->num_completed = dialog_stats_create_label();
    stats_data->num_total = dialog_stats_create_label();

    stats_data->size_stopped = dialog_stats_create_label();
    stats_data->size_running = dialog_stats_create_label();
    stats_data->size_completed = dialog_stats_create_label();
    stats_data->size_total = dialog_stats_create_label();
 
    stats_data->retrieved_stopped = dialog_stats_create_label();
    stats_data->retrieved_running = dialog_stats_create_label();
    stats_data->retrieved_completed = dialog_stats_create_label();
    stats_data->retrieved_total = dialog_stats_create_label();

    stats_data->remain_stopped = dialog_stats_create_label();
    stats_data->remain_running = dialog_stats_create_label();
    stats_data->remain_total = dialog_stats_create_label();

    stats_data->percent_stopped = dialog_stats_create_label();
    stats_data->percent_running = dialog_stats_create_label();
    stats_data->percent_total = dialog_stats_create_label();
    
    table = gtk_table_new (NUM_ROWS, NUM_COLS, FALSE);
    t = (GTK_TABLE (table));

    gtk_table_set_col_spacings (t, 15);

    /* column headers */
    gdk_imlib_data_to_pixmap (stop_xpm, &pm_stop, &pm_stop_mask);
    gtk_table_attach_defaults (t, gtk_pixmap_new (pm_stop, pm_stop_mask),
                               1, 2, 0, 1);
    gdk_imlib_data_to_pixmap (run_xpm, &pm_run, &pm_run_mask);
    gtk_table_attach_defaults (t, gtk_pixmap_new(pm_run, pm_run_mask), 
                               2, 3, 0, 1);
    gdk_imlib_data_to_pixmap (finish_xpm, &pm_finish, &pm_finish_mask);
    gtk_table_attach_defaults (t, gtk_pixmap_new (pm_finish, pm_finish_mask), 
                               3, 4, 0, 1);
    gtk_table_attach_defaults (t, gtk_label_new (_ ("Total")), 
                               4, 5, 0, 1);

    /* row labels */
    label = gtk_label_new (_ ("Number of files"));
    gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
    gtk_table_attach_defaults(t, label, 0, 1, 1, 2);
    label = gtk_label_new (_ ("Total size (kb)"));
    gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
    gtk_table_attach_defaults(t, label, 0, 1, 2, 3);
    label = gtk_label_new (_ ("Retrieved (kb)"));
    gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
    gtk_table_attach_defaults (t, label, 0, 1, 3, 4);
    label = gtk_label_new (_ ("Remaining (kb)"));
    gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
    gtk_table_attach_defaults (t, label, 0, 1, 4, 5);
    label = gtk_label_new (_ ("Progress"));
    gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
    gtk_table_attach_defaults (t, label, 0, 1, 5, 6);

    /* row: number of files */
    gtk_table_attach_defaults (t, stats_data->num_stopped,       1, 2, 1, 2);
    gtk_table_attach_defaults (t, stats_data->num_running,       2, 3, 1, 2);
    gtk_table_attach_defaults (t, stats_data->num_completed,     3, 4, 1, 2);
    gtk_table_attach_defaults (t, stats_data->num_total,         4, 5, 1, 2);
    
    /* row: total size */
    gtk_table_attach (t, stats_data->size_stopped,      1, 2, 2, 3,
                      GTK_EXPAND|GTK_FILL, 0, 0, 0);
    gtk_table_attach (t, stats_data->size_running,      2, 3, 2, 3,
                      GTK_EXPAND|GTK_FILL, 0, 0, 0);
    gtk_table_attach (t, stats_data->size_completed,    3, 4, 2, 3,
                      GTK_EXPAND|GTK_FILL, 0, 0, 0);
    gtk_table_attach (t, stats_data->size_total,        4, 5, 2, 3,
                      GTK_EXPAND|GTK_FILL, 0, 0, 0);
    
    /* row: retrieved */
    gtk_table_attach (t, stats_data->retrieved_stopped, 1, 2, 3, 4,
                      GTK_EXPAND|GTK_FILL, 0, 0, 0);
    gtk_table_attach (t, stats_data->retrieved_running, 2, 3, 3, 4,
                      GTK_EXPAND|GTK_FILL, 0, 0, 0);
    gtk_table_attach (t, stats_data->retrieved_completed, 3, 4, 3, 4,
                      GTK_EXPAND|GTK_FILL, 0, 0, 0);
    gtk_table_attach (t, stats_data->retrieved_total,   4, 5, 3, 4,
                      GTK_EXPAND|GTK_FILL, 0, 0, 0);

    /* row: remaining */
    gtk_table_attach (t, stats_data->remain_stopped, 1, 2, 4, 5,
                      GTK_EXPAND|GTK_FILL, 0, 0, 0);
    gtk_table_attach (t, stats_data->remain_running, 2, 3, 4, 5,
                      GTK_EXPAND|GTK_FILL, 0, 0, 0);
    gtk_table_attach (t, stats_data->remain_total,   4, 5, 4, 5,
                      GTK_EXPAND|GTK_FILL, 0, 0, 0);
    
    /* row: percent progress */
    gtk_table_attach_defaults (t, stats_data->percent_stopped, 1, 2, 5, 6);
    gtk_table_attach_defaults (t, stats_data->percent_running, 2, 3, 5, 6);
    gtk_table_attach_defaults (t, stats_data->percent_total,   4, 5, 5, 6);

    gtk_box_pack_start (GTK_BOX (GNOME_DIALOG (stats_data->dlg)->vbox),
                        table, FALSE, FALSE, 0);

    /* signal handlers */
    gnome_dialog_button_connect (GNOME_DIALOG (stats_data->dlg), GNOME_OK,
                                 GTK_SIGNAL_FUNC (ok_cb),
                                 NULL);
    gtk_signal_connect (GTK_OBJECT (stats_data->dlg),
                        "close",
                        GTK_SIGNAL_FUNC (close_cb),
                        NULL);
}

void
dialog_stats_show ()
{
    /* create window if it does not already exist */
    if (stats_data == NULL)
        dialog_stats_create_data();

    gtk_widget_show_all (stats_data->dlg);
    gdk_window_raise (GTK_WIDGET (GNOME_DIALOG (stats_data->dlg))->window);
}

static gchar*
dialog_stats_display_size (guint bytes)
{
    /* currently just displays in kb but might be nice to use "df -h" style */
    static gchar buffer[20];
    sprintf (buffer, "%d", (bytes+512)/1024);
    return buffer;
}

static gchar*
dialog_stats_display_percent (guint32 num, guint32 denom) 
{
    static gchar buffer[20];
    sprintf(buffer, "%.1f%%", denom==0?0:((gfloat)num*100)/(gfloat)denom);
    return buffer;
}

void
dialog_stats_update (FileListStats *stats)
{
    guint total_size, total_retrieved;
    static gchar buffer[20];

    if (stats_data == NULL)
        dialog_stats_create_data();

    /* row: num files */
    sprintf(buffer, "%d", stats->num_stopped);
    gtk_label_set_text (GTK_LABEL (stats_data->num_stopped), buffer);
    sprintf(buffer, "%d", stats->num_running);
    gtk_label_set_text (GTK_LABEL (stats_data->num_running), buffer);
    sprintf(buffer, "%d", stats->num_completed);
    gtk_label_set_text (GTK_LABEL (stats_data->num_completed), buffer);
    sprintf(buffer, "%d", 
            stats->num_stopped + stats->num_running + stats->num_completed);
    gtk_label_set_text (GTK_LABEL (stats_data->num_total), buffer);

    /* row: size */
    gtk_label_set_text (GTK_LABEL (stats_data->size_stopped),
                        dialog_stats_display_size(stats->size_stopped));
    gtk_label_set_text (GTK_LABEL (stats_data->size_running),
                        dialog_stats_display_size(stats->size_running));
    gtk_label_set_text (GTK_LABEL (stats_data->size_completed),
                        dialog_stats_display_size(stats->size_completed));
    total_size = 
        stats->size_stopped + stats->size_running + stats->size_completed;
    gtk_label_set_text (GTK_LABEL (stats_data->size_total),
                        dialog_stats_display_size(total_size));

    /* row: retrieved */
    gtk_label_set_text (GTK_LABEL (stats_data->retrieved_stopped),
                        dialog_stats_display_size(stats->retrieved_stopped));
    gtk_label_set_text (GTK_LABEL (stats_data->retrieved_running),
                        dialog_stats_display_size(stats->retrieved_running));
    gtk_label_set_text (GTK_LABEL (stats_data->retrieved_completed),
                        dialog_stats_display_size(stats->size_completed));
    total_retrieved = 
        stats->retrieved_stopped + stats->retrieved_running +
        stats->size_completed; /* retrieved_completed == size_completed */
    gtk_label_set_text (GTK_LABEL (stats_data->retrieved_total),
                        dialog_stats_display_size(total_retrieved));

    /* row: remaining */
    gtk_label_set_text (GTK_LABEL (stats_data->remain_stopped),
                        dialog_stats_display_size(stats->size_stopped -
                                                  stats->retrieved_stopped));
    gtk_label_set_text (GTK_LABEL (stats_data->remain_running),
                        dialog_stats_display_size(stats->size_running -
                                                  stats->retrieved_running));
    gtk_label_set_text (GTK_LABEL (stats_data->remain_total),
                        dialog_stats_display_size(stats->size_stopped +
                                                  stats->size_running -
                                                  stats->retrieved_stopped -
                                                  stats->retrieved_running));

    /* row: percent progress */
    gtk_label_set_text 
        (GTK_LABEL (stats_data->percent_stopped),
         dialog_stats_display_percent(stats->retrieved_stopped,
                                      stats->size_stopped));
    gtk_label_set_text 
        (GTK_LABEL (stats_data->percent_running),
         dialog_stats_display_percent(stats->retrieved_running,
                                      stats->size_running));
    gtk_label_set_text
        (GTK_LABEL (stats_data->percent_total),
         dialog_stats_display_percent(total_retrieved, total_size));
    
}
