// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_CAPS_H
#define _GSTREAMERMM_CAPS_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gstcaps.h>
#include <gstreamermm/structure.h>


namespace Gst
{

struct Structure;

/** Gst::Caps — A structure describing sets of media formats.
 * Gst::Caps (capabilities) are lighweight refcounted objects describing media
 * types. They are composed of an array of Gst::Structure.
 *
 * Gst::Caps are exposed on Gst::PadTemplate to describe all possible types a
 * given pad can handle. They are also stored in the Gst::Registry along with a
 * description of the Gst::Element.
 *
 * Gst::Caps are exposed on the element pads using the Gst::Pad::get_caps()
 * method.  This method describes the possible types that the pad can handle or
 * produce at runtime.
 *
 * Gst::Caps are also attached to buffers to describe to content of the data
 * pointed to by the buffer with Gst::Buffer::set_caps(). Gst::Caps attached to
 * a Gst::Buffer allow for format negotiation upstream and downstream.
 *
 * A Gst::Caps can be constructed with the following code fragment:
 *
 * TODO: Insert C++ translated code fragment from C API docs
 */
class Caps 
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Caps CppObjectType;
  typedef GstCaps BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  static Glib::RefPtr<Caps> create();

  // For use with Glib::RefPtr<> only.
  void reference()   const;
  void unreference() const;

  ///Provides access to the underlying C instance.
  GstCaps*       gobj();

  ///Provides access to the underlying C instance.
  const GstCaps* gobj() const;

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstCaps* gobj_copy() const;

protected:
  // Do not derive this.  Gst::Caps can neither be constructed nor deleted.
  Caps();
  void operator delete(void*, size_t);

private:
  // noncopyable
  Caps(const Caps&);
  Caps& operator=(const Caps&);


public:
  /** Creates a new Gst::Caps that indicates that it is compatible with any
   * media format.
   *
   * @return the new Gst::Caps
   */
  static Glib::RefPtr<Caps> create_any();

  /** Creates a new Gst::Caps that contains one Gst::Structure.
   *
   * @param media_type the media type of the structure
   * @return the new Gst::Caps
   */
  static Glib::RefPtr<Caps> create_simple(const Glib::ustring& media_type);

  /** Creates a new Gst::Caps and adds the first Gst::Structure given. The
   * structure is not copied; the returned Gst::Caps owns the structure.
   *
   * @param first_struct the first structure to add
   * @return Returns the new Gst::Caps
   */
  static Glib::RefPtr<Caps> create(Structure& first_struct);

  
  /** Creates a new Gst::Caps as a copy of the old @a caps. The new caps will have a
   * refcount of 1, owned by the caller. The structures are copied as well.
   * 
   * Note that this function is the semantic equivalent of a gst_caps_ref()
   * followed by a gst_caps_make_writable(). If you only want to hold on to a
   * reference to the data, you should use gst_caps_ref().
   * 
   * When you are finished with the caps, call gst_caps_unref() on it.
   * @return The new Gst::Caps.
   */
  Glib::RefPtr<Caps> copy() const;
  
  /** Creates a new Gst::Caps and appends a copy of the nth structure
   * contained in @a caps.
   * @param nth The nth structure to copy.
   * @return The new Gst::Caps.
   */
  Glib::RefPtr<Caps> copy_nth(guint nth);
  
  /** Appends the structures contained in @a caps2 to @a caps1. The structures in
   *  @a caps2 are not copied -- they are transferred to @a caps1, and then @a caps2 is
   * freed. If either caps is ANY, the resulting caps will be ANY.
   * @param caps2 The Gst::Caps to append.
   */
  void append(const Glib::RefPtr<Caps>& caps);
  
  /** Appends the structures contained in @a caps2 to @a caps1 if they are not yet
   * expressed by @a caps1. The structures in @a caps2 are not copied -- they are
   * transferred to @a caps1, and then @a caps2 is freed.
   * If either caps is ANY, the resulting caps will be ANY.
   * 
   * Since: 0.10.10
   * @param caps2 The Gst::Caps to merge in.
   */
  void merge(const Glib::RefPtr<Caps>& caps);

  /** Appends structure to caps. The structure is not copied; caps becomes the
   * owner of structure.
   *
   * @param structure the Gst::Structure to append
   */
  void append_structure(Structure& structure);

  /** Appends structure to caps if its not already expressed by caps. The
   * structure is not copied; caps becomes the owner of structure.
   *
   * @param structure the Gst::Structure to merge
   */
  void merge_structure(Structure& structure);

  /** Finds the structure in caps that has the index idx, and returns it.
   *
   * @param index the index of the structure
   * @return the Gst::Structure corresponding to index
   */
  const Structure* get_structure(guint idx) const;

  
  /** removes the stucture with the given index from the list of structures
   * contained in @a caps.
   * @param idx Index of the structure to remove.
   */
  void remove_structure(guint idx);
  
  /** Gets the number of structures contained in @a caps.
   * @return The number of structures that @a caps contains.
   */
  guint size() const;

  /** Sets a fields in a simple Gst::Caps. A simple Gst::Caps is one that only
   * has one structure.
   *
   * @param field field to set
   * @param value the value which the field should be set to
   */
  void set_simple(const Glib::ustring& name, const Glib::ValueBase& value);

  
  /** Sets fields in a simple Gst::Caps.  A simple Gst::Caps is one that
   * only has one structure.  The arguments must be passed in the same
   * manner as gst_structure_set(), and be <tt>0</tt>-terminated.
   * @param field First field to set.
   * @param varargs Additional parameters.
   */
  void set_simple_valist(char* field, const va_list& varargs);

  
  /** Determines if @a caps represents any media format.
   * @return <tt>true</tt> if @a caps represents any format.
   */
  bool is_any() const;
  
  /** Determines if @a caps represents no media formats.
   * @return <tt>true</tt> if @a caps represents no formats.
   */
  bool empty() const;
  
  /** Fixed Gst::Caps describe exactly one format, that is, they have exactly
   * one structure, and each field in the structure describes a fixed type.
   * Examples of non-fixed types are GST_TYPE_INT_RANGE and GST_TYPE_LIST.
   * @return <tt>true</tt> if @a caps is fixed.
   */
  bool is_fixed() const;
  
  /** Checks if the given caps represent the same set of caps.
   * &lt;note&gt;This function does not work reliably if optional properties for caps
   * are included on one caps and omitted on the other.&lt;/note&gt;
   * 
   * This function deals correctly with passing <tt>0</tt> for any of the caps.
   * @param caps2 Another Gst::Caps.
   * @return <tt>true</tt> if both caps are equal.
   */
  bool equals(const Glib::RefPtr<Caps>& other_caps) const;
  
  /** Tests if two Gst::Caps are equal.  This function only works on fixed
   * Gst::Caps.
   * @param caps2 The Gst::Caps to test.
   * @return <tt>true</tt> if the arguments represent the same format.
   */
  bool equals_fixed(const Glib::RefPtr<Caps>& other_caps) const;
  
  /** A given Gst::Caps structure is always compatible with another if
   * every media format that is in the first is also contained in the
   * second.  That is, @a caps1 is a subset of @a caps2.
   * @param caps2 The Gst::Caps to test.
   * @return <tt>true</tt> if @a caps1 is a subset of @a caps2.
   */
  bool is_always_compatible(const Glib::RefPtr<Caps>& other_caps) const;
  
  /** Checks if all caps represented by @a subset are also represented by @a superset.
   * &lt;note&gt;This function does not work reliably if optional properties for caps
   * are included on one caps and omitted on the other.&lt;/note&gt;
   * @param superset A potentially greater Gst::Caps.
   * @return <tt>true</tt> if @a subset is a subset of @a superset.
   */
  bool is_subset(const Glib::RefPtr<Caps>& superset_caps) const;
  
  /** Creates a new Gst::Caps that contains all the formats that are common
   * to both @a caps1 and @a caps2.
   * @param caps2 A Gst::Caps to intersect.
   * @return The new Gst::Caps.
   */
  Glib::RefPtr<Caps> get_intersect(const Glib::RefPtr<Caps>& other_caps) const;
  
  /** Creates a new Gst::Caps that contains all the formats that are in
   * either @a caps1 and @a caps2.
   * @param caps2 A Gst::Caps to union.
   * @return The new Gst::Caps.
   */
  Glib::RefPtr<Caps> get_union(const Glib::RefPtr<Caps>& other_caps) const;
  
  /** Creates a new Gst::Caps that represents the same set of formats as
   *  @a caps, but contains no lists.  Each list is expanded into separate
   *  @a GstStructures.
   * @return The new Gst::Caps.
   */
  Glib::RefPtr<Caps> normalize();
  
  /** Modifies the given @a caps inplace into a representation that represents the
   * same set of formats, but in a simpler form.  Component structures that are
   * identical are merged.  Component structures that have values that can be
   * merged are also merged.
   * @return <tt>true</tt>, if the caps could be simplified.
   */
  bool simplify();
  
  /** Serializes a Gst::Caps to XML and adds it as a child node of @a parent.
   * @param parent A XML parent node.
   * @return A XML node pointer.
   */
  xmlNodePtr save(const xmlNodePtr& parent) const;
  
  /** Creates a Gst::Caps from its XML serialization.
   * @param parent A XML node.
   * @return A new Gst::Caps structure.
   */
  static Glib::RefPtr<Caps> load(xmlNodePtr parent);

  
  /** Converts @a caps to a string representation.  This string representation
   * can be converted back to a Gst::Caps by gst_caps_from_string().
   * 
   * For debugging purposes its easier to do something like this:
   * 
   * GST_LOG ("caps are %" GST_PTR_FORMAT, caps);
   * 
   * This prints the caps in human readble form.
   * @return A newly allocated string representing @a caps.
   */
  Glib::ustring to_string() const;

  
  /** Converts @a caps from a string representation.
   * @param string A string to convert to Gst::Caps.
   * @return A newly allocated Gst::Caps.
   */
  static Glib::RefPtr<Caps> from_string(const Glib::ustring& string);

  
  /** Subtracts the @a subtrahend from the @a minuend.
   * &lt;note&gt;This function does not work reliably if optional properties for caps
   * are included on one caps and omitted on the other.&lt;/note&gt;
   * @param subtrahend Gst::Caps to substract.
   * @return The resulting caps.
   */
  Glib::RefPtr<Caps> subtract(const Glib::RefPtr<const Caps>& subtrahend_caps);
  
  /** Returns: the same Gst::Caps object.
   * @return The same Gst::Caps object.
   */
  Glib::RefPtr<Caps> make_writable();
  
  /** Destructively discard all but the first structure from @a caps. Useful when
   * fixating. @a caps must be writable.
   */
  void truncate();
  
  
};

} //namespace Gst


namespace Glib
{

  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::Caps
   */
  Glib::RefPtr<Gst::Caps> wrap(GstCaps* object, bool take_copy = false);

} // namespace Glib


#endif /* _GSTREAMERMM_CAPS_H */

