// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_TAGLIST_H
#define _GSTREAMERMM_TAGLIST_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gsttaglist.h>


namespace Gst
{

/** @addtogroup gstreamermmEnums Enums and Flags */

/**
 * @ingroup gstreamermmEnums
 */
enum TagMergeMode
{
  TAG_MERGE_UNDEFINED,
  TAG_MERGE_REPLACE_ALL,
  TAG_MERGE_REPLACE,
  TAG_MERGE_APPEND,
  TAG_MERGE_PREPEND,
  TAG_MERGE_KEEP,
  TAG_MERGE_KEEP_ALL,
  TAG_MERGE_COUNT
};

} // namespace Gst


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::TagMergeMode> : public Glib::Value_Enum<Gst::TagMergeMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{

/**
 * @ingroup gstreamermmEnums
 */
enum TagFlag
{
  TAG_FLAG_UNDEFINED,
  TAG_FLAG_META,
  TAG_FLAG_ENCODED,
  TAG_FLAG_DECODED,
  TAG_FLAG_COUNT
};

} // namespace Gst


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::TagFlag> : public Glib::Value_Enum<Gst::TagFlag>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{


/** Gst::TagList — List of tags and values used to describe media metadata.
 */
class TagList
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef TagList CppObjectType;
  typedef GstTagList BaseObjectType;

  static GType get_type() G_GNUC_CONST;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  TagList();

  explicit TagList(GstTagList* gobject, bool make_a_copy = false, bool destroy = true);

  TagList(const TagList& other);
  TagList& operator=(const TagList& other);

  ~TagList();

  void swap(TagList& other);

  ///Provides access to the underlying C instance.
  GstTagList*       gobj()       { return gobject_; }

  ///Provides access to the underlying C instance.
  const GstTagList* gobj() const { return gobject_; }

  ///Provides access to the underlying C instance. The caller is responsible for freeing it. Use when directly setting fields in structs.
  GstTagList* gobj_copy() const;

  /** Change whether the wrapper should destroy the underlying gobject or not
   * when the wrapper is deleted.
   * @param destroy whether or not the wrapper should destroy the underlying
   * gobject when it is destroyed
   */
  void set_destroy(bool destroy);

protected:
  GstTagList* gobject_;

private:
  bool destroy;

private:


public:
  /** For example,
   * void on_foreach(const Gst::TagList& taglist, const Glib::Ustring& tag);
   */
  typedef sigc::slot<void, const TagList&, const Glib::ustring&> SlotForeach;

  
  /** Checks if the given type is already registered.
   * @param tag Name of the tag.
   * @return <tt>true</tt> if the type is already registered.
   */
  static bool exists(const Glib::ustring& tag);
  
  /** Gets the Type used for this tag.
   * @param tag The tag.
   * @return The Type of this tag.
   */
  static GType get_type(const Glib::ustring& tag);
  
  /** Returns: the human-readable name of this tag
   * @param tag The tag.
   * @return The human-readable name of this tag.
   */
  static Glib::ustring get_nick(const Glib::ustring& tag);
  
  /** Returns: the human-readable description of this tag
   * @param tag The tag.
   * @return The human-readable description of this tag.
   */
  static Glib::ustring get_description(const Glib::ustring& tag);
  
  /** Gets the flag of @a tag.
   * @param tag The tag.
   * @return The flag of this tag.
   */
  static TagFlag get_flag(const Glib::ustring& tag);
  
  /** Checks if the given tag is fixed. A fixed tag can only contain one value.
   * Unfixed tags can contain lists of values.
   * @param tag Tag to check.
   * @return <tt>true</tt>, if the given tag is fixed.
   */
  static bool is_fixed(const Glib::ustring& tag);
  
  /** Checks if the given taglist is empty.
   * @return <tt>true</tt> if the taglist is empty, otherwise <tt>false</tt>.
   * 
   * Since: 0.10.11.
   */
  bool empty();
  
  /** Inserts the tags of the second list into the first list using the given mode.
   * @param from List to merge from.
   * @param mode The mode to use.
   */
  void insert(const TagList& other, TagMergeMode mode);
  
  /** Merges the two given lists into a new list. If one of the lists is <tt>0</tt>, a
   * copy of the other is returned. If both lists are <tt>0</tt>, <tt>0</tt> is returned.
   * @param list2 Second list to merge.
   * @param mode The mode to use.
   * @return The new list.
   */
  TagList merge(const TagList& other, TagMergeMode mode);

  /** Calls the given slot for each tag inside the tag list. Note that if there
   * is no tag, the slot won't be called at all.
   *
   * @param slot slot to be called for each tag
   */
  void foreach(const SlotForeach& slot);


};

} //namespace Gst


namespace Gst
{

/** @relates Gst::TagList
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 */
inline void swap(TagList& lhs, TagList& rhs)
  { lhs.swap(rhs); }

} // namespace Gst

namespace Glib
{

/** A Glib::wrap() method for this object.
 * 
 * @param object The C instance.
 * @param take_copy False if the result should take ownership of the C
 * instance. True if it should take a new copy or ref.
 * @param destroy False if the result should not delete the C instance when
 * wrapper is destroyed. True if it should.
 * @param dummy Unused; simply an extra param to disambiguate wrap in weird
 * case such as GStreamer types GstStructure and GstTagList which are both
 * really same C type
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gst::TagList
 */
Gst::TagList wrap(GstTagList* object, bool take_copy = false, bool destroy = true, bool dummy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Gst::TagList> : public Glib::Value_Boxed<Gst::TagList>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


#endif /* _GSTREAMERMM_TAGLIST_H */

