// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_PAD_H
#define _GSTREAMERMM_PAD_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gstreamermm/object.h>
#include <gstreamermm/miniobject.h>
#include <gstreamermm/enums.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstPad GstPad;
typedef struct _GstPadClass GstPadClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{ class Pad_Class; } // namespace Gst
namespace Gst
{

class Buffer;
class Caps;
class Element;
class Event;
class PadTemplate;
class Query;


class Pad : public Object 
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Pad CppObjectType;
  typedef Pad_Class CppClassType;
  typedef GstPad BaseObjectType;
  typedef GstPadClass BaseClassType;

private:  friend class Pad_Class;
  static CppClassType pad_class_;

private:
  // noncopyable
  Pad(const Pad&);
  Pad& operator=(const Pad&);

protected:
  explicit Pad(const Glib::ConstructParams& construct_params);
  explicit Pad(GstPad* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Pad();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstPad*       gobj()       { return reinterpret_cast<GstPad*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GstPad* gobj() const { return reinterpret_cast<GstPad*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstPad* gobj_copy();

private:


protected:
  Pad();

public:
  // The C API has gst_pad_new, we just use the very common ::create() here
  static Glib::RefPtr<Pad> create(const Glib::ustring& name, PadDirection direction);

  
  /** Gets the direction of the pad. The direction of the pad is
   * decided at construction time so this function does not take
   * the LOCK.
   * @return The Gst::PadDirection of the pad.
   * 
   * MT safe.
   */
  PadDirection get_direction() const;
  
  /** Gets the parent of @a pad, cast to a Gst::Element. If a @a pad has no parent or
   * its parent is not an element, return <tt>0</tt>.
   * @return The parent of the pad. The caller has a reference on the parent, so
   * unref when you're finished with it.
   * 
   * MT safe.
   */
  Glib::RefPtr<Element> get_parent_element();
  
  /** Gets the parent of @a pad, cast to a Gst::Element. If a @a pad has no parent or
   * its parent is not an element, return <tt>0</tt>.
   * @return The parent of the pad. The caller has a reference on the parent, so
   * unref when you're finished with it.
   * 
   * MT safe.
   */
  Glib::RefPtr<const Element> get_parent_element() const;
  
  /** Links the source pad and the sink pad.
   * @param sinkpad The sink Gst::Pad to link.
   * @return A result code indicating if the connection worked or
   * what went wrong.
   * 
   * MT Safe.
   */
  PadLinkReturn link(const Glib::RefPtr<Pad>& sink_pad);
  
  /** Unlinks the source pad from the sink pad. Will emit the Gst::Pad::unlinked
   * signal on both pads.
   * @param sinkpad The sink Gst::Pad to unlink.
   * @return <tt>true</tt> if the pads were unlinked. This function returns <tt>false</tt> if
   * the pads were not linked together.
   * 
   * MT safe.
   */
  bool unlink(const Glib::RefPtr<Pad>& sink_pad);
  
  /** Checks if a @a pad is linked to another pad or not.
   * @return <tt>true</tt> if the pad is linked, <tt>false</tt> otherwise.
   * 
   * MT safe.
   */
  bool is_linked() const;
  
  /** Checks if the source pad and the sink pad can be linked.
   * Both @a srcpad and @a sinkpad must be unlinked.
   * @param sinkpad The sink Gst::Pad to link.
   * @return <tt>true</tt> if the pads can be linked, <tt>false</tt> otherwise.
   */
  bool can_link(const Glib::RefPtr<Pad>& other_pad);
  
  /** Gets the capabilities this pad can produce or consume.
   * Note that this method doesn't necessarily return the caps set by
   * set_caps() - use Gst::PAD_CAPS for that instead.
   * gst_pad_get_caps returns all possible caps a pad can operate with, using
   * the pad's get_caps function;
   * this returns the pad template caps if not explicitly set.
   * @return A newly allocated copy of the Gst::Caps of this pad.
   * 
   * MT safe.
   */
  Glib::RefPtr<Caps> get_caps();
  
  /** Gets the capabilities this pad can produce or consume.
   * Note that this method doesn't necessarily return the caps set by
   * set_caps() - use Gst::PAD_CAPS for that instead.
   * gst_pad_get_caps returns all possible caps a pad can operate with, using
   * the pad's get_caps function;
   * this returns the pad template caps if not explicitly set.
   * @return A newly allocated copy of the Gst::Caps of this pad.
   * 
   * MT safe.
   */
  Glib::RefPtr<const Caps> get_caps() const;
  
  /** Gets the capabilities of the allowed media types that can flow through
   *  @a pad and its peer.
   * 
   * The allowed capabilities is calculated as the intersection of the results of
   * calling get_caps() on @a pad and its peer. The caller owns a reference
   * on the resulting caps.
   * @return The allowed Gst::Caps of the pad link. Unref the caps when you no
   * longer need it. This function returns <tt>0</tt> when @a pad has no peer.
   * 
   * MT safe.
   */
  Glib::RefPtr<Caps> get_allowed_caps();
  
  /** Gets the capabilities of the allowed media types that can flow through
   *  @a pad and its peer.
   * 
   * The allowed capabilities is calculated as the intersection of the results of
   * calling get_caps() on @a pad and its peer. The caller owns a reference
   * on the resulting caps.
   * @return The allowed Gst::Caps of the pad link. Unref the caps when you no
   * longer need it. This function returns <tt>0</tt> when @a pad has no peer.
   * 
   * MT safe.
   */
  Glib::RefPtr<const Caps> get_allowed_caps() const;
  
  /** Gets the capabilities of the media type that currently flows through @a pad
   * and its peer.
   * 
   * This function can be used on both src and sinkpads. Note that srcpads are
   * always negotiated before sinkpads so it is possible that the negotiated caps
   * on the srcpad do not match the negotiated caps of the peer.
   * @return The negotiated Gst::Caps of the pad link.  Unref the caps when
   * you no longer need it. This function returns <tt>0</tt> when the @a pad has no
   * peer or is not negotiated yet.
   * 
   * MT safe.
   */
  Glib::RefPtr<Caps> get_negotiated_caps();
  
  /** Gets the capabilities of the media type that currently flows through @a pad
   * and its peer.
   * 
   * This function can be used on both src and sinkpads. Note that srcpads are
   * always negotiated before sinkpads so it is possible that the negotiated caps
   * on the srcpad do not match the negotiated caps of the peer.
   * @return The negotiated Gst::Caps of the pad link.  Unref the caps when
   * you no longer need it. This function returns <tt>0</tt> when the @a pad has no
   * peer or is not negotiated yet.
   * 
   * MT safe.
   */
  Glib::RefPtr<const Caps> get_negotiated_caps() const;

  // Hand coded because the documentation tells us that we need to copy the Caps
  //TODO: Should/Could this be const?
  //TODO: Documentation.
  Glib::RefPtr<Caps> get_pad_template_caps();

  
  /** Sets the capabilities of this pad. The caps must be fixed. Any previous
   * caps on the pad will be unreffed. This function refs the caps so you should
   * unref if as soon as you don't need it anymore.
   * It is possible to set <tt>0</tt> caps, which will make the pad unnegotiated
   * again.
   * @param caps A Gst::Caps to set.
   * @return <tt>true</tt> if the caps could be set. <tt>false</tt> if the caps were not fixed
   * or bad parameters were provided to this function.
   * 
   * MT safe.
   */
  bool set_caps (const Glib::RefPtr<Caps>& caps);
  
  /** Gets the peer of @a pad. This function refs the peer pad so
   * you need to unref it after use.
   * @return The peer Gst::Pad. Unref after usage.
   * 
   * MT safe.
   */
  Glib::RefPtr<Pad> get_peer();
  
  /** Gets the peer of @a pad. This function refs the peer pad so
   * you need to unref it after use.
   * @return The peer Gst::Pad. Unref after usage.
   * 
   * MT safe.
   */
  Glib::RefPtr<const Pad> get_peer() const;
  
  /** Gets the capabilities of the peer connected to this pad.
   * @return The Gst::Caps of the peer pad. This function returns a new caps, so
   * use gst_caps_unref to get rid of it. this function returns <tt>0</tt> if there is
   * no peer pad.
   */
  Glib::RefPtr<Caps> peer_get_caps();
  
  /** Gets the capabilities of the peer connected to this pad.
   * @return The Gst::Caps of the peer pad. This function returns a new caps, so
   * use gst_caps_unref to get rid of it. this function returns <tt>0</tt> if there is
   * no peer pad.
   */
  Glib::RefPtr<const Caps> peer_get_caps() const;
  
  /** A helper function you can use that sets the
   *  @a gst_pad_get_fixed_caps_func as the getcaps function for the
   * pad. This way the function will always return the negotiated caps
   * or in case the pad is not negotiated, the padtemplate caps.
   * 
   * Use this function on a pad that, once _set_caps() has been called
   * on it, cannot be renegotiated to something else.
   */
  void use_fixed_caps();
  
  /** Query if a pad is active
   * @return <tt>true</tt> if the pad is active.
   * 
   * MT safe.
   */
  bool is_active() const;
  
  /** Blocks or unblocks the dataflow on a pad. This function is
   * a shortcut for set_blocked_async() with a <tt>0</tt>
   * callback.
   * @param blocked Boolean indicating we should block or unblock.
   * @return <tt>true</tt> if the pad could be blocked. This function can fail if the
   * wrong parameters were passed or the pad was already in the requested state.
   * 
   * MT safe.
   */
  bool set_blocked(bool blocked = true);
  
  /** Checks if the pad is blocked or not. This function returns the
   * last requested state of the pad. It is not certain that the pad
   * is actually blocking at this point (see is_blocking()).
   * @return <tt>true</tt> if the pad is blocked.
   * 
   * MT safe.
   */
  bool is_blocked() const;
  
  /** Checks if the pad is blocking or not. This is a guaranteed state
   * of whether the pad is actually blocking on a Gst::Buffer or a Gst::Event.
   * @return <tt>true</tt> if the pad is blocking.
   * 
   * MT safe.
   * 
   * Since: 0.10.11.
   */
  bool is_blocking() const;

  
  /** Removes a data probe from @a pad.
   * @param handler_id Handler id returned from gst_pad_add_data_probe.
   */
  void remove_data_probe(guint handler_id);
  
  /** Removes a buffer probe from @a pad.
   * @param handler_id Handler id returned from gst_pad_add_buffer_probe.
   */
  void remove_buffer_probe(guint handler_id);
  
  /** Removes an event probe from @a pad.
   * @param handler_id Handler id returned from gst_pad_add_event_probe.
   */
  void remove_event_probe(guint handler_id);

  FlowReturn alloc_buffer(guint64 offset, int size, const Glib::RefPtr<Caps>& caps, Glib::RefPtr<Buffer>& buf);
  FlowReturn alloc_buffer_and_set_caps(guint64 offset, int size, const Glib::RefPtr<Caps>& caps, Glib::RefPtr<Buffer>& buf);

  FlowReturn get_range(guint64 offset, guint size, Glib::RefPtr<Buffer>& buffer);

  
  /** Check if the given pad accepts the caps.
   * @param caps A Gst::Caps to check on the pad.
   * @return <tt>true</tt> if the pad can accept the caps.
   */
  bool accept_caps(const Glib::RefPtr<Caps>& caps);

  
  /** Calls get_allowed_caps() for every other pad belonging to the
   * same element as @a pad, and returns the intersection of the results.
   * 
   * This function is useful as a default getcaps function for an element
   * that can handle any stream format, but requires all its pads to have
   * the same caps.  Two such elements are tee and aggregator.
   * @return The intersection of the other pads' allowed caps.
   */
  Glib::RefPtr<Caps> proxy_getcaps();
  
  /** Calls get_allowed_caps() for every other pad belonging to the
   * same element as @a pad, and returns the intersection of the results.
   * 
   * This function is useful as a default getcaps function for an element
   * that can handle any stream format, but requires all its pads to have
   * the same caps.  Two such elements are tee and aggregator.
   * @return The intersection of the other pads' allowed caps.
   */
  Glib::RefPtr<Caps const> proxy_getcaps() const;

  
  /** Calls set_caps() for every other pad belonging to the
   * same element as @a pad.  If set_caps() fails on any pad,
   * the proxy setcaps fails. May be used only during negotiation.
   * @param caps The Gst::Caps to link with.
   * @return <tt>true</tt> if sucessful.
   */
  bool proxy_setcaps(const Glib::RefPtr<Caps>& caps);

  
  /** Fixate a caps on the given pad. Modifies the caps in place, so you should
   * make sure that the caps are actually writable (see gst_caps_make_writable()).
   * @param caps The  Gst::Caps to fixate.
   */
  void fixate_caps(const Glib::RefPtr<Caps>& caps);

  
  /** Check if the peer of @a pad accepts @a caps. If @a pad has no peer, this function
   * Returns: <tt>true</tt> if the peer of @a pad can accept the caps or @a pad has no peer.
   * @param caps A Gst::Caps to check on the pad.
   * @return <tt>true</tt> if the peer of @a pad can accept the caps or @a pad has no peer.
   */
  bool peer_accept_caps(const Glib::RefPtr<Caps>& caps);

  // This method is written manually because an extra ref is necessary
  FlowReturn push(const Glib::RefPtr<Buffer>& buffer);

  // This method is written manually because an extra ref is necessary
  bool push_event(const Glib::RefPtr<Event>& event);


  /** Checks if a pull_range() can be performed on the peer
   * source pad. This function is used by plugins that want to check
   * if they can use random access on the peer source pad.
   * 
   * The peer sourcepad can implement a custom Gst::PadCheckGetRangeFunction
   * if it needs to perform some logic to determine if pull_range is
   * possible.
   * @return A <tt>bool</tt> with the result.
   * 
   * MT safe.
   */
  bool check_pull_range() const;
  FlowReturn pull_range(guint64 offset, guint size, Glib::RefPtr<Buffer>& buffer);
  
  /** Activates or deactivates the given pad in pull mode via dispatching to the
   * pad's activatepullfunc. For use from within pad activation functions only.
   * When called on sink pads, will first proxy the call to the peer pad, which
   * is expected to activate its internally linked pads from within its
   * activate_pull function.
   * 
   * If you don't know what this is, you probably don't want to call it.
   * @param active Whether or not the pad should be active.
   * @return <tt>true</tt> if the operation was successful.
   * 
   * MT safe.
   */
  bool activate_pull(bool active = true);
  
  /** Activates or deactivates the given pad in push mode via dispatching to the
   * pad's activatepushfunc. For use from within pad activation functions only.
   * 
   * If you don't know what this is, you probably don't want to call it.
   * @param active Whether the pad should be active or not.
   * @return <tt>true</tt> if the operation was successful.
   * 
   * MT safe.
   */
  bool activate_push(bool active = true);

  // This method is written manually because an extra ref is necessary
  bool send_event(const Glib::RefPtr<Event>& event);
  
  /** Invokes the default event handler for the given pad. End-of-stream and
   * discontinuity events are handled specially, and then the event is sent to all
   * pads internally linked to @a pad. Note that if there are many possible sink
   * pads that are internally linked to @a pad, only one will be sent an event.
   * Multi-sinkpad elements should implement custom event handlers.
   * @param event The Gst::Event to handle.
   * @return <tt>true</tt> if the event was sent succesfully.
   */
  bool event_default(const Glib::RefPtr<Event>& event);
  
  /** Dispatches a query to a pad. The query should have been allocated by the
   * caller via one of the type-specific allocation functions in gstquery.h. The
   * element is responsible for filling the query with an appropriate response,
   * which should then be parsed with a type-specific query parsing function.
   * 
   * Again, the caller is responsible for both the allocation and deallocation of
   * the query structure.
   * @param query The Gst::Query to perform.
   * @return <tt>true</tt> if the query could be performed.
   */
  bool query(const Glib::RefPtr<Query>& query);
  
  /** Performs query() on the peer of @a pad.
   * 
   * The caller is responsible for both the allocation and deallocation of
   * the query structure.
   * @param query The Gst::Query to perform.
   * @return <tt>true</tt> if the query could be performed. This function returns <tt>false</tt>
   * if @a pad has no peer.
   * 
   * Since: 0.10.15.
   */
  bool peer_query(const Glib::RefPtr<Query>& query);
  
  /** Invokes the default query handler for the given pad.
   * The query is sent to all pads internally linked to @a pad. Note that
   * if there are many possible sink pads that are internally linked to
   *  @a pad, only one will be sent the query.
   * Multi-sinkpad elements should implement custom query handlers.
   * @param query The Gst::Query to handle.
   * @return <tt>true</tt> if the query was performed succesfully.
   */
  bool query_default(const Glib::RefPtr<Query>& query);
  bool query_position(Format& format) const;
  
  /** Queries a pad for the stream position.
   * @param format A pointer to the Gst::Format asked for.
   * On return contains the Gst::Format used.
   * @param cur A location in which to store the current position, or <tt>0</tt>.
   * @return <tt>true</tt> if the query could be performed.
   */
  bool query_position(Format& format, gint64& position) const;
  bool query_duration(Format& format) const;
  
  /** Queries a pad for the total stream duration.
   * @param format A pointer to the Gst::Format asked for.
   * On return contains the Gst::Format used.
   * @param duration A location in which to store the total duration, or <tt>0</tt>.
   * @return <tt>true</tt> if the query could be performed.
   */
  bool query_duration(Format& format, gint64& duration) const;
  bool query_convert(Format src_format, gint64 src_value, Format& dst_format, gint64& dst_value) const;
  bool query_peer_position(Format& format) const;
  
  /** Queries the peer of a given sink pad for the stream position.
   * @param format A pointer to the Gst::Format asked for.
   * On return contains the Gst::Format used.
   * @param cur A location in which to store the current position, or <tt>0</tt>.
   * @return <tt>true</tt> if the query could be performed.
   */
  bool query_peer_position(Format& format, gint64& position) const;
  bool query_peer_duration(Format& format) const;
   
  /** Queries the peer pad of a given sink pad for the total stream duration.
   * @param format A pointer to the Gst::Format asked for.
   * On return contains the Gst::Format used.
   * @param duration A location in which to store the total duration, or <tt>0</tt>.
   * @return <tt>true</tt> if the query could be performed.
   */
  bool query_peer_duration(Format& format, gint64& duration) const;
   
  /** Queries the peer pad of a given sink pad to convert @a src_val in @a src_format
   * to @a dest_format.
   * @param src_format A Gst::Format to convert from.
   * @param src_val A value to convert.
   * @param dest_format A pointer to the Gst::Format to convert to.
   * @param dest_val A pointer to the result.
   * @return <tt>true</tt> if the query could be performed.
   */
  bool query_peer_convert(Format src_format, gint64 src_value, Format& dst_format, gint64& dst_value) const;

  //TODO: Use ArrayHandle?
  
  /** Get an array of supported queries that can be performed
   * on this pad.
   * @return A zero-terminated array of Gst::QueryType.
   */
  const QueryType* get_query_types() const;
  
  /** Invoke the default dispatcher for the query types on
   * the pad.
   * @return An zero-terminated array of Gst::QueryType, or <tt>0</tt> if none of the
   * internally-linked pads has a query types function.
   */
  const QueryType* get_query_types_default() const;

 
  /** Gets a list of pads to which the given pad is linked to
   * inside of the parent element.
   * The caller must free this list after use.
   * @return A newly allocated List of pads.
   * 
   * Not MT safe.
   */
  Glib::ListHandle< Glib::RefPtr<Pad> > get_internal_links();
  
  /** Gets a list of pads to which the given pad is linked to
   * inside of the parent element.
   * This is the default handler, and thus returns a list of all of the
   * pads inside the parent element with opposite direction.
   * The caller must free this list after use.
   * @return A newly allocated List of pads, or <tt>0</tt> if the pad has no parent.
   * 
   * Not MT safe.
   */
  Glib::ListHandle< Glib::RefPtr<Pad> > get_internal_links_default();

  // This method is written manually because an extra ref is necessary
  FlowReturn chain(const Glib::RefPtr<Buffer>& buffer);

  
  /** Pause the task of @a pad. This function will also wait until the
   * function executed by the task is finished if this function is not
   * called from the task function.
   * @return A <tt>true</tt> if the task could be paused or <tt>false</tt> when the pad
   * has no task.
   */
  bool pause_task() ;
  
  /** Stop the task of @a pad. This function will also make sure that the
   * function executed by the task will effectively stop if not called
   * from the GstTaskFunction.
   * 
   * This function will deadlock if called from the GstTaskFunction of
   * the task. Use Gst::Task::pause() instead.
   * 
   * Regardless of whether the pad has a task, the stream lock is acquired and
   * released so as to ensure that streaming through this pad has finished.
   * @return A <tt>true</tt> if the task could be stopped or <tt>false</tt> on error.
   */
  bool stop_task() ;
  
  /** Activates or deactivates the given pad.
   * Normally called from within core state change functions.
   * 
   * If @a active, makes sure the pad is active. If it is already active, either in
   * push or pull mode, just return. Otherwise dispatches to the pad's activate
   * function to perform the actual activation.
   * 
   * If not @a active, checks the pad's current mode and calls
   * activate_push() or activate_pull(), as appropriate, with a
   * <tt>false</tt> argument.
   * @param active Whether or not the pad should be active.
   * @return #<tt>true</tt> if the operation was successful.
   * 
   * MT safe.
   */
  bool set_active(bool active = true);

  
  typedef sigc::slot<void, bool> SlotPadBlockCallback;

  bool set_blocked_async(bool blocked, const SlotPadBlockCallback& slot);

 
  /**
   * @par Prototype:
   * <tt>bool on_my_%have_data(const Glib::RefPtr<Gst::MiniObject>& mini_obj)</tt>
   */

  Glib::SignalProxy1< bool,const Glib::RefPtr<Gst::MiniObject>& > signal_have_data();


  /**
   * @par Prototype:
   * <tt>void on_my_%linked(const Glib::RefPtr<Pad>& peer_pad)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<Pad>& > signal_linked();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%request_link()</tt>
   */

  Glib::SignalProxy0< void > signal_request_link();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%unlinked(const Glib::RefPtr<Pad>& peer_pad)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<Pad>& > signal_unlinked();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The capabilities of the pad.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Caps> > property_caps() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The direction of the pad.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<PadDirection> property_direction() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The GstPadTemplate of this pad.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<PadTemplate> property_template() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The GstPadTemplate of this pad.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<PadTemplate> property_template() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual bool on_have_data(const Glib::RefPtr<Gst::MiniObject>& mini_obj);
  virtual void on_linked(const Glib::RefPtr<Pad>& peer_pad);
  virtual void on_request_link();
  virtual void on_unlinked(const Glib::RefPtr<Pad>& peer_pad);
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gst


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::Pad
   */
  Glib::RefPtr<Gst::Pad> wrap(GstPad* object, bool take_copy = false);
}


#endif /* _GSTREAMERMM_PAD_H */

