// Generated by gtkmmproc -- DO NOT MODIFY!


#include <gstreamermm/clock.h>
#include <gstreamermm/private/clock_p.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gstclock.h>

namespace Gst
{

guint get_hours(ClockTime time)
{
  return GST_CLOCK_TIME_IS_VALID (time) ? \
        (guint) (((GstClockTime)(time)) / (GST_SECOND * 60 * 60)) : 99;
}

guint get_minutes(ClockTime time)
{
  return GST_CLOCK_TIME_IS_VALID (time) ? \
        (guint) ((((GstClockTime)(time)) / (GST_SECOND * 60)) % 60) : 99;
}

guint get_seconds(ClockTime time)
{
  return GST_CLOCK_TIME_IS_VALID (time) ? \
        (guint) ((((GstClockTime)(time)) / GST_SECOND) % 60) : 99;
}

guint get_milliseconds(ClockTime time)
{
  return GST_CLOCK_TIME_IS_VALID (time) ? \
        (guint) ((((GstClockTime)(time)) / GST_MSECOND) % 1000) : 999;
}

guint get_microseconds(ClockTime time)
{
  return GST_CLOCK_TIME_IS_VALID (time) ? \
        (guint) ((((GstClockTime)(time)) / GST_USECOND) % 1000) : 999;
}

guint get_nanoseconds(ClockTime time)
{
  return GST_CLOCK_TIME_IS_VALID (time) ? \
        (guint) ((((GstClockTime)(time)) / GST_NSECOND) % 1000) : 999;
}

guint get_fractional_seconds(ClockTime time)
{
  return GST_CLOCK_TIME_IS_VALID (time) ? \
        (guint) (((GstClockTime)(time)) % GST_SECOND) : 999999999;
}

} //namespace Gst

namespace
{
} // anonymous namespace


/* Why reinterpret_cast<ClockID*>(gobject) is needed:
 *
 * A ClockID instance is in fact always a GstClockID instance.
 * Unfortunately, GstClockID cannot be a member of ClockID,
 * because it is an opaque struct.  Also, the C interface does not provide
 * any hooks to install a destroy notification handler, thus we cannot
 * wrap it dynamically either.
 *
 * The cast works because ClockID does not have any member data, and
 * it is impossible to derive from it.  This is ensured by not implementing
 * the (protected) default constructor.  The ctor is protected rather than
 * private just to avoid a compile warning.
 */

namespace Glib
{

Glib::RefPtr<Gst::ClockID> wrap(GstClockID* object, bool take_copy)
{
  if(take_copy && object)
    gst_clock_id_ref(object);

  // See the comment at the top of this file, if you want to know why the cast works.
  return Glib::RefPtr<Gst::ClockID>(reinterpret_cast<Gst::ClockID*>(object));
}

} // namespace Glib


namespace Gst
{


void ClockID::reference() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  gst_clock_id_ref(reinterpret_cast<GstClockID*>(const_cast<ClockID*>(this)));
}

void ClockID::unreference() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  gst_clock_id_unref(reinterpret_cast<GstClockID*>(const_cast<ClockID*>(this)));
}

GstClockID* ClockID::gobj()
{
  // See the comment at the top of this file, if you want to know why the cast works.
  return reinterpret_cast<GstClockID*>(this);
}

const GstClockID* ClockID::gobj() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  return reinterpret_cast<const GstClockID*>(this);
}

GstClockID* ClockID::gobj_copy() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  GstClockID *const gobject = reinterpret_cast<GstClockID*>(const_cast<ClockID*>(this));
  gst_clock_id_ref(gobject);
  return gobject;
}


} // namespace Gst


namespace Glib
{

Glib::RefPtr<Gst::Clock> wrap(GstClock* object, bool take_copy)
{
  return Glib::RefPtr<Gst::Clock>( dynamic_cast<Gst::Clock*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gst
{


/* The *_Class implementation: */

const Glib::Class& Clock_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Clock_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gst_clock_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}

void Clock_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
}

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


Glib::ObjectBase* Clock_Class::wrap_new(GObject* object)
{
  return new Clock((GstClock*)object);
}


/* The implementation: */

GstClock* Clock::gobj_copy()
{
  reference();
  return gobj();
}

Clock::Clock(const Glib::ConstructParams& construct_params)
:
  Object(construct_params)
{

}

Clock::Clock(GstClock* castitem)
:
  Object((GstObject*)(castitem))
{}

Clock::~Clock()
{}


Clock::CppClassType Clock::clock_class_; // initialize static member

GType Clock::get_type()
{
  return clock_class_.init().get_type();
}

GType Clock::get_base_type()
{
  return gst_clock_get_type();
}

Clock::Clock()
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Object(Glib::ConstructParams(clock_class_.init()))
{
  

}

bool Clock::add_observation(ClockTime slave_time, ClockTime master_time, gdouble* result)
{
  return gst_clock_add_observation(gobj(), ((GstClockTime)(slave_time)), ((GstClockTime)(master_time)), result);
}

bool Clock::set_master(const Clock& master_clock)
{
  return gst_clock_set_master(gobj(), ((GstClock*) (&(master_clock))));
}

Glib::RefPtr<Clock> Clock::get_master()
{
  return Glib::wrap(gst_clock_get_master(gobj()));
}

ClockTime Clock::set_resolution(ClockTime resolution)
{
  return ((ClockTime)(gst_clock_set_resolution(gobj(), ((GstClockTime)(resolution)))));
}

ClockTime Clock::get_resolution() const
{
  return ((ClockTime)(gst_clock_get_resolution(const_cast<GstClock*>(gobj()))));
}

ClockTime Clock::get_time() const
{
  return ((ClockTime)(gst_clock_get_time(const_cast<GstClock*>(gobj()))));
}

ClockTime Clock::get_internal_time() const
{
  return ((ClockTime)(gst_clock_get_internal_time(const_cast<GstClock*>(gobj()))));
}

ClockTime Clock::adjust_unlocked(ClockTime internal_time)
{
  return ((ClockTime)(gst_clock_adjust_unlocked(gobj(), ((GstClockTime)(internal_time)))));
}

ClockTime Clock::unadjust_unlocked(ClockTime external_time)
{
  return ((ClockTime)(gst_clock_unadjust_unlocked(gobj(), ((GstClockTime)(external_time)))));
}


#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED


} // namespace Gst


