// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_MESSAGE_H
#define _GSTREAMERMM_MESSAGE_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gstreamermm/miniobject.h>
#include <gstreamermm/structure.h>
#include <gstreamermm/wrap.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstMessage GstMessage;
typedef struct _GstMessageClass GstMessageClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{ class Message_Class; } // namespace Gst
namespace Gst
{


class Message : public Gst::MiniObject
{
protected:
 
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Message CppObjectType;
  typedef Message_Class CppClassType;
  typedef GstMessage BaseObjectType;
  typedef GstMessageClass BaseClassType;

private:  friend class Message_Class;
  static CppClassType message_class_;

private:
  // noncopyable
  Message(const Message&);
  Message& operator=(const Message&);

protected:
  explicit Message(GstMessage* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Message();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GstMiniObject.
  GstMessage*       gobj()       { return reinterpret_cast<GstMessage*>(gobject_); }

  ///Provides access to the underlying C GstMiniObject.
  const GstMessage* gobj() const { return reinterpret_cast<GstMessage*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstMessage* gobj_copy();

private:

 
public:
  const Structure& get_structure();

public:

  /** Wrap a GstMessage* in a C++ instance, creating an instance of a
   *  derived Gst::Message.  Gst::wrap() would just create a Gst::Message
   *  (rather than a derived one) because the derived Gst::Message classes
   *  do not correspond to GType types in the GStreamer API.
   */
  static Glib::RefPtr<Message> wrap(GstMessage* message, bool take_copy=false);

   MessageType get_message_type() const;
    ClockTime get_timestamp() const;
    Glib::RefPtr<Gst::Object> get_source();
  Glib::RefPtr<const Gst::Object> get_source() const;
 
protected: 
  Structure structure_;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

class MessageApplication : public Message
{
public:
  explicit MessageApplication(GstMessage *message);

  static Glib::RefPtr<Message> create(const Glib::RefPtr<Object>& src, Structure& structure);
};

class MessageClockProvide : public Message
{
public:
  explicit MessageClockProvide(GstMessage *message);

  static Glib::RefPtr<Message> create(const Glib::RefPtr<Object>& src, const Glib::RefPtr<Clock>& clock, bool ready);
  void parse(Glib::RefPtr<Clock>& clock, bool& ready);
};

class MessageClockLost : public Message
{
public:
  explicit MessageClockLost(GstMessage* castitem);

  static Glib::RefPtr<Message> create(const Glib::RefPtr<Object>& src, const Glib::RefPtr<Clock>& clock);
  void parse(Glib::RefPtr<Clock>& clock);
};

class MessageCustom : public Message
{
public:
  explicit MessageCustom(GstMessage* castitem);

  static Glib::RefPtr<Message> create(MessageType type, const Glib::RefPtr<Object>& src, Structure& structure);
};

class MessageElement : public Message
{
public:
  explicit MessageElement(GstMessage* castitem);

  static Glib::RefPtr<Message> create(const Glib::RefPtr<Object>& src, Structure& structure);
};

class MessageEos : public Message
{
public:
  explicit MessageEos(GstMessage* castitem);

  static Glib::RefPtr<Message> create(const Glib::RefPtr<Object>& src);
};

class MessageError : public Message
{
public:
  explicit MessageError(GstMessage* castitem);

  static Glib::RefPtr<Message> create(const Glib::RefPtr<Object>& src, Glib::Error& error, const std::string& debug);
  void parse(Glib::Error& error, std::string& debug);
  void parse(Glib::Error& error);
};

class MessageInfo : public Message
{
public:
  explicit MessageInfo(GstMessage* castitem);

  static Glib::RefPtr<Message> create(const Glib::RefPtr<Object>& src, Glib::Error& error, const std::string& debug);
  void parse(Glib::Error& error, std::string& debug);
};

class MessageNewClock: public Message
{
public:
  explicit MessageNewClock(GstMessage* castitem);

  static Glib::RefPtr<Message> create(const Glib::RefPtr<Object>& src, const Glib::RefPtr<Clock>& clock);
  void parse(Glib::RefPtr<Clock>& clock);
};

class MessageSegmentDone : public Message
{
public:
  explicit MessageSegmentDone(GstMessage* castitem);

  static Glib::RefPtr<Message> create(const Glib::RefPtr<Object>& src, Format format, gint64 position);
  void parse(Format& format, gint64& position);
};

class MessageSegmentStart : public Message
{
public:
  explicit MessageSegmentStart(GstMessage* castitem);

  static Glib::RefPtr<Message> create(const Glib::RefPtr<Object>& src, Format format, gint64 position);
  void parse(Format& format, gint64& position);
};

class MessageStateChanged : public Message
{
public:
  explicit MessageStateChanged(GstMessage* castitem);

  static Glib::RefPtr<Message> create(const Glib::RefPtr<Object>& src, State oldstate, State newstate, State pending);
  void parse(State& oldstate, State& newstate, State& pending);
};

//TODO:class MessageTag : public Message
//TODO:{
//TODO:}

class MessageBuffering : public Message
{
public:
  explicit MessageBuffering(GstMessage* castitem);

  static Glib::RefPtr<Message> create(const Glib::RefPtr<Object>& src, int percent);
  void parse(int& percent);
};

class MessageWarning : public Message
{
public:
  explicit MessageWarning(GstMessage* castitem);

  static Glib::RefPtr<Message> create(const Glib::RefPtr<Object>& src, Glib::Error& error, const std::string& debug);
  void parse(Glib::Error& error, std::string& debug);
};

class MessageDuration : public Message
{
public:
  explicit MessageDuration(GstMessage* castitem);

  static Glib::RefPtr<Message> create(const Glib::RefPtr<Object>& src, Format format, gint64 position);
  void parse(Format& format, gint64& position);
};

class MessageStateDirty : public Message
{
public:
  explicit MessageStateDirty(GstMessage* castitem);

  static Glib::RefPtr<Message> create(const Glib::RefPtr<Object>& src);
};

class MessageAsyncStart : public Message
{
public:
  explicit MessageAsyncStart(GstMessage* castitem);

  static Glib::RefPtr<Message> create(const Glib::RefPtr<Object>& src, bool new_base_time);
  void parse(bool& new_base_time);
};

class MessageAsyncDone : public Message
{
public:
  explicit MessageAsyncDone(GstMessage* castitem);

  static Glib::RefPtr<Message> create(const Glib::RefPtr<Object>& src);
};

class MessageLatency : public Message
{
public:
  explicit MessageLatency(GstMessage* castitem);

  static Glib::RefPtr<Message> create(const Glib::RefPtr<Object>& src);
};

} //namespace Gst


namespace Gst
{
  /** @relates Gst::Message
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Gst::Message> wrap(GstMessage* object, bool take_copy = false);
}


#endif /* _GSTREAMERMM_MESSAGE_H */

