// Generated by gtkmmproc -- DO NOT MODIFY!


#include <gstreamermm/element.h>
#include <gstreamermm/private/element_p.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gstreamermm/bus.h>
#include <gstreamermm/caps.h>
#include <gstreamermm/event.h>
#include <gstreamermm/message.h>
#include <gstreamermm/pad.h>
#include <gstreamermm/padtemplate.h>
#include <gstreamermm/query.h>
#include <gst/gstelement.h>
#include <gst/gstutils.h>
#include <stdexcept>

namespace Gst
{

Glib::RefPtr<Element>
Element::create(const Glib::ustring& factoryname, const Glib::ustring& name)
{
  GstElement* element = gst_element_factory_make(factoryname.c_str(), name.c_str());
  return Glib::wrap(element);
}

Glib::RefPtr<Element>
Element::link(const Glib::RefPtr<Element>& other_element)
{
  bool result = gst_element_link(gobj(), other_element->gobj());

  if(result)
    return other_element;
  else
    throw std::runtime_error("failed to link: " + get_name() + "->" + other_element->get_name() + "!\n");
}

Glib::RefPtr<Pad> Element::get_compatible_pad(const Glib::RefPtr<Pad>& pad, const Glib::RefPtr<Caps>& caps)
{
  GstPad* c_pad = gst_element_get_compatible_pad(gobj(), pad->gobj(), caps->gobj());
  if(c_pad)
    return Glib::wrap(c_pad); //gst_element_get_compatible_pad gives us a reference.
  else
    throw std::runtime_error("no unlinked Pad in Element '" + get_name() + "' found!");
}

Glib::RefPtr<PadTemplate> Element::get_compatible_pad_template(const Glib::RefPtr<PadTemplate>& padtemplate)
{
  GstPadTemplate* c_padtemplate = gst_element_get_compatible_pad_template(gobj(), padtemplate->gobj());
  if(c_padtemplate)
  {
    return Glib::wrap(c_padtemplate, true /* take reference */); //gst_element_get_compatible_pad_template() does not give us a reference.
  }
  else
    throw std::runtime_error("no compatible PadTemplate with '" + padtemplate->get_name() + "' in Element '" + get_name() + "' found!");
}

bool Element::query_position(Format& format) const
{
  return gst_element_query_position(const_cast<GstElement*>(gobj()), reinterpret_cast<GstFormat*>(&format), NULL);
}

bool Element::query_duration(Format& format) const
{
  return gst_element_query_duration(const_cast<GstElement*>(gobj()), reinterpret_cast<GstFormat*>(&format), NULL);
}

 // This method is written manually because an extra ref is necessary. See
 // gst_element_send_event() docs
 bool Element::send_event(const Glib::RefPtr<Event>& event)
{
  event->reference();
  gst_element_send_event(gobj(), event->gobj());
}

} //namespace Gst

namespace
{


static const Glib::SignalProxyInfo Element_signal_no_more_pads_info =
{
  "no-more-pads",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static void Element_signal_pad_added_callback(GstElement* self, GstPad* p0,void* data)
{
  using namespace Gst;
  typedef sigc::slot< void,const Glib::RefPtr<Pad>& > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Element_signal_pad_added_info =
{
  "pad-added",
  (GCallback) &Element_signal_pad_added_callback,
  (GCallback) &Element_signal_pad_added_callback
};


static void Element_signal_pad_removed_callback(GstElement* self, GstPad* p0,void* data)
{
  using namespace Gst;
  typedef sigc::slot< void,const Glib::RefPtr<Pad>& > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Element_signal_pad_removed_info =
{
  "pad-removed",
  (GCallback) &Element_signal_pad_removed_callback,
  (GCallback) &Element_signal_pad_removed_callback
};


} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gst::Element> wrap(GstElement* object, bool take_copy)
{
  return Glib::RefPtr<Gst::Element>( dynamic_cast<Gst::Element*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gst
{


/* The *_Class implementation: */

const Glib::Class& Element_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Element_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gst_element_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}

void Element_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  klass->no_more_pads = &no_more_pads_callback;
  klass->pad_added = &pad_added_callback;
  klass->pad_removed = &pad_removed_callback;
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
}

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
void Element_Class::no_more_pads_callback(GstElement* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_no_more_pads();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->no_more_pads)
    (*base->no_more_pads)(self);
}
void Element_Class::pad_added_callback(GstElement* self, GstPad* p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_pad_added(Glib::wrap(p0, true)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->pad_added)
    (*base->pad_added)(self, p0);
}
void Element_Class::pad_removed_callback(GstElement* self, GstPad* p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_pad_removed(Glib::wrap(p0, true)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->pad_removed)
    (*base->pad_removed)(self, p0);
}
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


Glib::ObjectBase* Element_Class::wrap_new(GObject* object)
{
  return new Element((GstElement*)object);
}


/* The implementation: */

GstElement* Element::gobj_copy()
{
  reference();
  return gobj();
}

Element::Element(const Glib::ConstructParams& construct_params)
:
  Object(construct_params)
{

}

Element::Element(GstElement* castitem)
:
  Object((GstObject*)(castitem))
{}

Element::~Element()
{}


Element::CppClassType Element::element_class_; // initialize static member

GType Element::get_type()
{
  return element_class_.init().get_type();
}

GType Element::get_base_type()
{
  return gst_element_get_type();
}


Element::Element()
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Object(Glib::ConstructParams(element_class_.init()))
{
  

}

bool Element::add_pad(const Glib::RefPtr<Pad>& pad)
{
  return gst_element_add_pad(gobj(), Glib::unwrap(pad));
}

Glib::RefPtr<Pad> Element::get_pad(const Glib::ustring& name)
{
  return Glib::wrap(gst_element_get_pad(gobj(), name.c_str()));
}

void Element::create_all_pads()
{
gst_element_create_all_pads(gobj()); 
}

Glib::RefPtr<Pad> Element::get_request_pad(const Glib::ustring& name)
{
  return Glib::wrap(gst_element_get_request_pad(gobj(), name.c_str()));
}

Glib::RefPtr<Pad> Element::get_static_pad(const Glib::ustring& name)
{
  return Glib::wrap(gst_element_get_static_pad(gobj(), name.c_str()));
}

void Element::no_more_pads()
{
gst_element_no_more_pads(gobj()); 
}

void Element::release_request_pad(const Glib::RefPtr<Pad>& pad)
{
gst_element_release_request_pad(gobj(), Glib::unwrap(pad)); 
}

bool Element::remove_pad(const Glib::RefPtr<Pad>& pad)
{
  return gst_element_remove_pad(gobj(), Glib::unwrap(pad));
}

void Element::unlink(const Glib::RefPtr<Element>& other_element)
{
gst_element_unlink(gobj(), Glib::unwrap(other_element)); 
}

bool Element::link_pads(const Glib::ustring& padname, const Glib::RefPtr<Element>& other_element, const Glib::ustring& others_padname)
{
  return gst_element_link_pads(gobj(), padname.c_str(), Glib::unwrap(other_element), others_padname.c_str());
}

void Element::unlink_pads(const Glib::ustring& padname, const Glib::RefPtr<Element>& other_element, const Glib::ustring& other_padname)
{
gst_element_unlink_pads(gobj(), padname.c_str(), Glib::unwrap(other_element), other_padname.c_str()); 
}

bool Element::link_pads_filtered(const char* padname, const Glib::RefPtr<Element>& other_element, const char* others_padname, const Glib::RefPtr<Caps>& filter)
{
  return gst_element_link_pads_filtered(gobj(), padname, Glib::unwrap(other_element), others_padname, Glib::unwrap(filter));
}

bool Element::link_filtered(const Glib::RefPtr<Element>& other_element, const Glib::RefPtr<Caps>& filter)
{
  return gst_element_link_filtered(gobj(), Glib::unwrap(other_element), Glib::unwrap(filter));
}

void Element::set_base_time(ClockTime time)
{
gst_element_set_base_time(gobj(), (GstClockTime (time))); 
}

ClockTime Element::get_base_time() const
{
  return gst_element_get_base_time(const_cast<GstElement*>(gobj()));
}

void Element::set_bus(const Glib::RefPtr<Bus>& bus)
{
gst_element_set_bus(gobj(), Glib::unwrap(bus)); 
}

Glib::RefPtr<Bus> Element::get_bus()
{
  return Glib::wrap(gst_element_get_bus(gobj()));
}

Glib::RefPtr<const Bus> Element::get_bus() const
{
  return const_cast<Element*>(this)->get_bus();
}

bool Element::is_indexable() const
{
  return gst_element_is_indexable(const_cast<GstElement*>(gobj()));
}

bool Element::requires_clock() const
{
  return gst_element_requires_clock(const_cast<GstElement*>(gobj()));
}

bool Element::set_clock(const Glib::RefPtr<Clock>& clock)
{
  return gst_element_set_clock(gobj(), Glib::unwrap(clock));
}

Glib::RefPtr<Clock> Element::get_clock()
{
  return Glib::wrap(gst_element_get_clock(gobj()));
}

Glib::RefPtr<const Clock> Element::get_clock() const
{
  return const_cast<Element*>(this)->get_clock();
}

bool Element::provides_clock() const
{
  return gst_element_provides_clock(const_cast<GstElement*>(gobj()));
}

Glib::RefPtr<Clock> Element::provide_clock()
{
  return Glib::wrap(gst_element_provide_clock(gobj()));
}

Glib::RefPtr<const Clock> Element::provide_clock() const
{
  return const_cast<Element*>(this)->provide_clock();
}

StateChangeReturn Element::set_state(State state)
{
  return ((StateChangeReturn)(gst_element_set_state(gobj(), ((GstState)(state)))));
}

StateChangeReturn Element::get_state(State& state, State& pending, ClockTime timeout) const
{
  return ((StateChangeReturn)(gst_element_get_state(const_cast<GstElement*>(gobj()), ((GstState*) (&(state))), ((GstState*) (&(pending))), (GstClockTime (timeout)))));
}

bool Element::set_locked_state(gboolean locked_state)
{
  return gst_element_set_locked_state(gobj(), locked_state);
}

bool Element::is_locked_state() const
{
  return gst_element_is_locked_state(const_cast<GstElement*>(gobj()));
}

void Element::abort_state()
{
gst_element_abort_state(gobj()); 
}

StateChangeReturn Element::continue_state(StateChangeReturn prestate_value)
{
  return ((StateChangeReturn)(gst_element_continue_state(gobj(), ((GstStateChangeReturn)(prestate_value)))));
}

void Element::lost_state()
{
gst_element_lost_state(gobj()); 
}

bool Element::sync_state_with_parent()
{
  return gst_element_sync_state_with_parent(gobj());
}

StateChangeReturn Element::change_state(StateChange transition)
{
  return ((StateChangeReturn)(gst_element_change_state(gobj(), ((GstStateChange)(transition)))));
}

bool Element::post_message(const Glib::RefPtr<Message>& message)
{
  return gst_element_post_message(gobj(), Glib::unwrap(message));
}

bool Element::query(const Glib::RefPtr<Query>& query)
{
  return gst_element_query(gobj(), Glib::unwrap(query));
}

bool Element::query_convert(Format src_format, gint64 src_value, Format& dst_format, gint64& dst_value) const
{
  return gst_element_query_convert(const_cast<GstElement*>(gobj()), ((GstFormat)(src_format)), src_value, ((GstFormat*) &(dst_format)), &(dst_value));
}

bool Element::query_position(Format& format, gint64& position) const
{
  return gst_element_query_position(const_cast<GstElement*>(gobj()), ((GstFormat*) &(format)), &(position));
}

bool Element::query_duration(Format& format, gint64& duration) const
{
  return gst_element_query_duration(const_cast<GstElement*>(gobj()), ((GstFormat*) &(format)), &(duration));
}

bool Element::seek(Format format, SeekFlags flags, gint64 position)
{
  return gst_element_seek_simple(gobj(), ((GstFormat)(format)), ((GstSeekFlags)(flags)), position);
}

bool Element::seek(double rate, Format format, SeekFlags flags, SeekType current_type, gint64 current_position, SeekType stop_type, gint64 stop_position)
{
  return gst_element_seek(gobj(), rate, ((GstFormat)(format)), ((GstSeekFlags)(flags)), ((GstSeekType)(current_type)), current_position, ((GstSeekType)(stop_type)), stop_position);
}


Glib::SignalProxy0< void > Element::signal_no_more_pads()
{
  return Glib::SignalProxy0< void >(this, &Element_signal_no_more_pads_info);
}


Glib::SignalProxy1< void,const Glib::RefPtr<Pad>& > Element::signal_pad_added()
{
  return Glib::SignalProxy1< void,const Glib::RefPtr<Pad>& >(this, &Element_signal_pad_added_info);
}


Glib::SignalProxy1< void,const Glib::RefPtr<Pad>& > Element::signal_pad_removed()
{
  return Glib::SignalProxy1< void,const Glib::RefPtr<Pad>& >(this, &Element_signal_pad_removed_info);
}


#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
void Gst::Element::on_no_more_pads()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->no_more_pads)
    (*base->no_more_pads)(gobj());
}
void Gst::Element::on_pad_added(const Glib::RefPtr<Pad>& new_pad)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->pad_added)
    (*base->pad_added)(gobj(),Glib::unwrap(new_pad));
}
void Gst::Element::on_pad_removed(const Glib::RefPtr<Pad>& old_pad)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->pad_removed)
    (*base->pad_removed)(gobj(),Glib::unwrap(old_pad));
}
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED


} // namespace Gst


