// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_VIDEOORIENTATION_H
#define _GSTREAMERMM_VIDEOORIENTATION_H


#include <glibmm.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/interfaces/videoorientation.h>
#include <glibmm/interface.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstVideoOrientation GstVideoOrientation;
typedef struct _GstVideoOrientationClass GstVideoOrientationClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{ class VideoOrientation_Class; } // namespace Gst
namespace Gst
{

/** Gst::VideoOrientation - Interface for elements providing video orientation
 * controls.
 * The interface allows unified access to control flipping and autocenter
 * operation of video-sources or operators.
 * @ingroup GstInterfaces
 */

class VideoOrientation : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef VideoOrientation CppObjectType;
  typedef VideoOrientation_Class CppClassType;
  typedef GstVideoOrientation BaseObjectType;
  typedef GstVideoOrientationInterface BaseClassType;

private:
  friend class VideoOrientation_Class;
  static CppClassType videoorientation_class_;

  // noncopyable
  VideoOrientation(const VideoOrientation&);
  VideoOrientation& operator=(const VideoOrientation&);

protected:
  VideoOrientation(); // you must derive from this class

  /** Called by constructors of derived classes. Provide the result of 
   * the Class init() function to ensure that it is properly 
   * initialized.
   * 
   * @param interface_class The Class object for the derived type.
   */
  explicit VideoOrientation(const Glib::Interface_Class& interface_class);

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface. 
  explicit VideoOrientation(GstVideoOrientation* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~VideoOrientation();

  static void add_interface(GType gtype_implementer);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstVideoOrientation*       gobj()       { return reinterpret_cast<GstVideoOrientation*>(gobject_); }

  ///Provides access to the underlying C GObject.  
  const GstVideoOrientation* gobj() const { return reinterpret_cast<GstVideoOrientation*>(gobject_); }

private:


public:
  
  /** Get the horizontal centering offset from the given object.
   * 
   * @newin{0,10}.11
   * @param center Return location for the result.
   * @return <tt>true</tt> in case the element supports centering.
   */
  bool get_hcenter(int& center) const;
  
  /** Get the horizontal flipping state (<tt>true</tt> for flipped) from the given object.
   * 
   * @newin{0,10}.11
   * @param flip Return location for the result.
   * @return <tt>true</tt> in case the element supports flipping.
   */

  bool get_hflip(bool& flip) const;
  
  /** Get the vertical centering offset from the given object.
   * 
   * @newin{0,10}.11
   * @param center Return location for the result.
   * @return <tt>true</tt> in case the element supports centering.
   */
  bool get_vcenter(int& center) const;
  
  /** Get the vertical flipping state (<tt>true</tt> for flipped) from the given object.
   * 
   * @newin{0,10}.11
   * @param flip Return location for the result.
   * @return <tt>true</tt> in case the element supports flipping.
   */

  bool get_vflip(bool& flip) const;
  
  /** Set the horizontal centering offset for the given object.
   * 
   * @newin{0,10}.11
   * @param center Centering offset.
   * @return <tt>true</tt> in case the element supports centering.
   */
  bool set_hcenter(int center);
  
  /** Set the horizontal flipping state (<tt>true</tt> for flipped) for the given object.
   * 
   * @newin{0,10}.11
   * @param flip Use flipping.
   * @return <tt>true</tt> in case the element supports flipping.
   */
  bool set_hflip(bool flip);
  
  /** Set the vertical centering offset for the given object.
   * 
   * @newin{0,10}.11
   * @param center Centering offset.
   * @return <tt>true</tt> in case the element supports centering.
   */
  bool set_vcenter(int center);
  
  /** Set the vertical flipping state (<tt>true</tt> for flipped) for the given object.
   * 
   * @newin{0,10}.11
   * @param flip Use flipping.
   * @return <tt>true</tt> in case the element supports flipping.
   */
  bool set_vflip(bool flip);

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual bool get_hflip_vfunc(bool& flip) const;
  virtual bool get_vflip_vfunc(bool& flip) const;
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual bool get_hcenter_vfunc(int& center) const;
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual bool get_vcenter_vfunc(int& center) const;
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual bool set_hflip_vfunc(bool flip);
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual bool set_vflip_vfunc(bool flip);
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual bool set_hcenter_vfunc(int center);
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual bool set_vcenter_vfunc(int center);
#endif //GLIBMM_VFUNCS_ENABLED


protected:

  
public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gst


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::VideoOrientation
   */
  Glib::RefPtr<Gst::VideoOrientation> wrap(GstVideoOrientation* object, bool take_copy = false);

} // namespace Glib


#endif /* _GSTREAMERMM_VIDEOORIENTATION_H */

