// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_BASEAUDIOSINK_H
#define _GSTREAMERMM_BASEAUDIOSINK_H


#include <glibmm.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/audio/gstringbuffer.h>
#include <gstreamermm/basesink.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstBaseAudioSink GstBaseAudioSink;
typedef struct _GstBaseAudioSinkClass GstBaseAudioSinkClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{ class BaseAudioSink_Class; } // namespace Gst
namespace Gst
{

class RingBuffer;

/** @addtogroup gstreamermmEnums Enums and Flags */

/**
 * @ingroup gstreamermmEnums
 */
enum BaseAudioSinkSlaveMethod
{
  BASE_AUDIO_SINK_SLAVE_RESAMPLE,
  BASE_AUDIO_SINK_SLAVE_SKEW,
  BASE_AUDIO_SINK_SLAVE_NONE
};

} // namespace Gst


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::BaseAudioSinkSlaveMethod> : public Glib::Value_Enum<Gst::BaseAudioSinkSlaveMethod>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{


/** Gst::BaseAudioSink - Base class for audio sinks.
 * This is the base class for audio sinks. Subclasses need to implement the
 * create_ringbuffer_vfunc vmethod. This base class will then take care of
 * writing samples to the ringbuffer, synchronisation, clipping and flushing.
 *
 * Last reviewed on 2006-09-27 (0.10.12).
 *
 * @ingroup GstBaseClasses
 */

class BaseAudioSink : public Gst::BaseSink
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef BaseAudioSink CppObjectType;
  typedef BaseAudioSink_Class CppClassType;
  typedef GstBaseAudioSink BaseObjectType;
  typedef GstBaseAudioSinkClass BaseClassType;

private:  friend class BaseAudioSink_Class;
  static CppClassType baseaudiosink_class_;

private:
  // noncopyable
  BaseAudioSink(const BaseAudioSink&);
  BaseAudioSink& operator=(const BaseAudioSink&);

protected:
  explicit BaseAudioSink(const Glib::ConstructParams& construct_params);
  explicit BaseAudioSink(GstBaseAudioSink* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~BaseAudioSink();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstBaseAudioSink*       gobj()       { return reinterpret_cast<GstBaseAudioSink*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GstBaseAudioSink* gobj() const { return reinterpret_cast<GstBaseAudioSink*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstBaseAudioSink* gobj_copy();

private:


public:
  /** Get the Gst::Clock of the Gst::BaseAudioSink.
   */
   Glib::RefPtr<Gst::Clock> get_provided_clock();
  Glib::RefPtr<const Gst::Clock> get_provided_clock() const;
 
  
  /** Create and return the Gst::RingBuffer for @a sink. This function will call the
   * ::create_ringbuffer vmethod and will set @a sink as the parent of the returned
   * buffer (see Gst::Object::set_parent()).
   * @return The new ringbuffer of @a sink.
   */
  Glib::RefPtr<Gst::RingBuffer> create_ring_buffer();
  
  /** Controls whether @a sink will provide a clock or not. If @a provide is <tt>true</tt>, 
   * Gst::Element::provide_clock() will return a clock that reflects the datarate
   * of @a sink. If @a provide is <tt>false</tt>, Gst::Element::provide_clock() will return <tt>0</tt>.
   * 
   * Since: 0.10.16
   * @param provide New state.
   */
  void set_provide_clock(bool provide);
  
  /** Queries whether @a sink will provide a clock or not. See also
   * gst_base_audio_sink_set_provide_clock.
   * @return <tt>true</tt> if @a sink will provide a clock.
   * 
   * Since: 0.10.16.
   */
  bool get_provide_clock() const;

  
  /** Controls how clock slaving will be performed in @a sink. 
   * 
   * Since: 0.10.16
   * @param method The new slave method.
   */
  void set_slave_method(Gst::BaseAudioSinkSlaveMethod method);
  
  /** Get the current slave method used by @a sink.
   * @return The current slave method used by @a sink.
   * 
   * Since: 0.10.16.
   */
  Gst::BaseAudioSinkSlaveMethod get_slave_method() const;

  /** vfunc to create and return a Gst::RingBuffer to write to.
   */
  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual Glib::RefPtr<Gst::RingBuffer> create_ring_buffer_vfunc();
#endif //GLIBMM_VFUNCS_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gst


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::BaseAudioSink
   */
  Glib::RefPtr<Gst::BaseAudioSink> wrap(GstBaseAudioSink* object, bool take_copy = false);
}


#endif /* _GSTREAMERMM_BASEAUDIOSINK_H */

