// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_VALUE_H
#define _GSTREAMERMM_VALUE_H


#include <glibmm.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gstvalue.h>
#include <glibmm/value_custom.h>


namespace Gst
{

/** @defgroup GstHelperClasses gstreamermm Helper Classes
 *  Classes used to represent GStreamer internal GValue types such as
 *  GST_TYPE_FRACTION, etc.
 */

/** A class that represents a 4 byte identifier (used in codecs).
 * Gst::Fourcc is used to store a four byte identifier in Gst::Structure of
 * Gst::Caps as a value representing a property (see GStreamer Application
 * Development Manual section 8.2.2 and GstValue docs).  When the value is set,
 * it is transformed to a GStreamer GType so retrieving the value is a bit
 * different.  The class can be used in setting and getting a Gst::Structure
 * field like so:
 *
 * @code
 * Glib::Value<Gst::Fourcc> value;
 * value.init(Glib::Value<Gst::Fourcc>::value_type());
 * value.set(Gst::Fourcc('M', 'J', 'P', 'G'));
 *
 * Gst::Structure structure("my-structure");
 * structure.set_field("id", value);
 * ...
 * Glib::ValueBase gst_value;
 * structure.get_field("id", gst_value);
 * Gst::Fourcc fourcc(gst_value);
 * char first_char = fourcc.first;
 * ...
 * @endcode
 * @ingroup GstHelperClasses
 */
class Fourcc
{
public:
  /** Construct an undefined Gst::Fourcc.
   */
  Fourcc();

  /** Construct a Gst::Fourcc from another.
   */
  Fourcc(const Fourcc& src);

  /** Construct a Gst::Fourcc from 4 characters.
   */
  Fourcc(char first, char second, char third, char fourth);

  /** Construct a Gst::Fourcc from an input string. Caller is responsible for
   * ensuring the input string consists of at least four characters.
   */
  explicit Fourcc(const Glib::ustring& s);

  /** Construct a Gst::Fourcc from a 32 bit unsigned integer.
   */
  explicit Fourcc(guint32 fourcc);

  /** Construct a Gst::Fourcc from a GST_TYPE_FOURCC.
   */
  explicit Fourcc(const Glib::ValueBase& gst_fourcc_value);

  /** Construct a Gst::Fourcc from a GST_TYPE_FOURCC.
   */
  explicit Fourcc(const GValue& gst_fourcc_value);

  Fourcc& operator=(const Fourcc& src);


public:
  /** Gets the four characters converted into a guint32 fourcc value with host
   * endianness.
   */
  guint32 get_fourcc() const;

public:
  char first;
  char second;
  char third;
  char fourth;

private:
  void set_ccs(guint32 fourcc);
};


/** A class that represents a fraction.
 * Gst::Fraction is used to store a fraction in Gst::Structures of Gst::Caps as
 * a value representing a property (see GStreamer Application Development
 * Manual section 8.2.2 and GstValue docs).  When the value is set, it is
 * transformed to a GStreamer GType so retrieving the value is a bit different.
 * The class can be used in setting and getting a Gst::Structure field like so:
 *
 * @code
 * Glib::Value<Gst::Fraction> value;
 * value.init(Glib::Value<Gst::Fraction>::value_type());
 * value.set(Gst::Fraction(25,1));
 *
 * Gst::Structure structure("my-structure");
 * structure.set_field("framerate", value);
 * ...
 * Glib::ValueBase gst_value;
 * structure.get_field("framerate", gst_value);
 * Gst::Fraction fract(gst_value);
 * int numerator = fract.num;
 * ...
 * @endcode
 * @ingroup GstHelperClasses
 */
class Fraction
{
public:
  /** Constructs a zero Gst::Fraction (0/1).
   */
  Fraction();

  /** Constructs a Gst::Fraction from another.
   */
  Fraction(const Fraction& src);

  /** Constructs a Gst::Fraction (num/denom).
   */
  Fraction(int num, int denom);

  /** Constructs a Gst::Fraction from a GST_TYPE_FRACTION.
   */
  explicit Fraction(const Glib::ValueBase& gst_fraction_value);

  /** Constructs a Gst::Fraction from a GST_TYPE_FRACTION.
   */
  explicit Fraction(const GValue& gst_fraction_value);

  Fraction& operator=(const Fraction& src);


public:
  int num;
  int denom;
};

//TODO: Use a template for IntRange, DoubleRange, FractionRange? murrayc

/** A class that represents an integer range (min - max).
 * Gst::IntRange is used to store an integer range in Gst::Structures of
 * Gst::Caps as a value representing a property (see GStreamer Application
 * Development Manual section 8.2.2 and GstValue docs).  When the value is set,
 * it is transformed to a GStreamer GType so retrieving the value is a bit
 * different.  The class can be used in setting and getting a Gst::Structure
 * field like so:
 *
 * @code
 * Glib::Value<Gst::IntRange> value;
 * value.init(Glib::Value<Gst::IntRange>::value_type());
 * value.set(Gst::IntRange(8000, 50000));
 *
 * Gst::Structure structure("my-structure");
 * structure.set_field("rate", value);
 * ...
 * Glib::ValueBase gst_value;
 * structure.get_field("rate", gst_value);
 * Gst::IntRange range(gst_value);
 * int max = range.max;
 * ...
 * @endcode
 * @ingroup GstHelperClasses
 */
class IntRange
{
public:
  /** Constructs a zero Gst::IntRange (0 - 0).
   */
  IntRange();

  /** Constructs an Gst::IntRange (min - max).
   */
  IntRange(int min, int max);

  /** Constructs an Gst::IntRange from another.
   */
  IntRange(const IntRange& src);

  /** Constructs an Gst::IntRange from a GST_TYPE_INT_RANGE.
   */
  explicit IntRange(const Glib::ValueBase& gst_int_range_value);

  /** Constructs an Gst::IntRange from a GST_TYPE_INT_RANGE.
   */
  explicit IntRange(const GValue& gst_int_range_value);

  IntRange& operator=(const IntRange& src);

public:
  int min;
  int max;
};

/** A class that represents a double range (min - max).
 * Gst::DoubleRange is used to use to store a double precision floating point
 * range in Gst::Structures of Gst::Caps as a value representing a property
 * (see GStreamer Application Development Manual section 8.2.2 and GstValue
 * docs).  When the value is set, it is transformed to a GStreamer GType so
 * retrieving the value is a bit different.  The class can be used in setting
 * and getting a Gst::Structure field like so:
 *
 * @code
 * Glib::Value<Gst::DoubleRange> value;
 * value.init(Glib::Value<Gst::DoubleRange>::value_type());
 * value.set(Gst::DoubleRange(44.1, 48.0));
 *
 * Gst::Structure structure("my-structure");
 * structure.set_field("rate", value);
 * ...
 * Glib::ValueBase gst_value;
 * structure.get_field("rate", gst_value);
 * Gst::DoubleRange range(gst_value);
 * double min = range.min;
 * ...
 * @endcode
 * @ingroup GstHelperClasses
 */
class DoubleRange
{
public:
  /** Constructs a zero Gst::DoubleRange (0.0 - 0.0).
   */
  DoubleRange();

  /** Constructs a Gst::DoubleRange (min - max).
   */
  DoubleRange(double min, double max);

  /** Constructs a Gst::DoubleRange from another.
   */
  DoubleRange(const DoubleRange& src);

  /** Constructs a Gst::DoubleRange from a GST_TYPE_DOUBLE_RANGE.
   */
  explicit DoubleRange(const Glib::ValueBase& gst_double_range_value);

  /** Constructs a Gst::DoubleRange from a GST_TYPE_DOUBLE_RANGE.
   */
  explicit DoubleRange(const GValue& gst_double_range_value);

  DoubleRange& operator=(const DoubleRange& src);

public:
  double min;
  double max;
};

/** A class that represents a fractional range.
 * Gst::FractionRange is used to store a fractional range in Gst::Structures of
 * Gst::Caps as a value representing a property (see GStreamer Application
 * Development Manual section 8.2.2 and GstValue docs).  When the value is set,
 * it is transformed to a GStreamer GType so retrieving the value is a bit
 * different.  The class can be used in setting and getting a Gst::Structure
 * field like so:
 *
 * @code
 * Glib::Value<Gst::FractionRange> value;
 * value.init(Glib::Value<Gst::Fraction>::value_type());
 * value.set(Gst::FractionRange(Gst::Fraction(1,2), Gst::Fraction(3,4)));
 *
 * Gst::Structure structure("my-structure");
 * structure.set_field("range", value);
 * ...
 * Glib::ValueBase gst_value;
 * structure.get_field("rate", gst_value);
 * Gst::FractionRange range(gst_value);
 * int min_numerator = range.min.num;
 * ...
 * @endcode
 * @ingroup GstHelperClasses
 */
class FractionRange
{
public:
  /** Constructs a zero Gst::FractionRange (0/1 - 0/1).
   */
  FractionRange();

  /** Constructs a Gst::FractionRange (min - max).
   */
  FractionRange(const Fraction& min, const Fraction& max);

  /** Constructs a Gst::FractionRange from another.
   */
  FractionRange(const FractionRange& src);

  /** Constructs a Gst::FractionRange from a GST_TYPE_FRACTION_RANGE.
   */
  explicit FractionRange(const Glib::ValueBase& gst_fraction_range_value);

  /** Constructs a Gst::FractionRange from a GST_TYPE_FRACTION_RANGE.
   */
  explicit FractionRange(const GValue& gst_fraction_range_value);

  FractionRange& operator=(const FractionRange& src);

public:
  Fraction min;
  Fraction max;
};

} //namespace Gst

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template<>
class Value<Gst::Fourcc> : public Value<unsigned int>
{
public:
  typedef Gst::Fourcc   CppType;
  typedef guint32       CType;

  static GType value_type() G_GNUC_CONST;

  void set(const Gst::Fourcc& data);
  Gst::Fourcc get() const;
};

template<>
class Value<Gst::IntRange> : public ValueBase_Boxed
{
public:
  typedef Gst::IntRange CppType;

  static GType value_type() G_GNUC_CONST;

  void set(const Gst::IntRange& data);
  Gst::IntRange get() const;
};

template<>
class Value<Gst::DoubleRange> : public ValueBase_Boxed
{
public:
  typedef Gst::DoubleRange CppType;

  static GType value_type() G_GNUC_CONST;

  void set(const Gst::DoubleRange& data);
  Gst::DoubleRange get() const;
};

template<>
class Value<Gst::Fraction> : public ValueBase_Boxed
{
public:
  typedef Gst::Fraction CppType;

  static GType value_type() G_GNUC_CONST;

  void set(const Gst::Fraction& data);
  Gst::Fraction get() const;
};

template<>
class Value<Gst::FractionRange> : public ValueBase_Boxed
{
public:
  typedef Gst::FractionRange CppType;

  static GType value_type() G_GNUC_CONST;

  void set(const Gst::FractionRange& data);
  Gst::FractionRange get() const;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#endif /* _GSTREAMERMM_VALUE_H */

