// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_URIHANDLER_H
#define _GSTREAMERMM_URIHANDLER_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gsturi.h>
#include <glibmm/interface.h>
#include <gstreamermm/enums.h>
#include <glibmm/arrayhandle.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstURIHandler GstURIHandler;
typedef struct _GstURIHandlerClass GstURIHandlerClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{ class URIHandler_Class; } // namespace Gst
namespace Gst
{

class Element;

/** @addtogroup gstreamermmEnums gstreamermm Enums and Flags */

/**
 * @ingroup gstreamermmEnums
 */
enum URIType
{
  URI_UNKNOWN,
  URI_SINK,
  URI_SRC
};

} // namespace Gst


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::URIType> : public Glib::Value_Enum<Gst::URIType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{


/** An interface to ease URI handling in plugins.
 * The Gst::URIHandler is an interface that is implemented by Source and Sink
 * Gst::Element to simplify then handling of URI.
 *
 * An application can use the following functions to quickly get an element
 * that handles the given URI for reading or writing (make_element_from_uri()).
 *
 * Source and Sink plugins should implement this interface when possible.
 *
 * Last reviewed on 2005-11-09 (0.9.4)
 * @ingroup GstInterfaces
 */

class URIHandler : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef URIHandler CppObjectType;
  typedef URIHandler_Class CppClassType;
  typedef GstURIHandler BaseObjectType;
  typedef GstURIHandlerInterface BaseClassType;

private:
  friend class URIHandler_Class;
  static CppClassType urihandler_class_;

  // noncopyable
  URIHandler(const URIHandler&);
  URIHandler& operator=(const URIHandler&);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */
protected:
  /**
   * You should derive from this class to use it.
   */
  URIHandler();
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  /** Called by constructors of derived classes. Provide the result of 
   * the Class init() function to ensure that it is properly 
   * initialized.
   * 
   * @param interface_class The Class object for the derived type.
   */
  explicit URIHandler(const Glib::Interface_Class& interface_class);

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface. 
  explicit URIHandler(GstURIHandler* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~URIHandler();

  static void add_interface(GType gtype_implementer);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstURIHandler*       gobj()       { return reinterpret_cast<GstURIHandler*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GstURIHandler* gobj() const { return reinterpret_cast<GstURIHandler*>(gobject_); }

private:


public:
  
  /** Tests if the given string is a valid protocol identifier. Protocols
   * must consist of alphanumeric characters, '+', '-' and '.' and must
   * start with a alphabetic character. See RFC 3986 Section 3.1.
   * @param protocol A string.
   * @return <tt>true</tt> if the string is a valid protocol identifier, <tt>false</tt> otherwise.
   */
  static bool protocol_is_valid(const Glib::ustring& protocol);
  
  /** Checks if an element exists that supports the given URI protocol. Note
   * that a positive return value does not imply that a subsequent call to
   * Gst::Element::make_from_uri() is guaranteed to work.
   * @param type Whether to check for a source or a sink.
   * @param protocol Protocol that should be checked for (e.g. "http" or "smb").
   * @return <tt>true</tt>.
   */
  static bool protocol_is_supported(const URIType type, const Glib::ustring& protocol);
  
  /** Tests if the given string is a valid URI identifier. URIs start with a valid
   * scheme followed by ":" and maybe a string identifying the location.
   * @param uri A URI string.
   * @return <tt>true</tt> if the string is a valid URI.
   */
  static bool uri_is_valid(const Glib::ustring& uri);
  
  /** Checks if the protocol of a given valid URI matches @a protocol.
   * @param uri A URI string.
   * @param protocol A protocol string (e.g. "http").
   * @return <tt>true</tt> if the protocol matches.
   */
  static bool uri_has_protocol(const Glib::ustring& uri, const Glib::ustring& protocol);
  
  /** Extracts the protocol out of a given valid URI. The returned string must be
   * freed using Glib::free().
   * @param uri A URI string.
   * @return The protocol for this URI.
   */
  static Glib::ustring get_protocol(const Glib::ustring& uri);
  
  /** Extracts the location out of a given valid URI, ie. the protocol and "://"
   * are stripped from the URI, which means that the location returned includes
   * the hostname if one is specified. The returned string must be freed using
   * Glib::free().
   * 
   * Free-function: g_free
   * @param uri A URI string.
   * @return The location for this
   * URI. Returns <tt>0</tt> if the URI isn't valid. If the URI does not contain
   * a location, an empty string is returned.
   */
  static Glib::ustring get_location(const Glib::ustring& uri);
  
  /** Constructs a URI for a given valid protocol and location.
   * 
   * Free-function: g_free
   * @param protocol Protocol for URI.
   * @param location Location for URI.
   * @return A new string for this
   * URI. Returns <tt>0</tt> if the given URI protocol is not valid, or the given
   * location is <tt>0</tt>.
   */
  static Glib::ustring construct_uri(const Glib::ustring& protocol, const Glib::ustring& location);
  
  /** Creates an element for handling the given URI.
   * @param type Whether to create a source or a sink.
   * @param uri URI to create an element for.
   * @param elementname Name of created element, can be <tt>0</tt>.
   * @return A new element or <tt>0</tt> if none could be created.
   */
  static Glib::RefPtr<Gst::Element> make_element_from_uri(const URIType type, const Glib::ustring& uri, const Glib::ustring& name);

  
  /** Gets the type of the given URI handler
   * @return The Gst::URIType of the URI handler.
   * Returns Gst::URI_UNKNOWN if the @a handler isn't implemented correctly.
   */
  guint get_uri_type() const;

 
  /** Gets the list of protocols supported by @a handler. This list may not be
   * modified.
   * @return The
   * supported protocols. Returns <tt>0</tt> if the @a handler isn't implemented
   * properly, or the @a handler doesn't support any protocols.
   */
  Glib::StringArrayHandle get_protocols() const;

  
  /** Gets the currently handled URI.
   * @return The URI currently handled by the @a handler.
   * Returns <tt>0</tt> if there are no URI currently handled. The
   * returned string must not be modified or freed.
   */
  Glib::ustring get_uri() const;
  
  /** Tries to set the URI of the given handler.
   * @param uri URI to set.
   * @return <tt>true</tt> if the URI was set successfully, else <tt>false</tt>.
   */
  bool set_uri(const Glib::ustring& uri);
  
  /** Emits the new-uri signal for a given handler, when that handler has a new URI.
   * This function should only be called by URI handlers themselves.
   * @param uri New URI or <tt>0</tt> if it was unset.
   */
  void new_uri(const Glib::ustring& uri);

  /** This signal is emitted when the URI of the uri handler has changed.
   *
* @par Slot Prototype:
   * <tt>void on_my_%new_uri(const Glib::ustring& uri)</tt>
   *
   */

  Glib::SignalProxy1< void,const Glib::ustring& > signal_new_uri();


  /** Virtual method which should be implemented to return the URI currently
   * handled by the element.
   */
    virtual Glib::ustring get_uri_vfunc() const;


  /** Virtual method which should be implemented to set a new URI.
   */
    virtual bool set_uri_vfunc(const Glib::ustring& uri);


  //TODO: The GstURIHandler vfuncs get_type(), get_protocols(), get_type_full()
  //and get_protocols_full() don't have a GstURIHandler as an argument declared
  //in the Interface structure so those seem impossible to wrap because the C++
  //callback would have no way of knowing which object's virtual function
  //should be called.


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_new_uri().
  virtual void on_new_uri(const Glib::ustring& uri);


};

} // namespace Gst


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::URIHandler
   */
  Glib::RefPtr<Gst::URIHandler> wrap(GstURIHandler* object, bool take_copy = false);

} // namespace Glib


#endif /* _GSTREAMERMM_URIHANDLER_H */

