// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_STREAMVOLUME_H
#define _GSTREAMERMM_STREAMVOLUME_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2009 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/interfaces/streamvolume.h>
#include <glibmm/interface.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstStreamVolume GstStreamVolume;
typedef struct _GstStreamVolumeClass GstStreamVolumeClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{ class StreamVolume_Class; } // namespace Gst
namespace Gst
{

/** @addtogroup gstreamermmEnums gstreamermm Enums and Flags */

/**
 * @ingroup gstreamermmEnums
 */
enum StreamVolumeFormat
{
  STREAM_VOLUME_FORMAT_LINEAR,
  STREAM_VOLUME_FORMAT_CUBIC,
  STREAM_VOLUME_FORMAT_DB
};

} // namespace Gst


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::StreamVolumeFormat> : public Glib::Value_Enum<Gst::StreamVolumeFormat>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{


/** An interface for elements that provide a stream volume.
 * @ingroup GstInterfaces
 */


class StreamVolume : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef StreamVolume CppObjectType;
  typedef StreamVolume_Class CppClassType;
  typedef GstStreamVolume BaseObjectType;
  typedef GstStreamVolumeInterface BaseClassType;

private:
  friend class StreamVolume_Class;
  static CppClassType streamvolume_class_;

  // noncopyable
  StreamVolume(const StreamVolume&);
  StreamVolume& operator=(const StreamVolume&);

protected:
  StreamVolume(); // you must derive from this class

  /** Called by constructors of derived classes. Provide the result of 
   * the Class init() function to ensure that it is properly 
   * initialized.
   * 
   * @param interface_class The Class object for the derived type.
   */
  explicit StreamVolume(const Glib::Interface_Class& interface_class);

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface. 
  explicit StreamVolume(GstStreamVolume* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~StreamVolume();

  static void add_interface(GType gtype_implementer);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstStreamVolume*       gobj()       { return reinterpret_cast<GstStreamVolume*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GstStreamVolume* gobj() const { return reinterpret_cast<GstStreamVolume*>(gobject_); }

private:


public:
  
  /** 
   * @param format Gst::StreamVolumeFormat which should be returned.
   * @return The current stream volume as linear factor.
   */
  double get_volume(Gst::StreamVolumeFormat format);
  
  /** 
   * @param format Gst::StreamVolumeFormat of @a val.
   * @param val Linear volume factor that should be set.
   */
  void set_volume(Gst::StreamVolumeFormat format, double val);
  
  /** 
   * @return Returns <tt>true</tt> if the stream is muted.
   */
  bool get_mute();
  
  /** 
   * @param mute Mute state that should be set.
   */
  void set_mute(bool mute);
  
  /** 
   * @param from Gst::StreamVolumeFormat to convert from.
   * @param to Gst::StreamVolumeFormat to convert to.
   * @param val Volume in @a from format that should be converted.
   * @return The converted volume.
   */
  static double convert_volume(Gst::StreamVolumeFormat from, Gst::StreamVolumeFormat to, double val);

  // Properties:
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Mute the audio channel without changing the volume.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_mute() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Mute the audio channel without changing the volume.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_mute() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Linear volume factor, 1.0=100%.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< double > property_volume() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Linear volume factor, 1.0=100%.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< double > property_volume() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gst


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::StreamVolume
   */
  Glib::RefPtr<Gst::StreamVolume> wrap(GstStreamVolume* object, bool take_copy = false);

} // namespace Glib


#endif /* _GSTREAMERMM_STREAMVOLUME_H */

