// Generated by gtkmmproc -- DO NOT MODIFY!


#include <glibmm.h>

#include <gstreamermm/bufferlist.h>
#include <gstreamermm/private/bufferlist_p.h>


/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008-2009 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gstreamermm/buffer.h>


extern "C"
{

static GstBufferListItem BufferList_Foreach_gstreamermm_callback(GstBuffer** buffer, guint group, guint idx, void* data)
{
  Gst::BufferList::SlotForeach* the_slot =
    static_cast<Gst::BufferList::SlotForeach*>(data);

  try
  {
    // First wrap the original buffer.
    Glib::RefPtr<Gst::Buffer> temp = Gst::wrap(*buffer, true);

    // Call the slot which can modify the buffer (ie. set it to a new one or
    // clear it altogether).
    GstBufferListItem const result =
      static_cast<GstBufferListItem>((*the_slot)(temp, group, idx));

    // Set the reference to the buffer according to how the temp buffer has
    // been altered.
    if(!temp)
    {
      // Clear the reference to the original buffer also.
      *buffer = 0;
    }
    else if(*buffer != temp->gobj())
    {
      // The temp buffer has been set to a new one so make the reference point
      // to it and take an extra reference for when the temp wrapper is
      // destroyed (I think that's right).
      *buffer = temp->gobj();
      temp->reference();
    }

    return result;
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  return GST_BUFFER_LIST_CONTINUE;
}

static GstBuffer* BufferListIterator_Process_gstreamermm_callback(GstBuffer* buffer, void* data)
{
  Gst::BufferListIterator::SlotProcess* the_slot =
    static_cast<Gst::BufferListIterator::SlotProcess*>(data);

  try
  {
    Glib::RefPtr<Gst::Buffer> result = (*the_slot)(Gst::wrap(buffer, true));

    if(result)
      return result->gobj_copy();
    else
      return 0;
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  return 0;
}

} // extern "C"


namespace Gst
{

bool BufferList::is_writable() const
{
  return static_cast<bool>(gst_buffer_list_is_writable(gobj()));
}

Glib::RefPtr<BufferList> BufferList::create_writable()
{
  return Gst::wrap(gst_buffer_list_make_writable(gobj()));
}

guint BufferList::n_groups() const
{
  return gst_buffer_list_n_groups(const_cast<GstBufferList*>(gobj()));
}

void BufferList::foreach(const SlotForeach& slot)
{
  gst_buffer_list_foreach(gobj(), &BufferList_Foreach_gstreamermm_callback,
    const_cast<SlotForeach*>(&slot));
}

void BufferList::iterate(BufferListIterator& result)
{
  result.set_gobject(gst_buffer_list_iterate(gobj()));
}

BufferListIterator::BufferListIterator()
: gobject_(0),
  take_ownership(false)
{
}

BufferListIterator::BufferListIterator(GstBufferListIterator* castitem,
  bool take_ownership)
: gobject_(castitem),
  take_ownership(take_ownership)
{
}

void BufferListIterator::set_gobject(GstBufferListIterator* castitem,
  bool take_ownership)
{
  if(gobject_ && take_ownership)
    gst_buffer_list_iterator_free(gobject_);

  gobject_ = castitem;
  this->take_ownership = take_ownership;
}

BufferListIterator::~BufferListIterator()
{
  if(take_ownership && gobject_)
    gst_buffer_list_iterator_free(gobject_);
}

Glib::RefPtr<Gst::Buffer> BufferListIterator::process(const SlotProcess& slot)
{
  return Gst::wrap(gst_buffer_list_iterator_do(gobj(),
    &BufferListIterator_Process_gstreamermm_callback,
    const_cast<SlotProcess*>(&slot)));
}

} //namespace Gst

namespace
{
} // anonymous namespace


namespace Gst
{

Glib::RefPtr<Gst::BufferList> wrap(GstBufferList* object, bool take_copy)
{
  //Note that we use Gst::wrap() instead of Glib::wrap() 
  //because we are dealing with a GstMiniObject, not a GObject:
  return Glib::RefPtr<Gst::BufferList>( dynamic_cast<Gst::BufferList*> (Gst::wrap_auto ((GstMiniObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Gst */


namespace Gst
{


/* The *_Class implementation: */

const Glib::Class& BufferList_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &BufferList_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gst_buffer_list_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}


void BufferList_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);


}


Gst::MiniObject* BufferList_Class::wrap_new(GstMiniObject* object)
{
  return new BufferList((GstBufferList*)object);
}


/* The implementation: */

GstBufferList* BufferList::gobj_copy()
{
  // Use the mini object copying function to get a copy of the underlying
  // gobject instead of referencing and returning the underlying gobject as
  // would be done normally:
  return reinterpret_cast<GstBufferList*>(gst_mini_object_copy(reinterpret_cast<GstMiniObject*>(gobj())));
}


BufferList::BufferList(GstBufferList* castitem)
:
  Gst::MiniObject((GstMiniObject*)(castitem))
{}

BufferList::~BufferList()
{}


BufferList::CppClassType BufferList::bufferlist_class_; // initialize static member

GType BufferList::get_type()
{
  return bufferlist_class_.init().get_type();
}


GType BufferList::get_base_type()
{
  return gst_buffer_list_get_type();
}


Glib::RefPtr<BufferList> BufferList::create()
{
  return Gst::wrap(gst_buffer_list_new());
}


Glib::RefPtr<Gst::Buffer> BufferList::get(guint group, guint idx)
{
  return Gst::wrap(gst_buffer_list_get(gobj(), group, idx));
}

Glib::RefPtr<const Gst::Buffer> BufferList::get(guint group, guint idx) const
{
  return const_cast<BufferList*>(this)->get(group, idx);
}


} // namespace Gst


namespace Gst
{


guint BufferListIterator::n_buffers() const
{
  return gst_buffer_list_iterator_n_buffers(const_cast<GstBufferListIterator*>(gobj()));
}

void BufferListIterator::add(const Glib::RefPtr<Gst::Buffer>& buffer)
{
  gst_buffer_list_iterator_add(gobj(), Gst::unwrap(buffer)); 
}

void BufferListIterator::add_group()
{
  gst_buffer_list_iterator_add_group(gobj()); 
}

Glib::RefPtr<Gst::Buffer> BufferListIterator::next()
{
  return Gst::wrap(gst_buffer_list_iterator_next(gobj()));
}

Glib::RefPtr<const Gst::Buffer> BufferListIterator::next() const
{
  return const_cast<BufferListIterator*>(this)->next();
}

bool BufferListIterator::next_group()
{
  return gst_buffer_list_iterator_next_group(gobj());
}

void BufferListIterator::remove()
{
  gst_buffer_list_iterator_remove(gobj()); 
}

Glib::RefPtr<Gst::Buffer> BufferListIterator::steal()
{
  return Gst::wrap(gst_buffer_list_iterator_steal(gobj()));
}

void BufferListIterator::take(const Glib::RefPtr<Gst::Buffer>& buffer)
{
  gst_buffer_list_iterator_take(gobj(), Gst::unwrap(buffer)); 
}

Glib::RefPtr<Gst::Buffer> BufferListIterator::merge_group()
{
  return Gst::wrap(gst_buffer_list_iterator_merge_group(gobj()));
}


} // namespace Gst


