
#include <glib.h>

// Disable the 'const' function attribute of the get_type() functions.
// GCC would optimize them out because we don't use the return value.
#undef  G_GNUC_CONST
#define G_GNUC_CONST /* empty */

#include <gstreamermm/wrap_init.h>
#include <glibmm/error.h>
#include <glibmm/object.h>

// #include the widget headers so that we can call the get_type() static methods:

#include "bin.h"
#include "buffer.h"
#include "bus.h"
#include "caps.h"
#include "childproxy.h"
#include "clock.h"
#include "element.h"
#include "elementfactory.h"
#include "enums.h"
#include "error.h"
#include "event.h"
#include "filter.h"
#include "format.h"
#include "index.h"
#include "ghostpad.h"
#include "indexfactory.h"
#include "interface.h"
#include "iterator.h"
#include "message.h"
#include "pad.h"
#include "padtemplate.h"
#include "parse.h"
#include "pipeline.h"
#include "plugin.h"
#include "pluginfeature.h"
#include "preset.h"
#include "query.h"
#include "registry.h"
#include "segment.h"
#include "structure.h"
#include "systemclock.h"
#include "taglist.h"
#include "tagsetter.h"
#include "task.h"
#include "urihandler.h"
#include "value.h"
#include "xml.h"
#include "basesrc.h"
#include "basesink.h"
#include "basetransform.h"
#include "pushsrc.h"
#include "audioclock.h"
#include "audiofilter.h"
#include "audiosink.h"
#include "audiosrc.h"
#include "baseaudiosink.h"
#include "baseaudiosrc.h"
#include "cddabasesrc.h"
#include "videosink.h"
#include "colorbalance.h"
#include "colorbalancechannel.h"
#include "mixer.h"
#include "mixeroptions.h"
#include "mixertrack.h"
#include "navigation.h"
#include "propertyprobe.h"
#include "tuner.h"
#include "tunerchannel.h"
#include "tunernorm.h"
#include "videoorientation.h"
#include "xoverlay.h"
#include "capsfilter.h"
#include "fakesrc.h"
#include "fakesink.h"
#include "fdsink.h"
#include "fdsrc.h"
#include "filesrc.h"
#include "filesink.h"
#include "identity.h"
#include "multiqueue.h"
#include "queue.h"
#include "tee.h"
#include "typefindelement.h"
#include "adder.h"
#include "alsamixer.h"
#include "alsasink.h"
#include "alsasrc.h"
#include "audioconvert.h"
#include "audioresample.h"
#include "audiotestsrc.h"
#include "cdparanoiasrc.h"
#include "clockoverlay.h"
#include "decodebin.h"
#include "ffmpegcolorspace.h"
#include "gdpdepay.h"
#include "gdppay.h"
#include "giosink.h"
#include "giosrc.h"
#include "giostreamsink.h"
#include "giostreamsrc.h"
#include "oggdemux.h"
#include "oggmux.h"
#include "playbin2.h"
#include "textoverlay.h"
#include "textrender.h"
#include "theoradec.h"
#include "theoraenc.h"
#include "timeoverlay.h"
#include "videorate.h"
#include "videoscale.h"
#include "videotestsrc.h"
#include "volume.h"
#include "vorbisdec.h"
#include "vorbisenc.h"
#include "vorbisparse.h"
#include "vorbistag.h"
#include "ximagesink.h"
#include "xvimagesink.h"

extern "C"
{

//Declarations of the *_get_type() functions:

#ifdef GSTREAMERMM_PLUGIN_ADDER
GType gst_adder_get_type(void);
#endif //GSTREAMERMM_PLUGIN_ADDER
#ifdef GSTREAMERMM_PLUGIN_ALSAMIXER
GType gst_alsa_mixer_element_get_type(void);
#endif //GSTREAMERMM_PLUGIN_ALSAMIXER
#ifdef GSTREAMERMM_PLUGIN_ALSASINK
GType gst_alsa_sink_get_type(void);
#endif //GSTREAMERMM_PLUGIN_ALSASINK
#ifdef GSTREAMERMM_PLUGIN_ALSASRC
GType gst_alsa_src_get_type(void);
#endif //GSTREAMERMM_PLUGIN_ALSASRC
GType gst_audio_clock_get_type(void);
#ifdef GSTREAMERMM_PLUGIN_AUDIOCONVERT
GType gst_audio_convert_get_type(void);
#endif //GSTREAMERMM_PLUGIN_AUDIOCONVERT
GType gst_audio_filter_get_type(void);
#ifdef GSTREAMERMM_PLUGIN_AUDIORESAMPLE
GType gst_audio_resample_get_type(void);
#endif //GSTREAMERMM_PLUGIN_AUDIORESAMPLE
GType gst_audio_sink_get_type(void);
GType gst_audio_src_get_type(void);
#ifdef GSTREAMERMM_PLUGIN_AUDIOTESTSRC
GType gst_audio_test_src_get_type(void);
#endif //GSTREAMERMM_PLUGIN_AUDIOTESTSRC
GType gst_base_audio_sink_get_type(void);
GType gst_base_audio_src_get_type(void);
GType gst_base_sink_get_type(void);
GType gst_base_src_get_type(void);
GType gst_base_transform_get_type(void);
GType gst_bin_get_type(void);
GType gst_bus_get_type(void);
#ifdef GSTREAMERMM_PLUGIN_CAPSFILTER
GType gst_caps_filter_get_type(void);
#endif //GSTREAMERMM_PLUGIN_CAPSFILTER
#ifdef GSTREAMERMM_PLUGIN_CDPARANOIASRC
GType gst_cd_paranoia_src_get_type(void);
#endif //GSTREAMERMM_PLUGIN_CDPARANOIASRC
GType gst_cdda_base_src_get_type(void);
GType gst_clock_get_type(void);
#ifdef GSTREAMERMM_PLUGIN_CLOCKOVERLAY
GType gst_clock_overlay_get_type(void);
#endif //GSTREAMERMM_PLUGIN_CLOCKOVERLAY
GType gst_color_balance_channel_get_type(void);
#ifdef GSTREAMERMM_PLUGIN_DECODEBIN
GType gst_decode_bin_get_type(void);
#endif //GSTREAMERMM_PLUGIN_DECODEBIN
GType gst_element_get_type(void);
GType gst_element_factory_get_type(void);
#ifdef GSTREAMERMM_PLUGIN_FAKESINK
GType gst_fake_sink_get_type(void);
#endif //GSTREAMERMM_PLUGIN_FAKESINK
#ifdef GSTREAMERMM_PLUGIN_FAKESRC
GType gst_fake_src_get_type(void);
#endif //GSTREAMERMM_PLUGIN_FAKESRC
#ifdef GSTREAMERMM_PLUGIN_FDSINK
GType gst_fd_sink_get_type(void);
#endif //GSTREAMERMM_PLUGIN_FDSINK
#ifdef GSTREAMERMM_PLUGIN_FDSRC
GType gst_fd_src_get_type(void);
#endif //GSTREAMERMM_PLUGIN_FDSRC
#ifdef GSTREAMERMM_PLUGIN_FFMPEGCOLORSPACE
GType gst_ff_mpeg_csp_get_type(void);
#endif //GSTREAMERMM_PLUGIN_FFMPEGCOLORSPACE
#ifdef GSTREAMERMM_PLUGIN_FILESINK
GType gst_file_sink_get_type(void);
#endif //GSTREAMERMM_PLUGIN_FILESINK
#ifdef GSTREAMERMM_PLUGIN_FILESRC
GType gst_file_src_get_type(void);
#endif //GSTREAMERMM_PLUGIN_FILESRC
#ifdef GSTREAMERMM_PLUGIN_GDPDEPAY
GType gst_gd_p_depay_get_type(void);
#endif //GSTREAMERMM_PLUGIN_GDPDEPAY
#ifdef GSTREAMERMM_PLUGIN_GDPPAY
GType gst_gd_p_pay_get_type(void);
#endif //GSTREAMERMM_PLUGIN_GDPPAY
GType gst_ghost_pad_get_type(void);
#ifdef GSTREAMERMM_PLUGIN_GIOSINK
GType gst_gio_sink_get_type(void);
#endif //GSTREAMERMM_PLUGIN_GIOSINK
#ifdef GSTREAMERMM_PLUGIN_GIOSRC
GType gst_gio_src_get_type(void);
#endif //GSTREAMERMM_PLUGIN_GIOSRC
#ifdef GSTREAMERMM_PLUGIN_GIOSTREAMSINK
GType gst_gio_stream_sink_get_type(void);
#endif //GSTREAMERMM_PLUGIN_GIOSTREAMSINK
#ifdef GSTREAMERMM_PLUGIN_GIOSTREAMSRC
GType gst_gio_stream_src_get_type(void);
#endif //GSTREAMERMM_PLUGIN_GIOSTREAMSRC
#ifdef GSTREAMERMM_PLUGIN_IDENTITY
GType gst_identity_get_type(void);
#endif //GSTREAMERMM_PLUGIN_IDENTITY
GType gst_index_get_type(void);
GType gst_index_factory_get_type(void);
GType gst_mixer_options_get_type(void);
GType gst_mixer_track_get_type(void);
#ifdef GSTREAMERMM_PLUGIN_MULTIQUEUE
GType gst_multi_queue_get_type(void);
#endif //GSTREAMERMM_PLUGIN_MULTIQUEUE
#ifdef GSTREAMERMM_PLUGIN_OGGDEMUX
GType gst_ogg_demux_get_type(void);
#endif //GSTREAMERMM_PLUGIN_OGGDEMUX
#ifdef GSTREAMERMM_PLUGIN_OGGMUX
GType gst_ogg_mux_get_type(void);
#endif //GSTREAMERMM_PLUGIN_OGGMUX
GType gst_pad_get_type(void);
GType gst_pad_template_get_type(void);
GType gst_pipeline_get_type(void);
#ifdef GSTREAMERMM_PLUGIN_PLAYBIN2
GType gst_play_bin2_get_type(void);
#endif //GSTREAMERMM_PLUGIN_PLAYBIN2
GType gst_plugin_get_type(void);
GType gst_plugin_feature_get_type(void);
GType gst_push_src_get_type(void);
#ifdef GSTREAMERMM_PLUGIN_QUEUE
GType gst_queue_get_type(void);
#endif //GSTREAMERMM_PLUGIN_QUEUE
GType gst_registry_get_type(void);
GType gst_system_clock_get_type(void);
GType gst_task_get_type(void);
#ifdef GSTREAMERMM_PLUGIN_TEE
GType gst_tee_get_type(void);
#endif //GSTREAMERMM_PLUGIN_TEE
#ifdef GSTREAMERMM_PLUGIN_TEXTOVERLAY
GType gst_text_overlay_get_type(void);
#endif //GSTREAMERMM_PLUGIN_TEXTOVERLAY
#ifdef GSTREAMERMM_PLUGIN_TEXTRENDER
GType gst_text_render_get_type(void);
#endif //GSTREAMERMM_PLUGIN_TEXTRENDER
#ifdef GSTREAMERMM_PLUGIN_THEORADEC
GType gst_theora_dec_get_type(void);
#endif //GSTREAMERMM_PLUGIN_THEORADEC
#ifdef GSTREAMERMM_PLUGIN_THEORAENC
GType gst_theora_enc_get_type(void);
#endif //GSTREAMERMM_PLUGIN_THEORAENC
#ifdef GSTREAMERMM_PLUGIN_TIMEOVERLAY
GType gst_time_overlay_get_type(void);
#endif //GSTREAMERMM_PLUGIN_TIMEOVERLAY
GType gst_tuner_channel_get_type(void);
GType gst_tuner_norm_get_type(void);
#ifdef GSTREAMERMM_PLUGIN_TYPEFINDELEMENT
GType gst_type_find_element_get_type(void);
#endif //GSTREAMERMM_PLUGIN_TYPEFINDELEMENT
#ifdef GSTREAMERMM_PLUGIN_VIDEORATE
GType gst_video_rate_get_type(void);
#endif //GSTREAMERMM_PLUGIN_VIDEORATE
#ifdef GSTREAMERMM_PLUGIN_VIDEOSCALE
GType gst_video_scale_get_type(void);
#endif //GSTREAMERMM_PLUGIN_VIDEOSCALE
GType gst_video_sink_get_type(void);
#ifdef GSTREAMERMM_PLUGIN_VIDEOTESTSRC
GType gst_video_test_src_get_type(void);
#endif //GSTREAMERMM_PLUGIN_VIDEOTESTSRC
#ifdef GSTREAMERMM_PLUGIN_VOLUME
GType gst_volume_get_type(void);
#endif //GSTREAMERMM_PLUGIN_VOLUME
#ifdef GSTREAMERMM_PLUGIN_VORBISDEC
GType gst_vorbis_dec_get_type(void);
#endif //GSTREAMERMM_PLUGIN_VORBISDEC
#ifdef GSTREAMERMM_PLUGIN_VORBISENC
GType gst_vorbis_enc_get_type(void);
#endif //GSTREAMERMM_PLUGIN_VORBISENC
#ifdef GSTREAMERMM_PLUGIN_VORBISPARSE
GType gst_vorbis_parse_get_type(void);
#endif //GSTREAMERMM_PLUGIN_VORBISPARSE
#ifdef GSTREAMERMM_PLUGIN_VORBISTAG
GType gst_vorbis_tag_get_type(void);
#endif //GSTREAMERMM_PLUGIN_VORBISTAG
#ifdef GSTREAMERMM_PLUGIN_XIMAGESINK
GType gst_ximage_sink_get_type(void);
#endif //GSTREAMERMM_PLUGIN_XIMAGESINK
GType gst_xml_get_type(void);
#ifdef GSTREAMERMM_PLUGIN_XVIMAGESINK
GType gst_xv_image_sink_get_type(void);
#endif //GSTREAMERMM_PLUGIN_XVIMAGESINK

//Declarations of the *_error_quark() functions:

GQuark gst_core_error_quark(void);
GQuark gst_library_error_quark(void);
GQuark gst_parse_error_quark(void);
GQuark gst_plugin_error_quark(void);
GQuark gst_resource_error_quark(void);
GQuark gst_stream_error_quark(void);
} // extern "C"


//Declarations of the *_Class::wrap_new() methods, instead of including all the private headers:

#ifdef GSTREAMERMM_PLUGIN_ADDER
namespace Gst {  class Adder_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#endif //GSTREAMERMM_PLUGIN_ADDER
#ifdef GSTREAMERMM_PLUGIN_ALSAMIXER
namespace Gst {  class AlsaMixer_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#endif //GSTREAMERMM_PLUGIN_ALSAMIXER
#ifdef GSTREAMERMM_PLUGIN_ALSASINK
namespace Gst {  class AlsaSink_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#endif //GSTREAMERMM_PLUGIN_ALSASINK
#ifdef GSTREAMERMM_PLUGIN_ALSASRC
namespace Gst {  class AlsaSrc_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#endif //GSTREAMERMM_PLUGIN_ALSASRC
namespace Gst {  class AudioClock_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#ifdef GSTREAMERMM_PLUGIN_AUDIOCONVERT
namespace Gst {  class AudioConvert_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#endif //GSTREAMERMM_PLUGIN_AUDIOCONVERT
namespace Gst {  class AudioFilter_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#ifdef GSTREAMERMM_PLUGIN_AUDIORESAMPLE
namespace Gst {  class AudioResample_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#endif //GSTREAMERMM_PLUGIN_AUDIORESAMPLE
namespace Gst {  class AudioSink_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class AudioSrc_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#ifdef GSTREAMERMM_PLUGIN_AUDIOTESTSRC
namespace Gst {  class AudioTestSrc_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#endif //GSTREAMERMM_PLUGIN_AUDIOTESTSRC
namespace Gst {  class BaseAudioSink_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class BaseAudioSrc_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class BaseSink_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class BaseSrc_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class BaseTransform_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class Bin_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class Bus_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#ifdef GSTREAMERMM_PLUGIN_CAPSFILTER
namespace Gst {  class CapsFilter_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#endif //GSTREAMERMM_PLUGIN_CAPSFILTER
#ifdef GSTREAMERMM_PLUGIN_CDPARANOIASRC
namespace Gst {  class CdParanoiaSrc_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#endif //GSTREAMERMM_PLUGIN_CDPARANOIASRC
namespace Gst {  class CddaBaseSrc_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class Clock_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#ifdef GSTREAMERMM_PLUGIN_CLOCKOVERLAY
namespace Gst {  class ClockOverlay_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#endif //GSTREAMERMM_PLUGIN_CLOCKOVERLAY
namespace Gst {  class ColorBalanceChannel_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#ifdef GSTREAMERMM_PLUGIN_DECODEBIN
namespace Gst {  class DecodeBin_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#endif //GSTREAMERMM_PLUGIN_DECODEBIN
namespace Gst {  class Element_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class ElementFactory_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#ifdef GSTREAMERMM_PLUGIN_FAKESINK
namespace Gst {  class FakeSink_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#endif //GSTREAMERMM_PLUGIN_FAKESINK
#ifdef GSTREAMERMM_PLUGIN_FAKESRC
namespace Gst {  class FakeSrc_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#endif //GSTREAMERMM_PLUGIN_FAKESRC
#ifdef GSTREAMERMM_PLUGIN_FDSINK
namespace Gst {  class FdSink_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#endif //GSTREAMERMM_PLUGIN_FDSINK
#ifdef GSTREAMERMM_PLUGIN_FDSRC
namespace Gst {  class FdSrc_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#endif //GSTREAMERMM_PLUGIN_FDSRC
#ifdef GSTREAMERMM_PLUGIN_FFMPEGCOLORSPACE
namespace Gst {  class FfmpegColorSpace_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#endif //GSTREAMERMM_PLUGIN_FFMPEGCOLORSPACE
#ifdef GSTREAMERMM_PLUGIN_FILESINK
namespace Gst {  class FileSink_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#endif //GSTREAMERMM_PLUGIN_FILESINK
#ifdef GSTREAMERMM_PLUGIN_FILESRC
namespace Gst {  class FileSrc_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#endif //GSTREAMERMM_PLUGIN_FILESRC
#ifdef GSTREAMERMM_PLUGIN_GDPDEPAY
namespace Gst {  class GDPDepay_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#endif //GSTREAMERMM_PLUGIN_GDPDEPAY
#ifdef GSTREAMERMM_PLUGIN_GDPPAY
namespace Gst {  class GDPPay_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#endif //GSTREAMERMM_PLUGIN_GDPPAY
namespace Gst {  class GhostPad_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#ifdef GSTREAMERMM_PLUGIN_GIOSINK
namespace Gst {  class GioSink_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#endif //GSTREAMERMM_PLUGIN_GIOSINK
#ifdef GSTREAMERMM_PLUGIN_GIOSRC
namespace Gst {  class GioSrc_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#endif //GSTREAMERMM_PLUGIN_GIOSRC
#ifdef GSTREAMERMM_PLUGIN_GIOSTREAMSINK
namespace Gst {  class GioStreamSink_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#endif //GSTREAMERMM_PLUGIN_GIOSTREAMSINK
#ifdef GSTREAMERMM_PLUGIN_GIOSTREAMSRC
namespace Gst {  class GioStreamSrc_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#endif //GSTREAMERMM_PLUGIN_GIOSTREAMSRC
#ifdef GSTREAMERMM_PLUGIN_IDENTITY
namespace Gst {  class Identity_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#endif //GSTREAMERMM_PLUGIN_IDENTITY
namespace Gst {  class Index_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class IndexFactory_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class MixerOptions_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class MixerTrack_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#ifdef GSTREAMERMM_PLUGIN_MULTIQUEUE
namespace Gst {  class MultiQueue_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#endif //GSTREAMERMM_PLUGIN_MULTIQUEUE
#ifdef GSTREAMERMM_PLUGIN_OGGDEMUX
namespace Gst {  class OggDemux_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#endif //GSTREAMERMM_PLUGIN_OGGDEMUX
#ifdef GSTREAMERMM_PLUGIN_OGGMUX
namespace Gst {  class OggMux_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#endif //GSTREAMERMM_PLUGIN_OGGMUX
namespace Gst {  class Pad_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class PadTemplate_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class Pipeline_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#ifdef GSTREAMERMM_PLUGIN_PLAYBIN2
namespace Gst {  class PlayBin2_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#endif //GSTREAMERMM_PLUGIN_PLAYBIN2
namespace Gst {  class Plugin_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class PluginFeature_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class PushSrc_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#ifdef GSTREAMERMM_PLUGIN_QUEUE
namespace Gst {  class Queue_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#endif //GSTREAMERMM_PLUGIN_QUEUE
namespace Gst {  class Registry_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class SystemClock_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class Task_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#ifdef GSTREAMERMM_PLUGIN_TEE
namespace Gst {  class Tee_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#endif //GSTREAMERMM_PLUGIN_TEE
#ifdef GSTREAMERMM_PLUGIN_TEXTOVERLAY
namespace Gst {  class TextOverlay_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#endif //GSTREAMERMM_PLUGIN_TEXTOVERLAY
#ifdef GSTREAMERMM_PLUGIN_TEXTRENDER
namespace Gst {  class TextRender_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#endif //GSTREAMERMM_PLUGIN_TEXTRENDER
#ifdef GSTREAMERMM_PLUGIN_THEORADEC
namespace Gst {  class TheoraDec_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#endif //GSTREAMERMM_PLUGIN_THEORADEC
#ifdef GSTREAMERMM_PLUGIN_THEORAENC
namespace Gst {  class TheoraEnc_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#endif //GSTREAMERMM_PLUGIN_THEORAENC
#ifdef GSTREAMERMM_PLUGIN_TIMEOVERLAY
namespace Gst {  class TimeOverlay_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#endif //GSTREAMERMM_PLUGIN_TIMEOVERLAY
namespace Gst {  class TunerChannel_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class TunerNorm_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#ifdef GSTREAMERMM_PLUGIN_TYPEFINDELEMENT
namespace Gst {  class TypeFindElement_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#endif //GSTREAMERMM_PLUGIN_TYPEFINDELEMENT
#ifdef GSTREAMERMM_PLUGIN_VIDEORATE
namespace Gst {  class VideoRate_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#endif //GSTREAMERMM_PLUGIN_VIDEORATE
#ifdef GSTREAMERMM_PLUGIN_VIDEOSCALE
namespace Gst {  class VideoScale_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#endif //GSTREAMERMM_PLUGIN_VIDEOSCALE
namespace Gst {  class VideoSink_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#ifdef GSTREAMERMM_PLUGIN_VIDEOTESTSRC
namespace Gst {  class VideoTestSrc_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#endif //GSTREAMERMM_PLUGIN_VIDEOTESTSRC
#ifdef GSTREAMERMM_PLUGIN_VOLUME
namespace Gst {  class Volume_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#endif //GSTREAMERMM_PLUGIN_VOLUME
#ifdef GSTREAMERMM_PLUGIN_VORBISDEC
namespace Gst {  class VorbisDec_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#endif //GSTREAMERMM_PLUGIN_VORBISDEC
#ifdef GSTREAMERMM_PLUGIN_VORBISENC
namespace Gst {  class VorbisEnc_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#endif //GSTREAMERMM_PLUGIN_VORBISENC
#ifdef GSTREAMERMM_PLUGIN_VORBISPARSE
namespace Gst {  class VorbisParse_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#endif //GSTREAMERMM_PLUGIN_VORBISPARSE
#ifdef GSTREAMERMM_PLUGIN_VORBISTAG
namespace Gst {  class VorbisTag_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#endif //GSTREAMERMM_PLUGIN_VORBISTAG
#ifdef GSTREAMERMM_PLUGIN_XIMAGESINK
namespace Gst {  class XImageSink_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#endif //GSTREAMERMM_PLUGIN_XIMAGESINK
namespace Gst {  class XML_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#ifdef GSTREAMERMM_PLUGIN_XVIMAGESINK
namespace Gst {  class XvImageSink_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
#endif //GSTREAMERMM_PLUGIN_XVIMAGESINK

namespace Gst { 

void wrap_init()
{
  // Register Error domains:
  Glib::Error::register_domain(gst_core_error_quark(), &Gst::CoreError::throw_func);
  Glib::Error::register_domain(gst_library_error_quark(), &Gst::LibraryError::throw_func);
  Glib::Error::register_domain(gst_parse_error_quark(), &Gst::ParseError::throw_func);
  Glib::Error::register_domain(gst_plugin_error_quark(), &Gst::PluginError::throw_func);
  Glib::Error::register_domain(gst_resource_error_quark(), &Gst::ResourceError::throw_func);
  Glib::Error::register_domain(gst_stream_error_quark(), &Gst::StreamError::throw_func);

// Map gtypes to gtkmm wrapper-creation functions:
#ifdef GSTREAMERMM_PLUGIN_ADDER
  Glib::wrap_register(gst_adder_get_type(), &Gst::Adder_Class::wrap_new);
#endif //GSTREAMERMM_PLUGIN_ADDER
#ifdef GSTREAMERMM_PLUGIN_ALSAMIXER
  Glib::wrap_register(gst_alsa_mixer_element_get_type(), &Gst::AlsaMixer_Class::wrap_new);
#endif //GSTREAMERMM_PLUGIN_ALSAMIXER
#ifdef GSTREAMERMM_PLUGIN_ALSASINK
  Glib::wrap_register(gst_alsa_sink_get_type(), &Gst::AlsaSink_Class::wrap_new);
#endif //GSTREAMERMM_PLUGIN_ALSASINK
#ifdef GSTREAMERMM_PLUGIN_ALSASRC
  Glib::wrap_register(gst_alsa_src_get_type(), &Gst::AlsaSrc_Class::wrap_new);
#endif //GSTREAMERMM_PLUGIN_ALSASRC
  Glib::wrap_register(gst_audio_clock_get_type(), &Gst::AudioClock_Class::wrap_new);
#ifdef GSTREAMERMM_PLUGIN_AUDIOCONVERT
  Glib::wrap_register(gst_audio_convert_get_type(), &Gst::AudioConvert_Class::wrap_new);
#endif //GSTREAMERMM_PLUGIN_AUDIOCONVERT
  Glib::wrap_register(gst_audio_filter_get_type(), &Gst::AudioFilter_Class::wrap_new);
#ifdef GSTREAMERMM_PLUGIN_AUDIORESAMPLE
  Glib::wrap_register(gst_audio_resample_get_type(), &Gst::AudioResample_Class::wrap_new);
#endif //GSTREAMERMM_PLUGIN_AUDIORESAMPLE
  Glib::wrap_register(gst_audio_sink_get_type(), &Gst::AudioSink_Class::wrap_new);
  Glib::wrap_register(gst_audio_src_get_type(), &Gst::AudioSrc_Class::wrap_new);
#ifdef GSTREAMERMM_PLUGIN_AUDIOTESTSRC
  Glib::wrap_register(gst_audio_test_src_get_type(), &Gst::AudioTestSrc_Class::wrap_new);
#endif //GSTREAMERMM_PLUGIN_AUDIOTESTSRC
  Glib::wrap_register(gst_base_audio_sink_get_type(), &Gst::BaseAudioSink_Class::wrap_new);
  Glib::wrap_register(gst_base_audio_src_get_type(), &Gst::BaseAudioSrc_Class::wrap_new);
  Glib::wrap_register(gst_base_sink_get_type(), &Gst::BaseSink_Class::wrap_new);
  Glib::wrap_register(gst_base_src_get_type(), &Gst::BaseSrc_Class::wrap_new);
  Glib::wrap_register(gst_base_transform_get_type(), &Gst::BaseTransform_Class::wrap_new);
  Glib::wrap_register(gst_bin_get_type(), &Gst::Bin_Class::wrap_new);
  Glib::wrap_register(gst_bus_get_type(), &Gst::Bus_Class::wrap_new);
#ifdef GSTREAMERMM_PLUGIN_CAPSFILTER
  Glib::wrap_register(gst_caps_filter_get_type(), &Gst::CapsFilter_Class::wrap_new);
#endif //GSTREAMERMM_PLUGIN_CAPSFILTER
#ifdef GSTREAMERMM_PLUGIN_CDPARANOIASRC
  Glib::wrap_register(gst_cd_paranoia_src_get_type(), &Gst::CdParanoiaSrc_Class::wrap_new);
#endif //GSTREAMERMM_PLUGIN_CDPARANOIASRC
  Glib::wrap_register(gst_cdda_base_src_get_type(), &Gst::CddaBaseSrc_Class::wrap_new);
  Glib::wrap_register(gst_clock_get_type(), &Gst::Clock_Class::wrap_new);
#ifdef GSTREAMERMM_PLUGIN_CLOCKOVERLAY
  Glib::wrap_register(gst_clock_overlay_get_type(), &Gst::ClockOverlay_Class::wrap_new);
#endif //GSTREAMERMM_PLUGIN_CLOCKOVERLAY
  Glib::wrap_register(gst_color_balance_channel_get_type(), &Gst::ColorBalanceChannel_Class::wrap_new);
#ifdef GSTREAMERMM_PLUGIN_DECODEBIN
  Glib::wrap_register(gst_decode_bin_get_type(), &Gst::DecodeBin_Class::wrap_new);
#endif //GSTREAMERMM_PLUGIN_DECODEBIN
  Glib::wrap_register(gst_element_get_type(), &Gst::Element_Class::wrap_new);
  Glib::wrap_register(gst_element_factory_get_type(), &Gst::ElementFactory_Class::wrap_new);
#ifdef GSTREAMERMM_PLUGIN_FAKESINK
  Glib::wrap_register(gst_fake_sink_get_type(), &Gst::FakeSink_Class::wrap_new);
#endif //GSTREAMERMM_PLUGIN_FAKESINK
#ifdef GSTREAMERMM_PLUGIN_FAKESRC
  Glib::wrap_register(gst_fake_src_get_type(), &Gst::FakeSrc_Class::wrap_new);
#endif //GSTREAMERMM_PLUGIN_FAKESRC
#ifdef GSTREAMERMM_PLUGIN_FDSINK
  Glib::wrap_register(gst_fd_sink_get_type(), &Gst::FdSink_Class::wrap_new);
#endif //GSTREAMERMM_PLUGIN_FDSINK
#ifdef GSTREAMERMM_PLUGIN_FDSRC
  Glib::wrap_register(gst_fd_src_get_type(), &Gst::FdSrc_Class::wrap_new);
#endif //GSTREAMERMM_PLUGIN_FDSRC
#ifdef GSTREAMERMM_PLUGIN_FFMPEGCOLORSPACE
  Glib::wrap_register(gst_ff_mpeg_csp_get_type(), &Gst::FfmpegColorSpace_Class::wrap_new);
#endif //GSTREAMERMM_PLUGIN_FFMPEGCOLORSPACE
#ifdef GSTREAMERMM_PLUGIN_FILESINK
  Glib::wrap_register(gst_file_sink_get_type(), &Gst::FileSink_Class::wrap_new);
#endif //GSTREAMERMM_PLUGIN_FILESINK
#ifdef GSTREAMERMM_PLUGIN_FILESRC
  Glib::wrap_register(gst_file_src_get_type(), &Gst::FileSrc_Class::wrap_new);
#endif //GSTREAMERMM_PLUGIN_FILESRC
#ifdef GSTREAMERMM_PLUGIN_GDPDEPAY
  Glib::wrap_register(gst_gd_p_depay_get_type(), &Gst::GDPDepay_Class::wrap_new);
#endif //GSTREAMERMM_PLUGIN_GDPDEPAY
#ifdef GSTREAMERMM_PLUGIN_GDPPAY
  Glib::wrap_register(gst_gd_p_pay_get_type(), &Gst::GDPPay_Class::wrap_new);
#endif //GSTREAMERMM_PLUGIN_GDPPAY
  Glib::wrap_register(gst_ghost_pad_get_type(), &Gst::GhostPad_Class::wrap_new);
#ifdef GSTREAMERMM_PLUGIN_GIOSINK
  Glib::wrap_register(gst_gio_sink_get_type(), &Gst::GioSink_Class::wrap_new);
#endif //GSTREAMERMM_PLUGIN_GIOSINK
#ifdef GSTREAMERMM_PLUGIN_GIOSRC
  Glib::wrap_register(gst_gio_src_get_type(), &Gst::GioSrc_Class::wrap_new);
#endif //GSTREAMERMM_PLUGIN_GIOSRC
#ifdef GSTREAMERMM_PLUGIN_GIOSTREAMSINK
  Glib::wrap_register(gst_gio_stream_sink_get_type(), &Gst::GioStreamSink_Class::wrap_new);
#endif //GSTREAMERMM_PLUGIN_GIOSTREAMSINK
#ifdef GSTREAMERMM_PLUGIN_GIOSTREAMSRC
  Glib::wrap_register(gst_gio_stream_src_get_type(), &Gst::GioStreamSrc_Class::wrap_new);
#endif //GSTREAMERMM_PLUGIN_GIOSTREAMSRC
#ifdef GSTREAMERMM_PLUGIN_IDENTITY
  Glib::wrap_register(gst_identity_get_type(), &Gst::Identity_Class::wrap_new);
#endif //GSTREAMERMM_PLUGIN_IDENTITY
  Glib::wrap_register(gst_index_get_type(), &Gst::Index_Class::wrap_new);
  Glib::wrap_register(gst_index_factory_get_type(), &Gst::IndexFactory_Class::wrap_new);
  Glib::wrap_register(gst_mixer_options_get_type(), &Gst::MixerOptions_Class::wrap_new);
  Glib::wrap_register(gst_mixer_track_get_type(), &Gst::MixerTrack_Class::wrap_new);
#ifdef GSTREAMERMM_PLUGIN_MULTIQUEUE
  Glib::wrap_register(gst_multi_queue_get_type(), &Gst::MultiQueue_Class::wrap_new);
#endif //GSTREAMERMM_PLUGIN_MULTIQUEUE
#ifdef GSTREAMERMM_PLUGIN_OGGDEMUX
  Glib::wrap_register(gst_ogg_demux_get_type(), &Gst::OggDemux_Class::wrap_new);
#endif //GSTREAMERMM_PLUGIN_OGGDEMUX
#ifdef GSTREAMERMM_PLUGIN_OGGMUX
  Glib::wrap_register(gst_ogg_mux_get_type(), &Gst::OggMux_Class::wrap_new);
#endif //GSTREAMERMM_PLUGIN_OGGMUX
  Glib::wrap_register(gst_pad_get_type(), &Gst::Pad_Class::wrap_new);
  Glib::wrap_register(gst_pad_template_get_type(), &Gst::PadTemplate_Class::wrap_new);
  Glib::wrap_register(gst_pipeline_get_type(), &Gst::Pipeline_Class::wrap_new);
#ifdef GSTREAMERMM_PLUGIN_PLAYBIN2
  Glib::wrap_register(gst_play_bin2_get_type(), &Gst::PlayBin2_Class::wrap_new);
#endif //GSTREAMERMM_PLUGIN_PLAYBIN2
  Glib::wrap_register(gst_plugin_get_type(), &Gst::Plugin_Class::wrap_new);
  Glib::wrap_register(gst_plugin_feature_get_type(), &Gst::PluginFeature_Class::wrap_new);
  Glib::wrap_register(gst_push_src_get_type(), &Gst::PushSrc_Class::wrap_new);
#ifdef GSTREAMERMM_PLUGIN_QUEUE
  Glib::wrap_register(gst_queue_get_type(), &Gst::Queue_Class::wrap_new);
#endif //GSTREAMERMM_PLUGIN_QUEUE
  Glib::wrap_register(gst_registry_get_type(), &Gst::Registry_Class::wrap_new);
  Glib::wrap_register(gst_system_clock_get_type(), &Gst::SystemClock_Class::wrap_new);
  Glib::wrap_register(gst_task_get_type(), &Gst::Task_Class::wrap_new);
#ifdef GSTREAMERMM_PLUGIN_TEE
  Glib::wrap_register(gst_tee_get_type(), &Gst::Tee_Class::wrap_new);
#endif //GSTREAMERMM_PLUGIN_TEE
#ifdef GSTREAMERMM_PLUGIN_TEXTOVERLAY
  Glib::wrap_register(gst_text_overlay_get_type(), &Gst::TextOverlay_Class::wrap_new);
#endif //GSTREAMERMM_PLUGIN_TEXTOVERLAY
#ifdef GSTREAMERMM_PLUGIN_TEXTRENDER
  Glib::wrap_register(gst_text_render_get_type(), &Gst::TextRender_Class::wrap_new);
#endif //GSTREAMERMM_PLUGIN_TEXTRENDER
#ifdef GSTREAMERMM_PLUGIN_THEORADEC
  Glib::wrap_register(gst_theora_dec_get_type(), &Gst::TheoraDec_Class::wrap_new);
#endif //GSTREAMERMM_PLUGIN_THEORADEC
#ifdef GSTREAMERMM_PLUGIN_THEORAENC
  Glib::wrap_register(gst_theora_enc_get_type(), &Gst::TheoraEnc_Class::wrap_new);
#endif //GSTREAMERMM_PLUGIN_THEORAENC
#ifdef GSTREAMERMM_PLUGIN_TIMEOVERLAY
  Glib::wrap_register(gst_time_overlay_get_type(), &Gst::TimeOverlay_Class::wrap_new);
#endif //GSTREAMERMM_PLUGIN_TIMEOVERLAY
  Glib::wrap_register(gst_tuner_channel_get_type(), &Gst::TunerChannel_Class::wrap_new);
  Glib::wrap_register(gst_tuner_norm_get_type(), &Gst::TunerNorm_Class::wrap_new);
#ifdef GSTREAMERMM_PLUGIN_TYPEFINDELEMENT
  Glib::wrap_register(gst_type_find_element_get_type(), &Gst::TypeFindElement_Class::wrap_new);
#endif //GSTREAMERMM_PLUGIN_TYPEFINDELEMENT
#ifdef GSTREAMERMM_PLUGIN_VIDEORATE
  Glib::wrap_register(gst_video_rate_get_type(), &Gst::VideoRate_Class::wrap_new);
#endif //GSTREAMERMM_PLUGIN_VIDEORATE
#ifdef GSTREAMERMM_PLUGIN_VIDEOSCALE
  Glib::wrap_register(gst_video_scale_get_type(), &Gst::VideoScale_Class::wrap_new);
#endif //GSTREAMERMM_PLUGIN_VIDEOSCALE
  Glib::wrap_register(gst_video_sink_get_type(), &Gst::VideoSink_Class::wrap_new);
#ifdef GSTREAMERMM_PLUGIN_VIDEOTESTSRC
  Glib::wrap_register(gst_video_test_src_get_type(), &Gst::VideoTestSrc_Class::wrap_new);
#endif //GSTREAMERMM_PLUGIN_VIDEOTESTSRC
#ifdef GSTREAMERMM_PLUGIN_VOLUME
  Glib::wrap_register(gst_volume_get_type(), &Gst::Volume_Class::wrap_new);
#endif //GSTREAMERMM_PLUGIN_VOLUME
#ifdef GSTREAMERMM_PLUGIN_VORBISDEC
  Glib::wrap_register(gst_vorbis_dec_get_type(), &Gst::VorbisDec_Class::wrap_new);
#endif //GSTREAMERMM_PLUGIN_VORBISDEC
#ifdef GSTREAMERMM_PLUGIN_VORBISENC
  Glib::wrap_register(gst_vorbis_enc_get_type(), &Gst::VorbisEnc_Class::wrap_new);
#endif //GSTREAMERMM_PLUGIN_VORBISENC
#ifdef GSTREAMERMM_PLUGIN_VORBISPARSE
  Glib::wrap_register(gst_vorbis_parse_get_type(), &Gst::VorbisParse_Class::wrap_new);
#endif //GSTREAMERMM_PLUGIN_VORBISPARSE
#ifdef GSTREAMERMM_PLUGIN_VORBISTAG
  Glib::wrap_register(gst_vorbis_tag_get_type(), &Gst::VorbisTag_Class::wrap_new);
#endif //GSTREAMERMM_PLUGIN_VORBISTAG
#ifdef GSTREAMERMM_PLUGIN_XIMAGESINK
  Glib::wrap_register(gst_ximage_sink_get_type(), &Gst::XImageSink_Class::wrap_new);
#endif //GSTREAMERMM_PLUGIN_XIMAGESINK
  Glib::wrap_register(gst_xml_get_type(), &Gst::XML_Class::wrap_new);
#ifdef GSTREAMERMM_PLUGIN_XVIMAGESINK
  Glib::wrap_register(gst_xv_image_sink_get_type(), &Gst::XvImageSink_Class::wrap_new);
#endif //GSTREAMERMM_PLUGIN_XVIMAGESINK

  // Register the gtkmm gtypes:
#ifdef GSTREAMERMM_PLUGIN_ADDER
  Gst::Adder::get_type();
#endif //GSTREAMERMM_PLUGIN_ADDER
#ifdef GSTREAMERMM_PLUGIN_ALSAMIXER
  Gst::AlsaMixer::get_type();
#endif //GSTREAMERMM_PLUGIN_ALSAMIXER
#ifdef GSTREAMERMM_PLUGIN_ALSASINK
  Gst::AlsaSink::get_type();
#endif //GSTREAMERMM_PLUGIN_ALSASINK
#ifdef GSTREAMERMM_PLUGIN_ALSASRC
  Gst::AlsaSrc::get_type();
#endif //GSTREAMERMM_PLUGIN_ALSASRC
  Gst::AudioClock::get_type();
#ifdef GSTREAMERMM_PLUGIN_AUDIOCONVERT
  Gst::AudioConvert::get_type();
#endif //GSTREAMERMM_PLUGIN_AUDIOCONVERT
  Gst::AudioFilter::get_type();
#ifdef GSTREAMERMM_PLUGIN_AUDIORESAMPLE
  Gst::AudioResample::get_type();
#endif //GSTREAMERMM_PLUGIN_AUDIORESAMPLE
  Gst::AudioSink::get_type();
  Gst::AudioSrc::get_type();
#ifdef GSTREAMERMM_PLUGIN_AUDIOTESTSRC
  Gst::AudioTestSrc::get_type();
#endif //GSTREAMERMM_PLUGIN_AUDIOTESTSRC
  Gst::BaseAudioSink::get_type();
  Gst::BaseAudioSrc::get_type();
  Gst::BaseSink::get_type();
  Gst::BaseSrc::get_type();
  Gst::BaseTransform::get_type();
  Gst::Bin::get_type();
  Gst::Bus::get_type();
#ifdef GSTREAMERMM_PLUGIN_CAPSFILTER
  Gst::CapsFilter::get_type();
#endif //GSTREAMERMM_PLUGIN_CAPSFILTER
#ifdef GSTREAMERMM_PLUGIN_CDPARANOIASRC
  Gst::CdParanoiaSrc::get_type();
#endif //GSTREAMERMM_PLUGIN_CDPARANOIASRC
  Gst::CddaBaseSrc::get_type();
  Gst::Clock::get_type();
#ifdef GSTREAMERMM_PLUGIN_CLOCKOVERLAY
  Gst::ClockOverlay::get_type();
#endif //GSTREAMERMM_PLUGIN_CLOCKOVERLAY
  Gst::ColorBalanceChannel::get_type();
#ifdef GSTREAMERMM_PLUGIN_DECODEBIN
  Gst::DecodeBin::get_type();
#endif //GSTREAMERMM_PLUGIN_DECODEBIN
  Gst::Element::get_type();
  Gst::ElementFactory::get_type();
#ifdef GSTREAMERMM_PLUGIN_FAKESINK
  Gst::FakeSink::get_type();
#endif //GSTREAMERMM_PLUGIN_FAKESINK
#ifdef GSTREAMERMM_PLUGIN_FAKESRC
  Gst::FakeSrc::get_type();
#endif //GSTREAMERMM_PLUGIN_FAKESRC
#ifdef GSTREAMERMM_PLUGIN_FDSINK
  Gst::FdSink::get_type();
#endif //GSTREAMERMM_PLUGIN_FDSINK
#ifdef GSTREAMERMM_PLUGIN_FDSRC
  Gst::FdSrc::get_type();
#endif //GSTREAMERMM_PLUGIN_FDSRC
#ifdef GSTREAMERMM_PLUGIN_FFMPEGCOLORSPACE
  Gst::FfmpegColorSpace::get_type();
#endif //GSTREAMERMM_PLUGIN_FFMPEGCOLORSPACE
#ifdef GSTREAMERMM_PLUGIN_FILESINK
  Gst::FileSink::get_type();
#endif //GSTREAMERMM_PLUGIN_FILESINK
#ifdef GSTREAMERMM_PLUGIN_FILESRC
  Gst::FileSrc::get_type();
#endif //GSTREAMERMM_PLUGIN_FILESRC
#ifdef GSTREAMERMM_PLUGIN_GDPDEPAY
  Gst::GDPDepay::get_type();
#endif //GSTREAMERMM_PLUGIN_GDPDEPAY
#ifdef GSTREAMERMM_PLUGIN_GDPPAY
  Gst::GDPPay::get_type();
#endif //GSTREAMERMM_PLUGIN_GDPPAY
  Gst::GhostPad::get_type();
#ifdef GSTREAMERMM_PLUGIN_GIOSINK
  Gst::GioSink::get_type();
#endif //GSTREAMERMM_PLUGIN_GIOSINK
#ifdef GSTREAMERMM_PLUGIN_GIOSRC
  Gst::GioSrc::get_type();
#endif //GSTREAMERMM_PLUGIN_GIOSRC
#ifdef GSTREAMERMM_PLUGIN_GIOSTREAMSINK
  Gst::GioStreamSink::get_type();
#endif //GSTREAMERMM_PLUGIN_GIOSTREAMSINK
#ifdef GSTREAMERMM_PLUGIN_GIOSTREAMSRC
  Gst::GioStreamSrc::get_type();
#endif //GSTREAMERMM_PLUGIN_GIOSTREAMSRC
#ifdef GSTREAMERMM_PLUGIN_IDENTITY
  Gst::Identity::get_type();
#endif //GSTREAMERMM_PLUGIN_IDENTITY
  Gst::Index::get_type();
  Gst::IndexFactory::get_type();
  Gst::MixerOptions::get_type();
  Gst::MixerTrack::get_type();
#ifdef GSTREAMERMM_PLUGIN_MULTIQUEUE
  Gst::MultiQueue::get_type();
#endif //GSTREAMERMM_PLUGIN_MULTIQUEUE
#ifdef GSTREAMERMM_PLUGIN_OGGDEMUX
  Gst::OggDemux::get_type();
#endif //GSTREAMERMM_PLUGIN_OGGDEMUX
#ifdef GSTREAMERMM_PLUGIN_OGGMUX
  Gst::OggMux::get_type();
#endif //GSTREAMERMM_PLUGIN_OGGMUX
  Gst::Pad::get_type();
  Gst::PadTemplate::get_type();
  Gst::Pipeline::get_type();
#ifdef GSTREAMERMM_PLUGIN_PLAYBIN2
  Gst::PlayBin2::get_type();
#endif //GSTREAMERMM_PLUGIN_PLAYBIN2
  Gst::Plugin::get_type();
  Gst::PluginFeature::get_type();
  Gst::PushSrc::get_type();
#ifdef GSTREAMERMM_PLUGIN_QUEUE
  Gst::Queue::get_type();
#endif //GSTREAMERMM_PLUGIN_QUEUE
  Gst::Registry::get_type();
  Gst::SystemClock::get_type();
  Gst::Task::get_type();
#ifdef GSTREAMERMM_PLUGIN_TEE
  Gst::Tee::get_type();
#endif //GSTREAMERMM_PLUGIN_TEE
#ifdef GSTREAMERMM_PLUGIN_TEXTOVERLAY
  Gst::TextOverlay::get_type();
#endif //GSTREAMERMM_PLUGIN_TEXTOVERLAY
#ifdef GSTREAMERMM_PLUGIN_TEXTRENDER
  Gst::TextRender::get_type();
#endif //GSTREAMERMM_PLUGIN_TEXTRENDER
#ifdef GSTREAMERMM_PLUGIN_THEORADEC
  Gst::TheoraDec::get_type();
#endif //GSTREAMERMM_PLUGIN_THEORADEC
#ifdef GSTREAMERMM_PLUGIN_THEORAENC
  Gst::TheoraEnc::get_type();
#endif //GSTREAMERMM_PLUGIN_THEORAENC
#ifdef GSTREAMERMM_PLUGIN_TIMEOVERLAY
  Gst::TimeOverlay::get_type();
#endif //GSTREAMERMM_PLUGIN_TIMEOVERLAY
  Gst::TunerChannel::get_type();
  Gst::TunerNorm::get_type();
#ifdef GSTREAMERMM_PLUGIN_TYPEFINDELEMENT
  Gst::TypeFindElement::get_type();
#endif //GSTREAMERMM_PLUGIN_TYPEFINDELEMENT
#ifdef GSTREAMERMM_PLUGIN_VIDEORATE
  Gst::VideoRate::get_type();
#endif //GSTREAMERMM_PLUGIN_VIDEORATE
#ifdef GSTREAMERMM_PLUGIN_VIDEOSCALE
  Gst::VideoScale::get_type();
#endif //GSTREAMERMM_PLUGIN_VIDEOSCALE
  Gst::VideoSink::get_type();
#ifdef GSTREAMERMM_PLUGIN_VIDEOTESTSRC
  Gst::VideoTestSrc::get_type();
#endif //GSTREAMERMM_PLUGIN_VIDEOTESTSRC
#ifdef GSTREAMERMM_PLUGIN_VOLUME
  Gst::Volume::get_type();
#endif //GSTREAMERMM_PLUGIN_VOLUME
#ifdef GSTREAMERMM_PLUGIN_VORBISDEC
  Gst::VorbisDec::get_type();
#endif //GSTREAMERMM_PLUGIN_VORBISDEC
#ifdef GSTREAMERMM_PLUGIN_VORBISENC
  Gst::VorbisEnc::get_type();
#endif //GSTREAMERMM_PLUGIN_VORBISENC
#ifdef GSTREAMERMM_PLUGIN_VORBISPARSE
  Gst::VorbisParse::get_type();
#endif //GSTREAMERMM_PLUGIN_VORBISPARSE
#ifdef GSTREAMERMM_PLUGIN_VORBISTAG
  Gst::VorbisTag::get_type();
#endif //GSTREAMERMM_PLUGIN_VORBISTAG
#ifdef GSTREAMERMM_PLUGIN_XIMAGESINK
  Gst::XImageSink::get_type();
#endif //GSTREAMERMM_PLUGIN_XIMAGESINK
  Gst::XML::get_type();
#ifdef GSTREAMERMM_PLUGIN_XVIMAGESINK
  Gst::XvImageSink::get_type();
#endif //GSTREAMERMM_PLUGIN_XVIMAGESINK

} // wrap_init()

} //Gst


