// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_AUDIOCLOCK_H
#define _GSTREAMERMM_AUDIOCLOCK_H


#include <glibmm.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gstreamermm/systemclock.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstAudioClock GstAudioClock;
typedef struct _GstAudioClockClass GstAudioClockClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{ class AudioClock_Class; } // namespace Gst
namespace Gst
{

/** Gst::AudioClock - Helper object for implementing audio clocks.
 * Gst::AudioClock makes it easy for elements to implement a Gst::Clock,
 * they simply need to provide a slot that returns the current clock time.
 *
 * This object is internally used to implement the clock in
 * Gst::BaseAudioSink.
 *
 * Last reviewed on 2006-09-27 (0.10.12).
 */

class AudioClock : public Gst::SystemClock
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef AudioClock CppObjectType;
  typedef AudioClock_Class CppClassType;
  typedef GstAudioClock BaseObjectType;
  typedef GstAudioClockClass BaseClassType;

private:  friend class AudioClock_Class;
  static CppClassType audioclock_class_;

private:
  // noncopyable
  AudioClock(const AudioClock&);
  AudioClock& operator=(const AudioClock&);

protected:
  explicit AudioClock(const Glib::ConstructParams& construct_params);
  explicit AudioClock(GstAudioClock* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~AudioClock();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstAudioClock*       gobj()       { return reinterpret_cast<GstAudioClock*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GstAudioClock* gobj() const { return reinterpret_cast<GstAudioClock*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstAudioClock* gobj_copy();

private:

  
public:
  /** For example,
   * Gst::ClockTime on_get_time(const Glib::RefPtr<Gst::Clock>& clock);.
   * This function will be called whenever the current clock time needs to be
   * calculated. If this function returns Gst::CLOCK_TIME_NONE, the last
   * reported time will be returned by the clock.
   *
   * @param clock The Gst::AudioClock.
   */
  typedef sigc::slot< Gst::ClockTime, const Glib::RefPtr<Gst::Clock>& > SlotGetTime;

protected:
  AudioClock(const Glib::ustring& name, const SlotGetTime& time_slot);

public:
  /** Create a new Gst::AudioClock instance. Whenever the clock time should
   * be calculated it will call @a time_slot. When @a time_slot returns
   * Gst::CLOCK_TIME_NONE, the clock will return the last reported time.
   * 
   *@param name The name of the clock.
   *@param time_slot A slot that returns the time.
   *
   * @return a new Gst::AudioClock.
   */
  
  static Glib::RefPtr<AudioClock> create(const Glib::ustring& name, const SlotGetTime& time_slot);
;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:
  SlotGetTime* slot;
  bool _slot_set(bool mark_set = false) const;
#endif


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gst


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::AudioClock
   */
  Glib::RefPtr<Gst::AudioClock> wrap(GstAudioClock* object, bool take_copy = false);
}


#endif /* _GSTREAMERMM_AUDIOCLOCK_H */

