/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* Unit tests for PDF links UI
 *
 * Copyright (C) 2003 Martin Kretzschmar
 *
 * Author:
 *   Martin Kretzschmar <Martin.Kretzschmar@inf.tu-dresden.de>
 *
 * GPdf is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * GPdf is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */

#include "gpdf-links-canvas-layer.h"
#include "Object.h"
#include "PDFDoc.h"
#include "Link.h"

#include <unit-test.h>

GnomeCanvas *canvas;

static void
setup ()
{
	canvas = GNOME_CANVAS (gnome_canvas_new_aa ());
}

static void
tear_down ()
{
	gtk_object_sink (GTK_OBJECT (canvas));
	canvas = NULL;
}

TEST_BEGIN (GPdfLinks, setup, tear_down)

TEST_NEW (empty_links)
{
	GPdfLinksCanvasLayer *links_layer;

	links_layer = GPDF_LINKS_CANVAS_LAYER (
		gnome_canvas_item_new (gnome_canvas_root (canvas),
				       GPDF_TYPE_LINKS_CANVAS_LAYER,
				       "links", NULL,
				       NULL));
	TEST (gpdf_links_canvas_layer_get_num_links (links_layer) == 0);
}

TEST_NEW (one_link_appearance)
{
	Object obj;
	PDFDoc *pdf_doc;
	Page *page;
	Links *links;
	GPdfLinksCanvasLayer *links_layer;
	GnomeCanvasItem *link_item;
	double x1, x2, y1, y2, ex1, ex2, ey1, ey2, ew;
	int old_w, w;
	GdkEvent ev;
	gboolean dummy;

	pdf_doc = new PDFDoc (
		new GString (TESTFILES_DIR "/simple-links.pdf"));
	TEST (pdf_doc->getCatalog () != NULL);
	page = pdf_doc->getCatalog ()->getPage (1);
	TEST (page->isOk ());
	links = new Links (page->getAnnots (&obj),
			   pdf_doc->getCatalog ()->getBaseURI ());
	TEST (links->getNumLinks () == 1);

	links_layer = GPDF_LINKS_CANVAS_LAYER (
		gnome_canvas_item_new (gnome_canvas_root (canvas),
				       GPDF_TYPE_LINKS_CANVAS_LAYER,
				       "links", links,
				       NULL));
	TEST (gpdf_links_canvas_layer_get_num_links (links_layer) 
	      == links->getNumLinks ());
	link_item = GNOME_CANVAS_ITEM (
		GNOME_CANVAS_GROUP (links_layer)->item_list->data);
	g_object_get (link_item, "x1", &x1, NULL);
	g_object_get (link_item, "y1", &y1, NULL);
	g_object_get (link_item, "x2", &x2, NULL);
	g_object_get (link_item, "y2", &y2, NULL);

	links->getLink (0)->getBorder (&ex1, &ey1, &ex2, &ey2, &ew);
	TEST (x1==ex1 && y1==ey1 && x2==ex2 && y2==ey2);

	g_object_get (link_item, "width_pixels", &old_w, NULL);
	g_object_set (link_item, "width_units", ew, NULL);
	g_object_get (link_item, "width_pixels", &w, NULL);
	TEST (old_w==w);

	delete pdf_doc;
}

TEST_END ()
