/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* PDF link canvas item
 *
 * Copyright (C) 2003 Martin Kretzschmar
 *
 * Author:
 *   Martin Kretzschmar <Martin.Kretzschmar@inf.tu-dresden.de>
 *
 * GPdf is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * GPdf is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */

#include <aconf.h>
#include "gpdf-util.h"
#include "gpdf-link-canvas-item.h"
#include "gpdf-g-switch.h"
#  include <libgnome/gnome-i18n.h>
#  include <libgnome/gnome-macros.h>
#  include "gpdf-marshal.h"
#include "gpdf-g-switch.h"
#include "Link.h"

BEGIN_EXTERN_C

struct _GPdfLinkCanvasItemPrivate {
	Link *link;
};

enum {
	CLICKED,
	LAST_SIGNAL
};

static guint gpdf_link_canvas_item_signals [LAST_SIGNAL];

enum {
	PROP_0,
	PROP_LINK
};

#define PARENT_TYPE GNOME_TYPE_CANVAS_RECT
GPDF_CLASS_BOILERPLATE (GPdfLinkCanvasItem, gpdf_link_canvas_item,
			GnomeCanvasRect, PARENT_TYPE);

static int
gpdf_link_canvas_item_event (GnomeCanvasItem *item, GdkEvent *event)
{
	GdkCursor *cursor;
	
	switch (event->type) {
	case GDK_ENTER_NOTIFY:
		cursor = gdk_cursor_new_for_display (gdk_display_get_default(),
						     GDK_HAND2);
		gdk_window_set_cursor (((GdkEventAny *)event)->window, cursor);
		gdk_cursor_unref (cursor);
		return TRUE;
	case GDK_LEAVE_NOTIFY:
		gdk_window_set_cursor (((GdkEventAny *)event)->window, NULL);
		return TRUE;
	case GDK_BUTTON_PRESS:
		if (event->button.button > 1)
			return FALSE;
		g_return_val_if_fail (GPDF_IS_LINK_CANVAS_ITEM (item), FALSE);
		g_signal_emit (G_OBJECT (item),
			       gpdf_link_canvas_item_signals [CLICKED], 0,
			       GPDF_LINK_CANVAS_ITEM (item)->priv->link);
		gdk_window_set_cursor (((GdkEventAny *)event)->window, NULL);
		return TRUE;
	default:		
		return FALSE;
	}
}

static void
gpdf_link_canvas_item_set_link (GPdfLinkCanvasItem *link_item, Link *link)
{
	link_item->priv->link = link;
}

static void
gpdf_link_canvas_item_set_property (GObject *object, guint param_id,
				    const GValue *value, GParamSpec *pspec)
{
	GPdfLinkCanvasItem *link_item;

	g_return_if_fail (GPDF_IS_LINK_CANVAS_ITEM (object));

	link_item = GPDF_LINK_CANVAS_ITEM (object);

	switch (param_id) {
	case PROP_LINK:
		gpdf_link_canvas_item_set_link (
			link_item,
			reinterpret_cast <Link *> (
				g_value_get_pointer (value)));
		break;
	default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, param_id, pspec);
		break;
	}
}

static void
gpdf_link_canvas_item_dispose (GObject *object)
{
	GPdfLinkCanvasItem *link_item;

	g_return_if_fail (GPDF_IS_LINK_CANVAS_ITEM (object));

	link_item = GPDF_LINK_CANVAS_ITEM (object);

	/* empty */

	GNOME_CALL_PARENT (G_OBJECT_CLASS, dispose, (object));
}

static void
gpdf_link_canvas_item_finalize (GObject *object)
{
	GPdfLinkCanvasItem *link_item;

	g_return_if_fail (GPDF_IS_LINK_CANVAS_ITEM (object));

	link_item = GPDF_LINK_CANVAS_ITEM (object);

	if (link_item->priv) {
		g_free (link_item->priv);
		link_item->priv = NULL;
	}

	GNOME_CALL_PARENT (G_OBJECT_CLASS, finalize, (object));
}

static void
gpdf_link_canvas_item_class_init (GPdfLinkCanvasItemClass *klass)
{
	GObjectClass *object_class;
	GnomeCanvasItemClass *item_class;

	object_class = G_OBJECT_CLASS (klass);
	item_class = GNOME_CANVAS_ITEM_CLASS (klass);

	object_class->dispose = gpdf_link_canvas_item_dispose;
	object_class->finalize = gpdf_link_canvas_item_finalize;
	object_class->set_property = gpdf_link_canvas_item_set_property;

	item_class->event = gpdf_link_canvas_item_event;

	g_object_class_install_property (
		object_class, PROP_LINK,
		g_param_spec_pointer ("link",
				      _("Link"),
				      _("Link"),
				      (GParamFlags)(G_PARAM_WRITABLE)));

	gpdf_link_canvas_item_signals [CLICKED] =
		g_signal_new ("clicked",
			      G_TYPE_FROM_CLASS (object_class),
			      G_SIGNAL_RUN_LAST,
			      G_STRUCT_OFFSET (GPdfLinkCanvasItemClass, 
					       clicked),
			      NULL, NULL,
			      gpdf_marshal_VOID__POINTER,
			      G_TYPE_NONE, 1,
			      G_TYPE_POINTER);
}

static void
gpdf_link_canvas_item_instance_init (GPdfLinkCanvasItem *link_item)
{
	link_item->priv = g_new0 (GPdfLinkCanvasItemPrivate, 1);
}


END_EXTERN_C
