/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* 
 * Copyright (C) 2000-2001 Ximian, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors: Carlos Garnacho Parro  <carlosg@gnome.org>
 */

#ifndef __PROFILE_H__
#define __PROFILE_H__

#define COMPARE_TAGS(VAL1, VAL2) (((VAL1 != NULL) && (VAL2 != NULL) && (strcmp (VAL1, VAL2) != 0)) || \
				  ((VAL1 == NULL) && (VAL2 != NULL) && (strlen (VAL2) > 0)) || \
				  ((VAL1 != NULL) && (VAL2 == NULL) && (strlen (VAL1) > 0)))

#include "gst.h"

gboolean profile_delete (xmlNodePtr);
void profile_save_current (const gchar*, const gchar*, GstTool*);
void profile_populate_option_menu (GstTool*, xmlNodePtr);
void profile_set_active (xmlNodePtr, GstTool*);

#endif /* __PROFILE_H__ */
