/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#include <glib.h>
#include <glib-object.h>
#include <config.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <glib/gstdio.h>
#include <gegl.h>


#define GNOME_SCAN_TYPE_MODULE_MANAGER (gnome_scan_module_manager_get_type ())
#define GNOME_SCAN_MODULE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_MODULE_MANAGER, GnomeScanModuleManager))
#define GNOME_SCAN_MODULE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_MODULE_MANAGER, GnomeScanModuleManagerClass))
#define GNOME_SCAN_IS_MODULE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_MODULE_MANAGER))
#define GNOME_SCAN_IS_MODULE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_MODULE_MANAGER))
#define GNOME_SCAN_MODULE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_MODULE_MANAGER, GnomeScanModuleManagerClass))

typedef struct _GnomeScanModuleManager GnomeScanModuleManager;
typedef struct _GnomeScanModuleManagerClass GnomeScanModuleManagerClass;

#define GNOME_SCAN_TYPE_OPTION_MANAGER (gnome_scan_option_manager_get_type ())
#define GNOME_SCAN_OPTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_MANAGER, GnomeScanOptionManager))
#define GNOME_SCAN_OPTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_MANAGER, GnomeScanOptionManagerClass))
#define GNOME_SCAN_IS_OPTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_MANAGER))
#define GNOME_SCAN_IS_OPTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_MANAGER))
#define GNOME_SCAN_OPTION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_MANAGER, GnomeScanOptionManagerClass))

typedef struct _GnomeScanOptionManager GnomeScanOptionManager;
typedef struct _GnomeScanOptionManagerClass GnomeScanOptionManagerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GNOME_SCAN_TYPE_OPTION (gnome_scan_option_get_type ())
#define GNOME_SCAN_OPTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION, GnomeScanOption))
#define GNOME_SCAN_OPTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION, GnomeScanOptionClass))
#define GNOME_SCAN_IS_OPTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION))
#define GNOME_SCAN_IS_OPTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION))
#define GNOME_SCAN_OPTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION, GnomeScanOptionClass))

typedef struct _GnomeScanOption GnomeScanOption;
typedef struct _GnomeScanOptionClass GnomeScanOptionClass;

#define GNOME_SCAN_TYPE_OPTION_BOOL (gnome_scan_option_bool_get_type ())
#define GNOME_SCAN_OPTION_BOOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_BOOL, GnomeScanOptionBool))
#define GNOME_SCAN_OPTION_BOOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_BOOL, GnomeScanOptionBoolClass))
#define GNOME_SCAN_IS_OPTION_BOOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_BOOL))
#define GNOME_SCAN_IS_OPTION_BOOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_BOOL))
#define GNOME_SCAN_OPTION_BOOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_BOOL, GnomeScanOptionBoolClass))

typedef struct _GnomeScanOptionBool GnomeScanOptionBool;
typedef struct _GnomeScanOptionBoolClass GnomeScanOptionBoolClass;

#define GNOME_SCAN_TYPE_OPTION_WIDGET (gnome_scan_option_widget_get_type ())
#define GNOME_SCAN_OPTION_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_WIDGET, GnomeScanOptionWidget))
#define GNOME_SCAN_OPTION_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_WIDGET, GnomeScanOptionWidgetClass))
#define GNOME_SCAN_IS_OPTION_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_WIDGET))
#define GNOME_SCAN_IS_OPTION_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_WIDGET))
#define GNOME_SCAN_OPTION_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_WIDGET, GnomeScanOptionWidgetClass))

typedef struct _GnomeScanOptionWidget GnomeScanOptionWidget;
typedef struct _GnomeScanOptionWidgetClass GnomeScanOptionWidgetClass;

#define GNOME_SCAN_TYPE_CHECKBOX_WIDGET (gnome_scan_checkbox_widget_get_type ())
#define GNOME_SCAN_CHECKBOX_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_CHECKBOX_WIDGET, GnomeScanCheckboxWidget))
#define GNOME_SCAN_CHECKBOX_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_CHECKBOX_WIDGET, GnomeScanCheckboxWidgetClass))
#define GNOME_SCAN_IS_CHECKBOX_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_CHECKBOX_WIDGET))
#define GNOME_SCAN_IS_CHECKBOX_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_CHECKBOX_WIDGET))
#define GNOME_SCAN_CHECKBOX_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_CHECKBOX_WIDGET, GnomeScanCheckboxWidgetClass))

typedef struct _GnomeScanCheckboxWidget GnomeScanCheckboxWidget;
typedef struct _GnomeScanCheckboxWidgetClass GnomeScanCheckboxWidgetClass;

#define GNOME_SCAN_TYPE_OPTION_NUMBER (gnome_scan_option_number_get_type ())
#define GNOME_SCAN_OPTION_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_NUMBER, GnomeScanOptionNumber))
#define GNOME_SCAN_OPTION_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_NUMBER, GnomeScanOptionNumberClass))
#define GNOME_SCAN_IS_OPTION_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_NUMBER))
#define GNOME_SCAN_IS_OPTION_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_NUMBER))
#define GNOME_SCAN_OPTION_NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_NUMBER, GnomeScanOptionNumberClass))

typedef struct _GnomeScanOptionNumber GnomeScanOptionNumber;
typedef struct _GnomeScanOptionNumberClass GnomeScanOptionNumberClass;

#define GNOME_SCAN_TYPE_SCALE_WIDGET (gnome_scan_scale_widget_get_type ())
#define GNOME_SCAN_SCALE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_SCALE_WIDGET, GnomeScanScaleWidget))
#define GNOME_SCAN_SCALE_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_SCALE_WIDGET, GnomeScanScaleWidgetClass))
#define GNOME_SCAN_IS_SCALE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_SCALE_WIDGET))
#define GNOME_SCAN_IS_SCALE_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_SCALE_WIDGET))
#define GNOME_SCAN_SCALE_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_SCALE_WIDGET, GnomeScanScaleWidgetClass))

typedef struct _GnomeScanScaleWidget GnomeScanScaleWidget;
typedef struct _GnomeScanScaleWidgetClass GnomeScanScaleWidgetClass;

#define GNOME_SCAN_TYPE_OPTION_STRING (gnome_scan_option_string_get_type ())
#define GNOME_SCAN_OPTION_STRING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_STRING, GnomeScanOptionString))
#define GNOME_SCAN_OPTION_STRING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_STRING, GnomeScanOptionStringClass))
#define GNOME_SCAN_IS_OPTION_STRING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_STRING))
#define GNOME_SCAN_IS_OPTION_STRING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_STRING))
#define GNOME_SCAN_OPTION_STRING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_STRING, GnomeScanOptionStringClass))

typedef struct _GnomeScanOptionString GnomeScanOptionString;
typedef struct _GnomeScanOptionStringClass GnomeScanOptionStringClass;

#define GNOME_SCAN_TYPE_ENTRY_WIDGET (gnome_scan_entry_widget_get_type ())
#define GNOME_SCAN_ENTRY_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_ENTRY_WIDGET, GnomeScanEntryWidget))
#define GNOME_SCAN_ENTRY_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_ENTRY_WIDGET, GnomeScanEntryWidgetClass))
#define GNOME_SCAN_IS_ENTRY_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_ENTRY_WIDGET))
#define GNOME_SCAN_IS_ENTRY_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_ENTRY_WIDGET))
#define GNOME_SCAN_ENTRY_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_ENTRY_WIDGET, GnomeScanEntryWidgetClass))

typedef struct _GnomeScanEntryWidget GnomeScanEntryWidget;
typedef struct _GnomeScanEntryWidgetClass GnomeScanEntryWidgetClass;

#define GNOME_SCAN_TYPE_OPTION_ENUM (gnome_scan_option_enum_get_type ())
#define GNOME_SCAN_OPTION_ENUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_ENUM, GnomeScanOptionEnum))
#define GNOME_SCAN_OPTION_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_ENUM, GnomeScanOptionEnumClass))
#define GNOME_SCAN_IS_OPTION_ENUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_ENUM))
#define GNOME_SCAN_IS_OPTION_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_ENUM))
#define GNOME_SCAN_OPTION_ENUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_ENUM, GnomeScanOptionEnumClass))

typedef struct _GnomeScanOptionEnum GnomeScanOptionEnum;
typedef struct _GnomeScanOptionEnumClass GnomeScanOptionEnumClass;

#define GNOME_SCAN_TYPE_COMBO_BOX_WIDGET (gnome_scan_combo_box_widget_get_type ())
#define GNOME_SCAN_COMBO_BOX_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_COMBO_BOX_WIDGET, GnomeScanComboBoxWidget))
#define GNOME_SCAN_COMBO_BOX_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_COMBO_BOX_WIDGET, GnomeScanComboBoxWidgetClass))
#define GNOME_SCAN_IS_COMBO_BOX_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_COMBO_BOX_WIDGET))
#define GNOME_SCAN_IS_COMBO_BOX_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_COMBO_BOX_WIDGET))
#define GNOME_SCAN_COMBO_BOX_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_COMBO_BOX_WIDGET, GnomeScanComboBoxWidgetClass))

typedef struct _GnomeScanComboBoxWidget GnomeScanComboBoxWidget;
typedef struct _GnomeScanComboBoxWidgetClass GnomeScanComboBoxWidgetClass;

#define GNOME_SCAN_TYPE_OPTION_PAPER_SIZE (gnome_scan_option_paper_size_get_type ())
#define GNOME_SCAN_OPTION_PAPER_SIZE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_PAPER_SIZE, GnomeScanOptionPaperSize))
#define GNOME_SCAN_OPTION_PAPER_SIZE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_PAPER_SIZE, GnomeScanOptionPaperSizeClass))
#define GNOME_SCAN_IS_OPTION_PAPER_SIZE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_PAPER_SIZE))
#define GNOME_SCAN_IS_OPTION_PAPER_SIZE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_PAPER_SIZE))
#define GNOME_SCAN_OPTION_PAPER_SIZE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_PAPER_SIZE, GnomeScanOptionPaperSizeClass))

typedef struct _GnomeScanOptionPaperSize GnomeScanOptionPaperSize;
typedef struct _GnomeScanOptionPaperSizeClass GnomeScanOptionPaperSizeClass;

#define GNOME_SCAN_TYPE_PAPER_SIZE_WIDGET (gnome_scan_paper_size_widget_get_type ())
#define GNOME_SCAN_PAPER_SIZE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_PAPER_SIZE_WIDGET, GnomeScanPaperSizeWidget))
#define GNOME_SCAN_PAPER_SIZE_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_PAPER_SIZE_WIDGET, GnomeScanPaperSizeWidgetClass))
#define GNOME_SCAN_IS_PAPER_SIZE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_PAPER_SIZE_WIDGET))
#define GNOME_SCAN_IS_PAPER_SIZE_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_PAPER_SIZE_WIDGET))
#define GNOME_SCAN_PAPER_SIZE_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_PAPER_SIZE_WIDGET, GnomeScanPaperSizeWidgetClass))

typedef struct _GnomeScanPaperSizeWidget GnomeScanPaperSizeWidget;
typedef struct _GnomeScanPaperSizeWidgetClass GnomeScanPaperSizeWidgetClass;

#define GNOME_SCAN_TYPE_PAGE_ORIENTATION_WIDGET (gnome_scan_page_orientation_widget_get_type ())
#define GNOME_SCAN_PAGE_ORIENTATION_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_PAGE_ORIENTATION_WIDGET, GnomeScanPageOrientationWidget))
#define GNOME_SCAN_PAGE_ORIENTATION_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_PAGE_ORIENTATION_WIDGET, GnomeScanPageOrientationWidgetClass))
#define GNOME_SCAN_IS_PAGE_ORIENTATION_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_PAGE_ORIENTATION_WIDGET))
#define GNOME_SCAN_IS_PAGE_ORIENTATION_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_PAGE_ORIENTATION_WIDGET))
#define GNOME_SCAN_PAGE_ORIENTATION_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_PAGE_ORIENTATION_WIDGET, GnomeScanPageOrientationWidgetClass))

typedef struct _GnomeScanPageOrientationWidget GnomeScanPageOrientationWidget;
typedef struct _GnomeScanPageOrientationWidgetClass GnomeScanPageOrientationWidgetClass;
#define _g_free0(var) (var = (g_free (var), NULL))


extern GnomeScanModuleManager* gnome_scan_module_manager;
GnomeScanModuleManager* gnome_scan_module_manager = NULL;
extern GnomeScanOptionManager* gnome_scan_option_manager;

GType gnome_scan_module_manager_get_type (void);
GnomeScanOptionManager* gnome_scan_option_manager_new (void);
GnomeScanOptionManager* gnome_scan_option_manager_construct (GType object_type);
GType gnome_scan_option_manager_get_type (void);
void gnome_scan_option_manager_register_rule_by_type (GnomeScanOptionManager* self, GType option_type, GType handler_type);
GType gnome_scan_option_get_type (void);
GType gnome_scan_option_bool_get_type (void);
GType gnome_scan_option_widget_get_type (void);
GType gnome_scan_checkbox_widget_get_type (void);
GType gnome_scan_option_number_get_type (void);
GType gnome_scan_scale_widget_get_type (void);
GType gnome_scan_option_string_get_type (void);
GType gnome_scan_entry_widget_get_type (void);
GType gnome_scan_option_enum_get_type (void);
GType gnome_scan_combo_box_widget_get_type (void);
GType gnome_scan_option_paper_size_get_type (void);
GType gnome_scan_paper_size_widget_get_type (void);
void gnome_scan_option_manager_register_rule_by_name (GnomeScanOptionManager* self, const char* option_name, GType handler_type);
GType gnome_scan_page_orientation_widget_get_type (void);
GnomeScanModuleManager* gnome_scan_module_manager_new (const char* path);
GnomeScanModuleManager* gnome_scan_module_manager_construct (GType object_type, const char* path);
void gnome_scan_module_manager_query_modules (GnomeScanModuleManager* self);
void gnome_scan_init (int* argv_length1, char*** argv);
void gnome_scan_exit (void);



void gnome_scan_init (int* argv_length1, char*** argv) {
	char* module_path;
	GnomeScanOptionManager* _tmp0_;
	GnomeScanModuleManager* _tmp3_;
	g_debug ("gnome-scan-init.vala:33: Initializing GNOME Scan %s for %s", PACKAGE_VERSION, g_get_prgname ());
	module_path = NULL;
	gnome_scan_option_manager = (_tmp0_ = gnome_scan_option_manager_new (), _g_object_unref0 (gnome_scan_option_manager), _tmp0_);
	gnome_scan_option_manager_register_rule_by_type (gnome_scan_option_manager, GNOME_SCAN_TYPE_OPTION_BOOL, GNOME_SCAN_TYPE_CHECKBOX_WIDGET);
	gnome_scan_option_manager_register_rule_by_type (gnome_scan_option_manager, GNOME_SCAN_TYPE_OPTION_NUMBER, GNOME_SCAN_TYPE_SCALE_WIDGET);
	gnome_scan_option_manager_register_rule_by_type (gnome_scan_option_manager, GNOME_SCAN_TYPE_OPTION_STRING, GNOME_SCAN_TYPE_ENTRY_WIDGET);
	gnome_scan_option_manager_register_rule_by_type (gnome_scan_option_manager, GNOME_SCAN_TYPE_OPTION_ENUM, GNOME_SCAN_TYPE_COMBO_BOX_WIDGET);
	gnome_scan_option_manager_register_rule_by_type (gnome_scan_option_manager, GNOME_SCAN_TYPE_OPTION_PAPER_SIZE, GNOME_SCAN_TYPE_PAPER_SIZE_WIDGET);
	gnome_scan_option_manager_register_rule_by_name (gnome_scan_option_manager, "page-orientation", GNOME_SCAN_TYPE_PAGE_ORIENTATION_WIDGET);
	if (g_file_test ("modules/gsfile", G_FILE_TEST_IS_DIR)) {
		char* _tmp1_;
		module_path = (_tmp1_ = g_strjoin (G_SEARCHPATH_SEPARATOR_S, "modules/gsfile", "modules/gsane", NULL), _g_free0 (module_path), _tmp1_);
	} else {
		char* _tmp2_;
		module_path = (_tmp2_ = g_strdup (MODULE_DIR), _g_free0 (module_path), _tmp2_);
	}
	gnome_scan_module_manager = (_tmp3_ = gnome_scan_module_manager_new (module_path), _g_object_unref0 (gnome_scan_module_manager), _tmp3_);
	gnome_scan_module_manager_query_modules (gnome_scan_module_manager);
	gegl_init (&(*argv_length1), &(*argv));
	_g_free0 (module_path);
}


void gnome_scan_exit (void) {
	GnomeScanModuleManager* _tmp0_;
	GnomeScanOptionManager* _tmp1_;
	gnome_scan_module_manager = (_tmp0_ = NULL, _g_object_unref0 (gnome_scan_module_manager), _tmp0_);
	gnome_scan_option_manager = (_tmp1_ = NULL, _g_object_unref0 (gnome_scan_option_manager), _tmp1_);
	gegl_exit ();
}




